/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi.osx;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import org.fusesource.jansi.internal.CLibrary;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jansi.JansiNativePty;

public class OsXNativePty
extends JansiNativePty {
    private static final int VEOF = 0;
    private static final int VEOL = 1;
    private static final int VEOL2 = 2;
    private static final int VERASE = 3;
    private static final int VWERASE = 4;
    private static final int VKILL = 5;
    private static final int VREPRINT = 6;
    private static final int VINTR = 8;
    private static final int VQUIT = 9;
    private static final int VSUSP = 10;
    private static final int VDSUSP = 11;
    private static final int VSTART = 12;
    private static final int VSTOP = 13;
    private static final int VLNEXT = 14;
    private static final int VDISCARD = 15;
    private static final int VMIN = 16;
    private static final int VTIME = 17;
    private static final int VSTATUS = 18;
    private static final int IGNBRK = 1;
    private static final int BRKINT = 2;
    private static final int IGNPAR = 4;
    private static final int PARMRK = 8;
    private static final int INPCK = 16;
    private static final int ISTRIP = 32;
    private static final int INLCR = 64;
    private static final int IGNCR = 128;
    private static final int ICRNL = 256;
    private static final int IXON = 512;
    private static final int IXOFF = 1024;
    private static final int IXANY = 2048;
    private static final int IMAXBEL = 8192;
    private static final int IUTF8 = 16384;
    private static final int OPOST = 1;
    private static final int ONLCR = 2;
    private static final int OXTABS = 4;
    private static final int ONOEOT = 8;
    private static final int OCRNL = 16;
    private static final int ONOCR = 32;
    private static final int ONLRET = 64;
    private static final int OFILL = 128;
    private static final int NLDLY = 768;
    private static final int TABDLY = 3076;
    private static final int CRDLY = 12288;
    private static final int FFDLY = 16384;
    private static final int BSDLY = 32768;
    private static final int VTDLY = 65536;
    private static final int OFDEL = 131072;
    private static final int CIGNORE = 1;
    private static final int CS5 = 0;
    private static final int CS6 = 256;
    private static final int CS7 = 512;
    private static final int CS8 = 768;
    private static final int CSTOPB = 1024;
    private static final int CREAD = 2048;
    private static final int PARENB = 4096;
    private static final int PARODD = 8192;
    private static final int HUPCL = 16384;
    private static final int CLOCAL = 32768;
    private static final int CCTS_OFLOW = 65536;
    private static final int CRTS_IFLOW = 131072;
    private static final int CDTR_IFLOW = 262144;
    private static final int CDSR_OFLOW = 524288;
    private static final int CCAR_OFLOW = 0x100000;
    private static final int ECHOKE = 1;
    private static final int ECHOE = 2;
    private static final int ECHOK = 4;
    private static final int ECHO = 8;
    private static final int ECHONL = 16;
    private static final int ECHOPRT = 32;
    private static final int ECHOCTL = 64;
    private static final int ISIG = 128;
    private static final int ICANON = 256;
    private static final int ALTWERASE = 512;
    private static final int IEXTEN = 1024;
    private static final int EXTPROC = 2048;
    private static final int TOSTOP = 0x400000;
    private static final int FLUSHO = 0x800000;
    private static final int NOKERNINFO = 0x2000000;
    private static final int PENDIN = 0x20000000;
    private static final int NOFLSH = Integer.MIN_VALUE;

    public static OsXNativePty current() {
        try {
            String string = OsXNativePty.ttyname();
            return new OsXNativePty(-1, null, 0, FileDescriptor.in, 1, FileDescriptor.out, string);
        }
        catch (IOException iOException) {
            throw new IOException("Not a tty", iOException);
        }
    }

    public static OsXNativePty open(Attributes attributes, Size size) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[64];
        CLibrary.openpty((int[])nArray, (int[])nArray2, (byte[])byArray, (CLibrary.Termios)(attributes != null ? OsXNativePty.termios(attributes) : null), (CLibrary.WinSize)(size != null ? new CLibrary.WinSize((short)size.getRows(), (short)size.getColumns()) : null));
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n);
        return new OsXNativePty(nArray[0], OsXNativePty.newDescriptor(nArray[0]), nArray2[0], OsXNativePty.newDescriptor(nArray2[0]), string);
    }

    public OsXNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, string);
    }

    public OsXNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, n3, fileDescriptor3, string);
    }

    @Override
    protected CLibrary.Termios toTermios(Attributes attributes) {
        return OsXNativePty.termios(attributes);
    }

    static CLibrary.Termios termios(Attributes attributes) {
        CLibrary.Termios termios2 = new CLibrary.Termios();
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNBRK), 1L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.BRKINT), 2L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNPAR), 4L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.PARMRK), 8L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.INPCK), 16L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.ISTRIP), 32L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.INLCR), 64L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNCR), 128L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.ICRNL), 256L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXON), 512L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXOFF), 1024L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXANY), 2048L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IMAXBEL), 8192L, termios2.c_iflag);
        termios2.c_iflag = OsXNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IUTF8), 16384L, termios2.c_iflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OPOST), 1L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONLCR), 2L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OXTABS), 4L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONOEOT), 8L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OCRNL), 16L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONOCR), 32L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONLRET), 64L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OFILL), 128L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.NLDLY), 768L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.TABDLY), 3076L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.CRDLY), 12288L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.FFDLY), 16384L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.BSDLY), 32768L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.VTDLY), 65536L, termios2.c_oflag);
        termios2.c_oflag = OsXNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OFDEL), 131072L, termios2.c_oflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CIGNORE), 1L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS5), 0L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS6), 256L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS7), 512L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS8), 768L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CSTOPB), 1024L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CREAD), 2048L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.PARENB), 4096L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.PARODD), 8192L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.HUPCL), 16384L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CLOCAL), 32768L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CCTS_OFLOW), 65536L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CRTS_IFLOW), 131072L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CDTR_IFLOW), 262144L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CDSR_OFLOW), 524288L, termios2.c_cflag);
        termios2.c_cflag = OsXNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CCAR_OFLOW), 0x100000L, termios2.c_cflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOKE), 1L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOE), 2L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOK), 4L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHO), 8L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHONL), 16L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOPRT), 32L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOCTL), 64L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ISIG), 128L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ICANON), 256L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ALTWERASE), 512L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.IEXTEN), 1024L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.EXTPROC), 2048L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.TOSTOP), 0x400000L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.FLUSHO), 0x800000L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.NOKERNINFO), 0x2000000L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.PENDIN), 0x20000000L, termios2.c_lflag);
        termios2.c_lflag = OsXNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.NOFLSH), Integer.MIN_VALUE, termios2.c_lflag);
        termios2.c_cc[0] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOF);
        termios2.c_cc[1] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOL);
        termios2.c_cc[2] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOL2);
        termios2.c_cc[3] = (byte)attributes.getControlChar(Attributes.ControlChar.VERASE);
        termios2.c_cc[4] = (byte)attributes.getControlChar(Attributes.ControlChar.VWERASE);
        termios2.c_cc[5] = (byte)attributes.getControlChar(Attributes.ControlChar.VKILL);
        termios2.c_cc[6] = (byte)attributes.getControlChar(Attributes.ControlChar.VREPRINT);
        termios2.c_cc[8] = (byte)attributes.getControlChar(Attributes.ControlChar.VINTR);
        termios2.c_cc[9] = (byte)attributes.getControlChar(Attributes.ControlChar.VQUIT);
        termios2.c_cc[10] = (byte)attributes.getControlChar(Attributes.ControlChar.VSUSP);
        termios2.c_cc[11] = (byte)attributes.getControlChar(Attributes.ControlChar.VDSUSP);
        termios2.c_cc[12] = (byte)attributes.getControlChar(Attributes.ControlChar.VSTART);
        termios2.c_cc[13] = (byte)attributes.getControlChar(Attributes.ControlChar.VSTOP);
        termios2.c_cc[14] = (byte)attributes.getControlChar(Attributes.ControlChar.VLNEXT);
        termios2.c_cc[15] = (byte)attributes.getControlChar(Attributes.ControlChar.VDISCARD);
        termios2.c_cc[16] = (byte)attributes.getControlChar(Attributes.ControlChar.VMIN);
        termios2.c_cc[17] = (byte)attributes.getControlChar(Attributes.ControlChar.VTIME);
        termios2.c_cc[18] = (byte)attributes.getControlChar(Attributes.ControlChar.VSTATUS);
        return termios2;
    }

    @Override
    protected Attributes toAttributes(CLibrary.Termios termios2) {
        Attributes attributes = new Attributes();
        EnumSet<Attributes.InputFlag> enumSet = attributes.getInputFlags();
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNBRK, 1);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNBRK, 1);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.BRKINT, 2);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNPAR, 4);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.PARMRK, 8);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.INPCK, 16);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.ISTRIP, 32);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.INLCR, 64);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNCR, 128);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.ICRNL, 256);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXON, 512);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXOFF, 1024);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXANY, 2048);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IMAXBEL, 8192);
        OsXNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IUTF8, 16384);
        EnumSet<Attributes.OutputFlag> enumSet2 = attributes.getOutputFlags();
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OPOST, 1);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONLCR, 2);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OXTABS, 4);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONOEOT, 8);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OCRNL, 16);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONOCR, 32);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONLRET, 64);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OFILL, 128);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.NLDLY, 768);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.TABDLY, 3076);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.CRDLY, 12288);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.FFDLY, 16384);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.BSDLY, 32768);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.VTDLY, 65536);
        OsXNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OFDEL, 131072);
        EnumSet<Attributes.ControlFlag> enumSet3 = attributes.getControlFlags();
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CIGNORE, 1);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS5, 0);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS6, 256);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS7, 512);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS8, 768);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CSTOPB, 1024);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CREAD, 2048);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.PARENB, 4096);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.PARODD, 8192);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.HUPCL, 16384);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CLOCAL, 32768);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CCTS_OFLOW, 65536);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CRTS_IFLOW, 131072);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CDSR_OFLOW, 524288);
        OsXNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CCAR_OFLOW, 0x100000);
        EnumSet<Attributes.LocalFlag> enumSet4 = attributes.getLocalFlags();
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOKE, 1);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOE, 2);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOK, 4);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHO, 8);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHONL, 16);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOPRT, 32);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOCTL, 64);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ISIG, 128);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ICANON, 256);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ALTWERASE, 512);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.IEXTEN, 1024);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.EXTPROC, 2048);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.TOSTOP, 0x400000);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.FLUSHO, 0x800000);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.NOKERNINFO, 0x2000000);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.PENDIN, 0x20000000);
        OsXNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.NOFLSH, Integer.MIN_VALUE);
        EnumMap<Attributes.ControlChar, Integer> enumMap = attributes.getControlChars();
        enumMap.put(Attributes.ControlChar.VEOF, Integer.valueOf(termios2.c_cc[0]));
        enumMap.put(Attributes.ControlChar.VEOL, Integer.valueOf(termios2.c_cc[1]));
        enumMap.put(Attributes.ControlChar.VEOL2, Integer.valueOf(termios2.c_cc[2]));
        enumMap.put(Attributes.ControlChar.VERASE, Integer.valueOf(termios2.c_cc[3]));
        enumMap.put(Attributes.ControlChar.VWERASE, Integer.valueOf(termios2.c_cc[4]));
        enumMap.put(Attributes.ControlChar.VKILL, Integer.valueOf(termios2.c_cc[5]));
        enumMap.put(Attributes.ControlChar.VREPRINT, Integer.valueOf(termios2.c_cc[6]));
        enumMap.put(Attributes.ControlChar.VINTR, Integer.valueOf(termios2.c_cc[8]));
        enumMap.put(Attributes.ControlChar.VQUIT, Integer.valueOf(termios2.c_cc[9]));
        enumMap.put(Attributes.ControlChar.VSUSP, Integer.valueOf(termios2.c_cc[10]));
        enumMap.put(Attributes.ControlChar.VDSUSP, Integer.valueOf(termios2.c_cc[11]));
        enumMap.put(Attributes.ControlChar.VSTART, Integer.valueOf(termios2.c_cc[12]));
        enumMap.put(Attributes.ControlChar.VSTOP, Integer.valueOf(termios2.c_cc[13]));
        enumMap.put(Attributes.ControlChar.VLNEXT, Integer.valueOf(termios2.c_cc[14]));
        enumMap.put(Attributes.ControlChar.VDISCARD, Integer.valueOf(termios2.c_cc[15]));
        enumMap.put(Attributes.ControlChar.VMIN, Integer.valueOf(termios2.c_cc[16]));
        enumMap.put(Attributes.ControlChar.VTIME, Integer.valueOf(termios2.c_cc[17]));
        enumMap.put(Attributes.ControlChar.VSTATUS, Integer.valueOf(termios2.c_cc[18]));
        return attributes;
    }

    private static long setFlag(boolean bl, long l, long l2) {
        return bl ? l2 | l : l2;
    }

    private static <T extends Enum<T>> void addFlag(long l, EnumSet<T> enumSet, T t, int n) {
        if ((l & (long)n) != 0L) {
            enumSet.add(t);
        }
    }
}

