/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi.linux;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import org.fusesource.jansi.internal.CLibrary;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.jansi.JansiNativePty;

public class LinuxNativePty
extends JansiNativePty {
    private static final int VINTR = 0;
    private static final int VQUIT = 1;
    private static final int VERASE = 2;
    private static final int VKILL = 3;
    private static final int VEOF = 4;
    private static final int VTIME = 5;
    private static final int VMIN = 6;
    private static final int VSWTC = 7;
    private static final int VSTART = 8;
    private static final int VSTOP = 9;
    private static final int VSUSP = 10;
    private static final int VEOL = 11;
    private static final int VREPRINT = 12;
    private static final int VDISCARD = 13;
    private static final int VWERASE = 14;
    private static final int VLNEXT = 15;
    private static final int VEOL2 = 16;
    private static final int IGNBRK = 1;
    private static final int BRKINT = 2;
    private static final int IGNPAR = 4;
    private static final int PARMRK = 8;
    private static final int INPCK = 16;
    private static final int ISTRIP = 32;
    private static final int INLCR = 64;
    private static final int IGNCR = 128;
    private static final int ICRNL = 256;
    private static final int IUCLC = 512;
    private static final int IXON = 1024;
    private static final int IXANY = 2048;
    private static final int IXOFF = 4096;
    private static final int IMAXBEL = 8192;
    private static final int IUTF8 = 16384;
    private static final int OPOST = 1;
    private static final int OLCUC = 2;
    private static final int ONLCR = 4;
    private static final int OCRNL = 8;
    private static final int ONOCR = 16;
    private static final int ONLRET = 32;
    private static final int OFILL = 64;
    private static final int OFDEL = 128;
    private static final int NLDLY = 256;
    private static final int NL0 = 0;
    private static final int NL1 = 256;
    private static final int CRDLY = 1536;
    private static final int CR0 = 0;
    private static final int CR1 = 512;
    private static final int CR2 = 1024;
    private static final int CR3 = 1536;
    private static final int TABDLY = 6144;
    private static final int TAB0 = 0;
    private static final int TAB1 = 2048;
    private static final int TAB2 = 4096;
    private static final int TAB3 = 6144;
    private static final int XTABS = 6144;
    private static final int BSDLY = 8192;
    private static final int BS0 = 0;
    private static final int BS1 = 8192;
    private static final int VTDLY = 16384;
    private static final int VT0 = 0;
    private static final int VT1 = 16384;
    private static final int FFDLY = 32768;
    private static final int FF0 = 0;
    private static final int FF1 = 32768;
    private static final int CBAUD = 4111;
    private static final int B0 = 0;
    private static final int B50 = 1;
    private static final int B75 = 2;
    private static final int B110 = 3;
    private static final int B134 = 4;
    private static final int B150 = 5;
    private static final int B200 = 6;
    private static final int B300 = 7;
    private static final int B600 = 8;
    private static final int B1200 = 9;
    private static final int B1800 = 10;
    private static final int B2400 = 11;
    private static final int B4800 = 12;
    private static final int B9600 = 13;
    private static final int B19200 = 14;
    private static final int B38400 = 15;
    private static final int EXTA = 14;
    private static final int EXTB = 15;
    private static final int CSIZE = 48;
    private static final int CS5 = 0;
    private static final int CS6 = 16;
    private static final int CS7 = 32;
    private static final int CS8 = 48;
    private static final int CSTOPB = 64;
    private static final int CREAD = 128;
    private static final int PARENB = 256;
    private static final int PARODD = 512;
    private static final int HUPCL = 1024;
    private static final int CLOCAL = 2048;
    private static final int ISIG = 1;
    private static final int ICANON = 2;
    private static final int XCASE = 4;
    private static final int ECHO = 8;
    private static final int ECHOE = 16;
    private static final int ECHOK = 32;
    private static final int ECHONL = 64;
    private static final int NOFLSH = 128;
    private static final int TOSTOP = 256;
    private static final int ECHOCTL = 512;
    private static final int ECHOPRT = 1024;
    private static final int ECHOKE = 2048;
    private static final int FLUSHO = 4096;
    private static final int PENDIN = 8192;
    private static final int IEXTEN = 32768;
    private static final int EXTPROC = 65536;

    public static LinuxNativePty current() {
        try {
            String string = LinuxNativePty.ttyname();
            return new LinuxNativePty(-1, null, 0, FileDescriptor.in, 1, FileDescriptor.out, string);
        }
        catch (IOException iOException) {
            throw new IOException("Not a tty", iOException);
        }
    }

    public static LinuxNativePty open(Attributes attributes, Size size) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        byte[] byArray = new byte[64];
        CLibrary.openpty((int[])nArray, (int[])nArray2, (byte[])byArray, (CLibrary.Termios)(attributes != null ? LinuxNativePty.termios(attributes) : null), (CLibrary.WinSize)(size != null ? new CLibrary.WinSize((short)size.getRows(), (short)size.getColumns()) : null));
        int n = 0;
        while (byArray[n] != 0) {
            ++n;
        }
        String string = new String(byArray, 0, n);
        return new LinuxNativePty(nArray[0], LinuxNativePty.newDescriptor(nArray[0]), nArray2[0], LinuxNativePty.newDescriptor(nArray2[0]), string);
    }

    public LinuxNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, string);
    }

    public LinuxNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        super(n, fileDescriptor, n2, fileDescriptor2, n3, fileDescriptor3, string);
    }

    @Override
    protected CLibrary.Termios toTermios(Attributes attributes) {
        return LinuxNativePty.termios(attributes);
    }

    static CLibrary.Termios termios(Attributes attributes) {
        CLibrary.Termios termios2 = new CLibrary.Termios();
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNBRK), 1L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.BRKINT), 2L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNPAR), 4L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.PARMRK), 8L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.INPCK), 16L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.ISTRIP), 32L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.INLCR), 64L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IGNCR), 128L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.ICRNL), 256L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXON), 1024L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXOFF), 4096L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IXANY), 2048L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IMAXBEL), 8192L, termios2.c_iflag);
        termios2.c_iflag = LinuxNativePty.setFlag(attributes.getInputFlag(Attributes.InputFlag.IUTF8), 16384L, termios2.c_iflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OPOST), 1L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONLCR), 4L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OCRNL), 8L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONOCR), 16L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.ONLRET), 32L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OFILL), 64L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.NLDLY), 256L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.TABDLY), 6144L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.CRDLY), 1536L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.FFDLY), 32768L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.BSDLY), 8192L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.VTDLY), 16384L, termios2.c_oflag);
        termios2.c_oflag = LinuxNativePty.setFlag(attributes.getOutputFlag(Attributes.OutputFlag.OFDEL), 128L, termios2.c_oflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS5), 0L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS6), 16L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS7), 32L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CS8), 48L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CSTOPB), 64L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CREAD), 128L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.PARENB), 256L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.PARODD), 512L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.HUPCL), 1024L, termios2.c_cflag);
        termios2.c_cflag = LinuxNativePty.setFlag(attributes.getControlFlag(Attributes.ControlFlag.CLOCAL), 2048L, termios2.c_cflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOKE), 2048L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOE), 16L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOK), 32L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHO), 8L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHONL), 64L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOPRT), 1024L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ECHOCTL), 512L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ISIG), 1L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.ICANON), 2L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.IEXTEN), 32768L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.EXTPROC), 65536L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.TOSTOP), 256L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.FLUSHO), 4096L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.PENDIN), 8192L, termios2.c_lflag);
        termios2.c_lflag = LinuxNativePty.setFlag(attributes.getLocalFlag(Attributes.LocalFlag.NOFLSH), 128L, termios2.c_lflag);
        termios2.c_cc[4] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOF);
        termios2.c_cc[11] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOL);
        termios2.c_cc[16] = (byte)attributes.getControlChar(Attributes.ControlChar.VEOL2);
        termios2.c_cc[2] = (byte)attributes.getControlChar(Attributes.ControlChar.VERASE);
        termios2.c_cc[14] = (byte)attributes.getControlChar(Attributes.ControlChar.VWERASE);
        termios2.c_cc[3] = (byte)attributes.getControlChar(Attributes.ControlChar.VKILL);
        termios2.c_cc[12] = (byte)attributes.getControlChar(Attributes.ControlChar.VREPRINT);
        termios2.c_cc[0] = (byte)attributes.getControlChar(Attributes.ControlChar.VINTR);
        termios2.c_cc[1] = (byte)attributes.getControlChar(Attributes.ControlChar.VQUIT);
        termios2.c_cc[10] = (byte)attributes.getControlChar(Attributes.ControlChar.VSUSP);
        termios2.c_cc[8] = (byte)attributes.getControlChar(Attributes.ControlChar.VSTART);
        termios2.c_cc[9] = (byte)attributes.getControlChar(Attributes.ControlChar.VSTOP);
        termios2.c_cc[15] = (byte)attributes.getControlChar(Attributes.ControlChar.VLNEXT);
        termios2.c_cc[13] = (byte)attributes.getControlChar(Attributes.ControlChar.VDISCARD);
        termios2.c_cc[6] = (byte)attributes.getControlChar(Attributes.ControlChar.VMIN);
        termios2.c_cc[5] = (byte)attributes.getControlChar(Attributes.ControlChar.VTIME);
        return termios2;
    }

    @Override
    protected Attributes toAttributes(CLibrary.Termios termios2) {
        Attributes attributes = new Attributes();
        EnumSet<Attributes.InputFlag> enumSet = attributes.getInputFlags();
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNBRK, 1);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNBRK, 1);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.BRKINT, 2);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNPAR, 4);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.PARMRK, 8);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.INPCK, 16);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.ISTRIP, 32);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.INLCR, 64);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IGNCR, 128);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.ICRNL, 256);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXON, 1024);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXOFF, 4096);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IXANY, 2048);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IMAXBEL, 8192);
        LinuxNativePty.addFlag(termios2.c_iflag, enumSet, Attributes.InputFlag.IUTF8, 16384);
        EnumSet<Attributes.OutputFlag> enumSet2 = attributes.getOutputFlags();
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OPOST, 1);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONLCR, 4);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OCRNL, 8);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONOCR, 16);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.ONLRET, 32);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OFILL, 64);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.NLDLY, 256);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.TABDLY, 6144);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.CRDLY, 1536);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.FFDLY, 32768);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.BSDLY, 8192);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.VTDLY, 16384);
        LinuxNativePty.addFlag(termios2.c_oflag, enumSet2, Attributes.OutputFlag.OFDEL, 128);
        EnumSet<Attributes.ControlFlag> enumSet3 = attributes.getControlFlags();
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS5, 0);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS6, 16);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS7, 32);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CS8, 48);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CSTOPB, 64);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CREAD, 128);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.PARENB, 256);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.PARODD, 512);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.HUPCL, 1024);
        LinuxNativePty.addFlag(termios2.c_cflag, enumSet3, Attributes.ControlFlag.CLOCAL, 2048);
        EnumSet<Attributes.LocalFlag> enumSet4 = attributes.getLocalFlags();
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOKE, 2048);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOE, 16);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOK, 32);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHO, 8);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHONL, 64);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOPRT, 1024);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ECHOCTL, 512);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ISIG, 1);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.ICANON, 2);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.IEXTEN, 32768);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.EXTPROC, 65536);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.TOSTOP, 256);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.FLUSHO, 4096);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.PENDIN, 8192);
        LinuxNativePty.addFlag(termios2.c_lflag, enumSet4, Attributes.LocalFlag.NOFLSH, 128);
        EnumMap<Attributes.ControlChar, Integer> enumMap = attributes.getControlChars();
        enumMap.put(Attributes.ControlChar.VEOF, Integer.valueOf(termios2.c_cc[4]));
        enumMap.put(Attributes.ControlChar.VEOL, Integer.valueOf(termios2.c_cc[11]));
        enumMap.put(Attributes.ControlChar.VEOL2, Integer.valueOf(termios2.c_cc[16]));
        enumMap.put(Attributes.ControlChar.VERASE, Integer.valueOf(termios2.c_cc[2]));
        enumMap.put(Attributes.ControlChar.VWERASE, Integer.valueOf(termios2.c_cc[14]));
        enumMap.put(Attributes.ControlChar.VKILL, Integer.valueOf(termios2.c_cc[3]));
        enumMap.put(Attributes.ControlChar.VREPRINT, Integer.valueOf(termios2.c_cc[12]));
        enumMap.put(Attributes.ControlChar.VINTR, Integer.valueOf(termios2.c_cc[0]));
        enumMap.put(Attributes.ControlChar.VQUIT, Integer.valueOf(termios2.c_cc[1]));
        enumMap.put(Attributes.ControlChar.VSUSP, Integer.valueOf(termios2.c_cc[10]));
        enumMap.put(Attributes.ControlChar.VSTART, Integer.valueOf(termios2.c_cc[8]));
        enumMap.put(Attributes.ControlChar.VSTOP, Integer.valueOf(termios2.c_cc[9]));
        enumMap.put(Attributes.ControlChar.VLNEXT, Integer.valueOf(termios2.c_cc[15]));
        enumMap.put(Attributes.ControlChar.VDISCARD, Integer.valueOf(termios2.c_cc[13]));
        enumMap.put(Attributes.ControlChar.VMIN, Integer.valueOf(termios2.c_cc[6]));
        enumMap.put(Attributes.ControlChar.VTIME, Integer.valueOf(termios2.c_cc[5]));
        return attributes;
    }

    private static long setFlag(boolean bl, long l, long l2) {
        return bl ? l2 | l : l2;
    }

    private static <T extends Enum<T>> void addFlag(long l, EnumSet<T> enumSet, T t, int n) {
        if ((l & (long)n) != 0L) {
            enumSet.add(t);
        }
    }
}

