/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fusesource.jansi.Ansi;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.jansi.freebsd.FreeBsdNativePty;
import org.jline.terminal.impl.jansi.linux.LinuxNativePty;
import org.jline.terminal.impl.jansi.osx.OsXNativePty;
import org.jline.terminal.impl.jansi.win.JansiWinSysTerminal;
import org.jline.terminal.spi.JansiSupport;
import org.jline.terminal.spi.Pty;

public class JansiSupportImpl
implements JansiSupport {
    static final int JANSI_MAJOR_VERSION;
    static final int JANSI_MINOR_VERSION;

    @Override
    public Pty current() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Linux")) {
            if (JANSI_MAJOR_VERSION > 1 || JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION >= 16) {
                return LinuxNativePty.current();
            }
        } else if (string.startsWith("Mac") || string.startsWith("Darwin")) {
            if (JANSI_MAJOR_VERSION > 1 || JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION >= 12) {
                return OsXNativePty.current();
            }
        } else if (!string.startsWith("Solaris") && !string.startsWith("SunOS") && string.startsWith("FreeBSD") && (JANSI_MAJOR_VERSION > 1 || JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION >= 16)) {
            return FreeBsdNativePty.current();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Pty open(Attributes attributes, Size size) {
        if (JANSI_MAJOR_VERSION > 1 || JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION >= 16) {
            String string = System.getProperty("os.name");
            if (string.startsWith("Linux")) {
                return LinuxNativePty.open(attributes, size);
            }
            if (string.startsWith("Mac") || string.startsWith("Darwin")) {
                return OsXNativePty.open(attributes, size);
            }
            if (!string.startsWith("Solaris") && !string.startsWith("SunOS") && string.startsWith("FreeBSD")) {
                return FreeBsdNativePty.open(attributes, size);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Terminal winSysTerminal(String string, String string2, boolean bl, Charset charset, int n, boolean bl2, Terminal.SignalHandler signalHandler) {
        if (JANSI_MAJOR_VERSION > 1 || JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION >= 12) {
            JansiWinSysTerminal jansiWinSysTerminal = new JansiWinSysTerminal(string, string2, bl, charset, n, bl2, signalHandler);
            if (JANSI_MAJOR_VERSION == 1 && JANSI_MINOR_VERSION < 16) {
                jansiWinSysTerminal.disableScrolling();
            }
            return jansiWinSysTerminal;
        }
        throw new UnsupportedOperationException();
    }

    static {
        int n = 0;
        int n2 = 0;
        try {
            Matcher matcher;
            String string = Ansi.class.getPackage().getImplementationVersion();
            if (string != null && (matcher = Pattern.compile("([0-9]+)\\.([0-9]+)([\\.-]\\S+)?").matcher(string)).matches()) {
                n = Integer.parseInt(matcher.group(1));
                n2 = Integer.parseInt(matcher.group(2));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JANSI_MAJOR_VERSION = n;
        JANSI_MINOR_VERSION = n2;
    }
}

