/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jansi;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import org.fusesource.jansi.internal.CLibrary;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.AbstractPty;
import org.jline.terminal.impl.jansi.JansiSupportImpl;
import org.jline.terminal.spi.Pty;
import org.jline.utils.ExecHelper;
import org.jline.utils.OSUtils;

public abstract class JansiNativePty
extends AbstractPty
implements Pty {
    private final int master;
    private final int slave;
    private final int slaveOut;
    private final String name;
    private final FileDescriptor masterFD;
    private final FileDescriptor slaveFD;
    private final FileDescriptor slaveOutFD;

    public JansiNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, String string) {
        this(n, fileDescriptor, n2, fileDescriptor2, n2, fileDescriptor2, string);
    }

    public JansiNativePty(int n, FileDescriptor fileDescriptor, int n2, FileDescriptor fileDescriptor2, int n3, FileDescriptor fileDescriptor3, String string) {
        this.master = n;
        this.slave = n2;
        this.slaveOut = n3;
        this.name = string;
        this.masterFD = fileDescriptor;
        this.slaveFD = fileDescriptor2;
        this.slaveOutFD = fileDescriptor3;
    }

    protected static String ttyname() {
        String string;
        if (JansiSupportImpl.JANSI_MAJOR_VERSION > 1 || JansiSupportImpl.JANSI_MAJOR_VERSION == 1 && JansiSupportImpl.JANSI_MINOR_VERSION >= 16) {
            string = CLibrary.ttyname((int)0);
        } else {
            try {
                string = ExecHelper.exec(true, OSUtils.TTY_COMMAND);
            }
            catch (IOException iOException) {
                throw new IOException("Not a tty", iOException);
            }
        }
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.isEmpty()) {
            throw new IOException("Not a tty");
        }
        return string;
    }

    @Override
    public void close() {
        if (this.master > 0) {
            this.getMasterInput().close();
        }
        if (this.slave > 0) {
            this.getSlaveInput().close();
        }
    }

    public int getMaster() {
        return this.master;
    }

    public int getSlave() {
        return this.slave;
    }

    public int getSlaveOut() {
        return this.slaveOut;
    }

    public String getName() {
        return this.name;
    }

    public FileDescriptor getMasterFD() {
        return this.masterFD;
    }

    public FileDescriptor getSlaveFD() {
        return this.slaveFD;
    }

    public FileDescriptor getSlaveOutFD() {
        return this.slaveOutFD;
    }

    @Override
    public InputStream getMasterInput() {
        return new FileInputStream(this.getMasterFD());
    }

    @Override
    public OutputStream getMasterOutput() {
        return new FileOutputStream(this.getMasterFD());
    }

    @Override
    protected InputStream doGetSlaveInput() {
        return new FileInputStream(this.getSlaveFD());
    }

    @Override
    public OutputStream getSlaveOutput() {
        return new FileOutputStream(this.getSlaveOutFD());
    }

    @Override
    public Attributes getAttr() {
        CLibrary.Termios termios2 = new CLibrary.Termios();
        CLibrary.tcgetattr((int)this.slave, (CLibrary.Termios)termios2);
        return this.toAttributes(termios2);
    }

    @Override
    protected void doSetAttr(Attributes attributes) {
        CLibrary.Termios termios2 = this.toTermios(attributes);
        CLibrary.tcsetattr((int)this.slave, (int)CLibrary.TCSANOW, (CLibrary.Termios)termios2);
    }

    @Override
    public Size getSize() {
        CLibrary.WinSize winSize = new CLibrary.WinSize();
        CLibrary.ioctl((int)this.slave, (long)CLibrary.TIOCGWINSZ, (CLibrary.WinSize)winSize);
        return new Size(winSize.ws_col, winSize.ws_row);
    }

    @Override
    public void setSize(Size size) {
        CLibrary.WinSize winSize = new CLibrary.WinSize((short)size.getRows(), (short)size.getColumns());
        CLibrary.ioctl((int)this.slave, (long)CLibrary.TIOCSWINSZ, (CLibrary.WinSize)winSize);
    }

    protected abstract CLibrary.Termios toTermios(Attributes var1);

    protected abstract Attributes toAttributes(CLibrary.Termios var1);

    public String toString() {
        return "JansiNativePty[" + this.getName() + "]";
    }

    protected static FileDescriptor newDescriptor(int n) {
        try {
            Constructor constructor = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            return (FileDescriptor)constructor.newInstance(n);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to create FileDescriptor", throwable);
        }
    }
}

