/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.util.EnumSet;
import java.util.function.IntSupplier;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;

public class MouseSupport {
    public static boolean hasMouseSupport(Terminal terminal) {
        return terminal.getStringCapability(InfoCmp.Capability.key_mouse) != null;
    }

    public static boolean trackMouse(Terminal terminal, Terminal.MouseTracking mouseTracking) {
        if (MouseSupport.hasMouseSupport(terminal)) {
            switch (mouseTracking) {
                case Off: {
                    terminal.writer().write("\u001b[?1000l");
                    break;
                }
                case Normal: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1000h");
                    break;
                }
                case Button: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1002h");
                    break;
                }
                case Any: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1003h");
                }
            }
            terminal.flush();
            return true;
        }
        return false;
    }

    public static MouseEvent readMouse(Terminal terminal, MouseEvent mouseEvent) {
        return MouseSupport.readMouse(() -> MouseSupport.readExt(terminal), mouseEvent);
    }

    public static MouseEvent readMouse(IntSupplier intSupplier, MouseEvent mouseEvent) {
        MouseEvent.Button button;
        MouseEvent.Type type;
        int n = intSupplier.getAsInt() - 32;
        int n2 = intSupplier.getAsInt() - 32 - 1;
        int n3 = intSupplier.getAsInt() - 32 - 1;
        EnumSet<MouseEvent.Modifier> enumSet = EnumSet.noneOf(MouseEvent.Modifier.class);
        if ((n & 4) == 4) {
            enumSet.add(MouseEvent.Modifier.Shift);
        }
        if ((n & 8) == 8) {
            enumSet.add(MouseEvent.Modifier.Alt);
        }
        if ((n & 0x10) == 16) {
            enumSet.add(MouseEvent.Modifier.Control);
        }
        if ((n & 0x40) == 64) {
            type = MouseEvent.Type.Wheel;
            button = (n & 1) == 1 ? MouseEvent.Button.WheelDown : MouseEvent.Button.WheelUp;
        } else {
            int n4 = n & 3;
            switch (n4) {
                case 0: {
                    button = MouseEvent.Button.Button1;
                    if (mouseEvent.getButton() == button && (mouseEvent.getType() == MouseEvent.Type.Pressed || mouseEvent.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                case 1: {
                    button = MouseEvent.Button.Button2;
                    if (mouseEvent.getButton() == button && (mouseEvent.getType() == MouseEvent.Type.Pressed || mouseEvent.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                case 2: {
                    button = MouseEvent.Button.Button3;
                    if (mouseEvent.getButton() == button && (mouseEvent.getType() == MouseEvent.Type.Pressed || mouseEvent.getType() == MouseEvent.Type.Dragged)) {
                        type = MouseEvent.Type.Dragged;
                        break;
                    }
                    type = MouseEvent.Type.Pressed;
                    break;
                }
                default: {
                    if (mouseEvent.getType() == MouseEvent.Type.Pressed || mouseEvent.getType() == MouseEvent.Type.Dragged) {
                        button = mouseEvent.getButton();
                        type = MouseEvent.Type.Released;
                        break;
                    }
                    button = MouseEvent.Button.NoButton;
                    type = MouseEvent.Type.Moved;
                }
            }
        }
        return new MouseEvent(type, button, enumSet, n2, n3);
    }

    private static int readExt(Terminal terminal) {
        try {
            int n = terminal.reader().read();
            if (n < 0) {
                throw new EOFException();
            }
            return n;
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

