/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntConsumer;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.CursorSupport;
import org.jline.terminal.impl.LineDisciplineTerminal;

public class ExternalTerminal
extends LineDisciplineTerminal {
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final InputStream masterInput;
    protected final Object lock = new Object();
    protected boolean paused = true;
    protected Thread pumpThread;

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset) {
        this(string, string2, inputStream, outputStream, charset, Terminal.SignalHandler.SIG_DFL);
    }

    public ExternalTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler) {
        super(string, string2, outputStream, charset, signalHandler);
        this.masterInput = inputStream;
        this.resume();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.pause();
            super.close();
        }
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause(boolean bl) {
        Thread thread;
        Object object = this.lock;
        synchronized (object) {
            this.paused = true;
            thread = this.pumpThread;
        }
        if (thread != null) {
            thread.interrupt();
            thread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.lock;
        synchronized (object) {
            this.paused = false;
            if (this.pumpThread == null) {
                this.pumpThread = new Thread(this::pump, this.toString() + " input pump thread");
                this.pumpThread.setDaemon(true);
                this.pumpThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paused() {
        Object object = this.lock;
        synchronized (object) {
            return this.paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void pump() {
        try {
            while (true) {
                int n;
                if ((n = this.masterInput.read()) >= 0) {
                    this.processInputByte((char)n);
                }
                if (n >= 0 && !this.closed.get()) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.paused) {
                            this.pumpThread = null;
                            return;
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                this.pumpThread = null;
            }
        }
        try {
            this.close();
            return;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return CursorSupport.getCursorPosition(this, intConsumer);
    }
}

