/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.impl.AbstractPty;
import org.jline.terminal.spi.Pty;
import org.jline.utils.ExecHelper;
import org.jline.utils.OSUtils;

public class ExecPty
extends AbstractPty
implements Pty {
    private final String name;
    private final boolean system;

    public static Pty current() {
        try {
            String string = ExecHelper.exec(true, OSUtils.TTY_COMMAND);
            return new ExecPty(string.trim(), true);
        }
        catch (IOException iOException) {
            throw new IOException("Not a tty", iOException);
        }
    }

    protected ExecPty(String string, boolean bl) {
        this.name = string;
        this.system = bl;
    }

    @Override
    public void close() {
    }

    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getMasterInput() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream getMasterOutput() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected InputStream doGetSlaveInput() {
        return this.system ? new FileInputStream(FileDescriptor.in) : new FileInputStream(this.getName());
    }

    @Override
    public OutputStream getSlaveOutput() {
        return this.system ? new FileOutputStream(FileDescriptor.out) : new FileOutputStream(this.getName());
    }

    @Override
    public Attributes getAttr() {
        String string = this.doGetConfig();
        return ExecPty.doGetAttr(string);
    }

    @Override
    protected void doSetAttr(Attributes attributes) {
        List<String> list = this.getFlagsToSet(attributes, this.getAttr());
        if (!list.isEmpty()) {
            list.add(0, OSUtils.STTY_COMMAND);
            if (!this.system) {
                list.add(1, OSUtils.STTY_F_OPTION);
                list.add(2, this.getName());
            }
            try {
                ExecHelper.exec(this.system, list.toArray(new String[list.size()]));
            }
            catch (IOException iOException) {
                if (iOException.toString().contains("unable to perform all requested operations")) {
                    list = this.getFlagsToSet(attributes, this.getAttr());
                    if (!list.isEmpty()) {
                        throw new IOException("Could not set the following flags: " + String.join((CharSequence)", ", list), iOException);
                    }
                }
                throw iOException;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> getFlagsToSet(Attributes attributes, Attributes attributes2) {
        void var7_20;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Attributes.InputFlag inputFlag : Attributes.InputFlag.values()) {
            if (attributes.getInputFlag(inputFlag) == attributes2.getInputFlag(inputFlag)) continue;
            arrayList.add((attributes.getInputFlag(inputFlag) ? inputFlag.name() : "-" + inputFlag.name()).toLowerCase());
        }
        for (Attributes.OutputFlag outputFlag : Attributes.OutputFlag.values()) {
            if (attributes.getOutputFlag(outputFlag) == attributes2.getOutputFlag(outputFlag)) continue;
            arrayList.add((attributes.getOutputFlag(outputFlag) ? outputFlag.name() : "-" + outputFlag.name()).toLowerCase());
        }
        for (Attributes.ControlFlag controlFlag : Attributes.ControlFlag.values()) {
            if (attributes.getControlFlag(controlFlag) == attributes2.getControlFlag(controlFlag)) continue;
            arrayList.add((attributes.getControlFlag(controlFlag) ? controlFlag.name() : "-" + controlFlag.name()).toLowerCase());
        }
        for (Attributes.LocalFlag localFlag : Attributes.LocalFlag.values()) {
            if (attributes.getLocalFlag(localFlag) == attributes2.getLocalFlag(localFlag)) continue;
            arrayList.add((attributes.getLocalFlag(localFlag) ? localFlag.name() : "-" + localFlag.name()).toLowerCase());
        }
        String string = System.getProperty("os.name").toLowerCase().startsWith("hp") ? "^-" : "undef";
        Attributes.ControlChar[] controlCharArray = Attributes.ControlChar.values();
        int n = controlCharArray.length;
        boolean bl = false;
        while (var7_20 < n) {
            Attributes.ControlChar controlChar = controlCharArray[var7_20];
            if (attributes.getControlChar(controlChar) != attributes2.getControlChar(controlChar)) {
                String string2 = "";
                int n2 = attributes.getControlChar(controlChar);
                arrayList.add(controlChar.name().toLowerCase().substring(1));
                if (controlChar == Attributes.ControlChar.VMIN || controlChar == Attributes.ControlChar.VTIME) {
                    arrayList.add(Integer.toBinaryString(n2));
                } else if (n2 == 0) {
                    arrayList.add(string);
                } else {
                    if (n2 >= 128) {
                        n2 -= 128;
                        string2 = string2 + "M-";
                    }
                    if (n2 < 32 || n2 == 127) {
                        n2 ^= 0x40;
                        string2 = string2 + "^";
                    }
                    string2 = string2 + (char)n2;
                    arrayList.add(string2);
                }
            }
            ++var7_20;
        }
        return arrayList;
    }

    @Override
    public Size getSize() {
        String string = this.doGetConfig();
        return ExecPty.doGetSize(string);
    }

    protected String doGetConfig() {
        return this.system ? ExecHelper.exec(true, OSUtils.STTY_COMMAND, "-a") : ExecHelper.exec(false, OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "-a");
    }

    static Attributes doGetAttr(String string) {
        Object object;
        Attributes attributes = new Attributes();
        for (Attributes.InputFlag enum_ : Attributes.InputFlag.values()) {
            object = ExecPty.doGetFlag(string, enum_);
            if (object == null) continue;
            attributes.setInputFlag(enum_, (Boolean)object);
        }
        for (Enum enum_ : Attributes.OutputFlag.values()) {
            object = ExecPty.doGetFlag(string, enum_);
            if (object == null) continue;
            attributes.setOutputFlag((Attributes.OutputFlag)enum_, (Boolean)object);
        }
        for (Enum enum_ : Attributes.ControlFlag.values()) {
            object = ExecPty.doGetFlag(string, enum_);
            if (object == null) continue;
            attributes.setControlFlag((Attributes.ControlFlag)enum_, (Boolean)object);
        }
        for (Enum enum_ : Attributes.LocalFlag.values()) {
            object = ExecPty.doGetFlag(string, enum_);
            if (object == null) continue;
            attributes.setLocalFlag((Attributes.LocalFlag)enum_, (Boolean)object);
        }
        for (Enum enum_ : Attributes.ControlChar.values()) {
            Matcher matcher;
            object = enum_.name().toLowerCase().substring(1);
            if ("reprint".endsWith((String)object)) {
                object = "(?:reprint|rprnt)";
            }
            if (!(matcher = Pattern.compile("[\\s;]" + (String)object + "\\s*=\\s*(.+?)[\\s;]").matcher(string)).find()) continue;
            attributes.setControlChar((Attributes.ControlChar)enum_, ExecPty.parseControlChar(matcher.group(1).toUpperCase()));
        }
        return attributes;
    }

    private static Boolean doGetFlag(String string, Enum<?> enum_) {
        Matcher matcher = Pattern.compile("(?:^|[\\s;])(\\-?" + enum_.name().toLowerCase() + ")(?:[\\s;]|$)").matcher(string);
        return matcher.find() ? Boolean.valueOf(!matcher.group(1).startsWith("-")) : null;
    }

    static int parseControlChar(String string) {
        if ("<UNDEF>".equals(string)) {
            return -1;
        }
        if ("DEL".equalsIgnoreCase(string)) {
            return 127;
        }
        if (string.charAt(0) == '0') {
            return Integer.parseInt(string, 8);
        }
        if (string.charAt(0) >= '1' && string.charAt(0) <= '9') {
            return Integer.parseInt(string, 10);
        }
        if (string.charAt(0) == '^') {
            if (string.charAt(1) == '?') {
                return 127;
            }
            return string.charAt(1) - 64;
        }
        if (string.charAt(0) == 'M' && string.charAt(1) == '-') {
            if (string.charAt(2) == '^') {
                if (string.charAt(3) == '?') {
                    return 255;
                }
                return string.charAt(3) - 64 + 128;
            }
            return string.charAt(2) + 128;
        }
        return string.charAt(0);
    }

    static Size doGetSize(String string) {
        return new Size(ExecPty.doGetInt("columns", string), ExecPty.doGetInt("rows", string));
    }

    static int doGetInt(String string, String string2) {
        String[] stringArray;
        for (String string3 : stringArray = new String[]{"\\b([0-9]+)\\s+" + string + "\\b", "\\b" + string + "\\s+([0-9]+)\\b", "\\b" + string + "\\s*=\\s*([0-9]+)\\b"}) {
            Matcher matcher = Pattern.compile(string3).matcher(string2);
            if (!matcher.find()) continue;
            return Integer.parseInt(matcher.group(1));
        }
        throw new IOException("Unable to parse " + string);
    }

    @Override
    public void setSize(Size size) {
        if (this.system) {
            ExecHelper.exec(true, OSUtils.STTY_COMMAND, "columns", Integer.toString(size.getColumns()), "rows", Integer.toString(size.getRows()));
        } else {
            ExecHelper.exec(false, OSUtils.STTY_COMMAND, OSUtils.STTY_F_OPTION, this.getName(), "columns", Integer.toString(size.getColumns()), "rows", Integer.toString(size.getRows()));
        }
    }

    public String toString() {
        return "ExecPty[" + this.getName() + (this.system ? ", system]" : "]");
    }
}

