/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingReader;

public class DumbTerminal
extends AbstractTerminal {
    private final NonBlockingInputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Attributes attributes;
    private final Size size;

    public DumbTerminal(InputStream inputStream, OutputStream outputStream) {
        this("dumb", "dumb", inputStream, outputStream, null);
    }

    public DumbTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset) {
        this(string, string2, inputStream, outputStream, charset, Terminal.SignalHandler.SIG_DFL);
    }

    public DumbTerminal(String string, String string2, InputStream inputStream, OutputStream outputStream, Charset charset, Terminal.SignalHandler signalHandler) {
        super(string, string2, charset, signalHandler);
        final NonBlockingInputStream nonBlockingInputStream = NonBlocking.nonBlocking(this.getName(), inputStream);
        this.input = new NonBlockingInputStream(){

            @Override
            public int read(long l, boolean bl) {
                int n;
                block9: {
                    block8: {
                        while (true) {
                            n = nonBlockingInputStream.read(l, bl);
                            if (DumbTerminal.this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
                                if (n == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                                    DumbTerminal.this.raise(Terminal.Signal.INT);
                                    continue;
                                }
                                if (n == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                                    DumbTerminal.this.raise(Terminal.Signal.QUIT);
                                    continue;
                                }
                                if (n == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                                    DumbTerminal.this.raise(Terminal.Signal.TSTP);
                                    continue;
                                }
                                if (n == DumbTerminal.this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                                    DumbTerminal.this.raise(Terminal.Signal.INFO);
                                    continue;
                                }
                            }
                            if (n != 13) break block8;
                            if (!DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) break;
                        }
                        if (DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                            n = 10;
                        }
                        break block9;
                    }
                    if (n == 10 && DumbTerminal.this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
                        n = 13;
                    }
                }
                return n;
            }
        };
        this.output = outputStream;
        this.reader = NonBlocking.nonBlocking(this.getName(), this.input, this.encoding());
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, this.encoding()));
        this.attributes = new Attributes();
        this.attributes.setControlChar(Attributes.ControlChar.VERASE, 127);
        this.attributes.setControlChar(Attributes.ControlChar.VWERASE, 23);
        this.attributes.setControlChar(Attributes.ControlChar.VKILL, 21);
        this.attributes.setControlChar(Attributes.ControlChar.VLNEXT, 22);
        this.size = new Size();
        this.parseInfoCmp();
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.copy(this.attributes);
        return attributes;
    }

    @Override
    public void setAttributes(Attributes attributes) {
        this.attributes.copy(attributes);
    }

    @Override
    public Size getSize() {
        Size size = new Size();
        size.copy(this.size);
        return size;
    }

    @Override
    public void setSize(Size size) {
        this.size.copy(size);
    }

    @Override
    public void close() {
    }
}

