/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.util.function.IntConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.terminal.Cursor;
import org.jline.terminal.Terminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;

public class CursorSupport {
    public static Cursor getCursorPosition(Terminal terminal, IntConsumer intConsumer) {
        try {
            String string = terminal.getStringCapability(InfoCmp.Capability.user6);
            String string2 = terminal.getStringCapability(InfoCmp.Capability.user7);
            if (string == null || string2 == null) {
                return null;
            }
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            block17: while (n < string.length()) {
                char c = string.charAt(n++);
                switch (c) {
                    case '\\': {
                        switch (string.charAt(n++)) {
                            case 'E': 
                            case 'e': {
                                stringBuilder.append("\\x1b");
                                continue block17;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                    case '%': {
                        c = string.charAt(n++);
                        switch (c) {
                            case '%': {
                                stringBuilder.append('%');
                                continue block17;
                            }
                            case 'i': {
                                bl = true;
                                continue block17;
                            }
                            case 'd': {
                                stringBuilder.append("([0-9]+)");
                                continue block17;
                            }
                        }
                        throw new IllegalArgumentException();
                    }
                }
                switch (c) {
                    case '[': {
                        stringBuilder.append('\\');
                    }
                }
                stringBuilder.append(c);
            }
            Pattern pattern = Pattern.compile(stringBuilder.toString());
            Curses.tputs(terminal.writer(), string2, new Object[0]);
            terminal.flush();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n2 = 0;
            while (true) {
                int n3;
                if ((n3 = terminal.reader().read()) < 0) {
                    return null;
                }
                stringBuilder2.append((char)n3);
                Matcher matcher = pattern.matcher(stringBuilder2.substring(n2));
                if (matcher.matches()) {
                    int n4 = Integer.parseInt(matcher.group(1));
                    int n5 = Integer.parseInt(matcher.group(2));
                    if (bl) {
                        --n5;
                        --n4;
                    }
                    if (intConsumer != null) {
                        for (int i = 0; i < n2; ++i) {
                            intConsumer.accept(stringBuilder2.charAt(i));
                        }
                    }
                    return new Cursor(n5, n4);
                }
                if (matcher.hitEnd()) continue;
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }
}

