/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.MouseSupport;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;

public abstract class AbstractTerminal
implements Terminal {
    protected final String name;
    protected final String type;
    protected final Charset encoding;
    protected final Map<Terminal.Signal, Terminal.SignalHandler> handlers = new HashMap<Terminal.Signal, Terminal.SignalHandler>();
    protected final Set<InfoCmp.Capability> bools = new HashSet<InfoCmp.Capability>();
    protected final Map<InfoCmp.Capability, Integer> ints = new HashMap<InfoCmp.Capability, Integer>();
    protected final Map<InfoCmp.Capability, String> strings = new HashMap<InfoCmp.Capability, String>();
    private MouseEvent lastMouseEvent = new MouseEvent(MouseEvent.Type.Moved, MouseEvent.Button.NoButton, EnumSet.noneOf(MouseEvent.Modifier.class), 0, 0);

    public AbstractTerminal(String string, String string2) {
        this(string, string2, null, Terminal.SignalHandler.SIG_DFL);
    }

    public AbstractTerminal(String string, String string2, Charset charset, Terminal.SignalHandler signalHandler) {
        this.name = string;
        this.type = string2;
        this.encoding = charset != null ? charset : Charset.defaultCharset();
        for (Terminal.Signal signal : Terminal.Signal.values()) {
            this.handlers.put(signal, signalHandler);
        }
    }

    @Override
    public Terminal.SignalHandler handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        Objects.requireNonNull(signal);
        Objects.requireNonNull(signalHandler);
        return this.handlers.put(signal, signalHandler);
    }

    @Override
    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        Terminal.SignalHandler signalHandler = this.handlers.get((Object)signal);
        if (signalHandler != Terminal.SignalHandler.SIG_DFL && signalHandler != Terminal.SignalHandler.SIG_IGN) {
            signalHandler.handle(signal);
        }
    }

    protected void echoSignal(Terminal.Signal signal) {
        int n;
        Attributes.ControlChar controlChar = null;
        switch (signal) {
            case INT: {
                controlChar = Attributes.ControlChar.VINTR;
                break;
            }
            case QUIT: {
                controlChar = Attributes.ControlChar.VQUIT;
                break;
            }
            case TSTP: {
                controlChar = Attributes.ControlChar.VSUSP;
            }
        }
        if (controlChar != null && (n = this.getAttributes().getControlChar(controlChar)) > 0 && n < 32) {
            this.writer().write(new char[]{'^', (char)(n + 64)}, 0, 2);
        }
    }

    @Override
    public Attributes enterRawMode() {
        Attributes attributes = this.getAttributes();
        Attributes attributes2 = new Attributes(attributes);
        attributes2.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        attributes2.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        attributes2.setControlChar(Attributes.ControlChar.VMIN, 0);
        attributes2.setControlChar(Attributes.ControlChar.VTIME, 1);
        this.setAttributes(attributes2);
        return attributes;
    }

    @Override
    public boolean echo() {
        return this.getAttributes().getLocalFlag(Attributes.LocalFlag.ECHO);
    }

    @Override
    public boolean echo(boolean bl) {
        Attributes attributes = this.getAttributes();
        boolean bl2 = attributes.getLocalFlag(Attributes.LocalFlag.ECHO);
        if (bl2 != bl) {
            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, bl);
            this.setAttributes(attributes);
        }
        return bl2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String getKind() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Charset encoding() {
        return this.encoding;
    }

    @Override
    public void flush() {
        this.writer().flush();
    }

    @Override
    public boolean puts(InfoCmp.Capability capability, Object ... objectArray) {
        String string = this.getStringCapability(capability);
        if (string == null) {
            return false;
        }
        Curses.tputs(this.writer(), string, objectArray);
        return true;
    }

    @Override
    public boolean getBooleanCapability(InfoCmp.Capability capability) {
        return this.bools.contains((Object)capability);
    }

    @Override
    public Integer getNumericCapability(InfoCmp.Capability capability) {
        return this.ints.get((Object)capability);
    }

    @Override
    public String getStringCapability(InfoCmp.Capability capability) {
        return this.strings.get((Object)capability);
    }

    protected void parseInfoCmp() {
        String string = null;
        if (this.type != null) {
            try {
                string = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception exception) {
                Log.warn("Unable to retrieve infocmp for type " + this.type, exception);
            }
        }
        if (string == null) {
            string = InfoCmp.getLoadedInfoCmp("ansi");
        }
        InfoCmp.parseInfoCmp(string, this.bools, this.ints, this.strings);
    }

    @Override
    public Cursor getCursorPosition(IntConsumer intConsumer) {
        return null;
    }

    @Override
    public boolean hasMouseSupport() {
        return MouseSupport.hasMouseSupport(this);
    }

    @Override
    public boolean trackMouse(Terminal.MouseTracking mouseTracking) {
        return MouseSupport.trackMouse(this, mouseTracking);
    }

    @Override
    public MouseEvent readMouseEvent() {
        this.lastMouseEvent = MouseSupport.readMouse(this, this.lastMouseEvent);
        return this.lastMouseEvent;
    }

    @Override
    public MouseEvent readMouseEvent(IntSupplier intSupplier) {
        this.lastMouseEvent = MouseSupport.readMouse(intSupplier, this.lastMouseEvent);
        return this.lastMouseEvent;
    }

    @Override
    public boolean hasFocusSupport() {
        return this.type != null && this.type.startsWith("xterm");
    }

    @Override
    public boolean trackFocus(boolean bl) {
        if (this.hasFocusSupport()) {
            this.writer().write(bl ? "\u001b[?1004h" : "\u001b[?1004l");
            this.writer().flush();
            return true;
        }
        return false;
    }

    protected void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public boolean canPauseResume() {
        return false;
    }

    @Override
    public void pause() {
    }

    @Override
    public void pause(boolean bl) {
    }

    @Override
    public void resume() {
    }

    @Override
    public boolean paused() {
        return false;
    }
}

