/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.jline.terminal.Attributes;
import org.jline.terminal.spi.Pty;
import org.jline.utils.NonBlockingInputStream;

public abstract class AbstractPty
implements Pty {
    private Attributes current;

    @Override
    public void setAttr(Attributes attributes) {
        this.current = new Attributes(attributes);
        this.doSetAttr(attributes);
    }

    @Override
    public InputStream getSlaveInput() {
        InputStream inputStream = this.doGetSlaveInput();
        if (Boolean.parseBoolean(System.getProperty("org.jline.terminal.pty.nonBlockingReads", "true"))) {
            return new PtyInputStream(inputStream);
        }
        return inputStream;
    }

    protected abstract void doSetAttr(Attributes var1);

    protected abstract InputStream doGetSlaveInput();

    protected void checkInterrupted() {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    class PtyInputStream
    extends NonBlockingInputStream {
        final InputStream in;
        int c = 0;

        PtyInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        @Override
        public int read(long l, boolean bl) {
            long l2;
            AbstractPty.this.checkInterrupted();
            if (this.c != 0) {
                int n = this.c;
                if (!bl) {
                    this.c = 0;
                }
                return n;
            }
            this.setNonBlocking();
            long l3 = System.currentTimeMillis();
            do {
                int n;
                if ((n = this.in.read()) >= 0) {
                    if (bl) {
                        this.c = n;
                    }
                    return n;
                }
                AbstractPty.this.checkInterrupted();
                l2 = System.currentTimeMillis();
            } while (l <= 0L || l2 - l3 <= l);
            return -2;
        }

        private void setNonBlocking() {
            if (AbstractPty.this.current == null || AbstractPty.this.current.getControlChar(Attributes.ControlChar.VMIN) != 0 || AbstractPty.this.current.getControlChar(Attributes.ControlChar.VTIME) != 1) {
                try {
                    Attributes attributes = AbstractPty.this.getAttr();
                    attributes.setControlChar(Attributes.ControlChar.VMIN, 0);
                    attributes.setControlChar(Attributes.ControlChar.VTIME, 1);
                    AbstractPty.this.setAttr(attributes);
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
            }
        }
    }
}

