/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.style.NopStyleSource;
import org.jline.style.StyleBundle;
import org.jline.style.StyleBundleInvocationHandler;
import org.jline.style.StyleFactory;
import org.jline.style.StyleResolver;
import org.jline.style.StyleSource;

public class Styler {
    private static final Logger log = Logger.getLogger(Styler.class.getName());
    private static volatile StyleSource source = new NopStyleSource();

    private Styler() {
    }

    public static StyleSource getSource() {
        return source;
    }

    public static void setSource(StyleSource styleSource) {
        source = Objects.requireNonNull(styleSource);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Source: " + styleSource);
        }
    }

    public static StyleResolver resolver(String string) {
        return new StyleResolver(source, string);
    }

    public static StyleFactory factory(String string) {
        return new StyleFactory(Styler.resolver(string));
    }

    public static <T extends StyleBundle> T bundle(Class<T> clazz) {
        return StyleBundleInvocationHandler.create(source, clazz);
    }

    public static <T extends StyleBundle> T bundle(String string, Class<T> clazz) {
        return StyleBundleInvocationHandler.create(Styler.resolver(string), clazz);
    }
}

