/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jline.style.StyleExpression;
import org.jline.style.StyleResolver;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;

public class StyledWriter
extends PrintWriter {
    private final Terminal terminal;
    private final StyleExpression expression;

    public StyledWriter(Writer writer, Terminal terminal, StyleResolver styleResolver, boolean bl) {
        super(writer, bl);
        this.terminal = Objects.requireNonNull(terminal);
        this.expression = new StyleExpression(styleResolver);
    }

    public StyledWriter(OutputStream outputStream, Terminal terminal, StyleResolver styleResolver, boolean bl) {
        super(outputStream, bl);
        this.terminal = Objects.requireNonNull(terminal);
        this.expression = new StyleExpression(styleResolver);
    }

    @Override
    public void write(@Nonnull String string) {
        AttributedString attributedString = this.expression.evaluate(string);
        super.write(attributedString.toAnsi(this.terminal));
    }

    @Override
    public PrintWriter format(@Nonnull String string, Object ... objectArray) {
        this.print(String.format(string, objectArray));
        return this;
    }

    @Override
    public PrintWriter format(Locale locale, @Nonnull String string, Object ... objectArray) {
        this.print(String.format(locale, string, objectArray));
        return this;
    }
}

