/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Objects;
import org.jline.style.StyleExpression;
import org.jline.style.StyleResolver;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

public class StyleFactory {
    private final StyleResolver resolver;

    public StyleFactory(StyleResolver styleResolver) {
        this.resolver = Objects.requireNonNull(styleResolver);
    }

    public AttributedString style(String string, String string2) {
        Objects.requireNonNull(string2);
        AttributedStyle attributedStyle = this.resolver.resolve(string);
        return new AttributedString(string2, attributedStyle);
    }

    public AttributedString style(String string, String string2, Object ... objectArray) {
        Objects.requireNonNull(string2);
        Objects.requireNonNull(objectArray);
        return this.style(string, String.format(string2, objectArray));
    }

    public AttributedString evaluate(String string) {
        Objects.requireNonNull(string);
        return new StyleExpression(this.resolver).evaluate(string);
    }

    public AttributedString evaluate(String string, Object ... objectArray) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(objectArray);
        return this.evaluate(String.format(string, objectArray));
    }
}

