/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Objects;
import org.jline.style.InterpolationHelper;
import org.jline.style.NopStyleSource;
import org.jline.style.StyleResolver;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class StyleExpression {
    private final StyleResolver resolver;

    public StyleExpression() {
        this(new StyleResolver(new NopStyleSource(), ""));
    }

    public StyleExpression(StyleResolver styleResolver) {
        this.resolver = Objects.requireNonNull(styleResolver);
    }

    public void evaluate(AttributedStringBuilder attributedStringBuilder, String string) {
        Objects.requireNonNull(attributedStringBuilder);
        Objects.requireNonNull(string);
        String string2 = InterpolationHelper.substVars(string, this::style, false);
        attributedStringBuilder.appendAnsi(string2);
    }

    private String style(String string) {
        int n = string.indexOf(32);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            AttributedStyle attributedStyle = this.resolver.resolve(string2);
            return new AttributedStringBuilder().style(attributedStyle).ansiAppend(string3).toAnsi();
        }
        return null;
    }

    public AttributedString evaluate(String string) {
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        this.evaluate(attributedStringBuilder, string);
        return attributedStringBuilder.toAttributedString();
    }
}

