/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.jline.style.StyleBundle;
import org.jline.style.StyleResolver;
import org.jline.style.StyleSource;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;

class StyleBundleInvocationHandler
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(StyleBundleInvocationHandler.class.getName());
    private final Class<? extends StyleBundle> type;
    private final StyleResolver resolver;

    public StyleBundleInvocationHandler(Class<? extends StyleBundle> clazz, StyleResolver styleResolver) {
        this.type = Objects.requireNonNull(clazz);
        this.resolver = Objects.requireNonNull(styleResolver);
    }

    private static void validate(Method method) {
        if (method.getParameterCount() != 1) {
            throw new InvalidStyleBundleMethodException(method, "Invalid parameters");
        }
        if (method.getReturnType() != AttributedString.class) {
            throw new InvalidStyleBundleMethodException(method, "Invalid return-type");
        }
    }

    @Nullable
    private static String emptyToNull(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return string;
    }

    @Nullable
    private static String getStyleGroup(Class<?> clazz) {
        StyleBundle.StyleGroup styleGroup = clazz.getAnnotation(StyleBundle.StyleGroup.class);
        return styleGroup != null ? StyleBundleInvocationHandler.emptyToNull(styleGroup.value().trim()) : null;
    }

    private static String getStyleName(Method method) {
        StyleBundle.StyleName styleName = method.getAnnotation(StyleBundle.StyleName.class);
        return styleName != null ? StyleBundleInvocationHandler.emptyToNull(styleName.value().trim()) : method.getName();
    }

    @Nullable
    private static String getDefaultStyle(Method method) {
        StyleBundle.DefaultStyle defaultStyle = method.getAnnotation(StyleBundle.DefaultStyle.class);
        return defaultStyle != null ? StyleBundleInvocationHandler.emptyToNull(defaultStyle.value()) : null;
    }

    static <T extends StyleBundle> T create(StyleResolver styleResolver, Class<T> clazz) {
        Objects.requireNonNull(styleResolver);
        Objects.requireNonNull(clazz);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Using style-group: %s for type: %s", styleResolver.getGroup(), clazz.getName()));
        }
        StyleBundleInvocationHandler styleBundleInvocationHandler = new StyleBundleInvocationHandler(clazz, styleResolver);
        return (T)((StyleBundle)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)styleBundleInvocationHandler));
    }

    static <T extends StyleBundle> T create(StyleSource styleSource, Class<T> clazz) {
        Objects.requireNonNull(clazz);
        String string = StyleBundleInvocationHandler.getStyleGroup(clazz);
        if (string == null) {
            throw new InvalidStyleGroupException(clazz);
        }
        return StyleBundleInvocationHandler.create(new StyleResolver(styleSource, string), clazz);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, objectArray);
        }
        StyleBundleInvocationHandler.validate(method);
        String string = StyleBundleInvocationHandler.getStyleName(method);
        String string2 = this.resolver.getSource().get(this.resolver.getGroup(), string);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Sourced-style: %s -> %s", string, string2));
        }
        if (string2 == null && (string2 = StyleBundleInvocationHandler.getDefaultStyle(method)) == null) {
            throw new StyleBundleMethodMissingDefaultStyleException(method);
        }
        String string3 = String.valueOf(objectArray[0]);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Applying style: %s -> %s to: %s", string, string2, string3));
        }
        AttributedStyle attributedStyle = this.resolver.resolve(string2);
        return new AttributedString(string3, attributedStyle);
    }

    public String toString() {
        return this.type.getName();
    }

    static class InvalidStyleGroupException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidStyleGroupException(Class<?> clazz) {
            super(String.format("%s missing or invalid @%s: %s", StyleBundle.class.getSimpleName(), StyleBundle.StyleGroup.class.getSimpleName(), clazz.getName()));
        }
    }

    static class InvalidStyleBundleMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidStyleBundleMethodException(Method method, String string) {
            super(string + ": " + method);
        }
    }

    static class StyleBundleMethodMissingDefaultStyleException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StyleBundleMethodMissingDefaultStyleException(Method method) {
            super(String.format("%s method missing @%s: %s", StyleBundle.class.getSimpleName(), StyleBundle.DefaultStyle.class.getSimpleName(), method));
        }
    }
}

