/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.jline.style.StyleSource;

public class MemoryStyleSource
implements StyleSource {
    private static final Logger log = Logger.getLogger(MemoryStyleSource.class.getName());
    private final Map<String, Map<String, String>> backing = new ConcurrentHashMap<String, Map<String, String>>();

    @Override
    @Nullable
    public String get(String string, String string2) {
        String string3 = null;
        Map<String, String> map = this.backing.get(string);
        if (map != null) {
            string3 = map.get(string2);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Get: [%s] %s -> %s", string, string2, string3));
        }
        return string3;
    }

    @Override
    public void set(String string2, String string3, String string4) {
        Objects.requireNonNull(string2);
        Objects.requireNonNull(string3);
        Objects.requireNonNull(string4);
        this.backing.computeIfAbsent(string2, string -> new ConcurrentHashMap()).put(string3, string4);
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Set: [%s] %s -> %s", string2, string3, string4));
        }
    }

    @Override
    public void remove(String string) {
        Objects.requireNonNull(string);
        if (this.backing.remove(string) != null && log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Removed: [%s]", string));
        }
    }

    @Override
    public void remove(String string, String string2) {
        Objects.requireNonNull(string);
        Objects.requireNonNull(string2);
        Map<String, String> map = this.backing.get(string);
        if (map != null) {
            map.remove(string2);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(String.format("Removed: [%s] %s", string, string2));
            }
        }
    }

    @Override
    public void clear() {
        this.backing.clear();
        log.finest("Cleared");
    }

    @Override
    public Iterable<String> groups() {
        return Collections.unmodifiableSet(this.backing.keySet());
    }

    @Override
    public Map<String, String> styles(String string) {
        Objects.requireNonNull(string);
        Map<String, String> map = this.backing.get(string);
        if (map == null) {
            map = Collections.emptyMap();
        }
        return Collections.unmodifiableMap(map);
    }
}

