/*
 * Decompiled with CFR 0.152.
 */
package org.jline.style;

import java.util.function.Function;

public final class InterpolationHelper {
    private static final char ESCAPE_CHAR = '\\';
    private static final String DELIM_START = "@{";
    private static final String DELIM_STOP = "}";
    private static final String MARKER = "@__";

    private InterpolationHelper() {
    }

    public static String substVars(String string, Function<String, String> function, boolean bl) {
        return InterpolationHelper.unescape(InterpolationHelper.doSubstVars(string, function, bl));
    }

    private static String doSubstVars(String string, Function<String, String> function, boolean bl) {
        int n;
        int n2 = -1;
        do {
            int n3;
            n2 = string.indexOf(DELIM_STOP, n2 + 1);
            while (n2 > 0 && string.charAt(n2 - 1) == '\\') {
                n2 = string.indexOf(DELIM_STOP, n2 + 1);
            }
            n = string.indexOf(DELIM_START);
            while (n2 >= 0 && (n3 = string.indexOf(DELIM_START, n + DELIM_START.length())) >= 0 && n3 <= n2) {
                if (n3 >= n2) continue;
                n = n3;
            }
        } while (n >= 0 && n2 >= 0 && n2 < n + DELIM_START.length());
        if (n < 0 || n2 < 0) {
            return string;
        }
        String string2 = string.substring(n + DELIM_START.length(), n2);
        String string3 = null;
        if (string2.length() > 0 && function != null) {
            string3 = function.apply(string2);
        }
        if (string3 == null) {
            string3 = bl ? "" : "@__{" + string2 + DELIM_STOP;
        }
        string = string.substring(0, n) + string3 + string.substring(n2 + DELIM_STOP.length(), string.length());
        string = InterpolationHelper.doSubstVars(string, function, bl);
        return string;
    }

    private static String unescape(String string) {
        string = string.replaceAll(MARKER, "@");
        int n = string.indexOf(92);
        while (n >= 0 && n < string.length() - 1) {
            char c = string.charAt(n + 1);
            if (c == '{' || c == '}' || c == '\\') {
                string = string.substring(0, n) + string.substring(n + 1);
            }
            n = string.indexOf(92, n + 1);
        }
        return string;
    }
}

