/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.history;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Spliterator;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.impl.ReaderUtils;
import org.jline.utils.Log;

public class DefaultHistory
implements History {
    public static final int DEFAULT_HISTORY_SIZE = 500;
    public static final int DEFAULT_HISTORY_FILE_SIZE = 10000;
    private final LinkedList<History.Entry> items = new LinkedList();
    private LineReader reader;
    private int lastLoaded = 0;
    private int nbEntriesInFile = 0;
    private int offset = 0;
    private int index = 0;

    public DefaultHistory() {
    }

    public DefaultHistory(LineReader lineReader) {
        this.attach(lineReader);
    }

    private Path getPath() {
        Object object;
        Object object2 = object = this.reader != null ? this.reader.getVariables().get("history-file") : null;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object instanceof File) {
            return ((File)object).toPath();
        }
        if (object != null) {
            return Paths.get(object.toString(), new String[0]);
        }
        return null;
    }

    @Override
    public void attach(LineReader lineReader) {
        if (this.reader != lineReader) {
            this.reader = lineReader;
            try {
                this.load();
            }
            catch (IOException iOException) {
                Log.warn("Failed to load history", iOException);
            }
        }
    }

    @Override
    public void load() {
        block15: {
            Path path = this.getPath();
            if (path != null) {
                try {
                    if (!Files.exists(path, new LinkOption[0])) break block15;
                    Log.trace("Loading history from: ", path);
                    try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                        this.internalClear();
                        bufferedReader.lines().forEach(string -> {
                            int n = string.indexOf(58);
                            if (n < 0) {
                                throw new IllegalArgumentException("Bad history file syntax! The history file `" + path + "` may be an older history: please remove it or use a different history file.");
                            }
                            Instant instant = Instant.ofEpochMilli(Long.parseLong(string.substring(0, n)));
                            String string2 = DefaultHistory.unescape(string.substring(n + 1));
                            this.internalAdd(instant, string2);
                        });
                        this.nbEntriesInFile = this.lastLoaded = this.items.size();
                        this.maybeResize();
                    }
                }
                catch (IOException iOException) {
                    Log.debug("Failed to load history; clearing", iOException);
                    this.internalClear();
                    throw iOException;
                }
            }
        }
    }

    @Override
    public void purge() {
        this.internalClear();
        Path path = this.getPath();
        if (path != null) {
            Log.trace("Purging history from: ", path);
            Files.deleteIfExists(path);
        }
    }

    @Override
    public void save() {
        Path path = this.getPath();
        if (path != null) {
            Log.trace("Saving history to: ", path);
            Files.createDirectories(path.toAbsolutePath().getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path.toAbsolutePath(), StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.CREATE);){
                for (History.Entry entry : this.items.subList(this.lastLoaded, this.items.size())) {
                    bufferedWriter.append(this.format(entry));
                }
            }
            this.nbEntriesInFile += this.items.size() - this.lastLoaded;
            int n = ReaderUtils.getInt(this.reader, "history-file-size", 10000);
            if (this.nbEntriesInFile > n + n / 4) {
                this.trimHistory(path, n);
            }
        }
        this.lastLoaded = this.items.size();
    }

    protected void trimHistory(Path path, int n) {
        Log.trace("Trimming history path: ", path);
        LinkedList<History.Entry> linkedList = new LinkedList<History.Entry>();
        Object object = Files.newBufferedReader(path);
        Object object2 = null;
        try {
            ((BufferedReader)object).lines().forEach(string -> {
                int n = string.indexOf(58);
                Instant instant = Instant.ofEpochMilli(Long.parseLong(string.substring(0, n)));
                String string2 = DefaultHistory.unescape(string.substring(n + 1));
                linkedList.add(new EntryImpl(linkedList.size(), instant, string2));
            });
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((BufferedReader)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((BufferedReader)object).close();
                }
            }
        }
        DefaultHistory.doTrimHistory(linkedList, n);
        object = Files.createTempFile(path.toAbsolutePath().getParent(), path.getFileName().toString(), ".tmp", new FileAttribute[0]);
        object2 = Files.newBufferedWriter((Path)object, StandardOpenOption.WRITE);
        Throwable throwable = null;
        try {
            for (History.Entry entry : linkedList) {
                ((Writer)object2).append(this.format(entry));
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object2 != null) {
                if (throwable != null) {
                    try {
                        ((BufferedWriter)object2).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((BufferedWriter)object2).close();
                }
            }
        }
        Files.move((Path)object, path, StandardCopyOption.REPLACE_EXISTING);
        this.internalClear();
        this.offset = linkedList.get(0).index();
        this.items.addAll(linkedList);
        this.lastLoaded = this.items.size();
        this.nbEntriesInFile = this.items.size();
        this.maybeResize();
    }

    private void internalClear() {
        this.offset = 0;
        this.index = 0;
        this.lastLoaded = 0;
        this.nbEntriesInFile = 0;
        this.items.clear();
    }

    static void doTrimHistory(List<History.Entry> list, int n) {
        for (int i = 0; i < list.size(); ++i) {
            int n2 = list.size() - i - 1;
            String string = list.get(n2).line().trim();
            ListIterator<History.Entry> listIterator = list.listIterator(n2);
            while (listIterator.hasPrevious()) {
                String string2 = listIterator.previous().line();
                if (!string.equals(string2.trim())) continue;
                listIterator.remove();
            }
        }
        while (list.size() > n) {
            list.remove(0);
        }
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public int index() {
        return this.offset + this.index;
    }

    @Override
    public int first() {
        return this.offset;
    }

    @Override
    public int last() {
        return this.offset + this.items.size() - 1;
    }

    private String format(History.Entry entry) {
        return Long.toString(entry.time().toEpochMilli()) + ":" + DefaultHistory.escape(entry.line()) + "\n";
    }

    @Override
    public String get(int n) {
        return this.items.get(n - this.offset).line();
    }

    @Override
    public void add(Instant instant, String string) {
        Objects.requireNonNull(instant);
        Objects.requireNonNull(string);
        if (ReaderUtils.getBoolean(this.reader, "disable-history", false)) {
            return;
        }
        if (ReaderUtils.isSet(this.reader, LineReader.Option.HISTORY_IGNORE_SPACE) && string.startsWith(" ")) {
            return;
        }
        if (ReaderUtils.isSet(this.reader, LineReader.Option.HISTORY_REDUCE_BLANKS)) {
            string = string.trim();
        }
        if (ReaderUtils.isSet(this.reader, LineReader.Option.HISTORY_IGNORE_DUPS) && !this.items.isEmpty() && string.equals(this.items.getLast().line())) {
            return;
        }
        if (this.matchPatterns(ReaderUtils.getString(this.reader, "history-ignore", ""), string)) {
            return;
        }
        this.internalAdd(instant, string);
        if (ReaderUtils.isSet(this.reader, LineReader.Option.HISTORY_INCREMENTAL)) {
            try {
                this.save();
            }
            catch (IOException iOException) {
                Log.warn("Failed to save history", iOException);
            }
        }
    }

    protected boolean matchPatterns(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                c = string.charAt(++i);
                stringBuilder.append(c);
                continue;
            }
            if (c == ':') {
                stringBuilder.append('|');
                continue;
            }
            if (c != '*') continue;
            stringBuilder.append('.').append('*');
        }
        return string2.matches(stringBuilder.toString());
    }

    protected void internalAdd(Instant instant, String string) {
        EntryImpl entryImpl = new EntryImpl(this.offset + this.items.size(), instant, string);
        this.items.add(entryImpl);
        this.maybeResize();
    }

    private void maybeResize() {
        while (this.size() > ReaderUtils.getInt(this.reader, "history-size", 500)) {
            this.items.removeFirst();
            --this.lastLoaded;
            ++this.offset;
        }
        this.index = this.size();
    }

    @Override
    public ListIterator<History.Entry> iterator(int n) {
        return this.items.listIterator(n - this.offset);
    }

    @Override
    public Spliterator<History.Entry> spliterator() {
        return this.items.spliterator();
    }

    @Override
    public boolean moveToLast() {
        int n = this.size() - 1;
        if (n >= 0 && n != this.index) {
            this.index = this.size() - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveTo(int n) {
        if ((n -= this.offset) >= 0 && n < this.size()) {
            this.index = n;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToFirst() {
        if (this.size() > 0 && this.index != 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public void moveToEnd() {
        this.index = this.size();
    }

    @Override
    public String current() {
        if (this.index >= this.size()) {
            return "";
        }
        return this.items.get(this.index).line();
    }

    @Override
    public boolean previous() {
        if (this.index <= 0) {
            return false;
        }
        --this.index;
        return true;
    }

    @Override
    public boolean next() {
        if (this.index >= this.size()) {
            return false;
        }
        ++this.index;
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (History.Entry entry : this) {
            stringBuilder.append(entry.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuilder.append('\\');
                    stringBuilder.append('n');
                    continue block5;
                }
                case '\r': {
                    stringBuilder.append('\\');
                    stringBuilder.append('r');
                    continue block5;
                }
                case '\\': {
                    stringBuilder.append('\\');
                    stringBuilder.append('\\');
                    continue block5;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static String unescape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block3: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    c = string.charAt(++i);
                    if (c == 'n') {
                        stringBuilder.append('\n');
                        continue block3;
                    }
                    if (c == 'r') {
                        stringBuilder.append('\r');
                        continue block3;
                    }
                    stringBuilder.append(c);
                    continue block3;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    static class EntryImpl
    implements History.Entry {
        private final int index;
        private final Instant time;
        private final String line;

        public EntryImpl(int n, Instant instant, String string) {
            this.index = n;
            this.time = instant;
            this.line = string;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public Instant time() {
            return this.time;
        }

        @Override
        public String line() {
            return this.line;
        }

        public String toString() {
            return String.format("%d: %s", this.index, this.line);
        }
    }
}

