/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class ArgumentCompleter
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();
    private boolean strict = true;

    public ArgumentCompleter(Collection<Completer> collection) {
        Objects.requireNonNull(collection);
        this.completers.addAll(collection);
    }

    public ArgumentCompleter(Completer ... completerArray) {
        this(Arrays.asList(completerArray));
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public List<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
        Objects.requireNonNull(parsedLine);
        Objects.requireNonNull(list);
        if (parsedLine.wordIndex() < 0) {
            return;
        }
        List<Completer> list2 = this.getCompleters();
        Completer completer = parsedLine.wordIndex() >= list2.size() ? list2.get(list2.size() - 1) : list2.get(parsedLine.wordIndex());
        for (int i = 0; this.isStrict() && i < parsedLine.wordIndex(); ++i) {
            Completer completer2 = list2.get(i >= list2.size() ? list2.size() - 1 : i);
            List<String> list3 = parsedLine.words();
            String string = list3 == null || i >= list3.size() ? "" : ((CharSequence)list3.get(i)).toString();
            LinkedList<Candidate> linkedList = new LinkedList<Candidate>();
            completer2.complete(lineReader, new ArgumentLine(string, string.length()), linkedList);
            boolean bl = false;
            for (Candidate candidate : linkedList) {
                if (!candidate.value().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return;
        }
        completer.complete(lineReader, parsedLine, list);
    }

    public static class ArgumentLine
    implements ParsedLine {
        private final String word;
        private final int cursor;

        public ArgumentLine(String string, int n) {
            this.word = string;
            this.cursor = n;
        }

        @Override
        public String word() {
            return this.word;
        }

        @Override
        public int wordCursor() {
            return this.cursor;
        }

        @Override
        public int wordIndex() {
            return 0;
        }

        @Override
        public List<String> words() {
            return Collections.singletonList(this.word);
        }

        @Override
        public String line() {
            return this.word;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }
    }
}

