/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl.completer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class AggregateCompleter
implements Completer {
    private final Collection<Completer> completers;

    public AggregateCompleter(Completer ... completerArray) {
        this(Arrays.asList(completerArray));
    }

    public AggregateCompleter(Collection<Completer> collection) {
        assert (collection != null);
        this.completers = collection;
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
        Objects.requireNonNull(parsedLine);
        Objects.requireNonNull(list);
        this.completers.forEach(completer -> completer.complete(lineReader, parsedLine, list));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{completers=" + this.completers + '}';
    }
}

