/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.io.Flushable;
import java.io.IOError;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.Buffer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.Expander;
import org.jline.reader.Highlighter;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Macro;
import org.jline.reader.MaskingCallback;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;
import org.jline.reader.Reference;
import org.jline.reader.SyntaxError;
import org.jline.reader.Widget;
import org.jline.reader.impl.BufferImpl;
import org.jline.reader.impl.DefaultExpander;
import org.jline.reader.impl.DefaultHighlighter;
import org.jline.reader.impl.DefaultParser;
import org.jline.reader.impl.KillRing;
import org.jline.reader.impl.ReaderUtils;
import org.jline.reader.impl.SimpleMaskingCallback;
import org.jline.reader.impl.UndoTree;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Attributes;
import org.jline.terminal.Cursor;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Curses;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.jline.utils.Levenshtein;
import org.jline.utils.Log;
import org.jline.utils.WCWidth;

public class LineReaderImpl
implements LineReader,
Flushable {
    public static final char NULL_MASK = '\u0000';
    public static final int TAB_WIDTH = 4;
    public static final String DEFAULT_WORDCHARS = "*?_-.[]~=/&;!#$%^(){}<>";
    public static final String DEFAULT_REMOVE_SUFFIX_CHARS = " \t\n;&|";
    public static final String DEFAULT_COMMENT_BEGIN = "#";
    public static final String DEFAULT_SEARCH_TERMINATORS = "\u001b\n";
    public static final String DEFAULT_BELL_STYLE = "";
    public static final int DEFAULT_LIST_MAX = 100;
    public static final int DEFAULT_ERRORS = 2;
    public static final long DEFAULT_BLINK_MATCHING_PAREN = 500L;
    public static final long DEFAULT_AMBIGUOUS_BINDING = 1000L;
    public static final String DEFAULT_SECONDARY_PROMPT_PATTERN = "%M> ";
    public static final String DEFAULT_OTHERS_GROUP_NAME = "others";
    public static final String DEFAULT_ORIGINAL_GROUP_NAME = "original";
    public static final String DEFAULT_COMPLETION_STYLE_STARTING = "36";
    public static final String DEFAULT_COMPLETION_STYLE_DESCRIPTION = "90";
    public static final String DEFAULT_COMPLETION_STYLE_GROUP = "35;1";
    public static final String DEFAULT_COMPLETION_STYLE_SELECTION = "7";
    private static final int MIN_ROWS = 3;
    public static final String BRACKETED_PASTE_ON = "\u001b[?2004h";
    public static final String BRACKETED_PASTE_OFF = "\u001b[?2004l";
    public static final String BRACKETED_PASTE_BEGIN = "\u001b[200~";
    public static final String BRACKETED_PASTE_END = "\u001b[201~";
    public static final String FOCUS_IN_SEQ = "\u001b[I";
    public static final String FOCUS_OUT_SEQ = "\u001b[O";
    protected final Terminal terminal;
    protected final String appName;
    protected final Map<String, KeyMap<Binding>> keyMaps;
    protected final Map<String, Object> variables;
    protected History history = new DefaultHistory();
    protected Completer completer = null;
    protected Highlighter highlighter = new DefaultHighlighter();
    protected Parser parser = new DefaultParser();
    protected Expander expander = new DefaultExpander();
    protected final Map<LineReader.Option, Boolean> options = new HashMap<LineReader.Option, Boolean>();
    protected final Buffer buf = new BufferImpl();
    protected final Size size = new Size();
    protected AttributedString prompt;
    protected AttributedString rightPrompt;
    protected MaskingCallback maskingCallback;
    protected Map<Integer, String> modifiedHistory = new HashMap<Integer, String>();
    protected Buffer historyBuffer = null;
    protected CharSequence searchBuffer;
    protected StringBuffer searchTerm = null;
    protected boolean searchFailing;
    protected boolean searchBackward;
    protected int searchIndex = -1;
    protected final BindingReader bindingReader;
    protected int findChar;
    protected int findDir;
    protected int findTailAdd;
    private int searchDir;
    private String searchString;
    protected int regionMark;
    protected LineReader.RegionType regionActive;
    private boolean forceChar;
    private boolean forceLine;
    protected String yankBuffer = "";
    protected ViMoveMode viMoveMode = ViMoveMode.NORMAL;
    protected KillRing killRing = new KillRing();
    protected UndoTree<Buffer> undo = new UndoTree<Buffer>(this::setBuffer);
    protected boolean isUndo;
    protected State state = State.DONE;
    protected boolean reading;
    protected Supplier<AttributedString> post;
    protected Map<String, Widget> builtinWidgets;
    protected Map<String, Widget> widgets;
    protected int count;
    protected int mult;
    protected int universal = 4;
    protected int repeatCount;
    protected boolean isArgDigit;
    protected ParsedLine parsedLine;
    protected boolean skipRedisplay;
    protected Display display;
    protected boolean overTyping = false;
    protected String keyMap;
    protected int smallTerminalOffset = 0;
    private static final String DESC_PREFIX = "(";
    private static final String DESC_SUFFIX = ")";
    private static final int MARGIN_BETWEEN_DISPLAY_AND_DESC = 1;
    private static final int MARGIN_BETWEEN_COLUMNS = 3;

    public LineReaderImpl(Terminal terminal) {
        this(terminal, null, null);
    }

    public LineReaderImpl(Terminal terminal, String string) {
        this(terminal, string, null);
    }

    public LineReaderImpl(Terminal terminal, String string, Map<String, Object> map) {
        Objects.requireNonNull(terminal, "terminal can not be null");
        this.terminal = terminal;
        if (string == null) {
            string = "JLine";
        }
        this.appName = string;
        this.variables = map != null ? map : new HashMap<String, Object>();
        this.keyMaps = this.defaultKeyMaps();
        this.builtinWidgets = this.builtinWidgets();
        this.widgets = new HashMap<String, Widget>(this.builtinWidgets);
        this.bindingReader = new BindingReader(terminal.reader());
    }

    @Override
    public Terminal getTerminal() {
        return this.terminal;
    }

    @Override
    public String getAppName() {
        return this.appName;
    }

    @Override
    public Map<String, KeyMap<Binding>> getKeyMaps() {
        return this.keyMaps;
    }

    @Override
    public KeyMap<Binding> getKeys() {
        return this.keyMaps.get(this.keyMap);
    }

    @Override
    public Map<String, Widget> getWidgets() {
        return this.widgets;
    }

    @Override
    public Map<String, Widget> getBuiltinWidgets() {
        return Collections.unmodifiableMap(this.builtinWidgets);
    }

    @Override
    public Buffer getBuffer() {
        return this.buf;
    }

    @Override
    public void runMacro(String string) {
        this.bindingReader.runMacro(string);
    }

    @Override
    public MouseEvent readMouseEvent() {
        return this.terminal.readMouseEvent(this.bindingReader::readCharacter);
    }

    public void setCompleter(Completer completer) {
        this.completer = completer;
    }

    public Completer getCompleter() {
        return this.completer;
    }

    public void setHistory(History history) {
        Objects.requireNonNull(history);
        this.history = history;
    }

    @Override
    public History getHistory() {
        return this.history;
    }

    public void setHighlighter(Highlighter highlighter) {
        this.highlighter = highlighter;
    }

    @Override
    public Highlighter getHighlighter() {
        return this.highlighter;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @Override
    public Expander getExpander() {
        return this.expander;
    }

    public void setExpander(Expander expander) {
        this.expander = expander;
    }

    @Override
    public String readLine() {
        return this.readLine(null, null, (MaskingCallback)null, null);
    }

    @Override
    public String readLine(Character c) {
        return this.readLine(null, null, c, null);
    }

    @Override
    public String readLine(String string) {
        return this.readLine(string, null, (MaskingCallback)null, null);
    }

    @Override
    public String readLine(String string, Character c) {
        return this.readLine(string, null, c, null);
    }

    @Override
    public String readLine(String string, Character c, String string2) {
        return this.readLine(string, null, c, string2);
    }

    @Override
    public String readLine(String string, String string2, Character c, String string3) {
        return this.readLine(string, string2, c != null ? new SimpleMaskingCallback(c) : null, string3);
    }

    /*
     * Exception decompiling
     */
    @Override
    public String readLine(String var1_1, String var2_2, MaskingCallback var3_3, String var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean freshLine() {
        boolean bl = this.terminal.getBooleanCapability(InfoCmp.Capability.auto_right_margin);
        boolean bl2 = bl && this.terminal.getBooleanCapability(InfoCmp.Capability.eat_newline_glitch);
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        attributedStringBuilder.style(AttributedStyle.DEFAULT.foreground(8));
        attributedStringBuilder.append("~");
        attributedStringBuilder.style(AttributedStyle.DEFAULT);
        if (!bl || bl2) {
            for (int i = 0; i < this.size.getColumns() - 1; ++i) {
                attributedStringBuilder.append(" ");
            }
            attributedStringBuilder.append(KeyMap.key(this.terminal, InfoCmp.Capability.carriage_return));
            attributedStringBuilder.append(" ");
            attributedStringBuilder.append(KeyMap.key(this.terminal, InfoCmp.Capability.carriage_return));
        } else {
            String string = this.terminal.getStringCapability(InfoCmp.Capability.clr_eol);
            if (string != null) {
                Curses.tputs(attributedStringBuilder, string, new Object[0]);
            }
            for (int i = 0; i < this.size.getColumns() - 2; ++i) {
                attributedStringBuilder.append(" ");
            }
            attributedStringBuilder.append(KeyMap.key(this.terminal, InfoCmp.Capability.carriage_return));
            attributedStringBuilder.append(" ");
            attributedStringBuilder.append(KeyMap.key(this.terminal, InfoCmp.Capability.carriage_return));
        }
        this.print(attributedStringBuilder.toAnsi(this.terminal));
        return true;
    }

    @Override
    public void callWidget(String string) {
        if (!this.reading) {
            throw new IllegalStateException("Widgets can only be called during a `readLine` call");
        }
        try {
            Widget widget = string.startsWith(".") ? this.builtinWidgets.get(string.substring(1)) : this.widgets.get(string);
            if (widget != null) {
                widget.apply();
            }
        }
        catch (Throwable throwable) {
            Log.debug("Error executing widget '", string, "'", throwable);
        }
    }

    public boolean redrawLine() {
        this.display.reset();
        return true;
    }

    public void putString(CharSequence charSequence) {
        this.buf.write(charSequence, this.overTyping);
    }

    @Override
    public void flush() {
        this.terminal.flush();
    }

    public boolean isKeyMap(String string) {
        return this.keyMap.equals(string);
    }

    public int readCharacter() {
        return this.bindingReader.readCharacter();
    }

    public int peekCharacter(long l) {
        return this.bindingReader.peekCharacter(l);
    }

    public Binding readBinding(KeyMap<Binding> keyMap) {
        return this.readBinding(keyMap, null);
    }

    public Binding readBinding(KeyMap<Binding> keyMap, KeyMap<Binding> keyMap2) {
        Binding binding = this.bindingReader.readBinding(keyMap, keyMap2);
        if (binding instanceof Reference) {
            String string = ((Reference)binding).name();
            if (!"yank-pop".equals(string) && !"yank".equals(string)) {
                this.killRing.resetLastYank();
            }
            if (!("kill-line".equals(string) || "kill-whole-line".equals(string) || "backward-kill-word".equals(string) || "kill-word".equals(string))) {
                this.killRing.resetLastKill();
            }
        }
        return binding;
    }

    @Override
    public ParsedLine getParsedLine() {
        return this.parsedLine;
    }

    public String getLastBinding() {
        return this.bindingReader.getLastBinding();
    }

    @Override
    public String getSearchTerm() {
        return this.searchTerm != null ? this.searchTerm.toString() : null;
    }

    @Override
    public LineReader.RegionType getRegionActive() {
        return this.regionActive;
    }

    @Override
    public int getRegionMark() {
        return this.regionMark;
    }

    @Override
    public boolean setKeyMap(String string) {
        KeyMap<Binding> keyMap = this.keyMaps.get(string);
        if (keyMap == null) {
            return false;
        }
        this.keyMap = string;
        if (this.reading) {
            this.callWidget("callback-keymap");
        }
        return true;
    }

    @Override
    public String getKeyMap() {
        return this.keyMap;
    }

    @Override
    public LineReader variable(String string, Object object) {
        this.variables.put(string, object);
        return this;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public Object getVariable(String string) {
        return this.variables.get(string);
    }

    @Override
    public void setVariable(String string, Object object) {
        this.variables.put(string, object);
    }

    @Override
    public LineReader option(LineReader.Option option, boolean bl) {
        this.options.put(option, bl);
        return this;
    }

    @Override
    public boolean isSet(LineReader.Option option) {
        Boolean bl = this.options.get((Object)option);
        return bl != null ? bl.booleanValue() : option.isDef();
    }

    @Override
    public void setOpt(LineReader.Option option) {
        this.options.put(option, Boolean.TRUE);
    }

    @Override
    public void unsetOpt(LineReader.Option option) {
        this.options.put(option, Boolean.FALSE);
    }

    protected String finishBuffer() {
        String string;
        String string2 = string = this.buf.toString();
        if (!this.isSet(LineReader.Option.DISABLE_EVENT_EXPANSION)) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (bl) {
                    bl = false;
                    if (c == '\n') continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                stringBuilder.append(c);
            }
            string = stringBuilder.toString();
        }
        if (this.maskingCallback != null) {
            string2 = this.maskingCallback.history(string2);
        }
        if (string2 != null && string2.length() > 0) {
            this.history.add(Instant.now(), string2);
        }
        return string;
    }

    protected void handleSignal(Terminal.Signal signal) {
        if (signal == Terminal.Signal.WINCH) {
            this.size.copy(this.terminal.getSize());
            this.display.resize(this.size.getRows(), this.size.getColumns());
            this.redisplay();
        } else if (signal == Terminal.Signal.CONT) {
            this.terminal.enterRawMode();
            this.size.copy(this.terminal.getSize());
            this.display.resize(this.size.getRows(), this.size.getColumns());
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.redrawLine();
            this.redisplay();
        }
    }

    protected Widget getWidget(Object object) {
        Widget widget;
        if (object instanceof Widget) {
            widget = (Widget)object;
        } else if (object instanceof Macro) {
            String string = ((Macro)object).getSequence();
            widget = () -> {
                this.bindingReader.runMacro(string);
                return true;
            };
        } else if (object instanceof Reference) {
            String string = ((Reference)object).name();
            widget = this.widgets.get(string);
            if (widget == null) {
                widget = () -> {
                    this.post = () -> new AttributedString("No such widget `" + string + "'");
                    return false;
                };
            }
        } else {
            widget = () -> {
                this.post = () -> new AttributedString("Unsupported widget");
                return false;
            };
        }
        return widget;
    }

    public void setPrompt(String string) {
        this.prompt = string == null ? AttributedString.EMPTY : this.expandPromptPattern(string, 0, DEFAULT_BELL_STYLE, 0);
    }

    public void setRightPrompt(String string) {
        this.rightPrompt = string == null ? AttributedString.EMPTY : this.expandPromptPattern(string, 0, DEFAULT_BELL_STYLE, 0);
    }

    protected void setBuffer(Buffer buffer) {
        this.buf.copyFrom(buffer);
    }

    protected void setBuffer(String string) {
        this.buf.clear();
        this.buf.write(string);
    }

    protected String viDeleteChangeYankToRemap(String string) {
        switch (string) {
            case "abort": 
            case "backward-char": 
            case "forward-char": 
            case "end-of-line": 
            case "vi-match-bracket": 
            case "vi-digit-or-beginning-of-line": 
            case "neg-argument": 
            case "digit-argument": 
            case "vi-backward-char": 
            case "vi-backward-word": 
            case "vi-forward-char": 
            case "vi-forward-word": 
            case "vi-forward-word-end": 
            case "vi-first-non-blank": 
            case "vi-goto-column": 
            case "vi-delete": 
            case "vi-yank": 
            case "vi-change-to": 
            case "vi-find-next-char": 
            case "vi-find-next-char-skip": 
            case "vi-find-prev-char": 
            case "vi-find-prev-char-skip": 
            case "vi-repeat-find": 
            case "vi-rev-repeat-find": {
                return string;
            }
        }
        return "vi-cmd-mode";
    }

    protected int switchCase(int n) {
        if (Character.isUpperCase(n)) {
            return Character.toLowerCase(n);
        }
        if (Character.isLowerCase(n)) {
            return Character.toUpperCase(n);
        }
        return n;
    }

    protected boolean isInViMoveOperation() {
        return this.viMoveMode != ViMoveMode.NORMAL;
    }

    protected boolean isInViChangeOperation() {
        return this.viMoveMode == ViMoveMode.CHANGE;
    }

    protected boolean isInViCmdMode() {
        return "vicmd".equals(this.keyMap);
    }

    protected boolean viForwardChar() {
        if (this.count < 0) {
            return this.callNeg(this::viBackwardChar);
        }
        int n = this.findeol();
        if (this.isInViCmdMode() && !this.isInViMoveOperation()) {
            --n;
        }
        if (this.buf.cursor() >= n) {
            return false;
        }
        while (this.count-- > 0 && this.buf.cursor() < n) {
            this.buf.move(1);
        }
        return true;
    }

    protected boolean viBackwardChar() {
        if (this.count < 0) {
            return this.callNeg(this::viForwardChar);
        }
        int n = this.findbol();
        if (this.buf.cursor() == n) {
            return false;
        }
        while (this.count-- > 0 && this.buf.cursor() > 0) {
            this.buf.move(-1);
            if (this.buf.currChar() != 10) continue;
            this.buf.move(1);
            break;
        }
        return true;
    }

    protected boolean forwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::backwardWord);
        }
        while (this.count-- > 0) {
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
            if (this.isInViChangeOperation() && this.count == 0) break;
            while (this.buf.cursor() < this.buf.length() && !this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
        }
        return true;
    }

    protected boolean viForwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::backwardWord);
        }
        while (this.count-- > 0) {
            int n;
            if (this.isViAlphaNum(this.buf.currChar())) {
                while (this.buf.cursor() < this.buf.length() && this.isViAlphaNum(this.buf.currChar())) {
                    this.buf.move(1);
                }
            } else {
                while (this.buf.cursor() < this.buf.length() && !this.isViAlphaNum(this.buf.currChar()) && !this.isWhitespace(this.buf.currChar())) {
                    this.buf.move(1);
                }
            }
            if (this.isInViChangeOperation() && this.count == 0) {
                return true;
            }
            int n2 = n = this.buf.currChar() == 10 ? 1 : 0;
            while (this.buf.cursor() < this.buf.length() && n < 2 && this.isWhitespace(this.buf.currChar())) {
                this.buf.move(1);
                n += this.buf.currChar() == 10 ? 1 : 0;
            }
        }
        return true;
    }

    protected boolean viForwardBlankWord() {
        if (this.count < 0) {
            return this.callNeg(this::viBackwardBlankWord);
        }
        while (this.count-- > 0) {
            int n;
            while (this.buf.cursor() < this.buf.length() && !this.isWhitespace(this.buf.currChar())) {
                this.buf.move(1);
            }
            if (this.isInViChangeOperation() && this.count == 0) {
                return true;
            }
            int n2 = n = this.buf.currChar() == 10 ? 1 : 0;
            while (this.buf.cursor() < this.buf.length() && n < 2 && this.isWhitespace(this.buf.currChar())) {
                this.buf.move(1);
                n += this.buf.currChar() == 10 ? 1 : 0;
            }
        }
        return true;
    }

    protected boolean emacsForwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::emacsBackwardWord);
        }
        while (this.count-- > 0) {
            while (this.buf.cursor() < this.buf.length() && !this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
            if (this.isInViChangeOperation() && this.count == 0) {
                return true;
            }
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
        }
        return true;
    }

    protected boolean viForwardBlankWordEnd() {
        if (this.count < 0) {
            return false;
        }
        block0: while (this.count-- > 0) {
            while (this.buf.cursor() < this.buf.length()) {
                this.buf.move(1);
                if (this.isWhitespace(this.buf.currChar())) continue;
            }
            while (this.buf.cursor() < this.buf.length()) {
                this.buf.move(1);
                if (!this.isWhitespace(this.buf.currChar())) continue;
                continue block0;
            }
        }
        return true;
    }

    protected boolean viForwardWordEnd() {
        if (this.count < 0) {
            return this.callNeg(this::backwardWord);
        }
        while (this.count-- > 0) {
            while (this.buf.cursor() < this.buf.length() && this.isWhitespace(this.buf.nextChar())) {
                this.buf.move(1);
            }
            if (this.buf.cursor() >= this.buf.length()) continue;
            if (this.isViAlphaNum(this.buf.nextChar())) {
                this.buf.move(1);
                while (this.buf.cursor() < this.buf.length() && this.isViAlphaNum(this.buf.nextChar())) {
                    this.buf.move(1);
                }
                continue;
            }
            this.buf.move(1);
            while (this.buf.cursor() < this.buf.length() && !this.isViAlphaNum(this.buf.nextChar()) && !this.isWhitespace(this.buf.nextChar())) {
                this.buf.move(1);
            }
        }
        if (this.buf.cursor() < this.buf.length() && this.isInViMoveOperation()) {
            this.buf.move(1);
        }
        return true;
    }

    protected boolean backwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::forwardWord);
        }
        while (this.count-- > 0) {
            while (this.buf.cursor() > 0 && !this.isWord(this.buf.atChar(this.buf.cursor() - 1))) {
                this.buf.move(-1);
            }
            while (this.buf.cursor() > 0 && this.isWord(this.buf.atChar(this.buf.cursor() - 1))) {
                this.buf.move(-1);
            }
        }
        return true;
    }

    protected boolean viBackwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::backwardWord);
        }
        while (this.count-- > 0) {
            int n = 0;
            while (this.buf.cursor() > 0) {
                this.buf.move(-1);
                if (!this.isWhitespace(this.buf.currChar())) break;
                if ((n += this.buf.currChar() == 10 ? 1 : 0) != 2) continue;
                this.buf.move(1);
                break;
            }
            if (this.buf.cursor() <= 0) continue;
            if (this.isViAlphaNum(this.buf.currChar())) {
                while (this.buf.cursor() > 0 && this.isViAlphaNum(this.buf.prevChar())) {
                    this.buf.move(-1);
                }
                continue;
            }
            while (this.buf.cursor() > 0 && !this.isViAlphaNum(this.buf.prevChar()) && !this.isWhitespace(this.buf.prevChar())) {
                this.buf.move(-1);
            }
        }
        return true;
    }

    protected boolean viBackwardBlankWord() {
        if (this.count < 0) {
            return this.callNeg(this::viForwardBlankWord);
        }
        block0: while (this.count-- > 0) {
            while (this.buf.cursor() > 0) {
                this.buf.move(-1);
                if (this.isWhitespace(this.buf.currChar())) continue;
            }
            while (this.buf.cursor() > 0) {
                this.buf.move(-1);
                if (!this.isWhitespace(this.buf.currChar())) continue;
                continue block0;
            }
        }
        return true;
    }

    protected boolean viBackwardWordEnd() {
        if (this.count < 0) {
            return this.callNeg(this::viForwardWordEnd);
        }
        while (this.count-- > 0 && this.buf.cursor() > 1) {
            int n = this.isViAlphaNum(this.buf.currChar()) ? 1 : (!this.isWhitespace(this.buf.currChar()) ? 2 : 0);
            while (this.buf.cursor() > 0) {
                boolean bl;
                boolean bl2 = bl = n != 1 && this.isWhitespace(this.buf.currChar());
                if (n != 0) {
                    bl |= this.isViAlphaNum(this.buf.currChar());
                }
                if (bl == (n == 2)) break;
                this.buf.move(-1);
            }
            while (this.buf.cursor() > 0 && this.isWhitespace(this.buf.currChar())) {
                this.buf.move(-1);
            }
        }
        return true;
    }

    protected boolean viBackwardBlankWordEnd() {
        if (this.count < 0) {
            return this.callNeg(this::viForwardBlankWordEnd);
        }
        while (this.count-- > 0) {
            while (this.buf.cursor() > 0 && !this.isWhitespace(this.buf.currChar())) {
                this.buf.move(-1);
            }
            while (this.buf.cursor() > 0 && this.isWhitespace(this.buf.currChar())) {
                this.buf.move(-1);
            }
        }
        return true;
    }

    protected boolean emacsBackwardWord() {
        if (this.count < 0) {
            return this.callNeg(this::emacsForwardWord);
        }
        block0: while (this.count-- > 0) {
            while (this.buf.cursor() > 0) {
                this.buf.move(-1);
                if (!this.isWord(this.buf.currChar())) continue;
            }
            while (this.buf.cursor() > 0) {
                this.buf.move(-1);
                if (this.isWord(this.buf.currChar())) continue;
                continue block0;
            }
        }
        return true;
    }

    protected boolean backwardDeleteWord() {
        if (this.count < 0) {
            return this.callNeg(this::deleteWord);
        }
        int n = this.buf.cursor();
        while (this.count-- > 0) {
            while (n > 0 && !this.isWord(this.buf.atChar(n - 1))) {
                --n;
            }
            while (n > 0 && this.isWord(this.buf.atChar(n - 1))) {
                --n;
            }
        }
        this.buf.backspace(this.buf.cursor() - n);
        return true;
    }

    protected boolean viBackwardKillWord() {
        if (this.count < 0) {
            return false;
        }
        int n = this.findbol();
        int n2 = this.buf.cursor();
        while (this.count-- > 0) {
            while (n2 > n && this.isWhitespace(this.buf.atChar(n2 - 1))) {
                --n2;
            }
            if (n2 <= n) continue;
            if (this.isViAlphaNum(this.buf.atChar(n2 - 1))) {
                while (n2 > n && this.isViAlphaNum(this.buf.atChar(n2 - 1))) {
                    --n2;
                }
                continue;
            }
            while (n2 > n && !this.isViAlphaNum(this.buf.atChar(n2 - 1)) && !this.isWhitespace(this.buf.atChar(n2 - 1))) {
                --n2;
            }
        }
        this.killRing.addBackwards(this.buf.substring(n2, this.buf.cursor()));
        this.buf.backspace(this.buf.cursor() - n2);
        return true;
    }

    protected boolean backwardKillWord() {
        if (this.count < 0) {
            return this.callNeg(this::killWord);
        }
        int n = this.buf.cursor();
        while (this.count-- > 0) {
            while (n > 0 && !this.isWord(this.buf.atChar(n - 1))) {
                --n;
            }
            while (n > 0 && this.isWord(this.buf.atChar(n - 1))) {
                --n;
            }
        }
        this.killRing.addBackwards(this.buf.substring(n, this.buf.cursor()));
        this.buf.backspace(this.buf.cursor() - n);
        return true;
    }

    protected boolean copyPrevWord() {
        int n;
        int n2;
        block4: {
            if (this.count <= 0) {
                return false;
            }
            n2 = this.buf.cursor();
            do {
                n = n2;
                while (n2 > 0 && !this.isWord(this.buf.atChar(n2 - 1))) {
                    --n2;
                }
                while (n2 > 0 && this.isWord(this.buf.atChar(n2 - 1))) {
                    --n2;
                }
                if (--this.count == 0) break block4;
            } while (n2 != 0);
            return false;
        }
        this.buf.write(this.buf.substring(n2, n));
        return true;
    }

    protected boolean upCaseWord() {
        int n = Math.abs(this.count);
        int n2 = this.buf.cursor();
        while (n-- > 0) {
            while (this.buf.cursor() < this.buf.length() && !this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar())) {
                this.buf.currChar(Character.toUpperCase(this.buf.currChar()));
                this.buf.move(1);
            }
        }
        if (this.count < 0) {
            this.buf.cursor(n2);
        }
        return true;
    }

    protected boolean downCaseWord() {
        int n = Math.abs(this.count);
        int n2 = this.buf.cursor();
        while (n-- > 0) {
            while (this.buf.cursor() < this.buf.length() && !this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar())) {
                this.buf.currChar(Character.toLowerCase(this.buf.currChar()));
                this.buf.move(1);
            }
        }
        if (this.count < 0) {
            this.buf.cursor(n2);
        }
        return true;
    }

    protected boolean capitalizeWord() {
        int n = Math.abs(this.count);
        int n2 = this.buf.cursor();
        while (n-- > 0) {
            boolean bl = true;
            while (this.buf.cursor() < this.buf.length() && !this.isWord(this.buf.currChar())) {
                this.buf.move(1);
            }
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar()) && !this.isAlpha(this.buf.currChar())) {
                this.buf.move(1);
            }
            while (this.buf.cursor() < this.buf.length() && this.isWord(this.buf.currChar())) {
                this.buf.currChar(bl ? Character.toUpperCase(this.buf.currChar()) : Character.toLowerCase(this.buf.currChar()));
                this.buf.move(1);
                bl = false;
            }
        }
        if (this.count < 0) {
            this.buf.cursor(n2);
        }
        return true;
    }

    protected boolean deleteWord() {
        if (this.count < 0) {
            return this.callNeg(this::backwardDeleteWord);
        }
        int n = this.buf.cursor();
        while (this.count-- > 0) {
            while (n < this.buf.length() && !this.isWord(this.buf.atChar(n))) {
                ++n;
            }
            while (n < this.buf.length() && this.isWord(this.buf.atChar(n))) {
                ++n;
            }
        }
        this.buf.delete(n - this.buf.cursor());
        return true;
    }

    protected boolean killWord() {
        if (this.count < 0) {
            return this.callNeg(this::backwardKillWord);
        }
        int n = this.buf.cursor();
        while (this.count-- > 0) {
            while (n < this.buf.length() && !this.isWord(this.buf.atChar(n))) {
                ++n;
            }
            while (n < this.buf.length() && this.isWord(this.buf.atChar(n))) {
                ++n;
            }
        }
        this.killRing.add(this.buf.substring(this.buf.cursor(), n));
        this.buf.delete(n - this.buf.cursor());
        return true;
    }

    protected boolean transposeWords() {
        int n;
        int n2 = this.buf.cursor() - 1;
        int n3 = this.buf.cursor();
        while (this.buf.atChar(n2) != 0 && this.buf.atChar(n2) != 10) {
            --n2;
        }
        ++n2;
        while (this.buf.atChar(n3) != 0 && this.buf.atChar(n3) != 10) {
            ++n3;
        }
        if (n3 - n2 < 2) {
            return false;
        }
        int n4 = 0;
        boolean bl = false;
        if (!this.isDelimiter(this.buf.atChar(n2))) {
            ++n4;
            bl = true;
        }
        for (n = n2; n < n3; ++n) {
            if (this.isDelimiter(this.buf.atChar(n))) {
                bl = false;
                continue;
            }
            if (!bl) {
                ++n4;
            }
            bl = true;
        }
        if (n4 < 2) {
            return false;
        }
        n = this.count < 0 ? 1 : 0;
        for (int i = Math.max(this.count, -this.count); i > 0; --i) {
            String string;
            int n5;
            int n6;
            int n7;
            for (n7 = this.buf.cursor(); n7 > n2 && !this.isDelimiter(this.buf.atChar(n7 - 1)); --n7) {
            }
            int n8 = n7;
            while (n8 < n3 && !this.isDelimiter(this.buf.atChar(++n8))) {
            }
            if (n != 0) {
                for (n6 = n7 - 1; n6 > n2 && this.isDelimiter(this.buf.atChar(n6 - 1)); --n6) {
                }
                if (n6 < n2) {
                    n5 = n8;
                    while (this.isDelimiter(this.buf.atChar(++n5))) {
                    }
                    n6 = n5;
                    while (n6 < n3 && !this.isDelimiter(this.buf.atChar(++n6))) {
                    }
                } else {
                    for (n5 = n6; n5 > n2 && !this.isDelimiter(this.buf.atChar(n5 - 1)); --n5) {
                    }
                }
            } else {
                n5 = n8;
                while (n5 < n3 && this.isDelimiter(this.buf.atChar(++n5))) {
                }
                if (n5 == n3) {
                    n6 = n7;
                    while (this.isDelimiter(this.buf.atChar(n6 - 1))) {
                        --n6;
                    }
                    for (n5 = n6; n5 > n2 && !this.isDelimiter(this.buf.atChar(n5 - 1)); --n5) {
                    }
                } else {
                    n6 = n5;
                    while (n6 < n3 && !this.isDelimiter(this.buf.atChar(++n6))) {
                    }
                }
            }
            if (n7 < n5) {
                string = this.buf.substring(0, n7) + this.buf.substring(n5, n6) + this.buf.substring(n8, n5) + this.buf.substring(n7, n8) + this.buf.substring(n6);
                this.buf.clear();
                this.buf.write(string);
                this.buf.cursor(n != 0 ? n8 : n6);
                continue;
            }
            string = this.buf.substring(0, n5) + this.buf.substring(n7, n8) + this.buf.substring(n6, n7) + this.buf.substring(n5, n6) + this.buf.substring(n8);
            this.buf.clear();
            this.buf.write(string);
            this.buf.cursor(n != 0 ? n6 : n8);
        }
        return true;
    }

    private int findbol() {
        int n;
        for (n = this.buf.cursor(); n > 0 && this.buf.atChar(n - 1) != 10; --n) {
        }
        return n;
    }

    private int findeol() {
        int n;
        for (n = this.buf.cursor(); n < this.buf.length() && this.buf.atChar(n) != 10; ++n) {
        }
        return n;
    }

    protected boolean insertComment() {
        return this.doInsertComment(false);
    }

    protected boolean viInsertComment() {
        return this.doInsertComment(true);
    }

    protected boolean doInsertComment(boolean bl) {
        String string = this.getString("comment-begin", DEFAULT_COMMENT_BEGIN);
        this.beginningOfLine();
        this.putString(string);
        if (bl) {
            this.setKeyMap("viins");
        }
        return this.acceptLine();
    }

    protected boolean viFindNextChar() {
        this.findChar = this.vigetkey();
        if (this.findChar > 0) {
            this.findDir = 1;
            this.findTailAdd = 0;
            return this.vifindchar(false);
        }
        return false;
    }

    protected boolean viFindPrevChar() {
        this.findChar = this.vigetkey();
        if (this.findChar > 0) {
            this.findDir = -1;
            this.findTailAdd = 0;
            return this.vifindchar(false);
        }
        return false;
    }

    protected boolean viFindNextCharSkip() {
        this.findChar = this.vigetkey();
        if (this.findChar > 0) {
            this.findDir = 1;
            this.findTailAdd = -1;
            return this.vifindchar(false);
        }
        return false;
    }

    protected boolean viFindPrevCharSkip() {
        this.findChar = this.vigetkey();
        if (this.findChar > 0) {
            this.findDir = -1;
            this.findTailAdd = 1;
            return this.vifindchar(false);
        }
        return false;
    }

    protected boolean viRepeatFind() {
        return this.vifindchar(true);
    }

    protected boolean viRevRepeatFind() {
        if (this.count < 0) {
            return this.callNeg(() -> this.vifindchar(true));
        }
        this.findTailAdd = -this.findTailAdd;
        this.findDir = -this.findDir;
        boolean bl = this.vifindchar(true);
        this.findTailAdd = -this.findTailAdd;
        this.findDir = -this.findDir;
        return bl;
    }

    private int vigetkey() {
        String string;
        Binding binding;
        int n = this.readCharacter();
        KeyMap<Binding> keyMap = this.keyMaps.get("main");
        if (keyMap != null && (binding = keyMap.getBound(new String(Character.toChars(n)))) instanceof Reference && "abort".equals(string = ((Reference)binding).name())) {
            return -1;
        }
        return n;
    }

    private boolean vifindchar(boolean bl) {
        if (this.findDir == 0) {
            return false;
        }
        if (this.count < 0) {
            return this.callNeg(this::viRevRepeatFind);
        }
        if (bl && this.findTailAdd != 0) {
            if (this.findDir > 0) {
                if (this.buf.cursor() < this.buf.length() && this.buf.nextChar() == this.findChar) {
                    this.buf.move(1);
                }
            } else if (this.buf.cursor() > 0 && this.buf.prevChar() == this.findChar) {
                this.buf.move(-1);
            }
        }
        int n = this.buf.cursor();
        while (this.count-- > 0) {
            do {
                this.buf.move(this.findDir);
            } while (this.buf.cursor() > 0 && this.buf.cursor() < this.buf.length() && this.buf.currChar() != this.findChar && this.buf.currChar() != 10);
            if (this.buf.cursor() > 0 && this.buf.cursor() < this.buf.length() && this.buf.currChar() != 10) continue;
            this.buf.cursor(n);
            return false;
        }
        if (this.findTailAdd != 0) {
            this.buf.move(this.findTailAdd);
        }
        if (this.findDir == 1 && this.isInViMoveOperation()) {
            this.buf.move(1);
        }
        return true;
    }

    private boolean callNeg(Widget widget) {
        this.count = -this.count;
        boolean bl = widget.apply();
        this.count = -this.count;
        return bl;
    }

    protected boolean viHistorySearchForward() {
        this.searchDir = 1;
        this.searchIndex = 0;
        return this.getViSearchString() && this.viRepeatSearch();
    }

    protected boolean viHistorySearchBackward() {
        this.searchDir = -1;
        this.searchIndex = this.history.size() - 1;
        return this.getViSearchString() && this.viRepeatSearch();
    }

    protected boolean viRepeatSearch() {
        int n;
        if (this.searchDir == 0) {
            return false;
        }
        int n2 = n = this.searchDir < 0 ? this.searchBackwards(this.searchString, this.searchIndex, false) : this.searchForwards(this.searchString, this.searchIndex, false);
        if (n == -1 || n == this.history.index()) {
            return false;
        }
        this.searchIndex = n;
        this.buf.clear();
        this.history.moveTo(this.searchIndex);
        this.buf.write(this.history.get(this.searchIndex));
        if ("vicmd".equals(this.keyMap)) {
            this.buf.move(-1);
        }
        return true;
    }

    protected boolean viRevRepeatSearch() {
        this.searchDir = -this.searchDir;
        boolean bl = this.viRepeatSearch();
        this.searchDir = -this.searchDir;
        return bl;
    }

    private boolean getViSearchString() {
        if (this.searchDir == 0) {
            return false;
        }
        String string = this.searchDir < 0 ? "?" : "/";
        BufferImpl bufferImpl = new BufferImpl();
        KeyMap<Binding> keyMap = this.keyMaps.get("main");
        if (keyMap == null) {
            keyMap = this.keyMaps.get(".safe");
        }
        block28: while (true) {
            String string2;
            this.post = () -> new AttributedString(string + bufferImpl.toString() + "_");
            this.redisplay();
            Binding binding = this.bindingReader.readBinding(keyMap);
            if (!(binding instanceof Reference)) continue;
            switch (string2 = ((Reference)binding).name()) {
                case "abort": {
                    this.post = null;
                    return false;
                }
                case "accept-line": 
                case "vi-cmd-mode": {
                    this.searchString = bufferImpl.toString();
                    this.post = null;
                    return true;
                }
                case "magic-space": {
                    bufferImpl.write(32);
                    continue block28;
                }
                case "redisplay": {
                    this.redisplay();
                    continue block28;
                }
                case "clear-screen": {
                    this.clearScreen();
                    continue block28;
                }
                case "self-insert": {
                    bufferImpl.write(this.getLastBinding());
                    continue block28;
                }
                case "self-insert-unmeta": {
                    if (this.getLastBinding().charAt(0) != '\u001b') continue block28;
                    String string3 = this.getLastBinding().substring(1);
                    if ("\r".equals(string3)) {
                        string3 = "\n";
                    }
                    bufferImpl.write(string3);
                    continue block28;
                }
                case "backward-delete-char": 
                case "vi-backward-delete-char": {
                    if (bufferImpl.length() <= 0) continue block28;
                    bufferImpl.backspace();
                    continue block28;
                }
                case "backward-kill-word": 
                case "vi-backward-kill-word": {
                    if (bufferImpl.length() > 0 && !this.isWhitespace(bufferImpl.prevChar())) {
                        bufferImpl.backspace();
                    }
                    if (bufferImpl.length() <= 0 || !this.isWhitespace(bufferImpl.prevChar())) continue block28;
                    bufferImpl.backspace();
                    continue block28;
                }
                case "quoted-insert": 
                case "vi-quoted-insert": {
                    int n = this.readCharacter();
                    if (n >= 0) {
                        bufferImpl.write(n);
                        continue block28;
                    }
                    this.beep();
                    continue block28;
                }
            }
            this.beep();
        }
    }

    protected boolean insertCloseCurly() {
        return this.insertClose("}");
    }

    protected boolean insertCloseParen() {
        return this.insertClose(DESC_SUFFIX);
    }

    protected boolean insertCloseSquare() {
        return this.insertClose("]");
    }

    protected boolean insertClose(String string) {
        this.putString(string);
        long l = this.getLong("blink-matching-paren", 500L);
        if (l <= 0L) {
            return true;
        }
        int n = this.buf.cursor();
        this.buf.move(-1);
        this.doViMatchBracket();
        this.redisplay();
        this.peekCharacter(l);
        this.buf.cursor(n);
        return true;
    }

    protected boolean viMatchBracket() {
        return this.doViMatchBracket();
    }

    protected boolean undefinedKey() {
        return false;
    }

    protected boolean doViMatchBracket() {
        int n = this.buf.cursor();
        if (n == this.buf.length()) {
            return false;
        }
        int n2 = this.getBracketType(this.buf.atChar(n));
        int n3 = n2 < 0 ? -1 : 1;
        int n4 = 1;
        if (n2 == 0) {
            return false;
        }
        while (n4 > 0) {
            if ((n += n3) < 0 || n >= this.buf.length()) {
                return false;
            }
            int n5 = this.getBracketType(this.buf.atChar(n));
            if (n5 == n2) {
                ++n4;
                continue;
            }
            if (n5 != -n2) continue;
            --n4;
        }
        if (n3 > 0 && this.isInViMoveOperation()) {
            ++n;
        }
        this.buf.cursor(n);
        return true;
    }

    protected int getBracketType(int n) {
        switch (n) {
            case 91: {
                return 1;
            }
            case 93: {
                return -1;
            }
            case 123: {
                return 2;
            }
            case 125: {
                return -2;
            }
            case 40: {
                return 3;
            }
            case 41: {
                return -3;
            }
        }
        return 0;
    }

    protected boolean transposeChars() {
        int n = this.buf.cursor() - 1;
        int n2 = this.buf.cursor();
        while (this.buf.atChar(n) != 0 && this.buf.atChar(n) != 10) {
            --n;
        }
        ++n;
        while (this.buf.atChar(n2) != 0 && this.buf.atChar(n2) != 10) {
            ++n2;
        }
        if (n2 - n < 2) {
            return false;
        }
        boolean bl = this.count < 0;
        for (int i = Math.max(this.count, -this.count); i > 0; --i) {
            while (this.buf.cursor() <= n) {
                this.buf.move(1);
            }
            while (this.buf.cursor() >= n2) {
                this.buf.move(-1);
            }
            int n3 = this.buf.currChar();
            this.buf.currChar(this.buf.prevChar());
            this.buf.move(-1);
            this.buf.currChar(n3);
            this.buf.move(bl ? 0 : 2);
        }
        return true;
    }

    protected boolean undo() {
        this.isUndo = true;
        if (this.undo.canUndo()) {
            this.undo.undo();
            return true;
        }
        return false;
    }

    protected boolean redo() {
        this.isUndo = true;
        if (this.undo.canRedo()) {
            this.undo.redo();
            return true;
        }
        return false;
    }

    protected boolean sendBreak() {
        if (this.searchTerm == null) {
            this.buf.clear();
            this.println();
            this.redrawLine();
            return false;
        }
        return true;
    }

    protected boolean backwardChar() {
        return this.buf.move(-this.count) != 0;
    }

    protected boolean forwardChar() {
        return this.buf.move(this.count) != 0;
    }

    protected boolean viDigitOrBeginningOfLine() {
        if (this.repeatCount > 0) {
            return this.digitArgument();
        }
        return this.beginningOfLine();
    }

    protected boolean universalArgument() {
        this.mult *= this.universal;
        this.isArgDigit = true;
        return true;
    }

    protected boolean argumentBase() {
        if (this.repeatCount > 0 && this.repeatCount < 32) {
            this.universal = this.repeatCount;
            this.isArgDigit = true;
            return true;
        }
        return false;
    }

    protected boolean negArgument() {
        this.mult *= -1;
        this.isArgDigit = true;
        return true;
    }

    protected boolean digitArgument() {
        String string = this.getLastBinding();
        this.repeatCount = this.repeatCount * 10 + string.charAt(string.length() - 1) - 48;
        this.isArgDigit = true;
        return true;
    }

    protected boolean viDelete() {
        int n = this.buf.cursor();
        Binding binding = this.readBinding(this.getKeys());
        if (binding instanceof Reference) {
            String string = this.viDeleteChangeYankToRemap(((Reference)binding).name());
            if ("vi-delete".equals(string)) {
                this.killWholeLine();
            } else {
                this.viMoveMode = ViMoveMode.DELETE;
                Widget widget = this.widgets.get(string);
                if (widget != null && !widget.apply()) {
                    this.viMoveMode = ViMoveMode.NORMAL;
                    return false;
                }
                this.viMoveMode = ViMoveMode.NORMAL;
            }
            return this.viDeleteTo(n, this.buf.cursor());
        }
        this.pushBackBinding();
        return false;
    }

    protected boolean viYankTo() {
        int n = this.buf.cursor();
        Binding binding = this.readBinding(this.getKeys());
        if (binding instanceof Reference) {
            String string = this.viDeleteChangeYankToRemap(((Reference)binding).name());
            if ("vi-yank".equals(string)) {
                this.yankBuffer = this.buf.toString();
                return true;
            }
            this.viMoveMode = ViMoveMode.YANK;
            Widget widget = this.widgets.get(string);
            if (widget != null && !widget.apply()) {
                return false;
            }
            this.viMoveMode = ViMoveMode.NORMAL;
            return this.viYankTo(n, this.buf.cursor());
        }
        this.pushBackBinding();
        return false;
    }

    protected boolean viYankWholeLine() {
        int n = this.buf.cursor();
        while (this.buf.move(-1) == -1 && this.buf.prevChar() != 10) {
        }
        int n2 = this.buf.cursor();
        for (int i = 0; i < this.repeatCount; ++i) {
            while (this.buf.move(1) == 1 && this.buf.prevChar() != 10) {
            }
        }
        int n3 = this.buf.cursor();
        this.yankBuffer = this.buf.substring(n2, n3);
        if (!this.yankBuffer.endsWith("\n")) {
            this.yankBuffer = this.yankBuffer + "\n";
        }
        this.buf.cursor(n);
        return true;
    }

    protected boolean viChange() {
        int n = this.buf.cursor();
        Binding binding = this.readBinding(this.getKeys());
        if (binding instanceof Reference) {
            String string = this.viDeleteChangeYankToRemap(((Reference)binding).name());
            if ("vi-change-to".equals(string)) {
                this.killWholeLine();
            } else {
                this.viMoveMode = ViMoveMode.CHANGE;
                Widget widget = this.widgets.get(string);
                if (widget != null && !widget.apply()) {
                    this.viMoveMode = ViMoveMode.NORMAL;
                    return false;
                }
                this.viMoveMode = ViMoveMode.NORMAL;
            }
            boolean bl = this.viChange(n, this.buf.cursor());
            this.setKeyMap("viins");
            return bl;
        }
        this.pushBackBinding();
        return false;
    }

    protected void cleanup() {
        if (this.isSet(LineReader.Option.ERASE_LINE_ON_FINISH)) {
            Buffer buffer = this.buf.copy();
            AttributedString attributedString = this.prompt;
            this.buf.clear();
            this.prompt = new AttributedString(DEFAULT_BELL_STYLE);
            this.doCleanup();
            this.prompt = attributedString;
            this.buf.copyFrom(buffer);
        } else {
            this.doCleanup();
        }
    }

    protected void doCleanup() {
        this.buf.cursor(this.buf.length());
        this.post = null;
        if (this.size.getColumns() > 0 || this.size.getRows() > 0) {
            this.redisplay(false);
            this.println();
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.trackMouse(Terminal.MouseTracking.Off);
            if (this.isSet(LineReader.Option.BRACKETED_PASTE)) {
                this.terminal.writer().write(BRACKETED_PASTE_OFF);
            }
            this.flush();
        }
        this.history.moveToEnd();
    }

    protected boolean historyIncrementalSearchForward() {
        return this.doSearchHistory(false);
    }

    protected boolean historyIncrementalSearchBackward() {
        return this.doSearchHistory(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doSearchHistory(boolean bl) {
        if (this.history.isEmpty()) {
            return false;
        }
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.getString("search-terminators", DEFAULT_SEARCH_TERMINATORS).codePoints().forEach(n -> this.bind(keyMap, "accept-line", new String(Character.toChars(n))));
        Buffer buffer = this.buf.copy();
        this.searchIndex = -1;
        this.searchTerm = new StringBuffer();
        this.searchBackward = bl;
        this.searchFailing = false;
        this.post = () -> new AttributedString((this.searchFailing ? "failing " : DEFAULT_BELL_STYLE) + (this.searchBackward ? "bck-i-search" : "fwd-i-search") + ": " + this.searchTerm + "_");
        this.redisplay();
        try {
            while (true) {
                int n2 = this.searchIndex;
                Binding binding = this.readBinding(this.getKeys(), keyMap);
                String string = binding instanceof Reference ? ((Reference)binding).name() : DEFAULT_BELL_STYLE;
                boolean bl2 = false;
                switch (string) {
                    case "abort": {
                        this.beep();
                        this.buf.copyFrom(buffer);
                        boolean bl3 = true;
                        return bl3;
                    }
                    case "history-incremental-search-backward": {
                        this.searchBackward = true;
                        bl2 = true;
                        break;
                    }
                    case "history-incremental-search-forward": {
                        this.searchBackward = false;
                        bl2 = true;
                        break;
                    }
                    case "backward-delete-char": {
                        if (this.searchTerm.length() <= 0) break;
                        this.searchTerm.deleteCharAt(this.searchTerm.length() - 1);
                        break;
                    }
                    case "self-insert": {
                        this.searchTerm.append(this.getLastBinding());
                        break;
                    }
                    default: {
                        if (this.searchIndex != -1) {
                            this.history.moveTo(this.searchIndex);
                        }
                        this.pushBackBinding();
                        boolean bl4 = true;
                        return bl4;
                    }
                }
                String string2 = this.doGetSearchPattern();
                if (string2.length() == 0) {
                    this.buf.copyFrom(buffer);
                    this.searchFailing = false;
                } else {
                    boolean bl5;
                    int n3 = this.isSet(LineReader.Option.CASE_INSENSITIVE_SEARCH) ? 1 : 0;
                    Pattern pattern = Pattern.compile(string2, n3 != 0 ? 66 : 64);
                    Pair pair2 = null;
                    if (this.searchBackward) {
                        bl5 = bl2;
                        pair2 = this.matches(pattern, this.buf.toString(), this.searchIndex).stream().filter(pair -> bl5 ? (Integer)pair.v < this.buf.cursor() : (Integer)pair.v <= this.buf.cursor()).max(Comparator.comparing(Pair::getV)).orElse(null);
                        if (pair2 == null) {
                            pair2 = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.history.reverseIterator(this.searchIndex < 0 ? this.history.last() : this.searchIndex - 1), 16), false).flatMap(entry -> this.matches(pattern, entry.line(), entry.index()).stream()).findFirst().orElse(null);
                        }
                    } else {
                        bl5 = bl2;
                        pair2 = this.matches(pattern, this.buf.toString(), this.searchIndex).stream().filter(pair -> bl5 ? (Integer)pair.v > this.buf.cursor() : (Integer)pair.v >= this.buf.cursor()).min(Comparator.comparing(Pair::getV)).orElse(null);
                        if (pair2 == null && (pair2 = (Pair)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.history.iterator((this.searchIndex < 0 ? this.history.last() : this.searchIndex) + 1), 16), false).flatMap(entry -> this.matches(pattern, entry.line(), entry.index()).stream()).findFirst().orElse(null)) == null && this.searchIndex >= 0) {
                            pair2 = this.matches(pattern, buffer.toString(), -1).stream().min(Comparator.comparing(Pair::getV)).orElse(null);
                        }
                    }
                    if (pair2 != null) {
                        this.searchIndex = (Integer)pair2.u;
                        this.buf.clear();
                        if (this.searchIndex >= 0) {
                            this.buf.write(this.history.get(this.searchIndex));
                        } else {
                            this.buf.write(buffer.toString());
                        }
                        this.buf.cursor((Integer)pair2.v);
                        this.searchFailing = false;
                    } else {
                        this.searchFailing = true;
                        this.beep();
                    }
                }
                this.redisplay();
                continue;
                break;
            }
        }
        catch (IOError iOError) {
            if (!(iOError.getCause() instanceof InterruptedException)) {
                throw iOError;
            }
            boolean bl6 = true;
            return bl6;
        }
        finally {
            this.searchTerm = null;
            this.searchIndex = -1;
            this.post = null;
        }
    }

    private List<Pair<Integer, Integer>> matches(Pattern pattern, String string, int n) {
        ArrayList<Pair<Integer, Integer>> arrayList = new ArrayList<Pair<Integer, Integer>>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            arrayList.add(new Pair<Integer, Integer>(n, matcher.start()));
        }
        return arrayList;
    }

    private String doGetSearchPattern() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < this.searchTerm.length(); ++i) {
            char c = this.searchTerm.charAt(i);
            if (Character.isLowerCase(c)) {
                if (bl) {
                    stringBuilder.append("\\E");
                    bl = false;
                }
                stringBuilder.append("[").append(Character.toLowerCase(c)).append(Character.toUpperCase(c)).append("]");
                continue;
            }
            if (!bl) {
                stringBuilder.append("\\Q");
                bl = true;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            stringBuilder.append("\\E");
        }
        return stringBuilder.toString();
    }

    private void pushBackBinding() {
        this.pushBackBinding(false);
    }

    private void pushBackBinding(boolean bl) {
        String string = this.getLastBinding();
        if (string != null) {
            this.bindingReader.runMacro(string);
            this.skipRedisplay = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean historySearchForward() {
        int n;
        if (this.historyBuffer == null || this.buf.length() == 0 || !this.buf.toString().equals(this.history.current())) {
            this.historyBuffer = this.buf.copy();
            this.searchBuffer = this.getFirstWord();
        }
        if ((n = this.history.index() + 1) >= this.history.last() + 1) {
            this.history.moveToEnd();
            if (this.buf.toString().equals(this.historyBuffer.toString())) return false;
            this.setBuffer(this.historyBuffer.toString());
            this.historyBuffer = null;
            return true;
        }
        int n2 = this.searchForwards(this.searchBuffer.toString(), n, true);
        if (n2 == -1) {
            this.history.moveToEnd();
            if (this.buf.toString().equals(this.historyBuffer.toString())) return false;
            this.setBuffer(this.historyBuffer.toString());
            this.historyBuffer = null;
            return true;
        }
        if (this.history.moveTo(n2)) {
            this.setBuffer(this.history.current());
            return true;
        }
        this.history.moveToEnd();
        this.setBuffer(this.historyBuffer.toString());
        return false;
    }

    private CharSequence getFirstWord() {
        int n;
        String string = this.buf.toString();
        for (n = 0; n < string.length() && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    protected boolean historySearchBackward() {
        int n;
        if (this.historyBuffer == null || this.buf.length() == 0 || !this.buf.toString().equals(this.history.current())) {
            this.historyBuffer = this.buf.copy();
            this.searchBuffer = this.getFirstWord();
        }
        if ((n = this.searchBackwards(this.searchBuffer.toString(), this.history.index(), true)) == -1) {
            return false;
        }
        if (!this.history.moveTo(n)) {
            return false;
        }
        this.setBuffer(this.history.current());
        return true;
    }

    public int searchBackwards(String string, int n) {
        return this.searchBackwards(string, n, false);
    }

    public int searchBackwards(String string) {
        return this.searchBackwards(string, this.history.index(), false);
    }

    public int searchBackwards(String string, int n, boolean bl) {
        boolean bl2 = this.isSet(LineReader.Option.CASE_INSENSITIVE_SEARCH);
        if (bl2) {
            string = string.toLowerCase();
        }
        ListIterator<History.Entry> listIterator = this.history.iterator(n);
        while (listIterator.hasPrevious()) {
            History.Entry entry = listIterator.previous();
            String string2 = entry.line();
            if (bl2) {
                string2 = string2.toLowerCase();
            }
            int n2 = string2.indexOf(string);
            if ((!bl || n2 != 0) && (bl || n2 < 0)) continue;
            return entry.index();
        }
        return -1;
    }

    public int searchForwards(String string, int n, boolean bl) {
        boolean bl2 = this.isSet(LineReader.Option.CASE_INSENSITIVE_SEARCH);
        if (bl2) {
            string = string.toLowerCase();
        }
        if (n > this.history.last()) {
            n = this.history.last();
        }
        ListIterator<History.Entry> listIterator = this.history.iterator(n);
        if (this.searchIndex != -1 && listIterator.hasNext()) {
            listIterator.next();
        }
        while (listIterator.hasNext()) {
            History.Entry entry = listIterator.next();
            String string2 = entry.line();
            if (bl2) {
                string2 = string2.toLowerCase();
            }
            int n2 = string2.indexOf(string);
            if ((!bl || n2 != 0) && (bl || n2 < 0)) continue;
            return entry.index();
        }
        return -1;
    }

    public int searchForwards(String string, int n) {
        return this.searchForwards(string, n, false);
    }

    public int searchForwards(String string) {
        return this.searchForwards(string, this.history.index());
    }

    protected boolean quit() {
        this.getBuffer().clear();
        return this.acceptLine();
    }

    protected boolean acceptLine() {
        this.parsedLine = null;
        if (!this.isSet(LineReader.Option.DISABLE_EVENT_EXPANSION)) {
            try {
                String string = this.buf.toString();
                String string2 = this.expander.expandHistory(this.history, string);
                if (!string2.equals(string)) {
                    this.buf.clear();
                    this.buf.write(string2);
                    if (this.isSet(LineReader.Option.HISTORY_VERIFY)) {
                        return true;
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            this.parsedLine = this.parser.parse(this.buf.toString(), this.buf.cursor(), Parser.ParseContext.ACCEPT_LINE);
        }
        catch (EOFError eOFError) {
            this.buf.write("\n");
            return true;
        }
        catch (SyntaxError syntaxError) {
            // empty catch block
        }
        this.callWidget("callback-finish");
        this.state = State.DONE;
        return true;
    }

    protected boolean selfInsert() {
        for (int i = this.count; i > 0; --i) {
            this.putString(this.getLastBinding());
        }
        return true;
    }

    protected boolean selfInsertUnmeta() {
        if (this.getLastBinding().charAt(0) == '\u001b') {
            String string = this.getLastBinding().substring(1);
            if ("\r".equals(string)) {
                string = "\n";
            }
            for (int i = this.count; i > 0; --i) {
                this.putString(string);
            }
            return true;
        }
        return false;
    }

    protected boolean overwriteMode() {
        this.overTyping = !this.overTyping;
        return true;
    }

    protected boolean beginningOfBufferOrHistory() {
        if (this.findbol() != 0) {
            this.buf.cursor(0);
            return true;
        }
        return this.beginningOfHistory();
    }

    protected boolean beginningOfHistory() {
        if (this.history.moveToFirst()) {
            this.setBuffer(this.history.current());
            return true;
        }
        return false;
    }

    protected boolean endOfBufferOrHistory() {
        if (this.findeol() != this.buf.length()) {
            this.buf.cursor(this.buf.length());
            return true;
        }
        return this.endOfHistory();
    }

    protected boolean endOfHistory() {
        if (this.history.moveToLast()) {
            this.setBuffer(this.history.current());
            return true;
        }
        return false;
    }

    protected boolean beginningOfLineHist() {
        if (this.count < 0) {
            return this.callNeg(this::endOfLineHist);
        }
        while (this.count-- > 0) {
            int n = this.findbol();
            if (n != this.buf.cursor()) {
                this.buf.cursor(n);
                continue;
            }
            this.moveHistory(false);
            this.buf.cursor(0);
        }
        return true;
    }

    protected boolean endOfLineHist() {
        if (this.count < 0) {
            return this.callNeg(this::beginningOfLineHist);
        }
        while (this.count-- > 0) {
            int n = this.findeol();
            if (n != this.buf.cursor()) {
                this.buf.cursor(n);
                continue;
            }
            this.moveHistory(true);
        }
        return true;
    }

    protected boolean upHistory() {
        while (this.count-- > 0) {
            if (this.moveHistory(false)) continue;
            return !this.isSet(LineReader.Option.HISTORY_BEEP);
        }
        return true;
    }

    protected boolean downHistory() {
        while (this.count-- > 0) {
            if (this.moveHistory(true)) continue;
            return !this.isSet(LineReader.Option.HISTORY_BEEP);
        }
        return true;
    }

    protected boolean viUpLineOrHistory() {
        return this.upLine() || this.upHistory() && this.viFirstNonBlank();
    }

    protected boolean viDownLineOrHistory() {
        return this.downLine() || this.downHistory() && this.viFirstNonBlank();
    }

    protected boolean upLine() {
        return this.buf.up();
    }

    protected boolean downLine() {
        return this.buf.down();
    }

    protected boolean upLineOrHistory() {
        return this.upLine() || this.upHistory();
    }

    protected boolean upLineOrSearch() {
        return this.upLine() || this.historySearchBackward();
    }

    protected boolean downLineOrHistory() {
        return this.downLine() || this.downHistory();
    }

    protected boolean downLineOrSearch() {
        return this.downLine() || this.historySearchForward();
    }

    protected boolean viCmdMode() {
        if (this.state == State.NORMAL) {
            this.buf.move(-1);
        }
        return this.setKeyMap("vicmd");
    }

    protected boolean viInsert() {
        return this.setKeyMap("viins");
    }

    protected boolean viAddNext() {
        this.buf.move(1);
        return this.setKeyMap("viins");
    }

    protected boolean viAddEol() {
        return this.endOfLine() && this.setKeyMap("viins");
    }

    protected boolean emacsEditingMode() {
        return this.setKeyMap("emacs");
    }

    protected boolean viChangeWholeLine() {
        return this.viFirstNonBlank() && this.viChangeEol();
    }

    protected boolean viChangeEol() {
        return this.viChange(this.buf.cursor(), this.buf.length()) && this.setKeyMap("viins");
    }

    protected boolean viKillEol() {
        int n = this.findeol();
        if (this.buf.cursor() == n) {
            return false;
        }
        this.killRing.add(this.buf.substring(this.buf.cursor(), n));
        this.buf.delete(n - this.buf.cursor());
        return true;
    }

    protected boolean quotedInsert() {
        int n = this.readCharacter();
        while (this.count-- > 0) {
            this.putString(new String(Character.toChars(n)));
        }
        return true;
    }

    protected boolean viJoin() {
        if (this.buf.down()) {
            while (this.buf.move(-1) == -1 && this.buf.prevChar() != 10) {
            }
            this.buf.backspace();
            this.buf.write(32);
            this.buf.move(-1);
            return true;
        }
        return false;
    }

    protected boolean viKillWholeLine() {
        return this.killWholeLine() && this.setKeyMap("viins");
    }

    protected boolean viInsertBol() {
        return this.beginningOfLine() && this.setKeyMap("viins");
    }

    protected boolean backwardDeleteChar() {
        if (this.count < 0) {
            return this.callNeg(this::deleteChar);
        }
        if (this.buf.cursor() == 0) {
            return false;
        }
        this.buf.backspace(this.count);
        return true;
    }

    protected boolean viFirstNonBlank() {
        this.beginningOfLine();
        while (this.buf.cursor() < this.buf.length() && this.isWhitespace(this.buf.currChar())) {
            this.buf.move(1);
        }
        return true;
    }

    protected boolean viBeginningOfLine() {
        this.buf.cursor(this.findbol());
        return true;
    }

    protected boolean viEndOfLine() {
        if (this.count < 0) {
            return false;
        }
        while (this.count-- > 0) {
            this.buf.cursor(this.findeol() + 1);
        }
        this.buf.move(-1);
        return true;
    }

    protected boolean beginningOfLine() {
        while (this.count-- > 0) {
            while (this.buf.move(-1) == -1 && this.buf.prevChar() != 10) {
            }
        }
        return true;
    }

    protected boolean endOfLine() {
        while (this.count-- > 0) {
            while (this.buf.move(1) == 1 && this.buf.currChar() != 10) {
            }
        }
        return true;
    }

    protected boolean deleteChar() {
        if (this.count < 0) {
            return this.callNeg(this::backwardDeleteChar);
        }
        if (this.buf.cursor() == this.buf.length()) {
            return false;
        }
        this.buf.delete(this.count);
        return true;
    }

    protected boolean viBackwardDeleteChar() {
        for (int i = 0; i < this.count; ++i) {
            if (this.buf.backspace()) continue;
            return false;
        }
        return true;
    }

    protected boolean viDeleteChar() {
        for (int i = 0; i < this.count; ++i) {
            if (this.buf.delete()) continue;
            return false;
        }
        return true;
    }

    protected boolean viSwapCase() {
        for (int i = 0; i < this.count; ++i) {
            if (this.buf.cursor() >= this.buf.length()) {
                return false;
            }
            int n = this.buf.atChar(this.buf.cursor());
            n = this.switchCase(n);
            this.buf.currChar(n);
            this.buf.move(1);
        }
        return true;
    }

    protected boolean viReplaceChars() {
        int n = this.readCharacter();
        if (n < 0 || n == 27 || n == 3) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.buf.currChar((char)n)) {
                if (i >= this.count - 1) continue;
                this.buf.move(1);
                continue;
            }
            return false;
        }
        return true;
    }

    protected boolean viChange(int n, int n2) {
        return this.doViDeleteOrChange(n, n2, true);
    }

    protected boolean viDeleteTo(int n, int n2) {
        return this.doViDeleteOrChange(n, n2, false);
    }

    protected boolean doViDeleteOrChange(int n, int n2, boolean bl) {
        if (n == n2) {
            return true;
        }
        if (n2 < n) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        this.buf.cursor(n);
        this.buf.delete(n2 - n);
        if (!bl && n > 0 && n == this.buf.length()) {
            this.buf.move(-1);
        }
        return true;
    }

    protected boolean viYankTo(int n, int n2) {
        int n3 = n;
        if (n2 < n) {
            int n4 = n2;
            n2 = n;
            n = n4;
        }
        if (n == n2) {
            this.yankBuffer = DEFAULT_BELL_STYLE;
            return true;
        }
        this.yankBuffer = this.buf.substring(n, n2);
        this.buf.cursor(n3);
        return true;
    }

    protected boolean viOpenLineAbove() {
        while (this.buf.move(-1) == -1 && this.buf.prevChar() != 10) {
        }
        this.buf.write(10);
        this.buf.move(-1);
        return this.setKeyMap("viins");
    }

    protected boolean viOpenLineBelow() {
        while (this.buf.move(1) == 1 && this.buf.currChar() != 10) {
        }
        this.buf.write(10);
        return this.setKeyMap("viins");
    }

    protected boolean viPutAfter() {
        if (this.yankBuffer.indexOf(10) >= 0) {
            while (this.buf.move(1) == 1 && this.buf.currChar() != 10) {
            }
            this.buf.move(1);
            this.putString(this.yankBuffer);
            this.buf.move(-this.yankBuffer.length());
        } else if (this.yankBuffer.length() != 0) {
            if (this.buf.cursor() < this.buf.length()) {
                this.buf.move(1);
            }
            for (int i = 0; i < this.count; ++i) {
                this.putString(this.yankBuffer);
            }
            this.buf.move(-1);
        }
        return true;
    }

    protected boolean viPutBefore() {
        if (this.yankBuffer.indexOf(10) >= 0) {
            while (this.buf.move(-1) == -1 && this.buf.prevChar() != 10) {
            }
            this.putString(this.yankBuffer);
            this.buf.move(-this.yankBuffer.length());
        } else if (this.yankBuffer.length() != 0) {
            if (this.buf.cursor() > 0) {
                this.buf.move(-1);
            }
            for (int i = 0; i < this.count; ++i) {
                this.putString(this.yankBuffer);
            }
            this.buf.move(-1);
        }
        return true;
    }

    protected boolean doLowercaseVersion() {
        this.bindingReader.runMacro(this.getLastBinding().toLowerCase());
        return true;
    }

    protected boolean setMarkCommand() {
        if (this.count < 0) {
            this.regionActive = LineReader.RegionType.NONE;
            return true;
        }
        this.regionMark = this.buf.cursor();
        this.regionActive = LineReader.RegionType.CHAR;
        return true;
    }

    protected boolean exchangePointAndMark() {
        if (this.count == 0) {
            this.regionActive = LineReader.RegionType.CHAR;
            return true;
        }
        int n = this.regionMark;
        this.regionMark = this.buf.cursor();
        this.buf.cursor(n);
        if (this.buf.cursor() > this.buf.length()) {
            this.buf.cursor(this.buf.length());
        }
        if (this.count > 0) {
            this.regionActive = LineReader.RegionType.CHAR;
        }
        return true;
    }

    protected boolean visualMode() {
        if (this.isInViMoveOperation()) {
            this.isArgDigit = true;
            this.forceLine = false;
            this.forceChar = true;
            return true;
        }
        if (this.regionActive == LineReader.RegionType.NONE) {
            this.regionMark = this.buf.cursor();
            this.regionActive = LineReader.RegionType.CHAR;
        } else if (this.regionActive == LineReader.RegionType.CHAR) {
            this.regionActive = LineReader.RegionType.NONE;
        } else if (this.regionActive == LineReader.RegionType.LINE) {
            this.regionActive = LineReader.RegionType.CHAR;
        }
        return true;
    }

    protected boolean visualLineMode() {
        if (this.isInViMoveOperation()) {
            this.isArgDigit = true;
            this.forceLine = true;
            this.forceChar = false;
            return true;
        }
        if (this.regionActive == LineReader.RegionType.NONE) {
            this.regionMark = this.buf.cursor();
            this.regionActive = LineReader.RegionType.LINE;
        } else if (this.regionActive == LineReader.RegionType.CHAR) {
            this.regionActive = LineReader.RegionType.LINE;
        } else if (this.regionActive == LineReader.RegionType.LINE) {
            this.regionActive = LineReader.RegionType.NONE;
        }
        return true;
    }

    protected boolean deactivateRegion() {
        this.regionActive = LineReader.RegionType.NONE;
        return true;
    }

    protected boolean whatCursorPosition() {
        this.post = () -> {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            if (this.buf.cursor() < this.buf.length()) {
                int n = this.buf.currChar();
                attributedStringBuilder.append("Char: ");
                if (n == 32) {
                    attributedStringBuilder.append("SPC");
                } else if (n == 10) {
                    attributedStringBuilder.append("LFD");
                } else if (n < 32) {
                    attributedStringBuilder.append('^');
                    attributedStringBuilder.append((char)(n + 65 - 1));
                } else if (n == 127) {
                    attributedStringBuilder.append("^?");
                } else {
                    attributedStringBuilder.append((char)n);
                }
                attributedStringBuilder.append(" (");
                attributedStringBuilder.append("0").append(Integer.toOctalString(n)).append(" ");
                attributedStringBuilder.append(Integer.toString(n)).append(" ");
                attributedStringBuilder.append("0x").append(Integer.toHexString(n)).append(" ");
                attributedStringBuilder.append(DESC_SUFFIX);
            } else {
                attributedStringBuilder.append("EOF");
            }
            attributedStringBuilder.append("   ");
            attributedStringBuilder.append("point ");
            attributedStringBuilder.append(Integer.toString(this.buf.cursor() + 1));
            attributedStringBuilder.append(" of ");
            attributedStringBuilder.append(Integer.toString(this.buf.length() + 1));
            attributedStringBuilder.append(" (");
            attributedStringBuilder.append(Integer.toString(this.buf.length() == 0 ? 100 : 100 * this.buf.cursor() / this.buf.length()));
            attributedStringBuilder.append("%)");
            attributedStringBuilder.append("   ");
            attributedStringBuilder.append("column ");
            attributedStringBuilder.append(Integer.toString(this.buf.cursor() - this.findbol()));
            return attributedStringBuilder.toAttributedString();
        };
        return true;
    }

    protected Map<String, Widget> builtinWidgets() {
        HashMap<String, Widget> hashMap = new HashMap<String, Widget>();
        hashMap.put("accept-line", this::acceptLine);
        hashMap.put("argument-base", this::argumentBase);
        hashMap.put("backward-char", this::backwardChar);
        hashMap.put("backward-delete-char", this::backwardDeleteChar);
        hashMap.put("backward-delete-word", this::backwardDeleteWord);
        hashMap.put("backward-kill-line", this::backwardKillLine);
        hashMap.put("backward-kill-word", this::backwardKillWord);
        hashMap.put("backward-word", this::backwardWord);
        hashMap.put("beep", this::beep);
        hashMap.put("beginning-of-buffer-or-history", this::beginningOfBufferOrHistory);
        hashMap.put("beginning-of-history", this::beginningOfHistory);
        hashMap.put("beginning-of-line", this::beginningOfLine);
        hashMap.put("beginning-of-line-hist", this::beginningOfLineHist);
        hashMap.put("capitalize-word", this::capitalizeWord);
        hashMap.put("clear", this::clear);
        hashMap.put("clear-screen", this::clearScreen);
        hashMap.put("complete-prefix", this::completePrefix);
        hashMap.put("complete-word", this::completeWord);
        hashMap.put("copy-prev-word", this::copyPrevWord);
        hashMap.put("copy-region-as-kill", this::copyRegionAsKill);
        hashMap.put("delete-char", this::deleteChar);
        hashMap.put("delete-char-or-list", this::deleteCharOrList);
        hashMap.put("delete-word", this::deleteWord);
        hashMap.put("digit-argument", this::digitArgument);
        hashMap.put("do-lowercase-version", this::doLowercaseVersion);
        hashMap.put("down-case-word", this::downCaseWord);
        hashMap.put("down-line", this::downLine);
        hashMap.put("down-line-or-history", this::downLineOrHistory);
        hashMap.put("down-line-or-search", this::downLineOrSearch);
        hashMap.put("down-history", this::downHistory);
        hashMap.put("emacs-editing-mode", this::emacsEditingMode);
        hashMap.put("emacs-backward-word", this::emacsBackwardWord);
        hashMap.put("emacs-forward-word", this::emacsForwardWord);
        hashMap.put("end-of-buffer-or-history", this::endOfBufferOrHistory);
        hashMap.put("end-of-history", this::endOfHistory);
        hashMap.put("end-of-line", this::endOfLine);
        hashMap.put("end-of-line-hist", this::endOfLineHist);
        hashMap.put("exchange-point-and-mark", this::exchangePointAndMark);
        hashMap.put("expand-history", this::expandHistory);
        hashMap.put("expand-or-complete", this::expandOrComplete);
        hashMap.put("expand-or-complete-prefix", this::expandOrCompletePrefix);
        hashMap.put("expand-word", this::expandWord);
        hashMap.put("fresh-line", this::freshLine);
        hashMap.put("forward-char", this::forwardChar);
        hashMap.put("forward-word", this::forwardWord);
        hashMap.put("history-incremental-search-backward", this::historyIncrementalSearchBackward);
        hashMap.put("history-incremental-search-forward", this::historyIncrementalSearchForward);
        hashMap.put("history-search-backward", this::historySearchBackward);
        hashMap.put("history-search-forward", this::historySearchForward);
        hashMap.put("insert-close-curly", this::insertCloseCurly);
        hashMap.put("insert-close-paren", this::insertCloseParen);
        hashMap.put("insert-close-square", this::insertCloseSquare);
        hashMap.put("insert-comment", this::insertComment);
        hashMap.put("kill-buffer", this::killBuffer);
        hashMap.put("kill-line", this::killLine);
        hashMap.put("kill-region", this::killRegion);
        hashMap.put("kill-whole-line", this::killWholeLine);
        hashMap.put("kill-word", this::killWord);
        hashMap.put("list-choices", this::listChoices);
        hashMap.put("menu-complete", this::menuComplete);
        hashMap.put("menu-expand-or-complete", this::menuExpandOrComplete);
        hashMap.put("neg-argument", this::negArgument);
        hashMap.put("overwrite-mode", this::overwriteMode);
        hashMap.put("quoted-insert", this::quotedInsert);
        hashMap.put("redisplay", this::redisplay);
        hashMap.put("redraw-line", this::redrawLine);
        hashMap.put("redo", this::redo);
        hashMap.put("self-insert", this::selfInsert);
        hashMap.put("self-insert-unmeta", this::selfInsertUnmeta);
        hashMap.put("abort", this::sendBreak);
        hashMap.put("set-mark-command", this::setMarkCommand);
        hashMap.put("transpose-chars", this::transposeChars);
        hashMap.put("transpose-words", this::transposeWords);
        hashMap.put("undefined-key", this::undefinedKey);
        hashMap.put("universal-argument", this::universalArgument);
        hashMap.put("undo", this::undo);
        hashMap.put("up-case-word", this::upCaseWord);
        hashMap.put("up-history", this::upHistory);
        hashMap.put("up-line", this::upLine);
        hashMap.put("up-line-or-history", this::upLineOrHistory);
        hashMap.put("up-line-or-search", this::upLineOrSearch);
        hashMap.put("vi-add-eol", this::viAddEol);
        hashMap.put("vi-add-next", this::viAddNext);
        hashMap.put("vi-backward-char", this::viBackwardChar);
        hashMap.put("vi-backward-delete-char", this::viBackwardDeleteChar);
        hashMap.put("vi-backward-blank-word", this::viBackwardBlankWord);
        hashMap.put("vi-backward-blank-word-end", this::viBackwardBlankWordEnd);
        hashMap.put("vi-backward-kill-word", this::viBackwardKillWord);
        hashMap.put("vi-backward-word", this::viBackwardWord);
        hashMap.put("vi-backward-word-end", this::viBackwardWordEnd);
        hashMap.put("vi-beginning-of-line", this::viBeginningOfLine);
        hashMap.put("vi-cmd-mode", this::viCmdMode);
        hashMap.put("vi-digit-or-beginning-of-line", this::viDigitOrBeginningOfLine);
        hashMap.put("vi-down-line-or-history", this::viDownLineOrHistory);
        hashMap.put("vi-change-to", this::viChange);
        hashMap.put("vi-change-eol", this::viChangeEol);
        hashMap.put("vi-change-whole-line", this::viChangeWholeLine);
        hashMap.put("vi-delete-char", this::viDeleteChar);
        hashMap.put("vi-delete", this::viDelete);
        hashMap.put("vi-end-of-line", this::viEndOfLine);
        hashMap.put("vi-kill-eol", this::viKillEol);
        hashMap.put("vi-first-non-blank", this::viFirstNonBlank);
        hashMap.put("vi-find-next-char", this::viFindNextChar);
        hashMap.put("vi-find-next-char-skip", this::viFindNextCharSkip);
        hashMap.put("vi-find-prev-char", this::viFindPrevChar);
        hashMap.put("vi-find-prev-char-skip", this::viFindPrevCharSkip);
        hashMap.put("vi-forward-blank-word", this::viForwardBlankWord);
        hashMap.put("vi-forward-blank-word-end", this::viForwardBlankWordEnd);
        hashMap.put("vi-forward-char", this::viForwardChar);
        hashMap.put("vi-forward-word", this::viForwardWord);
        hashMap.put("vi-forward-word", this::viForwardWord);
        hashMap.put("vi-forward-word-end", this::viForwardWordEnd);
        hashMap.put("vi-history-search-backward", this::viHistorySearchBackward);
        hashMap.put("vi-history-search-forward", this::viHistorySearchForward);
        hashMap.put("vi-insert", this::viInsert);
        hashMap.put("vi-insert-bol", this::viInsertBol);
        hashMap.put("vi-insert-comment", this::viInsertComment);
        hashMap.put("vi-join", this::viJoin);
        hashMap.put("vi-kill-line", this::viKillWholeLine);
        hashMap.put("vi-match-bracket", this::viMatchBracket);
        hashMap.put("vi-open-line-above", this::viOpenLineAbove);
        hashMap.put("vi-open-line-below", this::viOpenLineBelow);
        hashMap.put("vi-put-after", this::viPutAfter);
        hashMap.put("vi-put-before", this::viPutBefore);
        hashMap.put("vi-repeat-find", this::viRepeatFind);
        hashMap.put("vi-repeat-search", this::viRepeatSearch);
        hashMap.put("vi-replace-chars", this::viReplaceChars);
        hashMap.put("vi-rev-repeat-find", this::viRevRepeatFind);
        hashMap.put("vi-rev-repeat-search", this::viRevRepeatSearch);
        hashMap.put("vi-swap-case", this::viSwapCase);
        hashMap.put("vi-up-line-or-history", this::viUpLineOrHistory);
        hashMap.put("vi-yank", this::viYankTo);
        hashMap.put("vi-yank-whole-line", this::viYankWholeLine);
        hashMap.put("visual-line-mode", this::visualLineMode);
        hashMap.put("visual-mode", this::visualMode);
        hashMap.put("what-cursor-position", this::whatCursorPosition);
        hashMap.put("yank", this::yank);
        hashMap.put("yank-pop", this::yankPop);
        hashMap.put("mouse", this::mouse);
        hashMap.put("begin-paste", this::beginPaste);
        hashMap.put("terminal-focus-in", this::focusIn);
        hashMap.put("terminal-focus-out", this::focusOut);
        return hashMap;
    }

    public boolean redisplay() {
        this.redisplay(true);
        return true;
    }

    protected synchronized void redisplay(boolean bl) {
        AttributedCharSequence attributedCharSequence;
        int n;
        List<Object> list;
        if (this.skipRedisplay) {
            this.skipRedisplay = false;
            return;
        }
        if (this.size.getRows() > 0 && this.size.getRows() < 3) {
            int n2;
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(4);
            attributedStringBuilder.append(this.prompt);
            this.concat(this.getHighlightedBuffer(this.buf.toString()).columnSplitLength(Integer.MAX_VALUE), attributedStringBuilder);
            AttributedString attributedString = attributedStringBuilder.toAttributedString();
            attributedStringBuilder.setLength(0);
            attributedStringBuilder.append(this.prompt);
            String string = this.buf.upToCursor();
            if (this.maskingCallback != null) {
                string = this.maskingCallback.display(string);
            }
            this.concat(new AttributedString(string).columnSplitLength(Integer.MAX_VALUE), attributedStringBuilder);
            AttributedString attributedString2 = attributedStringBuilder.toAttributedString();
            int n3 = WCWidth.wcwidth(8230);
            int n4 = this.size.getColumns();
            int n5 = attributedString2.columnLength();
            int n6 = n4 / 2 + 1;
            while (n5 <= this.smallTerminalOffset + n3) {
                this.smallTerminalOffset -= n6;
            }
            while (n5 >= this.smallTerminalOffset + n4 - n3) {
                this.smallTerminalOffset += n6;
            }
            if (this.smallTerminalOffset > 0) {
                attributedStringBuilder.setLength(0);
                attributedStringBuilder.append("\u2026");
                attributedStringBuilder.append(attributedString.columnSubSequence(this.smallTerminalOffset + n3, Integer.MAX_VALUE));
                attributedString = attributedStringBuilder.toAttributedString();
            }
            if ((n2 = attributedString.columnLength()) >= this.smallTerminalOffset + n4) {
                attributedStringBuilder.setLength(0);
                attributedStringBuilder.append(attributedString.columnSubSequence(0, n4 - n3));
                attributedStringBuilder.append("\u2026");
                attributedString = attributedStringBuilder.toAttributedString();
            }
            this.display.update(Collections.singletonList(attributedString), n5 - this.smallTerminalOffset, bl);
            return;
        }
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        AttributedString attributedString = this.getDisplayedBufferWithPrompts(arrayList);
        if (this.size.getColumns() <= 0) {
            list = new ArrayList<AttributedString>();
            list.add(attributedString);
        } else {
            list = attributedString.columnSplitLength(this.size.getColumns(), true, this.display.delayLineWrap());
        }
        List<Object> list2 = this.rightPrompt.length() == 0 || this.size.getColumns() <= 0 ? new ArrayList() : this.rightPrompt.columnSplitLength(this.size.getColumns());
        while (list.size() < list2.size()) {
            list.add(new AttributedString(DEFAULT_BELL_STYLE));
        }
        for (n = 0; n < list2.size(); ++n) {
            attributedCharSequence = (AttributedString)list2.get(n);
            list.set(n, this.addRightPrompt((AttributedString)attributedCharSequence, (AttributedString)list.get(n)));
        }
        n = -1;
        if (this.size.getColumns() > 0) {
            attributedCharSequence = new AttributedStringBuilder().tabs(4);
            ((AttributedStringBuilder)attributedCharSequence).append(this.prompt);
            String string = this.buf.upToCursor();
            if (this.maskingCallback != null) {
                string = this.maskingCallback.display(string);
            }
            ((AttributedStringBuilder)attributedCharSequence).append(this.insertSecondaryPrompts(new AttributedString(string), arrayList, false));
            List<AttributedString> list3 = attributedCharSequence.columnSplitLength(this.size.getColumns(), false, this.display.delayLineWrap());
            if (!list3.isEmpty()) {
                n = this.size.cursorPos(list3.size() - 1, list3.get(list3.size() - 1).columnLength());
            }
        }
        this.display.update(list, n, bl);
    }

    private void concat(List<AttributedString> list, AttributedStringBuilder attributedStringBuilder) {
        if (list.size() > 1) {
            for (int i = 0; i < list.size() - 1; ++i) {
                attributedStringBuilder.append(list.get(i));
                attributedStringBuilder.style(attributedStringBuilder.style().inverse());
                attributedStringBuilder.append("\\n");
                attributedStringBuilder.style(attributedStringBuilder.style().inverseOff());
            }
        }
        attributedStringBuilder.append(list.get(list.size() - 1));
    }

    public AttributedString getDisplayedBufferWithPrompts(List<AttributedString> list) {
        AttributedString attributedString = this.getHighlightedBuffer(this.buf.toString());
        AttributedString attributedString2 = this.insertSecondaryPrompts(attributedString, list);
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(4);
        attributedStringBuilder.append(this.prompt);
        attributedStringBuilder.append(attributedString2);
        if (this.post != null) {
            attributedStringBuilder.append("\n");
            attributedStringBuilder.append(this.post.get());
        }
        return attributedStringBuilder.toAttributedString();
    }

    private AttributedString getHighlightedBuffer(String string) {
        if (this.maskingCallback != null) {
            string = this.maskingCallback.display(string);
        }
        if (this.highlighter != null && !this.isSet(LineReader.Option.DISABLE_HIGHLIGHTER)) {
            return this.highlighter.highlight(this, string);
        }
        return new AttributedString(string);
    }

    private AttributedString expandPromptPattern(String string, int n, String string2, int n2) {
        char c;
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        boolean bl = false;
        int n3 = -1;
        StringBuilder stringBuilder = null;
        StringBuilder stringBuilder2 = new StringBuilder();
        string = string + "%{";
        int n4 = string.length();
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        block8: while (n8 < n4) {
            if ((c = string.charAt(n8++)) == '%' && n8 < n4) {
                int n9 = 0;
                boolean bl2 = false;
                block9: while (true) {
                    c = string.charAt(n8++);
                    switch (c) {
                        case '{': 
                        case '}': {
                            AttributedString attributedString;
                            String string3 = stringBuilder2.toString();
                            if (!bl) {
                                attributedString = AttributedString.fromAnsi(string3);
                                n7 += attributedString.columnLength();
                            } else {
                                attributedString = new AttributedString(string3, AttributedStyle.HIDDEN);
                            }
                            if (n3 == arrayList.size()) {
                                stringBuilder = stringBuilder2;
                                if (n8 < n4) {
                                    stringBuilder2 = new StringBuilder();
                                }
                            } else {
                                stringBuilder2.setLength(0);
                            }
                            arrayList.add(attributedString);
                            bl = c == '{';
                            break block9;
                        }
                        case '%': {
                            stringBuilder2.append(c);
                            break block9;
                        }
                        case 'N': {
                            stringBuilder2.append(this.getInt("line-offset", 0) + n2);
                            break block9;
                        }
                        case 'M': {
                            if (string2 == null) continue block8;
                            stringBuilder2.append(string2);
                            break block9;
                        }
                        case 'P': {
                            if (bl2 && n9 >= 0) {
                                n = n9;
                            }
                            if (n8 < n4) {
                                n5 = string.charAt(n8++);
                            }
                            n6 = stringBuilder2.length();
                            n3 = arrayList.size();
                            break block9;
                        }
                        case '-': 
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            boolean bl3 = false;
                            if (c == '-') {
                                bl3 = true;
                                c = string.charAt(n8++);
                            }
                            bl2 = true;
                            n9 = 0;
                            while (c >= '0' && c <= '9') {
                                n9 = (n9 < 0 ? 0 : 10 * n9) + (c - 48);
                                c = string.charAt(n8++);
                            }
                            if (bl3) {
                                n9 = -n9;
                            }
                            --n8;
                            continue block9;
                        }
                    }
                    break;
                }
                continue;
            }
            stringBuilder2.append(c);
        }
        if (n > n7) {
            n8 = WCWidth.wcwidth(n5);
            c = (n - n7) / n8;
            stringBuilder2 = stringBuilder;
            while (--c >= '\u0000') {
                stringBuilder2.insert(n6, (char)n5);
            }
            arrayList.set(n3, AttributedString.fromAnsi(stringBuilder2.toString()));
        }
        return AttributedString.join(null, arrayList);
    }

    private AttributedString insertSecondaryPrompts(AttributedString attributedString, List<AttributedString> list) {
        return this.insertSecondaryPrompts(attributedString, list, true);
    }

    private AttributedString insertSecondaryPrompts(AttributedString attributedString, List<AttributedString> list, boolean bl) {
        AttributedString attributedString2;
        String string;
        int n;
        Objects.requireNonNull(list);
        List<AttributedString> list2 = attributedString.columnSplitLength(Integer.MAX_VALUE);
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        String string2 = this.getString("secondary-prompt-pattern", DEFAULT_SECONDARY_PROMPT_PATTERN);
        boolean bl2 = string2.contains("%M");
        AttributedStringBuilder attributedStringBuilder2 = new AttributedStringBuilder();
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl && string2.contains("%P")) {
            n2 = this.prompt.columnLength();
            for (n = 0; n < list2.size() - 1; ++n) {
                attributedStringBuilder2.append(list2.get(n)).append("\n");
                string = DEFAULT_BELL_STYLE;
                if (bl2) {
                    try {
                        this.parser.parse(attributedStringBuilder2.toString(), attributedStringBuilder2.length(), Parser.ParseContext.SECONDARY_PROMPT);
                    }
                    catch (EOFError eOFError) {
                        string = eOFError.getMissing();
                    }
                    catch (SyntaxError syntaxError) {
                        // empty catch block
                    }
                }
                arrayList.add(string);
                attributedString2 = this.expandPromptPattern(string2, 0, string, n + 1);
                n2 = Math.max(n2, attributedString2.columnLength());
            }
            attributedStringBuilder2.setLength(0);
        }
        for (n = 0; n < list2.size() - 1; ++n) {
            attributedStringBuilder.append(list2.get(n)).append("\n");
            attributedStringBuilder2.append(list2.get(n)).append("\n");
            if (bl) {
                string = DEFAULT_BELL_STYLE;
                if (bl2) {
                    if (arrayList.isEmpty()) {
                        try {
                            this.parser.parse(attributedStringBuilder2.toString(), attributedStringBuilder2.length(), Parser.ParseContext.SECONDARY_PROMPT);
                        }
                        catch (EOFError eOFError) {
                            string = eOFError.getMissing();
                        }
                        catch (SyntaxError syntaxError) {}
                    } else {
                        string = (String)arrayList.get(n);
                    }
                }
                attributedString2 = this.expandPromptPattern(string2, n2, string, n + 1);
            } else {
                attributedString2 = list.get(n);
            }
            list.add(attributedString2);
            attributedStringBuilder.append(attributedString2);
        }
        attributedStringBuilder.append(list2.get(n));
        attributedStringBuilder2.append(list2.get(n));
        return attributedStringBuilder.toAttributedString();
    }

    private AttributedString addRightPrompt(AttributedString attributedString, AttributedString attributedString2) {
        int n = attributedString.columnLength();
        boolean bl = attributedString2.length() > 0 && attributedString2.charAt(attributedString2.length() - 1) == '\n';
        int n2 = this.size.getColumns() - n - (attributedString2.columnLength() + (bl ? 1 : 0));
        if (n2 >= 3) {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder(this.size.getColumns());
            attributedStringBuilder.append(attributedString2, 0, bl ? attributedString2.length() - 1 : attributedString2.length());
            for (int i = 0; i < n2; ++i) {
                attributedStringBuilder.append(' ');
            }
            attributedStringBuilder.append(attributedString);
            if (bl) {
                attributedStringBuilder.append('\n');
            }
            attributedString2 = attributedStringBuilder.toAttributedString();
        }
        return attributedString2;
    }

    protected boolean insertTab() {
        return this.isSet(LineReader.Option.INSERT_TAB) && this.getLastBinding().equals("\t") && this.buf.toString().matches("(^|[\\s\\S]*\n)[\r\n\t ]*");
    }

    protected boolean expandHistory() {
        String string = this.buf.toString();
        String string2 = this.expander.expandHistory(this.history, string);
        if (!string2.equals(string)) {
            this.buf.clear();
            this.buf.write(string2);
            return true;
        }
        return false;
    }

    protected boolean expandWord() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.Expand, this.isSet(LineReader.Option.MENU_COMPLETE), false);
    }

    protected boolean expandOrComplete() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.ExpandComplete, this.isSet(LineReader.Option.MENU_COMPLETE), false);
    }

    protected boolean expandOrCompletePrefix() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.ExpandComplete, this.isSet(LineReader.Option.MENU_COMPLETE), true);
    }

    protected boolean completeWord() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.Complete, this.isSet(LineReader.Option.MENU_COMPLETE), false);
    }

    protected boolean menuComplete() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.Complete, true, false);
    }

    protected boolean menuExpandOrComplete() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.ExpandComplete, true, false);
    }

    protected boolean completePrefix() {
        if (this.insertTab()) {
            return this.selfInsert();
        }
        return this.doComplete(CompletionType.Complete, this.isSet(LineReader.Option.MENU_COMPLETE), true);
    }

    protected boolean listChoices() {
        return this.doComplete(CompletionType.List, this.isSet(LineReader.Option.MENU_COMPLETE), false);
    }

    protected boolean deleteCharOrList() {
        if (this.buf.cursor() != this.buf.length() || this.buf.length() == 0) {
            return this.deleteChar();
        }
        return this.doComplete(CompletionType.List, this.isSet(LineReader.Option.MENU_COMPLETE), false);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doComplete(CompletionType completionType, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        Object object2;
        List<Function> list;
        Object object3;
        Object object4;
        Object object5;
        CompletingParsedLine completingParsedLine;
        if (this.getBoolean("disable-completion", false)) {
            return true;
        }
        if (!this.isSet(LineReader.Option.DISABLE_EVENT_EXPANSION)) {
            try {
                if (this.expandHistory()) {
                    return true;
                }
            }
            catch (Exception exception) {
                Log.info("Error while expanding history", exception);
                return false;
            }
        }
        try {
            completingParsedLine = this.wrap(this.parser.parse(this.buf.toString(), this.buf.cursor(), Parser.ParseContext.COMPLETE));
        }
        catch (Exception exception) {
            Log.info("Error while parsing line", exception);
            return false;
        }
        ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
        try {
            if (this.completer != null) {
                this.completer.complete(this, completingParsedLine, arrayList);
            }
        }
        catch (Exception exception) {
            Log.info("Error while finding completion candidates", exception);
            return false;
        }
        if (completionType == CompletionType.ExpandComplete || completionType == CompletionType.Expand) {
            String string2 = this.expander.expandVar(completingParsedLine.word());
            if (!completingParsedLine.word().equals(string2)) {
                if (bl2) {
                    this.buf.backspace(completingParsedLine.wordCursor());
                } else {
                    this.buf.move(completingParsedLine.word().length() - completingParsedLine.wordCursor());
                    this.buf.backspace(completingParsedLine.word().length());
                }
                this.buf.write(string2);
                return true;
            }
            if (completionType == CompletionType.Expand) {
                return false;
            }
            completionType = CompletionType.Complete;
        }
        boolean bl4 = this.isSet(LineReader.Option.CASE_INSENSITIVE);
        int n = this.getInt("errors", 2);
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (Candidate predicate2 : arrayList) {
            hashMap.computeIfAbsent(AttributedString.fromAnsi(predicate2.value()).toString(), string -> new ArrayList()).add(predicate2);
        }
        if (bl2) {
            object5 = completingParsedLine.word();
            object4 = bl4 ? ((String)object5).toLowerCase() : object5;
            object3 = ((String)object4).substring(0, completingParsedLine.wordCursor());
            list = Arrays.asList(this.simpleMatcher(arg_0 -> LineReaderImpl.lambda$doComplete$16(bl4, (String)object3, arg_0)), this.simpleMatcher(arg_0 -> LineReaderImpl.lambda$doComplete$17(bl4, (String)object3, arg_0)), this.typoMatcher((String)object3, n, bl4));
            Predicate<String> predicate = arg_0 -> LineReaderImpl.lambda$doComplete$18(bl4, (String)object3, arg_0);
        } else if (this.isSet(LineReader.Option.COMPLETE_IN_WORD)) {
            object5 = completingParsedLine.word();
            object4 = bl4 ? ((String)object5).toLowerCase() : object5;
            object3 = ((String)object4).substring(0, completingParsedLine.wordCursor());
            object2 = ((String)object4).substring(completingParsedLine.wordCursor());
            object = Pattern.compile(Pattern.quote((String)object3) + ".*" + Pattern.quote((String)object2) + ".*");
            Pattern pattern = Pattern.compile(".*" + Pattern.quote((String)object3) + ".*" + Pattern.quote((String)object2) + ".*");
            list = Arrays.asList(this.simpleMatcher(arg_0 -> LineReaderImpl.lambda$doComplete$19((Pattern)object, bl4, arg_0)), this.simpleMatcher(string -> pattern.matcher(bl4 ? string.toLowerCase() : string).matches()), this.typoMatcher((String)object4, n, bl4));
            Predicate<String> predicate = arg_0 -> LineReaderImpl.lambda$doComplete$21(bl4, (String)object5, arg_0);
        } else {
            object5 = completingParsedLine.word();
            object4 = bl4 ? ((String)object5).toLowerCase() : object5;
            list = Arrays.asList(this.simpleMatcher(arg_0 -> LineReaderImpl.lambda$doComplete$22(bl4, (String)object4, arg_0)), this.simpleMatcher(arg_0 -> LineReaderImpl.lambda$doComplete$23(bl4, (String)object4, arg_0)), this.typoMatcher((String)object4, n, bl4));
            Predicate<String> predicate = arg_0 -> LineReaderImpl.lambda$doComplete$24(bl4, (String)object5, arg_0);
        }
        object5 = Collections.emptyMap();
        object4 = list.iterator();
        while (object4.hasNext() && (object5 = (Map)(object3 = (Function)object4.next()).apply(hashMap)).isEmpty()) {
        }
        if (object5.isEmpty()) {
            return false;
        }
        if (completionType == CompletionType.List) {
            object4 = object5.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
            this.doList((List<Candidate>)object4, completingParsedLine.word(), false, completingParsedLine::escape);
            return !object4.isEmpty();
        }
        object4 = null;
        if (object5.size() == 1) {
            object4 = object5.values().stream().flatMap(Collection::stream).findFirst().orElse(null);
        } else if (this.isSet(LineReader.Option.RECOGNIZE_EXACT)) {
            void var10_18;
            object4 = object5.values().stream().flatMap(Collection::stream).filter(Candidate::complete).filter(arg_0 -> LineReaderImpl.lambda$doComplete$26((Predicate)var10_18, arg_0)).findFirst().orElse(null);
        }
        if (object4 != null && !((Candidate)object4).value().isEmpty()) {
            if (bl2) {
                this.buf.backspace(completingParsedLine.rawWordCursor());
            } else {
                this.buf.move(completingParsedLine.rawWordLength() - completingParsedLine.rawWordCursor());
                this.buf.backspace(completingParsedLine.rawWordLength());
            }
            this.buf.write(completingParsedLine.escape(((Candidate)object4).value(), ((Candidate)object4).complete()));
            if (((Candidate)object4).complete()) {
                if (this.buf.currChar() != 32) {
                    this.buf.write(" ");
                } else {
                    this.buf.move(1);
                }
            }
            if (((Candidate)object4).suffix() != null) {
                this.redisplay();
                object3 = this.readBinding(this.getKeys());
                if (object3 != null) {
                    object2 = this.getString("REMOVE_SUFFIX_CHARS", DEFAULT_REMOVE_SUFFIX_CHARS);
                    Object object6 = object = object3 instanceof Reference ? ((Reference)object3).name() : null;
                    if ("self-insert".equals(object) && ((String)object2).indexOf(this.getLastBinding().charAt(0)) >= 0 || "accept-line".equals(object)) {
                        this.buf.backspace(((Candidate)object4).suffix().length());
                        if (this.getLastBinding().charAt(0) != ' ') {
                            this.buf.write(32);
                        }
                    }
                    this.pushBackBinding(true);
                }
            }
            return true;
        }
        object3 = object5.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        if (bl) {
            this.buf.move(completingParsedLine.word().length() - completingParsedLine.wordCursor());
            this.buf.backspace(completingParsedLine.word().length());
            this.doMenu((List<Candidate>)object3, completingParsedLine.word(), completingParsedLine::escape);
            return true;
        }
        if (bl2) {
            object2 = completingParsedLine.word().substring(0, completingParsedLine.wordCursor());
        } else {
            object2 = completingParsedLine.word();
            this.buf.move(completingParsedLine.rawWordLength() - completingParsedLine.rawWordCursor());
        }
        object = null;
        for (String string2 : object5.keySet()) {
            object = object == null ? string2 : this.getCommonStart((String)object, string2, bl4);
        }
        boolean bl5 = bl3 = ((String)object).startsWith((String)object2) && !((String)object).equals(object2);
        if (bl3) {
            this.buf.backspace(completingParsedLine.rawWordLength());
            this.buf.write(completingParsedLine.escape((CharSequence)object, false));
            object2 = object;
            if ((!this.isSet(LineReader.Option.AUTO_LIST) && this.isSet(LineReader.Option.AUTO_MENU) || this.isSet(LineReader.Option.AUTO_LIST) && this.isSet(LineReader.Option.LIST_AMBIGUOUS)) && !this.nextBindingIsComplete()) {
                return true;
            }
        }
        if (this.isSet(LineReader.Option.AUTO_LIST)) {
            if (!this.doList((List<Candidate>)object3, (String)object2, true, completingParsedLine::escape)) {
                return true;
            }
        }
        if (this.isSet(LineReader.Option.AUTO_MENU)) {
            this.buf.backspace(((String)object2).length());
            this.doMenu((List<Candidate>)object3, completingParsedLine.word(), completingParsedLine::escape);
        }
        return true;
    }

    private CompletingParsedLine wrap(final ParsedLine parsedLine) {
        if (parsedLine instanceof CompletingParsedLine) {
            return (CompletingParsedLine)parsedLine;
        }
        return new CompletingParsedLine(){

            @Override
            public String word() {
                return parsedLine.word();
            }

            @Override
            public int wordCursor() {
                return parsedLine.wordCursor();
            }

            @Override
            public int wordIndex() {
                return parsedLine.wordIndex();
            }

            @Override
            public List<String> words() {
                return parsedLine.words();
            }

            @Override
            public String line() {
                return parsedLine.line();
            }

            @Override
            public int cursor() {
                return parsedLine.cursor();
            }

            @Override
            public CharSequence escape(CharSequence charSequence, boolean bl) {
                return charSequence;
            }

            @Override
            public int rawWordCursor() {
                return this.wordCursor();
            }

            @Override
            public int rawWordLength() {
                return this.word().length();
            }
        };
    }

    protected Comparator<Candidate> getCandidateComparator(boolean bl, String string) {
        String string3 = bl ? string.toLowerCase() : string;
        ToIntFunction<String> toIntFunction = string2 -> this.distance(string3, bl ? string2.toLowerCase() : string2);
        return Comparator.comparing(Candidate::value, Comparator.comparingInt(toIntFunction)).thenComparing(Candidate::value, Comparator.comparingInt(String::length)).thenComparing(Comparator.naturalOrder());
    }

    protected String getOthersGroupName() {
        return this.getString("OTHERS_GROUP_NAME", DEFAULT_OTHERS_GROUP_NAME);
    }

    protected String getOriginalGroupName() {
        return this.getString("ORIGINAL_GROUP_NAME", DEFAULT_ORIGINAL_GROUP_NAME);
    }

    protected Comparator<String> getGroupComparator() {
        return Comparator.comparingInt(string -> this.getOthersGroupName().equals(string) ? 1 : (this.getOriginalGroupName().equals(string) ? -1 : 0)).thenComparing(String::toLowerCase, Comparator.naturalOrder());
    }

    private void mergeCandidates(List<Candidate> list) {
        Object object;
        HashMap<String, List> hashMap = new HashMap<String, List>();
        for (Candidate object2 : list) {
            if (object2.key() == null) continue;
            object = hashMap.computeIfAbsent(object2.key(), string -> new ArrayList());
            object.add(object2);
        }
        if (!hashMap.isEmpty()) {
            for (List list2 : hashMap.values()) {
                if (list2.size() < 1) continue;
                list.removeAll(list2);
                list2.sort(Comparator.comparing(Candidate::value));
                object = (Candidate)list2.get(0);
                String string2 = list2.stream().map(Candidate::displ).collect(Collectors.joining(" "));
                list.add(new Candidate(((Candidate)object).value(), string2, ((Candidate)object).group(), ((Candidate)object).descr(), ((Candidate)object).suffix(), null, ((Candidate)object).complete()));
            }
        }
    }

    private Function<Map<String, List<Candidate>>, Map<String, List<Candidate>>> simpleMatcher(Predicate<String> predicate) {
        return map -> map.entrySet().stream().filter(entry -> predicate.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Function<Map<String, List<Candidate>>, Map<String, List<Candidate>>> typoMatcher(String string, int n, boolean bl) {
        return map -> {
            Map<String, List> map2 = map.entrySet().stream().filter(entry -> this.distance(string, bl ? (String)entry.getKey() : ((String)entry.getKey()).toLowerCase()) < n).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (map2.size() > 1) {
                map2.computeIfAbsent(string, string -> new ArrayList()).add(new Candidate(string, string, this.getOriginalGroupName(), null, null, null, false));
            }
            return map2;
        };
    }

    private int distance(String string, String string2) {
        if (string.length() < string2.length()) {
            int n = Levenshtein.distance(string, string2.substring(0, Math.min(string2.length(), string.length())));
            int n2 = Levenshtein.distance(string, string2);
            return Math.min(n, n2);
        }
        return Levenshtein.distance(string, string2);
    }

    protected boolean nextBindingIsComplete() {
        this.redisplay();
        KeyMap<Binding> keyMap = this.keyMaps.get("menu");
        Binding binding = this.readBinding(this.getKeys(), keyMap);
        if (binding instanceof Reference && "menu-complete".equals(((Reference)binding).name())) {
            return true;
        }
        this.pushBackBinding();
        return false;
    }

    protected boolean doMenu(List<Candidate> list, String string, BiFunction<CharSequence, Boolean, CharSequence> biFunction) {
        Binding binding;
        MenuSupport menuSupport;
        ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
        this.mergeCandidates(list);
        this.computePost(list, null, arrayList, string);
        this.post = menuSupport = new MenuSupport(list, string, biFunction);
        this.redisplay();
        KeyMap<Binding> keyMap = this.keyMaps.get("menu");
        while ((binding = this.readBinding(this.getKeys(), keyMap)) != null) {
            String string2;
            switch (string2 = binding instanceof Reference ? ((Reference)binding).name() : DEFAULT_BELL_STYLE) {
                case "menu-complete": {
                    menuSupport.next();
                    break;
                }
                case "reverse-menu-complete": {
                    menuSupport.previous();
                    break;
                }
                case "up-line-or-history": 
                case "up-line-or-search": {
                    menuSupport.up();
                    break;
                }
                case "down-line-or-history": 
                case "down-line-or-search": {
                    menuSupport.down();
                    break;
                }
                case "forward-char": {
                    menuSupport.right();
                    break;
                }
                case "backward-char": {
                    menuSupport.left();
                    break;
                }
                case "clear-screen": {
                    this.clearScreen();
                    break;
                }
                default: {
                    Candidate candidate = menuSupport.completion();
                    if (candidate.suffix() != null) {
                        String string3 = this.getString("REMOVE_SUFFIX_CHARS", DEFAULT_REMOVE_SUFFIX_CHARS);
                        if ("self-insert".equals(string2) && string3.indexOf(this.getLastBinding().charAt(0)) >= 0 || "backward-delete-char".equals(string2)) {
                            this.buf.backspace(candidate.suffix().length());
                        }
                    }
                    if (candidate.complete() && this.getLastBinding().charAt(0) != ' ' && ("self-insert".equals(string2) || this.getLastBinding().charAt(0) != ' ')) {
                        this.buf.write(32);
                    }
                    if (!("accept-line".equals(string2) || "self-insert".equals(string2) && candidate.suffix() != null && candidate.suffix().startsWith(this.getLastBinding()))) {
                        this.pushBackBinding(true);
                    }
                    this.post = null;
                    return true;
                }
            }
            this.redisplay();
        }
        return false;
    }

    protected boolean doList(List<Candidate> list, String string, boolean bl, BiFunction<CharSequence, Boolean, CharSequence> biFunction) {
        this.mergeCandidates(list);
        AttributedString attributedString = this.insertSecondaryPrompts(AttributedStringBuilder.append(this.prompt, this.buf.toString()), new ArrayList<AttributedString>());
        int n = attributedString.columnSplitLength(this.size.getColumns(), false, this.display.delayLineWrap()).size();
        PostResult postResult = this.computePost(list, null, null, string);
        int n2 = postResult.lines;
        int n3 = this.getInt("list-max", 100);
        if (n3 > 0 && list.size() >= n3 || n2 >= this.size.getRows() - n) {
            this.post = () -> new AttributedString(this.getAppName() + ": do you wish to see to see all " + list.size() + " possibilities (" + n2 + " lines)?");
            this.redisplay(true);
            int bl2 = this.readCharacter();
            if (bl2 != 121 && bl2 != 89 && bl2 != 9) {
                this.post = null;
                return false;
            }
        }
        boolean bl2 = this.isSet(LineReader.Option.CASE_INSENSITIVE);
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            String string2 = string + stringBuilder.toString();
            List<Candidate> list2 = stringBuilder.length() > 0 ? list.stream().filter(candidate -> bl2 ? candidate.value().toLowerCase().startsWith(string2.toLowerCase()) : candidate.value().startsWith(string2)).sorted(this.getCandidateComparator(bl2, string2)).collect(Collectors.toList()) : list.stream().sorted(this.getCandidateComparator(bl2, string2)).collect(Collectors.toList());
            this.post = () -> {
                AttributedString attributedString = this.insertSecondaryPrompts(AttributedStringBuilder.append(this.prompt, this.buf.toString()), new ArrayList<AttributedString>());
                int n = attributedString.columnSplitLength(this.size.getColumns(), false, this.display.delayLineWrap()).size();
                PostResult postResult2 = this.computePost(list2, null, null, string2);
                if (postResult2.lines >= this.size.getRows() - n) {
                    this.post = null;
                    int n2 = this.buf.cursor();
                    this.buf.cursor(this.buf.length());
                    this.redisplay(false);
                    this.buf.cursor(n2);
                    this.println();
                    List<AttributedString> list2 = postResult.post.columnSplitLength(this.size.getColumns(), false, this.display.delayLineWrap());
                    Display display = new Display(this.terminal, false);
                    display.resize(this.size.getRows(), this.size.getColumns());
                    display.update(list2, -1);
                    this.redrawLine();
                    return new AttributedString(DEFAULT_BELL_STYLE);
                }
                return postResult2.post;
            };
            if (!bl) {
                return false;
            }
            this.redisplay();
            Binding binding = this.bindingReader.readBinding(this.getKeys());
            if (binding instanceof Reference) {
                String string3 = ((Reference)binding).name();
                if ("backward-delete-char".equals(string3) || "vi-backward-delete-char".equals(string3)) {
                    if (stringBuilder.length() == 0) {
                        this.pushBackBinding();
                        this.post = null;
                        return false;
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    this.buf.backspace();
                    continue;
                }
                if ("self-insert".equals(string3)) {
                    stringBuilder.append(this.getLastBinding());
                    this.buf.write(this.getLastBinding());
                    if (!list2.isEmpty()) continue;
                    this.post = null;
                    return false;
                }
                if ("\t".equals(this.getLastBinding())) {
                    if (list2.size() == 1 || stringBuilder.length() > 0) {
                        this.post = null;
                        this.pushBackBinding();
                    } else if (this.isSet(LineReader.Option.AUTO_MENU)) {
                        this.buf.backspace(biFunction.apply(string2, false).length());
                        this.doMenu(list2, string2, biFunction);
                    }
                    return false;
                }
                this.pushBackBinding();
                this.post = null;
                return false;
            }
            if (binding == null) break;
        }
        this.post = null;
        return false;
    }

    protected PostResult computePost(List<Candidate> list, Candidate candidate, List<Candidate> list2, String string) {
        return this.computePost(list, candidate, list2, string, this.display::wcwidth, this.size.getColumns(), this.isSet(LineReader.Option.AUTO_GROUP), this.isSet(LineReader.Option.GROUP), this.isSet(LineReader.Option.LIST_ROWS_FIRST));
    }

    protected PostResult computePost(List<Candidate> list, Candidate candidate, List<Candidate> list2, String string2, Function<String, Integer> function, int n, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (bl2) {
            String string3;
            Comparator<String> comparator = this.getGroupComparator();
            AbstractMap abstractMap = comparator != null ? new TreeMap(comparator) : new LinkedHashMap();
            for (Candidate object : list) {
                string3 = object.group();
                abstractMap.computeIfAbsent(string3 != null ? string3 : DEFAULT_BELL_STYLE, string -> new LinkedHashMap()).put(object.value(), object);
            }
            for (Map.Entry entry : abstractMap.entrySet()) {
                string3 = (String)entry.getKey();
                if (string3.isEmpty() && abstractMap.size() > 1) {
                    string3 = this.getOthersGroupName();
                }
                if (!string3.isEmpty() && bl) {
                    arrayList.add(string3);
                }
                arrayList.add(new ArrayList(((Map)entry.getValue()).values()));
                if (list2 == null) continue;
                list2.addAll(((Map)entry.getValue()).values());
            }
        } else {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            TreeMap<String, Candidate> treeMap = new TreeMap<String, Candidate>();
            for (Candidate candidate2 : list) {
                String string4 = candidate2.group();
                if (string4 != null) {
                    linkedHashSet.add(string4);
                }
                treeMap.put(candidate2.value(), candidate2);
            }
            if (bl) {
                arrayList.addAll(linkedHashSet);
            }
            arrayList.add(new ArrayList(treeMap.values()));
            if (list2 != null) {
                list2.addAll(treeMap.values());
            }
        }
        return this.toColumns(arrayList, candidate, string2, function, n, bl3);
    }

    protected PostResult toColumns(List<Object> list, Candidate candidate, String string, Function<String, Integer> function, int n, boolean bl) {
        int[] nArray = new int[2];
        int n2 = 0;
        for (Object iterator : list) {
            if (iterator instanceof String) {
                int n3 = function.apply((String)iterator);
                n2 = Math.max(n2, n3);
                continue;
            }
            if (!(iterator instanceof List)) continue;
            for (Candidate candidate2 : (List)iterator) {
                int n4 = function.apply(candidate2.displ());
                if (candidate2.descr() != null) {
                    ++n4;
                    n4 += DESC_PREFIX.length();
                    n4 += function.apply(candidate2.descr()).intValue();
                    n4 += DESC_SUFFIX.length();
                }
                n2 = Math.max(n2, n4);
            }
        }
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        for (Object object : list) {
            this.toColumns(object, n, n2, attributedStringBuilder, candidate, string, bl, nArray);
        }
        if (attributedStringBuilder.length() > 0 && attributedStringBuilder.charAt(attributedStringBuilder.length() - 1) == '\n') {
            attributedStringBuilder.setLength(attributedStringBuilder.length() - 1);
        }
        return new PostResult(attributedStringBuilder.toAttributedString(), nArray[0], nArray[1]);
    }

    protected void toColumns(Object object, int n, int n4, AttributedStringBuilder attributedStringBuilder, Candidate candidate, String string, boolean bl, int[] nArray) {
        if (n4 <= 0) {
            return;
        }
        if (object instanceof String) {
            attributedStringBuilder.style(this.getCompletionStyleGroup()).append((String)object).style(AttributedStyle.DEFAULT).append("\n");
            nArray[0] = nArray[0] + 1;
        } else if (object instanceof List) {
            int n5;
            List list = (List)object;
            n4 = Math.min(n, n4);
            for (n5 = n / n4; n5 > 1 && n5 * n4 + (n5 - 1) * 3 >= n; --n5) {
            }
            int n6 = (list.size() + n5 - 1) / n5;
            int n7 = (list.size() + n6 - 1) / n6;
            IntBinaryOperator intBinaryOperator = bl ? (n2, n3) -> n2 * n7 + n3 : (n2, n3) -> n3 * n6 + n2;
            for (int i = 0; i < n6; ++i) {
                for (int j = 0; j < n7; ++j) {
                    int n8;
                    int n9 = intBinaryOperator.applyAsInt(i, j);
                    if (n9 >= list.size()) continue;
                    Candidate candidate2 = (Candidate)list.get(n9);
                    boolean bl2 = j < n7 - 1 && intBinaryOperator.applyAsInt(i, j + 1) < list.size();
                    AttributedString attributedString = AttributedString.fromAnsi(candidate2.displ());
                    AttributedString attributedString2 = AttributedString.fromAnsi(candidate2.descr());
                    int n10 = attributedString.columnLength();
                    int n11 = 0;
                    if (attributedString2 != null) {
                        n8 = n4 - (n10 + 1 + DESC_PREFIX.length() + DESC_SUFFIX.length());
                        n11 = attributedString2.columnLength();
                        if (n11 > n8) {
                            attributedString2 = AttributedStringBuilder.append(attributedString2.columnSubSequence(0, n8 - WCWidth.wcwidth(8230)), "\u2026");
                            n11 = attributedString2.columnLength();
                        }
                        attributedString2 = AttributedStringBuilder.append(DESC_PREFIX, attributedString2, DESC_SUFFIX);
                        n11 += DESC_PREFIX.length() + DESC_SUFFIX.length();
                    }
                    if (candidate2 == candidate) {
                        nArray[1] = i;
                        attributedStringBuilder.style(this.getCompletionStyleSelection());
                        if (attributedString.toString().regionMatches(this.isSet(LineReader.Option.CASE_INSENSITIVE), 0, string, 0, string.length())) {
                            attributedStringBuilder.append(attributedString.toString(), 0, string.length());
                            attributedStringBuilder.append(attributedString.toString(), string.length(), attributedString.length());
                        } else {
                            attributedStringBuilder.append(attributedString.toString());
                        }
                        for (n8 = 0; n8 < n4 - n10 - n11; ++n8) {
                            attributedStringBuilder.append(' ');
                        }
                        if (attributedString2 != null) {
                            attributedStringBuilder.append(attributedString2);
                        }
                        attributedStringBuilder.style(AttributedStyle.DEFAULT);
                    } else {
                        if (attributedString.toString().regionMatches(this.isSet(LineReader.Option.CASE_INSENSITIVE), 0, string, 0, string.length())) {
                            attributedStringBuilder.style(this.getCompletionStyleStarting());
                            attributedStringBuilder.append(attributedString, 0, string.length());
                            attributedStringBuilder.style(AttributedStyle.DEFAULT);
                            attributedStringBuilder.append(attributedString, string.length(), attributedString.length());
                        } else {
                            attributedStringBuilder.append(attributedString);
                        }
                        if (attributedString2 != null || bl2) {
                            for (n8 = 0; n8 < n4 - n10 - n11; ++n8) {
                                attributedStringBuilder.append(' ');
                            }
                        }
                        if (attributedString2 != null) {
                            attributedStringBuilder.style(this.getCompletionStyleDescription());
                            attributedStringBuilder.append(attributedString2);
                            attributedStringBuilder.style(AttributedStyle.DEFAULT);
                        }
                    }
                    if (!bl2) continue;
                    for (n8 = 0; n8 < 3; ++n8) {
                        attributedStringBuilder.append(' ');
                    }
                }
                attributedStringBuilder.append('\n');
            }
            nArray[0] = nArray[0] + n6;
        }
    }

    private AttributedStyle getCompletionStyleStarting() {
        return this.getCompletionStyle("COMPLETION_STYLE_STARTING", DEFAULT_COMPLETION_STYLE_STARTING);
    }

    protected AttributedStyle getCompletionStyleDescription() {
        return this.getCompletionStyle("COMPLETION_STYLE_DESCRIPTION", DEFAULT_COMPLETION_STYLE_DESCRIPTION);
    }

    protected AttributedStyle getCompletionStyleGroup() {
        return this.getCompletionStyle("COMPLETION_STYLE_GROUP", DEFAULT_COMPLETION_STYLE_GROUP);
    }

    protected AttributedStyle getCompletionStyleSelection() {
        return this.getCompletionStyle("COMPLETION_STYLE_SELECTION", DEFAULT_COMPLETION_STYLE_SELECTION);
    }

    protected AttributedStyle getCompletionStyle(String string, String string2) {
        return this.buildStyle(this.getString(string, string2));
    }

    protected AttributedStyle buildStyle(String string) {
        return AttributedString.fromAnsi("\u001b[" + string + "m ").styleAt(0);
    }

    private String getCommonStart(String string, String string2, boolean bl) {
        int n;
        int[] nArray = string.codePoints().toArray();
        int[] nArray2 = string2.codePoints().toArray();
        for (n = 0; n < Math.min(nArray.length, nArray2.length); ++n) {
            int n2 = nArray[n];
            int n3 = nArray2[n];
            if (n2 != n3 && bl && (n2 = Character.toUpperCase(n2)) != (n3 = Character.toUpperCase(n3))) {
                n2 = Character.toLowerCase(n2);
                n3 = Character.toLowerCase(n3);
            }
            if (n2 != n3) break;
        }
        return new String(nArray, 0, n);
    }

    protected boolean moveHistory(boolean bl, int n) {
        boolean bl2 = true;
        for (int i = 0; i < n && (bl2 = this.moveHistory(bl)); ++i) {
        }
        return bl2;
    }

    protected boolean moveHistory(boolean bl) {
        if (!this.buf.toString().equals(this.history.current())) {
            this.modifiedHistory.put(this.history.index(), this.buf.toString());
        }
        if (bl && !this.history.next()) {
            return false;
        }
        if (!bl && !this.history.previous()) {
            return false;
        }
        this.setBuffer(this.modifiedHistory.containsKey(this.history.index()) ? this.modifiedHistory.get(this.history.index()) : this.history.current());
        return true;
    }

    void print(String string) {
        this.terminal.writer().write(string);
    }

    void println(String string) {
        this.print(string);
        this.println();
    }

    void println() {
        this.terminal.puts(InfoCmp.Capability.carriage_return, new Object[0]);
        this.print("\n");
        this.redrawLine();
    }

    protected boolean killBuffer() {
        this.killRing.add(this.buf.toString());
        this.buf.clear();
        return true;
    }

    protected boolean killWholeLine() {
        int n;
        int n2;
        if (this.buf.length() == 0) {
            return false;
        }
        if (this.count < 0) {
            n2 = this.buf.cursor();
            while (this.buf.atChar(n2) != 0 && this.buf.atChar(n2) != 10) {
                ++n2;
            }
            n = n2;
            for (int i = -this.count; i > 0; --i) {
                while (n > 0 && this.buf.atChar(n - 1) != 10) {
                    --n;
                }
                --n;
            }
        } else {
            for (n = this.buf.cursor(); n > 0 && this.buf.atChar(n - 1) != 10; --n) {
            }
            n2 = n;
            while (this.count-- > 0) {
                while (n2 < this.buf.length() && this.buf.atChar(n2) != 10) {
                    ++n2;
                }
                ++n2;
            }
        }
        String string = this.buf.substring(n, n2);
        this.buf.cursor(n);
        this.buf.delete(n2 - n);
        this.killRing.add(string);
        return true;
    }

    public boolean killLine() {
        int n;
        if (this.count < 0) {
            return this.callNeg(this::backwardKillLine);
        }
        if (this.buf.cursor() == this.buf.length()) {
            return false;
        }
        int n2 = n = this.buf.cursor();
        while (this.count-- > 0) {
            if (this.buf.atChar(n2) == 10) {
                ++n2;
                continue;
            }
            while (this.buf.atChar(n2) != 0 && this.buf.atChar(n2) != 10) {
                ++n2;
            }
        }
        int n3 = n2 - n;
        String string = this.buf.substring(n, n + n3);
        this.buf.delete(n3);
        this.killRing.add(string);
        return true;
    }

    public boolean backwardKillLine() {
        int n;
        if (this.count < 0) {
            return this.callNeg(this::killLine);
        }
        if (this.buf.cursor() == 0) {
            return false;
        }
        int n2 = n = this.buf.cursor();
        while (this.count-- > 0 && n2 != 0) {
            if (this.buf.atChar(n2 - 1) == 10) {
                --n2;
                continue;
            }
            while (n2 > 0 && this.buf.atChar(n2 - 1) != 0 && this.buf.atChar(n2 - 1) != 10) {
                --n2;
            }
        }
        int n3 = n - n2;
        String string = this.buf.substring(n - n2, n);
        this.buf.cursor(n2);
        this.buf.delete(n3);
        this.killRing.add(string);
        return true;
    }

    public boolean killRegion() {
        return this.doCopyKillRegion(true);
    }

    public boolean copyRegionAsKill() {
        return this.doCopyKillRegion(false);
    }

    private boolean doCopyKillRegion(boolean bl) {
        if (this.regionMark > this.buf.length()) {
            this.regionMark = this.buf.length();
        }
        if (this.regionActive == LineReader.RegionType.LINE) {
            int n = this.regionMark;
            int n2 = this.buf.cursor();
            if (n < n2) {
                while (n > 0 && this.buf.atChar(n - 1) != 10) {
                    --n;
                }
                while (n2 < this.buf.length() - 1 && this.buf.atChar(n2 + 1) != 10) {
                    ++n2;
                }
                if (this.isInViCmdMode()) {
                    ++n2;
                }
                this.killRing.add(this.buf.substring(n, n2));
                if (bl) {
                    this.buf.backspace(n2 - n);
                }
            } else {
                while (n2 > 0 && this.buf.atChar(n2 - 1) != 10) {
                    --n2;
                }
                while (n < this.buf.length() && this.buf.atChar(n) != 10) {
                    ++n;
                }
                if (this.isInViCmdMode()) {
                    ++n;
                }
                this.killRing.addBackwards(this.buf.substring(n2, n));
                if (bl) {
                    this.buf.cursor(n2);
                    this.buf.delete(n - n2);
                }
            }
        } else if (this.regionMark > this.buf.cursor()) {
            if (this.isInViCmdMode()) {
                ++this.regionMark;
            }
            this.killRing.add(this.buf.substring(this.buf.cursor(), this.regionMark));
            if (bl) {
                this.buf.delete(this.regionMark - this.buf.cursor());
            }
        } else {
            if (this.isInViCmdMode()) {
                this.buf.move(1);
            }
            this.killRing.add(this.buf.substring(this.regionMark, this.buf.cursor()));
            if (bl) {
                this.buf.backspace(this.buf.cursor() - this.regionMark);
            }
        }
        if (bl) {
            this.regionActive = LineReader.RegionType.NONE;
        }
        return true;
    }

    public boolean yank() {
        String string = this.killRing.yank();
        if (string == null) {
            return false;
        }
        this.putString(string);
        return true;
    }

    public boolean yankPop() {
        if (!this.killRing.lastYank()) {
            return false;
        }
        String string = this.killRing.yank();
        if (string == null) {
            return false;
        }
        this.buf.backspace(string.length());
        String string2 = this.killRing.yankPop();
        if (string2 == null) {
            return false;
        }
        this.putString(string2);
        return true;
    }

    public boolean mouse() {
        MouseEvent mouseEvent = this.readMouseEvent();
        if (mouseEvent.getType() == MouseEvent.Type.Released && mouseEvent.getButton() == MouseEvent.Button.Button1) {
            StringBuilder stringBuilder = new StringBuilder();
            Cursor cursor = this.terminal.getCursorPosition(n -> stringBuilder.append((char)n));
            this.bindingReader.runMacro(stringBuilder.toString());
            ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
            this.getDisplayedBufferWithPrompts(arrayList);
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(4);
            attributedStringBuilder.append(this.prompt);
            attributedStringBuilder.append(this.insertSecondaryPrompts(new AttributedString(this.buf.upToCursor()), arrayList, false));
            List<AttributedString> list = attributedStringBuilder.columnSplitLength(this.size.getColumns(), false, this.display.delayLineWrap());
            int n2 = list.size() - 1;
            int n3 = Math.max(0, Math.min(n2 + mouseEvent.getY() - cursor.getY(), arrayList.size()));
            int n4 = n2 == 0 ? this.prompt.columnLength() : ((AttributedString)arrayList.get(n2 - 1)).columnLength();
            int n5 = n3 == 0 ? this.prompt.columnLength() : ((AttributedString)arrayList.get(n3 - 1)).columnLength();
            int n6 = n5 - n4;
            this.buf.moveXY(mouseEvent.getX() - cursor.getX() - n6, mouseEvent.getY() - cursor.getY());
        }
        return true;
    }

    public boolean beginPaste() {
        Object t;
        Object object = new Object();
        Object object2 = new Object();
        KeyMap<Object> keyMap = new KeyMap<Object>();
        keyMap.setUnicode(object);
        keyMap.setNomatch(object);
        keyMap.setAmbiguousTimeout(0L);
        keyMap.bind(object2, (CharSequence)BRACKETED_PASTE_END);
        StringBuilder stringBuilder = new StringBuilder();
        while ((t = this.bindingReader.readBinding(keyMap)) != object2) {
            String string = this.getLastBinding();
            if ("\r".equals(string)) {
                string = "\n";
            }
            stringBuilder.append(string);
        }
        this.regionActive = LineReader.RegionType.PASTE;
        this.regionMark = this.getBuffer().cursor();
        this.getBuffer().write(stringBuilder);
        return true;
    }

    public boolean focusIn() {
        return false;
    }

    public boolean focusOut() {
        return false;
    }

    public boolean clear() {
        this.display.update(Collections.emptyList(), 0);
        return true;
    }

    public boolean clearScreen() {
        if (this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0])) {
            this.redrawLine();
        } else {
            this.println();
        }
        return true;
    }

    public boolean beep() {
        BellType bellType = BellType.AUDIBLE;
        switch (this.getString("bell-style", DEFAULT_BELL_STYLE).toLowerCase()) {
            case "none": 
            case "off": {
                bellType = BellType.NONE;
                break;
            }
            case "audible": {
                bellType = BellType.AUDIBLE;
                break;
            }
            case "visible": {
                bellType = BellType.VISIBLE;
                break;
            }
            case "on": {
                BellType bellType2 = bellType = this.getBoolean("prefer-visible-bell", false) ? BellType.VISIBLE : BellType.AUDIBLE;
            }
        }
        if (bellType == BellType.VISIBLE) {
            if (this.terminal.puts(InfoCmp.Capability.flash_screen, new Object[0]) || this.terminal.puts(InfoCmp.Capability.bell, new Object[0])) {
                this.flush();
            }
        } else if (bellType == BellType.AUDIBLE && this.terminal.puts(InfoCmp.Capability.bell, new Object[0])) {
            this.flush();
        }
        return true;
    }

    protected boolean isDelimiter(int n) {
        return !Character.isLetterOrDigit(n);
    }

    protected boolean isWhitespace(int n) {
        return Character.isWhitespace(n);
    }

    protected boolean isViAlphaNum(int n) {
        return n == 95 || Character.isLetterOrDigit(n);
    }

    protected boolean isAlpha(int n) {
        return Character.isLetter(n);
    }

    protected boolean isWord(int n) {
        String string = this.getString("WORDCHARS", DEFAULT_WORDCHARS);
        return Character.isLetterOrDigit(n) || n < 128 && string.indexOf((char)n) >= 0;
    }

    String getString(String string, String string2) {
        return ReaderUtils.getString(this, string, string2);
    }

    boolean getBoolean(String string, boolean bl) {
        return ReaderUtils.getBoolean(this, string, bl);
    }

    int getInt(String string, int n) {
        return ReaderUtils.getInt(this, string, n);
    }

    long getLong(String string, long l) {
        return ReaderUtils.getLong(this, string, l);
    }

    @Override
    public Map<String, KeyMap<Binding>> defaultKeyMaps() {
        HashMap<String, KeyMap<Binding>> hashMap = new HashMap<String, KeyMap<Binding>>();
        hashMap.put("emacs", this.emacs());
        hashMap.put("vicmd", this.viCmd());
        hashMap.put("viins", this.viInsertion());
        hashMap.put("menu", this.menu());
        hashMap.put("viopp", this.viOpp());
        hashMap.put("visual", this.visual());
        hashMap.put(".safe", this.safe());
        if (this.getBoolean("bind-tty-special-chars", true)) {
            Attributes attributes = this.terminal.getAttributes();
            this.bindConsoleChars((KeyMap)hashMap.get("emacs"), attributes);
            this.bindConsoleChars((KeyMap)hashMap.get("viins"), attributes);
        }
        for (KeyMap keyMap : hashMap.values()) {
            keyMap.setUnicode(new Reference("self-insert"));
            keyMap.setAmbiguousTimeout(this.getLong("ambiguous-binding", 1000L));
        }
        hashMap.put("main", (KeyMap<Binding>)hashMap.get("emacs"));
        return hashMap;
    }

    public KeyMap<Binding> emacs() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "set-mark-command", KeyMap.ctrl('@'));
        this.bind(keyMap, "beginning-of-line", KeyMap.ctrl('A'));
        this.bind(keyMap, "backward-char", KeyMap.ctrl('B'));
        this.bind(keyMap, "delete-char-or-list", KeyMap.ctrl('D'));
        this.bind(keyMap, "end-of-line", KeyMap.ctrl('E'));
        this.bind(keyMap, "forward-char", KeyMap.ctrl('F'));
        this.bind(keyMap, "abort", KeyMap.ctrl('G'));
        this.bind(keyMap, "backward-delete-char", KeyMap.ctrl('H'));
        this.bind(keyMap, "expand-or-complete", KeyMap.ctrl('I'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('J'));
        this.bind(keyMap, "kill-line", KeyMap.ctrl('K'));
        this.bind(keyMap, "clear-screen", KeyMap.ctrl('L'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('M'));
        this.bind(keyMap, "down-line-or-history", KeyMap.ctrl('N'));
        this.bind(keyMap, "up-line-or-history", KeyMap.ctrl('P'));
        this.bind(keyMap, "history-incremental-search-backward", KeyMap.ctrl('R'));
        this.bind(keyMap, "history-incremental-search-forward", KeyMap.ctrl('S'));
        this.bind(keyMap, "transpose-chars", KeyMap.ctrl('T'));
        this.bind(keyMap, "kill-whole-line", KeyMap.ctrl('U'));
        this.bind(keyMap, "quoted-insert", KeyMap.ctrl('V'));
        this.bind(keyMap, "backward-kill-word", KeyMap.ctrl('W'));
        this.bind(keyMap, "yank", KeyMap.ctrl('Y'));
        this.bind(keyMap, "character-search", KeyMap.ctrl(']'));
        this.bind(keyMap, "undo", KeyMap.ctrl('_'));
        this.bind(keyMap, "self-insert", KeyMap.range(" -~"));
        this.bind(keyMap, "insert-close-paren", DESC_SUFFIX);
        this.bind(keyMap, "insert-close-square", "]");
        this.bind(keyMap, "insert-close-curly", "}");
        this.bind(keyMap, "backward-delete-char", KeyMap.del());
        this.bind(keyMap, "vi-match-bracket", KeyMap.translate("^X^B"));
        this.bind(keyMap, "abort", KeyMap.translate("^X^G"));
        this.bind(keyMap, "vi-find-next-char", KeyMap.translate("^X^F"));
        this.bind(keyMap, "vi-join", KeyMap.translate("^X^J"));
        this.bind(keyMap, "kill-buffer", KeyMap.translate("^X^K"));
        this.bind(keyMap, "infer-next-history", KeyMap.translate("^X^N"));
        this.bind(keyMap, "overwrite-mode", KeyMap.translate("^X^O"));
        this.bind(keyMap, "redo", KeyMap.translate("^X^R"));
        this.bind(keyMap, "undo", KeyMap.translate("^X^U"));
        this.bind(keyMap, "vi-cmd-mode", KeyMap.translate("^X^V"));
        this.bind(keyMap, "exchange-point-and-mark", KeyMap.translate("^X^X"));
        this.bind(keyMap, "do-lowercase-version", KeyMap.translate("^XA-^XZ"));
        this.bind(keyMap, "what-cursor-position", KeyMap.translate("^X="));
        this.bind(keyMap, "kill-line", KeyMap.translate("^X^?"));
        this.bind(keyMap, "abort", KeyMap.alt(KeyMap.ctrl('G')));
        this.bind(keyMap, "backward-kill-word", KeyMap.alt(KeyMap.ctrl('H')));
        this.bind(keyMap, "self-insert-unmeta", KeyMap.alt(KeyMap.ctrl('M')));
        this.bind(keyMap, "complete-word", KeyMap.alt(KeyMap.esc()));
        this.bind(keyMap, "character-search-backward", KeyMap.alt(KeyMap.ctrl(']')));
        this.bind(keyMap, "copy-prev-word", KeyMap.alt(KeyMap.ctrl('_')));
        this.bind(keyMap, "set-mark-command", KeyMap.alt(' '));
        this.bind(keyMap, "neg-argument", KeyMap.alt('-'));
        this.bind(keyMap, "digit-argument", KeyMap.range("\\E0-\\E9"));
        this.bind(keyMap, "beginning-of-history", KeyMap.alt('<'));
        this.bind(keyMap, "list-choices", KeyMap.alt('='));
        this.bind(keyMap, "end-of-history", KeyMap.alt('>'));
        this.bind(keyMap, "list-choices", KeyMap.alt('?'));
        this.bind(keyMap, "do-lowercase-version", KeyMap.range("^[A-^[Z"));
        this.bind(keyMap, "backward-word", KeyMap.alt('b'));
        this.bind(keyMap, "capitalize-word", KeyMap.alt('c'));
        this.bind(keyMap, "kill-word", KeyMap.alt('d'));
        this.bind(keyMap, "kill-word", KeyMap.translate("^[[3;5~"));
        this.bind(keyMap, "forward-word", KeyMap.alt('f'));
        this.bind(keyMap, "down-case-word", KeyMap.alt('l'));
        this.bind(keyMap, "history-search-forward", KeyMap.alt('n'));
        this.bind(keyMap, "history-search-backward", KeyMap.alt('p'));
        this.bind(keyMap, "transpose-words", KeyMap.alt('t'));
        this.bind(keyMap, "up-case-word", KeyMap.alt('u'));
        this.bind(keyMap, "yank-pop", KeyMap.alt('y'));
        this.bind(keyMap, "backward-kill-word", KeyMap.alt(KeyMap.del()));
        this.bindArrowKeys(keyMap);
        this.bind(keyMap, "forward-word", KeyMap.translate("^[[1;5C"));
        this.bind(keyMap, "backward-word", KeyMap.translate("^[[1;5D"));
        this.bind(keyMap, "forward-word", KeyMap.alt(this.key(InfoCmp.Capability.key_right)));
        this.bind(keyMap, "backward-word", KeyMap.alt(this.key(InfoCmp.Capability.key_left)));
        this.bind(keyMap, "forward-word", KeyMap.alt(KeyMap.translate("^[[C")));
        this.bind(keyMap, "backward-word", KeyMap.alt(KeyMap.translate("^[[D")));
        return keyMap;
    }

    public KeyMap<Binding> viInsertion() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "self-insert", KeyMap.range("^@-^_"));
        this.bind(keyMap, "list-choices", KeyMap.ctrl('D'));
        this.bind(keyMap, "abort", KeyMap.ctrl('G'));
        this.bind(keyMap, "backward-delete-char", KeyMap.ctrl('H'));
        this.bind(keyMap, "expand-or-complete", KeyMap.ctrl('I'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('J'));
        this.bind(keyMap, "clear-screen", KeyMap.ctrl('L'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('M'));
        this.bind(keyMap, "menu-complete", KeyMap.ctrl('N'));
        this.bind(keyMap, "reverse-menu-complete", KeyMap.ctrl('P'));
        this.bind(keyMap, "history-incremental-search-backward", KeyMap.ctrl('R'));
        this.bind(keyMap, "history-incremental-search-forward", KeyMap.ctrl('S'));
        this.bind(keyMap, "transpose-chars", KeyMap.ctrl('T'));
        this.bind(keyMap, "kill-whole-line", KeyMap.ctrl('U'));
        this.bind(keyMap, "quoted-insert", KeyMap.ctrl('V'));
        this.bind(keyMap, "backward-kill-word", KeyMap.ctrl('W'));
        this.bind(keyMap, "yank", KeyMap.ctrl('Y'));
        this.bind(keyMap, "vi-cmd-mode", KeyMap.ctrl('['));
        this.bind(keyMap, "undo", KeyMap.ctrl('_'));
        this.bind(keyMap, "history-incremental-search-backward", KeyMap.ctrl('X') + "r");
        this.bind(keyMap, "history-incremental-search-forward", KeyMap.ctrl('X') + "s");
        this.bind(keyMap, "self-insert", KeyMap.range(" -~"));
        this.bind(keyMap, "insert-close-paren", DESC_SUFFIX);
        this.bind(keyMap, "insert-close-square", "]");
        this.bind(keyMap, "insert-close-curly", "}");
        this.bind(keyMap, "backward-delete-char", KeyMap.del());
        this.bindArrowKeys(keyMap);
        return keyMap;
    }

    public KeyMap<Binding> viCmd() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "list-choices", KeyMap.ctrl('D'));
        this.bind(keyMap, "emacs-editing-mode", KeyMap.ctrl('E'));
        this.bind(keyMap, "abort", KeyMap.ctrl('G'));
        this.bind(keyMap, "vi-backward-char", KeyMap.ctrl('H'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('J'));
        this.bind(keyMap, "kill-line", KeyMap.ctrl('K'));
        this.bind(keyMap, "clear-screen", KeyMap.ctrl('L'));
        this.bind(keyMap, "accept-line", KeyMap.ctrl('M'));
        this.bind(keyMap, "vi-down-line-or-history", KeyMap.ctrl('N'));
        this.bind(keyMap, "vi-up-line-or-history", KeyMap.ctrl('P'));
        this.bind(keyMap, "quoted-insert", KeyMap.ctrl('Q'));
        this.bind(keyMap, "history-incremental-search-backward", KeyMap.ctrl('R'));
        this.bind(keyMap, "history-incremental-search-forward", KeyMap.ctrl('S'));
        this.bind(keyMap, "transpose-chars", KeyMap.ctrl('T'));
        this.bind(keyMap, "kill-whole-line", KeyMap.ctrl('U'));
        this.bind(keyMap, "quoted-insert", KeyMap.ctrl('V'));
        this.bind(keyMap, "backward-kill-word", KeyMap.ctrl('W'));
        this.bind(keyMap, "yank", KeyMap.ctrl('Y'));
        this.bind(keyMap, "history-incremental-search-backward", KeyMap.ctrl('X') + "r");
        this.bind(keyMap, "history-incremental-search-forward", KeyMap.ctrl('X') + "s");
        this.bind(keyMap, "abort", KeyMap.alt(KeyMap.ctrl('G')));
        this.bind(keyMap, "backward-kill-word", KeyMap.alt(KeyMap.ctrl('H')));
        this.bind(keyMap, "self-insert-unmeta", KeyMap.alt(KeyMap.ctrl('M')));
        this.bind(keyMap, "complete-word", KeyMap.alt(KeyMap.esc()));
        this.bind(keyMap, "character-search-backward", KeyMap.alt(KeyMap.ctrl(']')));
        this.bind(keyMap, "set-mark-command", KeyMap.alt(' '));
        this.bind(keyMap, "digit-argument", KeyMap.alt('-'));
        this.bind(keyMap, "beginning-of-history", KeyMap.alt('<'));
        this.bind(keyMap, "list-choices", KeyMap.alt('='));
        this.bind(keyMap, "end-of-history", KeyMap.alt('>'));
        this.bind(keyMap, "list-choices", KeyMap.alt('?'));
        this.bind(keyMap, "do-lowercase-version", KeyMap.range("^[A-^[Z"));
        this.bind(keyMap, "backward-word", KeyMap.alt('b'));
        this.bind(keyMap, "capitalize-word", KeyMap.alt('c'));
        this.bind(keyMap, "kill-word", KeyMap.alt('d'));
        this.bind(keyMap, "forward-word", KeyMap.alt('f'));
        this.bind(keyMap, "down-case-word", KeyMap.alt('l'));
        this.bind(keyMap, "history-search-forward", KeyMap.alt('n'));
        this.bind(keyMap, "history-search-backward", KeyMap.alt('p'));
        this.bind(keyMap, "transpose-words", KeyMap.alt('t'));
        this.bind(keyMap, "up-case-word", KeyMap.alt('u'));
        this.bind(keyMap, "yank-pop", KeyMap.alt('y'));
        this.bind(keyMap, "backward-kill-word", KeyMap.alt(KeyMap.del()));
        this.bind(keyMap, "forward-char", " ");
        this.bind(keyMap, "vi-insert-comment", DEFAULT_COMMENT_BEGIN);
        this.bind(keyMap, "end-of-line", "$");
        this.bind(keyMap, "vi-match-bracket", "%");
        this.bind(keyMap, "vi-down-line-or-history", "+");
        this.bind(keyMap, "vi-rev-repeat-find", ",");
        this.bind(keyMap, "vi-up-line-or-history", "-");
        this.bind(keyMap, "vi-repeat-change", ".");
        this.bind(keyMap, "vi-history-search-backward", "/");
        this.bind(keyMap, "vi-digit-or-beginning-of-line", "0");
        this.bind(keyMap, "digit-argument", KeyMap.range("1-9"));
        this.bind(keyMap, "vi-repeat-find", ";");
        this.bind(keyMap, "list-choices", "=");
        this.bind(keyMap, "vi-history-search-forward", "?");
        this.bind(keyMap, "vi-add-eol", "A");
        this.bind(keyMap, "vi-backward-blank-word", "B");
        this.bind(keyMap, "vi-change-eol", "C");
        this.bind(keyMap, "vi-kill-eol", "D");
        this.bind(keyMap, "vi-forward-blank-word-end", "E");
        this.bind(keyMap, "vi-find-prev-char", "F");
        this.bind(keyMap, "vi-fetch-history", "G");
        this.bind(keyMap, "vi-insert-bol", "I");
        this.bind(keyMap, "vi-join", "J");
        this.bind(keyMap, "vi-rev-repeat-search", "N");
        this.bind(keyMap, "vi-open-line-above", "O");
        this.bind(keyMap, "vi-put-before", "P");
        this.bind(keyMap, "vi-replace", "R");
        this.bind(keyMap, "vi-kill-line", "S");
        this.bind(keyMap, "vi-find-prev-char-skip", "T");
        this.bind(keyMap, "redo", "U");
        this.bind(keyMap, "visual-line-mode", "V");
        this.bind(keyMap, "vi-forward-blank-word", "W");
        this.bind(keyMap, "vi-backward-delete-char", "X");
        this.bind(keyMap, "vi-yank-whole-line", "Y");
        this.bind(keyMap, "vi-first-non-blank", "^");
        this.bind(keyMap, "vi-add-next", "a");
        this.bind(keyMap, "vi-backward-word", "b");
        this.bind(keyMap, "vi-change-to", "c");
        this.bind(keyMap, "vi-delete", "d");
        this.bind(keyMap, "vi-forward-word-end", "e");
        this.bind(keyMap, "vi-find-next-char", "f");
        this.bind(keyMap, "what-cursor-position", "ga");
        this.bind(keyMap, "vi-backward-blank-word-end", "gE");
        this.bind(keyMap, "vi-backward-word-end", "ge");
        this.bind(keyMap, "vi-backward-char", "h");
        this.bind(keyMap, "vi-insert", "i");
        this.bind(keyMap, "down-line-or-history", "j");
        this.bind(keyMap, "up-line-or-history", "k");
        this.bind(keyMap, "vi-forward-char", "l");
        this.bind(keyMap, "vi-repeat-search", "n");
        this.bind(keyMap, "vi-open-line-below", "o");
        this.bind(keyMap, "vi-put-after", "p");
        this.bind(keyMap, "vi-replace-chars", "r");
        this.bind(keyMap, "vi-substitute", "s");
        this.bind(keyMap, "vi-find-next-char-skip", "t");
        this.bind(keyMap, "undo", "u");
        this.bind(keyMap, "visual-mode", "v");
        this.bind(keyMap, "vi-forward-word", "w");
        this.bind(keyMap, "vi-delete-char", "x");
        this.bind(keyMap, "vi-yank", "y");
        this.bind(keyMap, "vi-goto-column", "|");
        this.bind(keyMap, "vi-swap-case", "~");
        this.bind(keyMap, "vi-backward-char", KeyMap.del());
        this.bindArrowKeys(keyMap);
        return keyMap;
    }

    public KeyMap<Binding> menu() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "menu-complete", "\t");
        this.bind(keyMap, "reverse-menu-complete", this.key(InfoCmp.Capability.back_tab));
        this.bind(keyMap, "accept-line", "\r", "\n");
        this.bindArrowKeys(keyMap);
        return keyMap;
    }

    public KeyMap<Binding> safe() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "self-insert", KeyMap.range("^@-^?"));
        this.bind(keyMap, "accept-line", "\r", "\n");
        this.bind(keyMap, "abort", KeyMap.ctrl('G'));
        return keyMap;
    }

    public KeyMap<Binding> visual() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "up-line", this.key(InfoCmp.Capability.key_up), "k");
        this.bind(keyMap, "down-line", this.key(InfoCmp.Capability.key_down), "j");
        this.bind(keyMap, this::deactivateRegion, KeyMap.esc());
        this.bind(keyMap, "exchange-point-and-mark", "o");
        this.bind(keyMap, "put-replace-selection", "p");
        this.bind(keyMap, "vi-delete", "x");
        this.bind(keyMap, "vi-oper-swap-case", "~");
        return keyMap;
    }

    public KeyMap<Binding> viOpp() {
        KeyMap<Binding> keyMap = new KeyMap<Binding>();
        this.bind(keyMap, "up-line", this.key(InfoCmp.Capability.key_up), "k");
        this.bind(keyMap, "down-line", this.key(InfoCmp.Capability.key_down), "j");
        this.bind(keyMap, "vi-cmd-mode", KeyMap.esc());
        return keyMap;
    }

    private void bind(KeyMap<Binding> keyMap, String string, Iterable<? extends CharSequence> iterable) {
        keyMap.bind((Binding)new Reference(string), iterable);
    }

    private void bind(KeyMap<Binding> keyMap, String string, CharSequence ... charSequenceArray) {
        keyMap.bind((Binding)new Reference(string), charSequenceArray);
    }

    private void bind(KeyMap<Binding> keyMap, Widget widget, CharSequence ... charSequenceArray) {
        keyMap.bind((Binding)widget, charSequenceArray);
    }

    private String key(InfoCmp.Capability capability) {
        return KeyMap.key(this.terminal, capability);
    }

    private void bindArrowKeys(KeyMap<Binding> keyMap) {
        this.bind(keyMap, "up-line-or-search", this.key(InfoCmp.Capability.key_up));
        this.bind(keyMap, "down-line-or-search", this.key(InfoCmp.Capability.key_down));
        this.bind(keyMap, "backward-char", this.key(InfoCmp.Capability.key_left));
        this.bind(keyMap, "forward-char", this.key(InfoCmp.Capability.key_right));
        this.bind(keyMap, "beginning-of-line", this.key(InfoCmp.Capability.key_home));
        this.bind(keyMap, "end-of-line", this.key(InfoCmp.Capability.key_end));
        this.bind(keyMap, "delete-char", this.key(InfoCmp.Capability.key_dc));
        this.bind(keyMap, "kill-whole-line", this.key(InfoCmp.Capability.key_dl));
        this.bind(keyMap, "overwrite-mode", this.key(InfoCmp.Capability.key_ic));
        this.bind(keyMap, "mouse", this.key(InfoCmp.Capability.key_mouse));
        this.bind(keyMap, "begin-paste", BRACKETED_PASTE_BEGIN);
        this.bind(keyMap, "terminal-focus-in", FOCUS_IN_SEQ);
        this.bind(keyMap, "terminal-focus-out", FOCUS_OUT_SEQ);
    }

    private void bindConsoleChars(KeyMap<Binding> keyMap, Attributes attributes) {
        if (attributes != null) {
            this.rebind(keyMap, "backward-delete-char", KeyMap.del(), (char)attributes.getControlChar(Attributes.ControlChar.VERASE));
            this.rebind(keyMap, "backward-kill-word", KeyMap.ctrl('W'), (char)attributes.getControlChar(Attributes.ControlChar.VWERASE));
            this.rebind(keyMap, "kill-whole-line", KeyMap.ctrl('U'), (char)attributes.getControlChar(Attributes.ControlChar.VKILL));
            this.rebind(keyMap, "quoted-insert", KeyMap.ctrl('V'), (char)attributes.getControlChar(Attributes.ControlChar.VLNEXT));
        }
    }

    private void rebind(KeyMap<Binding> keyMap, String string, String string2, char c) {
        if (c > '\u0000' && c < '\u0080') {
            Reference reference = new Reference(string);
            this.bind(keyMap, "self-insert", string2);
            keyMap.bind((Binding)reference, (CharSequence)Character.toString(c));
        }
    }

    private static /* synthetic */ boolean lambda$doComplete$24(boolean bl, String string, String string2) {
        return bl ? string2.equalsIgnoreCase(string) : string2.equals(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$23(boolean bl, String string, String string2) {
        return (bl ? string2.toLowerCase() : string2).contains(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$22(boolean bl, String string, String string2) {
        return (bl ? string2.toLowerCase() : string2).startsWith(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$21(boolean bl, String string, String string2) {
        return bl ? string2.equalsIgnoreCase(string) : string2.equals(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$19(Pattern pattern, boolean bl, String string) {
        return pattern.matcher(bl ? string.toLowerCase() : string).matches();
    }

    private static /* synthetic */ boolean lambda$doComplete$18(boolean bl, String string, String string2) {
        return bl ? string2.equalsIgnoreCase(string) : string2.equals(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$17(boolean bl, String string, String string2) {
        return (bl ? string2.toLowerCase() : string2).contains(string);
    }

    private static /* synthetic */ boolean lambda$doComplete$16(boolean bl, String string, String string2) {
        return (bl ? string2.toLowerCase() : string2).startsWith(string);
    }

    private static /* synthetic */ void lambda$readLine$0(Thread thread, Terminal.Signal signal) {
        thread.interrupt();
    }

    protected static class PostResult {
        final AttributedString post;
        final int lines;
        final int selectedLine;

        public PostResult(AttributedString attributedString, int n, int n2) {
            this.post = attributedString;
            this.lines = n;
            this.selectedLine = n2;
        }
    }

    private class MenuSupport
    implements Supplier<AttributedString> {
        final List<Candidate> possible = new ArrayList<Candidate>();
        final BiFunction<CharSequence, Boolean, CharSequence> escaper;
        int selection;
        int topLine;
        String word;
        AttributedString computed;
        int lines;
        int columns;
        String completed;

        public MenuSupport(List<Candidate> list, String string, BiFunction<CharSequence, Boolean, CharSequence> biFunction) {
            this.escaper = biFunction;
            this.selection = -1;
            this.topLine = 0;
            this.word = LineReaderImpl.DEFAULT_BELL_STYLE;
            this.completed = string;
            LineReaderImpl.this.computePost(list, null, this.possible, string);
            this.next();
        }

        public Candidate completion() {
            return this.possible.get(this.selection);
        }

        public void next() {
            this.selection = (this.selection + 1) % this.possible.size();
            this.update();
        }

        public void previous() {
            this.selection = (this.selection + this.possible.size() - 1) % this.possible.size();
            this.update();
        }

        private void major(int n) {
            int n2 = LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST) ? this.columns : this.lines;
            int n3 = this.selection + n * n2;
            if (n3 < 0) {
                int n4 = (n3 + n2) % n2;
                int n5 = this.possible.size() % n2;
                n3 = this.possible.size() - n5 + n4;
                if (n3 >= this.possible.size()) {
                    n3 -= n2;
                }
            } else if (n3 >= this.possible.size()) {
                n3 %= n2;
            }
            this.selection = n3;
            this.update();
        }

        private void minor(int n) {
            int n2;
            int n3 = LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST) ? this.columns : this.lines;
            int n4 = this.selection % n3;
            if (this.selection - n4 + n3 > (n2 = this.possible.size())) {
                n3 = n2 % n3;
            }
            this.selection = this.selection - n4 + (n3 + n4 + n) % n3;
            this.update();
        }

        public void up() {
            if (LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST)) {
                this.major(-1);
            } else {
                this.minor(-1);
            }
        }

        public void down() {
            if (LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST)) {
                this.major(1);
            } else {
                this.minor(1);
            }
        }

        public void left() {
            if (LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST)) {
                this.minor(-1);
            } else {
                this.major(-1);
            }
        }

        public void right() {
            if (LineReaderImpl.this.isSet(LineReader.Option.LIST_ROWS_FIRST)) {
                this.minor(1);
            } else {
                this.major(1);
            }
        }

        private void update() {
            LineReaderImpl.this.buf.backspace(this.word.length());
            this.word = this.escaper.apply(this.completion().value(), true).toString();
            LineReaderImpl.this.buf.write(this.word);
            PostResult postResult = LineReaderImpl.this.computePost(this.possible, this.completion(), null, this.completed);
            AttributedString attributedString = LineReaderImpl.this.insertSecondaryPrompts(AttributedStringBuilder.append(LineReaderImpl.this.prompt, LineReaderImpl.this.buf.toString()), new ArrayList());
            int n = attributedString.columnSplitLength(LineReaderImpl.this.size.getColumns(), false, LineReaderImpl.this.display.delayLineWrap()).size();
            if (postResult.lines > LineReaderImpl.this.size.getRows() - n) {
                AttributedString attributedString2;
                int n2 = LineReaderImpl.this.size.getRows() - n - 1;
                if (postResult.selectedLine >= 0) {
                    if (postResult.selectedLine < this.topLine) {
                        this.topLine = postResult.selectedLine;
                    } else if (postResult.selectedLine >= this.topLine + n2) {
                        this.topLine = postResult.selectedLine - n2 + 1;
                    }
                }
                if ((attributedString2 = postResult.post).length() > 0 && attributedString2.charAt(attributedString2.length() - 1) != '\n') {
                    attributedString2 = new AttributedStringBuilder(attributedString2.length() + 1).append(attributedString2).append("\n").toAttributedString();
                }
                List<AttributedString> list = attributedString2.columnSplitLength(LineReaderImpl.this.size.getColumns(), true, LineReaderImpl.this.display.delayLineWrap());
                ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>(list.subList(this.topLine, this.topLine + n2));
                arrayList.add(new AttributedStringBuilder().style(AttributedStyle.DEFAULT.foreground(6)).append("rows ").append(Integer.toString(this.topLine + 1)).append(" to ").append(Integer.toString(this.topLine + n2)).append(" of ").append(Integer.toString(list.size())).append("\n").style(AttributedStyle.DEFAULT).toAttributedString());
                this.computed = AttributedString.join(AttributedString.EMPTY, arrayList);
            } else {
                this.computed = postResult.post;
            }
            this.lines = postResult.lines;
            this.columns = (this.possible.size() + this.lines - 1) / this.lines;
        }

        @Override
        public AttributedString get() {
            return this.computed;
        }
    }

    protected static enum CompletionType {
        Expand,
        ExpandComplete,
        Complete,
        List;

    }

    static class Pair<U, V> {
        final U u;
        final V v;

        public Pair(U u, V v) {
            this.u = u;
            this.v = v;
        }

        public U getU() {
            return this.u;
        }

        public V getV() {
            return this.v;
        }
    }

    protected static enum BellType {
        NONE,
        AUDIBLE,
        VISIBLE;

    }

    protected static enum ViMoveMode {
        NORMAL,
        YANK,
        DELETE,
        CHANGE;

    }

    protected static enum State {
        NORMAL,
        DONE,
        EOF,
        INTERRUPT;

    }
}

