/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;

    public DefaultParser quoteChars(char[] cArray) {
        this.quoteChars = cArray;
        return this;
    }

    public DefaultParser escapeChars(char[] cArray) {
        this.escapeChars = cArray;
        return this;
    }

    public DefaultParser eofOnUnclosedQuote(boolean bl) {
        this.eofOnUnclosedQuote = bl;
        return this;
    }

    public DefaultParser eofOnEscapedNewLine(boolean bl) {
        this.eofOnEscapedNewLine = bl;
        return this;
    }

    public void setQuoteChars(char[] cArray) {
        this.quoteChars = cArray;
    }

    public char[] getQuoteChars() {
        return this.quoteChars;
    }

    public void setEscapeChars(char[] cArray) {
        this.escapeChars = cArray;
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    public void setEofOnUnclosedQuote(boolean bl) {
        this.eofOnUnclosedQuote = bl;
    }

    public boolean isEofOnUnclosedQuote() {
        return this.eofOnUnclosedQuote;
    }

    public void setEofOnEscapedNewLine(boolean bl) {
        this.eofOnEscapedNewLine = bl;
    }

    public boolean isEofOnEscapedNewLine() {
        return this.eofOnEscapedNewLine;
    }

    @Override
    public ParsedLine parse(String string, int n, Parser.ParseContext parseContext) {
        LinkedList<String> linkedList = new LinkedList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = 0;
        for (int i = 0; string != null && i < string.length(); ++i) {
            if (i == n) {
                n3 = linkedList.size();
                n2 = stringBuilder.length();
                n5 = i - n7;
            }
            if (n4 < 0 && this.isQuoteChar(string, i)) {
                n4 = i;
                continue;
            }
            if (n4 >= 0) {
                if (string.charAt(n4) == string.charAt(i) && !this.isEscaped(string, i)) {
                    linkedList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n4 = -1;
                    if (n5 < 0 || n6 >= 0) continue;
                    n6 = i - n7 + 1;
                    continue;
                }
                if (this.isEscapeChar(string, i)) continue;
                stringBuilder.append(string.charAt(i));
                continue;
            }
            if (this.isDelimiter(string, i)) {
                if (stringBuilder.length() > 0) {
                    linkedList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    if (n5 >= 0 && n6 < 0) {
                        n6 = i - n7;
                    }
                }
                n7 = i + 1;
                continue;
            }
            if (this.isEscapeChar(string, i)) continue;
            stringBuilder.append(string.charAt(i));
        }
        if (stringBuilder.length() > 0 || n == string.length()) {
            linkedList.add(stringBuilder.toString());
            if (n5 >= 0 && n6 < 0) {
                n6 = string.length() - n7;
            }
        }
        if (n == string.length()) {
            n3 = linkedList.size() - 1;
            n2 = ((String)linkedList.get(linkedList.size() - 1)).length();
            n6 = n5 = n - n7;
        }
        if (this.eofOnEscapedNewLine && this.isEscapeChar(string, string.length() - 1)) {
            throw new EOFError(-1, -1, "Escaped new line", "newline");
        }
        if (this.eofOnUnclosedQuote && n4 >= 0) {
            throw new EOFError(-1, -1, "Missing closing quote", string.charAt(n4) == '\'' ? "quote" : "dquote");
        }
        String string2 = n4 >= 0 ? string.substring(n4, n4 + 1) : null;
        return new ArgumentList(string, linkedList, n3, n2, n, string2, n5, n6);
    }

    public boolean isDelimiter(CharSequence charSequence, int n) {
        return !this.isQuoted(charSequence, n) && !this.isEscaped(charSequence, n) && this.isDelimiterChar(charSequence, n);
    }

    public boolean isQuoted(CharSequence charSequence, int n) {
        return false;
    }

    public boolean isQuoteChar(CharSequence charSequence, int n) {
        if (n < 0) {
            return false;
        }
        if (this.quoteChars != null) {
            for (char c : this.quoteChars) {
                if (c != charSequence.charAt(n)) continue;
                return !this.isEscaped(charSequence, n);
            }
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence charSequence, int n) {
        if (n < 0) {
            return false;
        }
        if (this.escapeChars != null) {
            for (char c : this.escapeChars) {
                if (c != charSequence.charAt(n)) continue;
                return !this.isEscaped(charSequence, n);
            }
        }
        return false;
    }

    public boolean isEscaped(CharSequence charSequence, int n) {
        if (n <= 0) {
            return false;
        }
        return this.isEscapeChar(charSequence, n - 1);
    }

    public boolean isDelimiterChar(CharSequence charSequence, int n) {
        return Character.isWhitespace(charSequence.charAt(n));
    }

    private boolean isRawEscapeChar(char c) {
        if (this.escapeChars != null) {
            for (char c2 : this.escapeChars) {
                if (c2 != c) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRawQuoteChar(char c) {
        if (this.quoteChars != null) {
            for (char c2 : this.quoteChars) {
                if (c2 != c) continue;
                return true;
            }
        }
        return false;
    }

    public class ArgumentList
    implements ParsedLine,
    CompletingParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;
        private final String openingQuote;
        private final int rawWordCursor;
        private final int rawWordLength;

        @Deprecated
        public ArgumentList(String string, List<String> list, int n, int n2, int n3) {
            this(string, list, n, n2, n3, null, n2, list.get(n).length());
        }

        public ArgumentList(String string, List<String> list, int n, int n2, int n3, String string2, int n4, int n5) {
            this.line = string;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(list));
            this.wordIndex = n;
            this.wordCursor = n2;
            this.cursor = n3;
            this.openingQuote = string2;
            this.rawWordCursor = n4;
            this.rawWordLength = n5;
        }

        @Override
        public int wordIndex() {
            return this.wordIndex;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }

        @Override
        public List<String> words() {
            return this.words;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public CharSequence escape(CharSequence charSequence, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(charSequence);
            Predicate<Integer> predicate = this.openingQuote != null ? n -> DefaultParser.this.isRawEscapeChar(stringBuilder.charAt((int)n)) || String.valueOf(stringBuilder.charAt((int)n)).equals(this.openingQuote) : n -> DefaultParser.this.isDelimiterChar(stringBuilder, (int)n) || DefaultParser.this.isRawEscapeChar(stringBuilder.charAt((int)n)) || DefaultParser.this.isRawQuoteChar(stringBuilder.charAt((int)n));
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (!predicate.test(i)) continue;
                stringBuilder.insert(i++, DefaultParser.this.escapeChars[0]);
            }
            if (this.openingQuote != null) {
                stringBuilder.insert(0, this.openingQuote);
                if (bl) {
                    stringBuilder.append(this.openingQuote);
                }
            }
            return stringBuilder;
        }

        @Override
        public int rawWordCursor() {
            return this.rawWordCursor;
        }

        @Override
        public int rawWordLength() {
            return this.rawWordLength;
        }
    }
}

