/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.Objects;
import org.jline.reader.Buffer;

public class BufferImpl
implements Buffer {
    private int cursor = 0;
    private int cursorCol = -1;
    private int[] buffer;
    private int g0;
    private int g1;

    public BufferImpl() {
        this(64);
    }

    public BufferImpl(int n) {
        this.buffer = new int[n];
        this.g0 = 0;
        this.g1 = this.buffer.length;
    }

    private BufferImpl(BufferImpl bufferImpl) {
        this.cursor = bufferImpl.cursor;
        this.cursorCol = bufferImpl.cursorCol;
        this.buffer = (int[])bufferImpl.buffer.clone();
        this.g0 = bufferImpl.g0;
        this.g1 = bufferImpl.g1;
    }

    @Override
    public BufferImpl copy() {
        return new BufferImpl(this);
    }

    @Override
    public int cursor() {
        return this.cursor;
    }

    @Override
    public int length() {
        return this.buffer.length - (this.g1 - this.g0);
    }

    @Override
    public boolean currChar(int n) {
        if (this.cursor == this.length()) {
            return false;
        }
        this.buffer[this.adjust((int)this.cursor)] = n;
        return true;
    }

    @Override
    public int currChar() {
        if (this.cursor == this.length()) {
            return 0;
        }
        return this.atChar(this.cursor);
    }

    @Override
    public int prevChar() {
        if (this.cursor <= 0) {
            return 0;
        }
        return this.atChar(this.cursor - 1);
    }

    @Override
    public int nextChar() {
        if (this.cursor >= this.length() - 1) {
            return 0;
        }
        return this.atChar(this.cursor + 1);
    }

    @Override
    public int atChar(int n) {
        if (n < 0 || n >= this.length()) {
            return 0;
        }
        return this.buffer[this.adjust(n)];
    }

    private int adjust(int n) {
        return n >= this.g0 ? n + this.g1 - this.g0 : n;
    }

    @Override
    public void write(int n) {
        this.write(new int[]{n});
    }

    @Override
    public void write(int n, boolean bl) {
        if (bl) {
            this.delete(1);
        }
        this.write(new int[]{n});
    }

    @Override
    public void write(CharSequence charSequence) {
        Objects.requireNonNull(charSequence);
        this.write(charSequence.codePoints().toArray());
    }

    @Override
    public void write(CharSequence charSequence, boolean bl) {
        Objects.requireNonNull(charSequence);
        int[] nArray = charSequence.codePoints().toArray();
        if (bl) {
            this.delete(nArray.length);
        }
        this.write(nArray);
    }

    private void write(int[] nArray) {
        int n;
        this.moveGapToCursor();
        int n2 = this.length() + nArray.length;
        if (n < n2) {
            for (n = this.buffer.length; n < n2; n *= 2) {
            }
            int[] nArray2 = new int[n];
            System.arraycopy(this.buffer, 0, nArray2, 0, this.g0);
            System.arraycopy(this.buffer, this.g1, nArray2, this.g1 + n - this.buffer.length, this.buffer.length - this.g1);
            this.g1 += n - this.buffer.length;
            this.buffer = nArray2;
        }
        System.arraycopy(nArray, 0, this.buffer, this.cursor, nArray.length);
        this.g0 += nArray.length;
        this.cursor += nArray.length;
        this.cursorCol = -1;
    }

    @Override
    public boolean clear() {
        if (this.length() == 0) {
            return false;
        }
        this.g0 = 0;
        this.g1 = this.buffer.length;
        this.cursor = 0;
        this.cursorCol = -1;
        return true;
    }

    @Override
    public String substring(int n) {
        return this.substring(n, this.length());
    }

    @Override
    public String substring(int n, int n2) {
        if (n >= n2 || n < 0 || n2 > this.length()) {
            return "";
        }
        if (n2 <= this.g0) {
            return new String(this.buffer, n, n2 - n);
        }
        if (n > this.g0) {
            return new String(this.buffer, this.g1 - this.g0 + n, n2 - n);
        }
        int[] nArray = (int[])this.buffer.clone();
        System.arraycopy(nArray, this.g1, nArray, this.g0, nArray.length - this.g1);
        return new String(nArray, n, n2 - n);
    }

    @Override
    public String upToCursor() {
        return this.substring(0, this.cursor);
    }

    @Override
    public boolean cursor(int n) {
        if (n == this.cursor) {
            return true;
        }
        return this.move(n - this.cursor) != 0;
    }

    @Override
    public int move(int n) {
        int n2 = n;
        if (this.cursor == 0 && n2 <= 0) {
            return 0;
        }
        if (this.cursor == this.length() && n2 >= 0) {
            return 0;
        }
        if (this.cursor + n2 < 0) {
            n2 = -this.cursor;
        } else if (this.cursor + n2 > this.length()) {
            n2 = this.length() - this.cursor;
        }
        this.cursor += n2;
        this.cursorCol = -1;
        return n2;
    }

    @Override
    public boolean up() {
        int n;
        int n2;
        int n3 = this.getCursorCol();
        for (n2 = this.cursor - 1; n2 >= 0 && this.atChar(n2) != 10; --n2) {
        }
        if (n2 < 0) {
            return false;
        }
        for (n = n2 - 1; n >= 0 && this.atChar(n) != 10; --n) {
        }
        this.cursor = Math.min(n + n3 + 1, n2);
        return true;
    }

    @Override
    public boolean down() {
        int n;
        int n2;
        int n3 = this.getCursorCol();
        for (n2 = this.cursor; n2 < this.length() && this.atChar(n2) != 10; ++n2) {
        }
        if (n2 >= this.length()) {
            return false;
        }
        for (n = n2 + 1; n < this.length() && this.atChar(n) != 10; ++n) {
        }
        this.cursor = Math.min(n2 + n3 + 1, n);
        return true;
    }

    @Override
    public boolean moveXY(int n, int n2) {
        int n3 = 0;
        while (this.prevChar() != 10 && this.move(-1) == -1) {
            ++n3;
        }
        this.cursorCol = 0;
        while (n2 < 0) {
            this.up();
            ++n2;
        }
        while (n2 > 0) {
            this.down();
            --n2;
        }
        n3 = Math.max(n3 + n, 0);
        for (int i = 0; i < n3 && this.move(1) == 1 && this.currChar() != 10; ++i) {
        }
        this.cursorCol = n3;
        return true;
    }

    private int getCursorCol() {
        if (this.cursorCol < 0) {
            int n;
            this.cursorCol = 0;
            for (n = this.cursor - 1; n >= 0 && this.atChar(n) != 10; --n) {
            }
            this.cursorCol = this.cursor - n - 1;
        }
        return this.cursorCol;
    }

    @Override
    public int backspace(int n) {
        int n2 = Math.max(Math.min(this.cursor, n), 0);
        this.moveGapToCursor();
        this.cursor -= n2;
        this.g0 -= n2;
        this.cursorCol = -1;
        return n2;
    }

    @Override
    public boolean backspace() {
        return this.backspace(1) == 1;
    }

    @Override
    public int delete(int n) {
        int n2 = Math.max(Math.min(this.length() - this.cursor, n), 0);
        this.moveGapToCursor();
        this.g1 += n2;
        this.cursorCol = -1;
        return n2;
    }

    @Override
    public boolean delete() {
        return this.delete(1) == 1;
    }

    @Override
    public String toString() {
        return this.substring(0, this.length());
    }

    @Override
    public void copyFrom(Buffer buffer) {
        if (!(buffer instanceof BufferImpl)) {
            throw new IllegalStateException();
        }
        BufferImpl bufferImpl = (BufferImpl)buffer;
        this.g0 = bufferImpl.g0;
        this.g1 = bufferImpl.g1;
        this.buffer = (int[])bufferImpl.buffer.clone();
        this.cursor = bufferImpl.cursor;
        this.cursorCol = bufferImpl.cursorCol;
    }

    private void moveGapToCursor() {
        if (this.cursor < this.g0) {
            int n = this.g0 - this.cursor;
            System.arraycopy(this.buffer, this.cursor, this.buffer, this.g1 - n, n);
            this.g0 -= n;
            this.g1 -= n;
        } else if (this.cursor > this.g0) {
            int n = this.cursor - this.g0;
            System.arraycopy(this.buffer, this.g1, this.buffer, this.g0, n);
            this.g0 += n;
            this.g1 += n;
        }
    }
}

