/*
 * Decompiled with CFR 0.152.
 */
package org.jline.keymap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.jline.terminal.Terminal;
import org.jline.utils.Curses;
import org.jline.utils.InfoCmp;

public class KeyMap<T> {
    public static final int KEYMAP_LENGTH = 128;
    public static final long DEFAULT_AMBIGUOUS_TIMEOUT = 1000L;
    private Object[] mapping = new Object[128];
    private T anotherKey = null;
    private T unicode;
    private T nomatch;
    private long ambiguousTimeout = 1000L;
    public static final Comparator<String> KEYSEQ_COMPARATOR = (string, string2) -> {
        int n = string.length();
        int n2 = string2.length();
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == (c = string2.charAt(i))) continue;
            int n4 = n - n2;
            return n4 != 0 ? n4 : c2 - c;
        }
        return n - n2;
    };

    public static String display(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuilder.append('^');
                stringBuilder.append((char)(c + 65 - 1));
                continue;
            }
            if (c == '\u007f') {
                stringBuilder.append("^?");
                continue;
            }
            if (c == '^' || c == '\\') {
                stringBuilder.append('\\').append(c);
                continue;
            }
            if (c >= '\u0080') {
                stringBuilder.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuilder.append(c);
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static String translate(String string) {
        char c;
        if (!(string.isEmpty() || (c = string.charAt(0)) != '\'' && c != '\"' || string.charAt(string.length() - 1) != c)) {
            string = string.substring(1, string.length() - 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            int n;
            block25: {
                block24: {
                    n = string.charAt(i);
                    if (n != 92) break block24;
                    if (++i >= string.length()) break;
                    n = string.charAt(i);
                    block0 : switch (n) {
                        case 97: {
                            n = 7;
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 100: {
                            n = 127;
                            break;
                        }
                        case 69: 
                        case 101: {
                            n = 27;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 92: {
                            n = 92;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n2;
                            int n3;
                            n = 0;
                            for (n3 = 0; n3 < 3 && i < string.length() && (n2 = Character.digit(string.charAt(i), 8)) >= 0; ++n3, ++i) {
                                n = (char)(n * 8 + n2);
                            }
                            --i;
                            n = (char)(n & 0xFF);
                            break;
                        }
                        case 120: {
                            int n2;
                            int n3;
                            ++i;
                            n = 0;
                            for (n3 = 0; n3 < 2 && i < string.length() && (n2 = Character.digit(string.charAt(i), 16)) >= 0; ++n3, ++i) {
                                n = (char)(n * 16 + n2);
                            }
                            --i;
                            n = (char)(n & 0xFF);
                            break;
                        }
                        case 117: {
                            int n2;
                            ++i;
                            n = 0;
                            int n3 = 0;
                            while (n3 < 4) {
                                if (i >= string.length() || (n2 = Character.digit(string.charAt(i), 16)) < 0) break block0;
                                n = (char)(n * 16 + n2);
                                ++n3;
                                ++i;
                            }
                            break block25;
                        }
                        case 67: {
                            if (++i >= string.length()) break;
                            n = string.charAt(i);
                            if (n == 45) {
                                if (++i >= string.length()) break;
                                n = string.charAt(i);
                            }
                            n = (char)(n == 63 ? 127 : (char)(Character.toUpperCase((char)n) & 0x1F));
                        }
                    }
                    break block25;
                }
                if (n == 94) {
                    if (++i >= string.length()) break;
                    n = string.charAt(i);
                    if (n != 94) {
                        n = (char)(n == 63 ? 127 : (char)(Character.toUpperCase((char)n) & 0x1F));
                    }
                }
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static Collection<String> range(String string) {
        char c;
        char c2;
        String string2;
        String[] stringArray = string.split("-");
        if (stringArray.length != 2) {
            return null;
        }
        stringArray[0] = KeyMap.translate(stringArray[0]);
        stringArray[1] = KeyMap.translate(stringArray[1]);
        if (stringArray[0].length() != stringArray[1].length()) {
            return null;
        }
        if (stringArray[0].length() > 1) {
            string2 = stringArray[0].substring(0, stringArray[0].length() - 1);
            if (!stringArray[1].startsWith(string2)) {
                return null;
            }
        } else {
            string2 = "";
        }
        if ((c2 = stringArray[0].charAt(stringArray[0].length() - 1)) > (c = stringArray[1].charAt(stringArray[1].length() - 1))) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (char c3 = c2; c3 <= c; c3 = (char)(c3 + '\u0001')) {
            arrayList.add(string2 + c3);
        }
        return arrayList;
    }

    public static String esc() {
        return "\u001b";
    }

    public static String alt(char c) {
        return "\u001b" + c;
    }

    public static String alt(String string) {
        return "\u001b" + string;
    }

    public static String del() {
        return "\u007f";
    }

    public static String ctrl(char c) {
        return c == '?' ? KeyMap.del() : Character.toString((char)(Character.toUpperCase(c) & 0x1F));
    }

    public static String key(Terminal terminal, InfoCmp.Capability capability) {
        return Curses.tputs(terminal.getStringCapability(capability), new Object[0]);
    }

    public T getUnicode() {
        return this.unicode;
    }

    public void setUnicode(T t) {
        this.unicode = t;
    }

    public T getNomatch() {
        return this.nomatch;
    }

    public void setNomatch(T t) {
        this.nomatch = t;
    }

    public long getAmbiguousTimeout() {
        return this.ambiguousTimeout;
    }

    public void setAmbiguousTimeout(long l) {
        this.ambiguousTimeout = l;
    }

    public T getAnotherKey() {
        return this.anotherKey;
    }

    public Map<String, T> getBoundKeys() {
        TreeMap treeMap = new TreeMap(KEYSEQ_COMPARATOR);
        KeyMap.doGetBoundKeys(this, "", treeMap);
        return treeMap;
    }

    private static <T> void doGetBoundKeys(KeyMap<T> keyMap, String string, Map<String, T> map) {
        if (keyMap.anotherKey != null) {
            map.put(string, keyMap.anotherKey);
        }
        for (int i = 0; i < keyMap.mapping.length; ++i) {
            if (keyMap.mapping[i] instanceof KeyMap) {
                KeyMap.doGetBoundKeys((KeyMap)keyMap.mapping[i], string + (char)i, map);
                continue;
            }
            if (keyMap.mapping[i] == null) continue;
            map.put(string + (char)i, keyMap.mapping[i]);
        }
    }

    public T getBound(CharSequence charSequence, int[] nArray) {
        nArray[0] = -1;
        if (charSequence != null && charSequence.length() > 0) {
            char c = charSequence.charAt(0);
            if (c >= this.mapping.length) {
                nArray[0] = Character.codePointCount(charSequence, 0, charSequence.length());
                return null;
            }
            if (this.mapping[c] instanceof KeyMap) {
                CharSequence charSequence2 = charSequence.subSequence(1, charSequence.length());
                return ((KeyMap)this.mapping[c]).getBound(charSequence2, nArray);
            }
            if (this.mapping[c] != null) {
                nArray[0] = charSequence.length() - 1;
                return (T)this.mapping[c];
            }
            nArray[0] = charSequence.length();
            return this.anotherKey;
        }
        return this.anotherKey;
    }

    public T getBound(CharSequence charSequence) {
        int[] nArray = new int[1];
        T t = this.getBound(charSequence, nArray);
        return (T)(nArray[0] <= 0 ? t : null);
    }

    public void bindIfNotBound(T t, CharSequence charSequence) {
        if (t != null && charSequence != null) {
            KeyMap.bind(this, charSequence, t, true);
        }
    }

    public void bind(T t, CharSequence ... charSequenceArray) {
        for (CharSequence charSequence : charSequenceArray) {
            this.bind(t, charSequence);
        }
    }

    public void bind(T t, Iterable<? extends CharSequence> iterable) {
        for (CharSequence charSequence : iterable) {
            this.bind(t, charSequence);
        }
    }

    public void bind(T t, CharSequence charSequence) {
        if (charSequence != null) {
            if (t == null) {
                this.unbind(charSequence);
            } else {
                KeyMap.bind(this, charSequence, t, false);
            }
        }
    }

    public void unbind(CharSequence ... charSequenceArray) {
        for (CharSequence charSequence : charSequenceArray) {
            this.unbind(charSequence);
        }
    }

    public void unbind(CharSequence charSequence) {
        if (charSequence != null) {
            KeyMap.unbind(this, charSequence);
        }
    }

    private static <T> T unbind(KeyMap<T> keyMap, CharSequence charSequence) {
        KeyMap keyMap2 = null;
        if (charSequence != null && charSequence.length() > 0) {
            int n;
            for (n = 0; n < charSequence.length() - 1; ++n) {
                char c = charSequence.charAt(n);
                if (c > keyMap.mapping.length) {
                    return null;
                }
                if (!(keyMap.mapping[c] instanceof KeyMap)) {
                    return null;
                }
                keyMap2 = keyMap;
                keyMap = (KeyMap)keyMap.mapping[c];
            }
            n = charSequence.charAt(charSequence.length() - 1);
            if (n > keyMap.mapping.length) {
                return null;
            }
            if (keyMap.mapping[n] instanceof KeyMap) {
                KeyMap keyMap3 = (KeyMap)keyMap.mapping[n];
                T t = keyMap3.anotherKey;
                keyMap3.anotherKey = null;
                return t;
            }
            Object object = keyMap.mapping[n];
            keyMap.mapping[n] = null;
            int n2 = 0;
            for (int i = 0; i < keyMap.mapping.length; ++i) {
                if (keyMap.mapping[i] == null) continue;
                ++n2;
            }
            if (n2 == 0 && keyMap2 != null) {
                keyMap2.mapping[charSequence.charAt((int)(charSequence.length() - 2))] = keyMap.anotherKey;
            }
            return (T)object;
        }
        return null;
    }

    private static <T> void bind(KeyMap<T> keyMap, CharSequence charSequence, T t, boolean bl) {
        if (charSequence != null && charSequence.length() > 0) {
            for (int i = 0; i < charSequence.length(); ++i) {
                Object object;
                char c = charSequence.charAt(i);
                if (c >= keyMap.mapping.length) {
                    return;
                }
                if (i < charSequence.length() - 1) {
                    if (!(keyMap.mapping[c] instanceof KeyMap)) {
                        object = new KeyMap<T>();
                        ((KeyMap)object).anotherKey = keyMap.mapping[c];
                        keyMap.mapping[c] = object;
                    }
                    keyMap = (KeyMap)keyMap.mapping[c];
                    continue;
                }
                if (keyMap.mapping[c] instanceof KeyMap) {
                    ((KeyMap)keyMap.mapping[c]).anotherKey = t;
                    continue;
                }
                object = keyMap.mapping[c];
                if (bl && object != null) continue;
                keyMap.mapping[c] = t;
            }
        }
    }
}

