/*
 * Decompiled with CFR 0.152.
 */
package org.jline.keymap;

import java.io.IOError;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jline.keymap.KeyMap;
import org.jline.reader.EndOfFileException;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlockingReader;

public class BindingReader {
    protected final NonBlockingReader reader;
    protected final StringBuilder opBuffer = new StringBuilder();
    protected final Deque<Integer> pushBackChar = new ArrayDeque<Integer>();
    protected String lastBinding;

    public BindingReader(NonBlockingReader nonBlockingReader) {
        this.reader = nonBlockingReader;
    }

    public <T> T readBinding(KeyMap<T> keyMap) {
        return this.readBinding(keyMap, null, true);
    }

    public <T> T readBinding(KeyMap<T> keyMap, KeyMap<T> keyMap2) {
        return this.readBinding(keyMap, keyMap2, true);
    }

    public <T> T readBinding(KeyMap<T> keyMap, KeyMap<T> keyMap2, boolean bl) {
        this.lastBinding = null;
        T t = null;
        int[] nArray = new int[1];
        boolean bl2 = false;
        while (true) {
            int n;
            if (keyMap2 != null) {
                t = keyMap2.getBound(this.opBuffer, nArray);
            }
            if (t == null && (keyMap2 == null || nArray[0] >= 0)) {
                t = keyMap.getBound(this.opBuffer, nArray);
            }
            if (t != null) {
                if (nArray[0] >= 0) {
                    this.runMacro(this.opBuffer.substring(this.opBuffer.length() - nArray[0]));
                    this.opBuffer.setLength(this.opBuffer.length() - nArray[0]);
                } else {
                    long l = keyMap.getAmbiguousTimeout();
                    if (l > 0L && this.peekCharacter(l) != -2) {
                        t = null;
                    }
                }
                if (t != null) {
                    this.lastBinding = this.opBuffer.toString();
                    this.opBuffer.setLength(0);
                    return t;
                }
            } else if (nArray[0] > 0) {
                n = this.opBuffer.codePointAt(0);
                String string = this.opBuffer.substring(Character.charCount(n));
                this.lastBinding = this.opBuffer.substring(0, Character.charCount(n));
                t = n >= 128 ? keyMap.getUnicode() : keyMap.getNomatch();
                this.opBuffer.setLength(0);
                this.opBuffer.append(string);
                if (t != null) {
                    return t;
                }
            }
            if (!bl && bl2) break;
            n = this.readCharacter();
            if (n == -1) {
                return null;
            }
            this.opBuffer.appendCodePoint(n);
            bl2 = true;
        }
        return null;
    }

    public int readCharacter() {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.pop();
        }
        try {
            int n = -2;
            int n2 = 0;
            while (n == -2) {
                n = this.reader.read(100L);
                if (n < 0 || !Character.isHighSurrogate((char)n)) continue;
                n2 = n;
                n = -2;
            }
            return n2 != 0 ? Character.toCodePoint((char)n2, (char)n) : n;
        }
        catch (ClosedException closedException) {
            throw new EndOfFileException(closedException);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public int peekCharacter(long l) {
        if (!this.pushBackChar.isEmpty()) {
            return this.pushBackChar.peek();
        }
        try {
            return this.reader.peek(l);
        }
        catch (IOException iOException) {
            throw new IOError(iOException);
        }
    }

    public void runMacro(String string) {
        string.codePoints().forEachOrdered(this.pushBackChar::addLast);
    }

    public String getCurrentBuffer() {
        return this.opBuffer.toString();
    }

    public String getLastBinding() {
        return this.lastBinding;
    }
}

