/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.telnet;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.telnet.Connection;
import org.jline.builtins.telnet.ConnectionData;
import org.jline.builtins.telnet.ConnectionEvent;

public class TelnetIO {
    protected static final int IAC = 255;
    protected static final int GA = 249;
    protected static final int WILL = 251;
    protected static final int WONT = 252;
    protected static final int DO = 253;
    protected static final int DONT = 254;
    protected static final int SB = 250;
    protected static final int SE = 240;
    protected static final int NOP = 241;
    protected static final int DM = 242;
    protected static final int BRK = 243;
    protected static final int IP = 244;
    protected static final int AO = 245;
    protected static final int AYT = 246;
    protected static final int EC = 247;
    protected static final int EL = 248;
    protected static final int ECHO = 1;
    protected static final int SUPGA = 3;
    protected static final int NAWS = 31;
    protected static final int TTYPE = 24;
    protected static final int IS = 0;
    protected static final int SEND = 1;
    protected static final int LOGOUT = 18;
    protected static final int LINEMODE = 34;
    protected static final int LM_MODE = 1;
    protected static final int LM_EDIT = 1;
    protected static final int LM_TRAPSIG = 2;
    protected static final int LM_MODEACK = 4;
    protected static final int LM_FORWARDMASK = 2;
    protected static final int LM_SLC = 3;
    protected static final int LM_SLC_NOSUPPORT = 0;
    protected static final int LM_SLC_DEFAULT = 3;
    protected static final int LM_SLC_VALUE = 2;
    protected static final int LM_SLC_CANTCHANGE = 1;
    protected static final int LM_SLC_LEVELBITS = 3;
    protected static final int LM_SLC_ACK = 128;
    protected static final int LM_SLC_FLUSHIN = 64;
    protected static final int LM_SLC_FLUSHOUT = 32;
    protected static final int LM_SLC_SYNCH = 1;
    protected static final int LM_SLC_BRK = 2;
    protected static final int LM_SLC_IP = 3;
    protected static final int LM_SLC_AO = 4;
    protected static final int LM_SLC_AYT = 5;
    protected static final int LM_SLC_EOR = 6;
    protected static final int LM_SLC_ABORT = 7;
    protected static final int LM_SLC_EOF = 8;
    protected static final int LM_SLC_SUSP = 9;
    protected static final int NEWENV = 39;
    protected static final int NE_INFO = 2;
    protected static final int NE_VAR = 0;
    protected static final int NE_VALUE = 1;
    protected static final int NE_ESC = 2;
    protected static final int NE_USERVAR = 3;
    protected static final int NE_VAR_OK = 2;
    protected static final int NE_VAR_DEFINED = 1;
    protected static final int NE_VAR_DEFINED_EMPTY = 0;
    protected static final int NE_VAR_UNDEFINED = -1;
    protected static final int NE_IN_ERROR = -2;
    protected static final int NE_IN_END = -3;
    protected static final int NE_VAR_NAME_MAXLENGTH = 50;
    protected static final int NE_VAR_VALUE_MAXLENGTH = 1000;
    protected static final int EXT_ASCII = 17;
    protected static final int SEND_LOC = 23;
    protected static final int AUTHENTICATION = 37;
    protected static final int ENCRYPT = 38;
    private static final Logger LOG = Logger.getLogger(TelnetIO.class.getName());
    private static final int SMALLEST_BELIEVABLE_WIDTH = 20;
    private static final int SMALLEST_BELIEVABLE_HEIGHT = 6;
    private static final int DEFAULT_WIDTH = 80;
    private static final int DEFAULT_HEIGHT = 25;
    private Connection connection;
    private ConnectionData connectionData;
    private DataOutputStream out;
    private DataInputStream in;
    private IACHandler iacHandler;
    private InetAddress localAddress;
    private boolean noIac = false;
    private boolean initializing;
    private boolean crFlag;

    public void initIO() {
        this.iacHandler = new IACHandler();
        this.in = new DataInputStream(this.connectionData.getSocket().getInputStream());
        this.out = new DataOutputStream(new BufferedOutputStream(this.connectionData.getSocket().getOutputStream()));
        this.localAddress = this.connectionData.getSocket().getLocalAddress();
        this.crFlag = false;
        this.initTelnetCommunication();
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.connectionData = this.connection.getConnectionData();
    }

    public void write(byte by) {
        if (!this.crFlag && by == 10) {
            this.out.write(13);
        }
        this.out.write(by);
        this.crFlag = by == 13;
    }

    public void write(int n) {
        this.write((byte)n);
    }

    public void write(byte[] byArray) {
        for (byte by : byArray) {
            this.write(by);
        }
    }

    public void write(int[] nArray) {
        for (int n : nArray) {
            this.write((byte)n);
        }
    }

    public void write(char c) {
        this.write((byte)c);
    }

    public void write(String string) {
        this.write(string.getBytes());
    }

    public void flush() {
        this.out.flush();
    }

    public void closeOutput() {
        try {
            this.write(255);
            this.write(253);
            this.write(18);
            this.out.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "closeOutput()", iOException);
        }
    }

    private void rawWrite(int n) {
        this.out.write(n);
    }

    public int read() {
        int n = this.rawread();
        this.noIac = false;
        while (n == 255 && !this.noIac) {
            n = this.rawread();
            if (n != 255) {
                this.iacHandler.handleC(n);
                n = this.rawread();
                continue;
            }
            this.noIac = true;
        }
        return this.stripCRSeq(n);
    }

    public void closeInput() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int read16int() {
        int n = this.in.readUnsignedShort();
        return n;
    }

    private int rawread() {
        int n = 0;
        n = this.in.readUnsignedByte();
        this.connectionData.activity();
        return n;
    }

    private int stripCRSeq(int n) {
        if (n == 13) {
            this.rawread();
            return 10;
        }
        return n;
    }

    private void initTelnetCommunication() {
        this.initializing = true;
        try {
            if (this.connectionData.isLineMode()) {
                this.iacHandler.doLineModeInit();
                LOG.log(Level.FINE, "Line mode initialized.");
            } else {
                this.iacHandler.doCharacterModeInit();
                LOG.log(Level.FINE, "Character mode initialized.");
            }
            this.connectionData.getSocket().setSoTimeout(1000);
            this.read();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.connectionData.getSocket().setSoTimeout(0);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "initTelnetCommunication()", exception);
            }
        }
        this.initializing = false;
    }

    private void IamHere() {
        try {
            this.write("[" + this.localAddress.toString() + ":Yes]");
            this.flush();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "IamHere()", exception);
        }
    }

    private void nvtBreak() {
        this.connection.processConnectionEvent(new ConnectionEvent(this.connection, ConnectionEvent.Type.CONNECTION_BREAK));
    }

    private void setTerminalGeometry(int n, int n2) {
        if (n < 20) {
            n = 80;
        }
        if (n2 < 6) {
            n2 = 25;
        }
        this.connectionData.setTerminalGeometry(n, n2);
        this.connection.processConnectionEvent(new ConnectionEvent(this.connection, ConnectionEvent.Type.CONNECTION_TERMINAL_GEOMETRY_CHANGED));
    }

    public void setEcho(boolean bl) {
    }

    class IACHandler {
        private int[] buffer = new int[2];
        private boolean DO_ECHO = false;
        private boolean DO_SUPGA = false;
        private boolean DO_NAWS = false;
        private boolean DO_TTYPE = false;
        private boolean DO_LINEMODE = false;
        private boolean DO_NEWENV = false;
        private boolean WAIT_DO_REPLY_SUPGA = false;
        private boolean WAIT_DO_REPLY_ECHO = false;
        private boolean WAIT_DO_REPLY_NAWS = false;
        private boolean WAIT_DO_REPLY_TTYPE = false;
        private boolean WAIT_DO_REPLY_LINEMODE = false;
        private boolean WAIT_LM_MODE_ACK = false;
        private boolean WAIT_LM_DO_REPLY_FORWARDMASK = false;
        private boolean WAIT_DO_REPLY_NEWENV = false;
        private boolean WAIT_NE_SEND_REPLY = false;
        private boolean WAIT_WILL_REPLY_SUPGA = false;
        private boolean WAIT_WILL_REPLY_ECHO = false;
        private boolean WAIT_WILL_REPLY_NAWS = false;
        private boolean WAIT_WILL_REPLY_TTYPE = false;

        IACHandler() {
        }

        public void doCharacterModeInit() {
            this.sendCommand(251, 1, true);
            this.sendCommand(254, 1, true);
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.sendCommand(253, 39, true);
        }

        public void doLineModeInit() {
            this.sendCommand(253, 31, true);
            this.sendCommand(251, 3, true);
            this.sendCommand(253, 3, true);
            this.sendCommand(253, 24, true);
            this.sendCommand(253, 34, true);
            this.sendCommand(253, 39, true);
        }

        public void handleC(int n) {
            this.buffer[0] = n;
            if (!this.parseTWO(this.buffer)) {
                this.buffer[1] = TelnetIO.this.rawread();
                this.parse(this.buffer);
            }
            this.buffer[0] = 0;
            this.buffer[1] = 0;
        }

        private boolean parseTWO(int[] nArray) {
            switch (nArray[0]) {
                case 255: {
                    break;
                }
                case 246: {
                    TelnetIO.this.IamHere();
                    break;
                }
                case 241: 
                case 244: 
                case 245: 
                case 247: 
                case 248: {
                    break;
                }
                case 243: {
                    TelnetIO.this.nvtBreak();
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        private void parse(int[] nArray) {
            block0 : switch (nArray[0]) {
                case 251: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(253, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(254, nArray[1], false);
                    break;
                }
                case 252: {
                    if (this.waitDOreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(253, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 253: {
                    if (this.supported(nArray[1]) && this.isEnabled(nArray[1])) break;
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.enable(nArray[1]);
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (this.supported(nArray[1])) {
                        this.sendCommand(251, nArray[1], false);
                        this.enable(nArray[1]);
                        break;
                    }
                    this.sendCommand(252, nArray[1], false);
                    break;
                }
                case 254: {
                    if (this.waitWILLreply(nArray[1]) && this.supported(nArray[1])) {
                        this.setWait(251, nArray[1], false);
                        break;
                    }
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    this.enable(nArray[1]);
                    break;
                }
                case 242: {
                    break;
                }
                case 250: {
                    if (!this.supported(nArray[1]) || !this.isEnabled(nArray[1])) break;
                    switch (nArray[1]) {
                        case 31: {
                            this.handleNAWS();
                            break block0;
                        }
                        case 24: {
                            this.handleTTYPE();
                            break block0;
                        }
                        case 34: {
                            this.handleLINEMODE();
                            break block0;
                        }
                        case 39: {
                            this.handleNEWENV();
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private void handleNAWS() {
            int n;
            int n2 = TelnetIO.this.read16int();
            if (n2 == 255) {
                n2 = TelnetIO.this.read16int();
            }
            if ((n = TelnetIO.this.read16int()) == 255) {
                n = TelnetIO.this.read16int();
            }
            this.skipToSE();
            TelnetIO.this.setTerminalGeometry(n2, n);
        }

        private void handleTTYPE() {
            String string = "";
            TelnetIO.this.rawread();
            string = this.readIACSETerminatedString(40);
            LOG.log(Level.FINE, "Reported terminal name " + string);
            TelnetIO.this.connectionData.setNegotiatedTerminalType(string);
        }

        public void handleLINEMODE() {
            int n = TelnetIO.this.rawread();
            switch (n) {
                case 1: {
                    this.handleLMMode();
                    break;
                }
                case 3: {
                    this.handleLMSLC();
                    break;
                }
                case 251: 
                case 252: {
                    this.handleLMForwardMask(n);
                    break;
                }
                default: {
                    this.skipToSE();
                }
            }
        }

        public void handleLMMode() {
            if (this.WAIT_LM_MODE_ACK) {
                int n = TelnetIO.this.rawread();
                if (n != 7) {
                    LOG.log(Level.FINE, "Client violates linemodeack sent: " + n);
                }
                this.WAIT_LM_MODE_ACK = false;
            }
            this.skipToSE();
        }

        public void handleLMSLC() {
            int[] nArray = new int[3];
            if (!this.readTriple(nArray)) {
                return;
            }
            if (nArray[0] == 0 && nArray[1] == 3 && nArray[2] == 0) {
                this.skipToSE();
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(34);
                TelnetIO.this.rawWrite(3);
                for (int i = 1; i < 12; ++i) {
                    TelnetIO.this.rawWrite(i);
                    TelnetIO.this.rawWrite(3);
                    TelnetIO.this.rawWrite(0);
                }
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                TelnetIO.this.flush();
            } else {
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(34);
                TelnetIO.this.rawWrite(3);
                TelnetIO.this.rawWrite(nArray[0]);
                TelnetIO.this.rawWrite(nArray[1] | 0x80);
                TelnetIO.this.rawWrite(nArray[2]);
                while (this.readTriple(nArray)) {
                    TelnetIO.this.rawWrite(nArray[0]);
                    TelnetIO.this.rawWrite(nArray[1] | 0x80);
                    TelnetIO.this.rawWrite(nArray[2]);
                }
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                TelnetIO.this.flush();
            }
        }

        public void handleLMForwardMask(int n) {
            switch (n) {
                case 252: {
                    if (!this.WAIT_LM_DO_REPLY_FORWARDMASK) break;
                    this.WAIT_LM_DO_REPLY_FORWARDMASK = false;
                }
            }
            this.skipToSE();
        }

        public void handleNEWENV() {
            LOG.log(Level.FINE, "handleNEWENV()");
            int n = TelnetIO.this.rawread();
            switch (n) {
                case 0: {
                    this.handleNEIs();
                    break;
                }
                case 2: {
                    this.handleNEInfo();
                    break;
                }
                default: {
                    this.skipToSE();
                }
            }
        }

        private int readNEVariableName(StringBuffer stringBuffer) {
            LOG.log(Level.FINE, "readNEVariableName()");
            int n = -1;
            while ((n = TelnetIO.this.rawread()) != -1) {
                if (n == 255) {
                    n = TelnetIO.this.rawread();
                    if (n == 255) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    if (n == 240) {
                        return -3;
                    }
                    return -2;
                }
                if (n == 2) {
                    n = TelnetIO.this.rawread();
                    if (n == 2 || n == 0 || n == 3 || n == 1) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    return -2;
                }
                if (n == 0 || n == 3) {
                    return -1;
                }
                if (n == 1) {
                    return 1;
                }
                if (stringBuffer.length() >= 50) {
                    return -2;
                }
                stringBuffer.append((char)n);
            }
            return -2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int readNEVariableValue(StringBuffer stringBuffer) {
            LOG.log(Level.FINE, "readNEVariableValue()");
            int n = TelnetIO.this.rawread();
            if (n == -1) {
                return -2;
            }
            if (n == 255) {
                n = TelnetIO.this.rawread();
                if (n == 255) {
                    return 0;
                }
                if (n != 240) return -2;
                return -3;
            }
            if (n == 0 || n == 3) {
                return 0;
            }
            if (n == 2) {
                n = TelnetIO.this.rawread();
                if (n != 2 && n != 0 && n != 3 && n != 1) return -2;
                stringBuffer.append((char)n);
            } else {
                stringBuffer.append((char)n);
            }
            while ((n = TelnetIO.this.rawread()) != -1) {
                if (n == 255) {
                    n = TelnetIO.this.rawread();
                    if (n == 255) {
                        stringBuffer.append((char)n);
                        continue;
                    }
                    if (n != 240) return -2;
                    return -3;
                }
                if (n == 2) {
                    n = TelnetIO.this.rawread();
                    if (n != 2 && n != 0 && n != 3 && n != 1) return -2;
                    stringBuffer.append((char)n);
                    continue;
                }
                if (n == 0 || n == 3) {
                    return 2;
                }
                if (stringBuffer.length() > 1000) {
                    return -2;
                }
                stringBuffer.append((char)n);
            }
            return -2;
        }

        public void readNEVariables() {
            LOG.log(Level.FINE, "readNEVariables()");
            StringBuffer stringBuffer = new StringBuffer(50);
            int n = TelnetIO.this.rawread();
            if (n == 255) {
                this.skipToSE();
                LOG.log(Level.FINE, "readNEVariables()::INVALID VARIABLE");
                return;
            }
            boolean bl = true;
            if (n == 0 || n == 3) {
                block12: do {
                    switch (this.readNEVariableName(stringBuffer)) {
                        case -2: {
                            LOG.log(Level.FINE, "readNEVariables()::NE_IN_ERROR");
                            return;
                        }
                        case -3: {
                            LOG.log(Level.FINE, "readNEVariables()::NE_IN_END");
                            return;
                        }
                        case 1: {
                            LOG.log(Level.FINE, "readNEVariables()::NE_VAR_DEFINED");
                            String string = stringBuffer.toString();
                            stringBuffer.delete(0, stringBuffer.length());
                            switch (this.readNEVariableValue(stringBuffer)) {
                                case -2: {
                                    LOG.log(Level.FINE, "readNEVariables()::NE_IN_ERROR");
                                    return;
                                }
                                case -3: {
                                    LOG.log(Level.FINE, "readNEVariables()::NE_IN_END");
                                    return;
                                }
                                case 0: {
                                    LOG.log(Level.FINE, "readNEVariables()::NE_VAR_DEFINED_EMPTY");
                                    break;
                                }
                                case 2: {
                                    LOG.log(Level.FINE, "readNEVariables()::NE_VAR_OK:VAR=" + string + " VAL=" + stringBuffer.toString());
                                    TelnetIO.this.connectionData.getEnvironment().put(string, stringBuffer.toString());
                                    stringBuffer.delete(0, stringBuffer.length());
                                }
                            }
                            continue block12;
                        }
                        case -1: {
                            LOG.log(Level.FINE, "readNEVariables()::NE_VAR_UNDEFINED");
                        }
                    }
                } while (bl);
            }
        }

        public void handleNEIs() {
            LOG.log(Level.FINE, "handleNEIs()");
            if (this.isEnabled(39)) {
                this.readNEVariables();
            }
        }

        public void handleNEInfo() {
            LOG.log(Level.FINE, "handleNEInfo()");
            if (this.isEnabled(39)) {
                this.readNEVariables();
            }
        }

        public void getTTYPE() {
            if (this.isEnabled(24)) {
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(24);
                TelnetIO.this.rawWrite(1);
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                TelnetIO.this.flush();
            }
        }

        public void negotiateLineMode() {
            if (this.isEnabled(34)) {
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(34);
                TelnetIO.this.rawWrite(1);
                TelnetIO.this.rawWrite(3);
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                this.WAIT_LM_MODE_ACK = true;
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(34);
                TelnetIO.this.rawWrite(254);
                TelnetIO.this.rawWrite(2);
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                this.WAIT_LM_DO_REPLY_FORWARDMASK = true;
                TelnetIO.this.flush();
            }
        }

        private void negotiateEnvironment() {
            if (this.isEnabled(39)) {
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(250);
                TelnetIO.this.rawWrite(39);
                TelnetIO.this.rawWrite(1);
                TelnetIO.this.rawWrite(0);
                TelnetIO.this.rawWrite(3);
                TelnetIO.this.rawWrite(255);
                TelnetIO.this.rawWrite(240);
                this.WAIT_NE_SEND_REPLY = true;
                TelnetIO.this.flush();
            }
        }

        private void skipToSE() {
            while (TelnetIO.this.rawread() != 240) {
            }
        }

        private boolean readTriple(int[] nArray) {
            nArray[0] = TelnetIO.this.rawread();
            nArray[1] = TelnetIO.this.rawread();
            if (nArray[0] == 255 && nArray[1] == 240) {
                return false;
            }
            nArray[2] = TelnetIO.this.rawread();
            return true;
        }

        private String readIACSETerminatedString(int n) {
            int n2 = 0;
            char[] cArray = new char[n];
            int n3 = 32;
            boolean bl = true;
            do {
                int n4 = TelnetIO.this.rawread();
                switch (n4) {
                    case 255: {
                        n4 = TelnetIO.this.rawread();
                        if (n4 != 240) break;
                        bl = false;
                        break;
                    }
                    case -1: {
                        return new String("default");
                    }
                }
                if (!bl) continue;
                n3 = (char)n4;
                if (n3 == 10 || n3 == 13 || n2 == n) {
                    bl = false;
                    continue;
                }
                cArray[n2++] = n3;
            } while (bl);
            return new String(cArray, 0, n2);
        }

        private boolean supported(int n) {
            switch (n) {
                case 1: 
                case 3: 
                case 24: 
                case 31: 
                case 39: {
                    return true;
                }
                case 34: {
                    return TelnetIO.this.connectionData.isLineMode();
                }
            }
            return false;
        }

        private void sendCommand(int n, int n2, boolean bl) {
            TelnetIO.this.rawWrite(255);
            TelnetIO.this.rawWrite(n);
            TelnetIO.this.rawWrite(n2);
            if (n == 253 && bl) {
                this.setWait(253, n2, true);
            }
            if (n == 251 && bl) {
                this.setWait(251, n2, true);
            }
            TelnetIO.this.flush();
        }

        private void enable(int n) {
            switch (n) {
                case 3: {
                    if (this.DO_SUPGA) {
                        this.DO_SUPGA = false;
                        break;
                    }
                    this.DO_SUPGA = true;
                    break;
                }
                case 1: {
                    if (this.DO_ECHO) {
                        this.DO_ECHO = false;
                        break;
                    }
                    this.DO_ECHO = true;
                    break;
                }
                case 31: {
                    if (this.DO_NAWS) {
                        this.DO_NAWS = false;
                        break;
                    }
                    this.DO_NAWS = true;
                    break;
                }
                case 24: {
                    if (this.DO_TTYPE) {
                        this.DO_TTYPE = false;
                        break;
                    }
                    this.DO_TTYPE = true;
                    this.getTTYPE();
                    break;
                }
                case 34: {
                    if (this.DO_LINEMODE) {
                        this.DO_LINEMODE = false;
                        TelnetIO.this.connectionData.setLineMode(false);
                        break;
                    }
                    this.DO_LINEMODE = true;
                    this.negotiateLineMode();
                    break;
                }
                case 39: {
                    if (this.DO_NEWENV) {
                        this.DO_NEWENV = false;
                        break;
                    }
                    this.DO_NEWENV = true;
                    this.negotiateEnvironment();
                }
            }
        }

        private boolean isEnabled(int n) {
            switch (n) {
                case 3: {
                    return this.DO_SUPGA;
                }
                case 1: {
                    return this.DO_ECHO;
                }
                case 31: {
                    return this.DO_NAWS;
                }
                case 24: {
                    return this.DO_TTYPE;
                }
                case 34: {
                    return this.DO_LINEMODE;
                }
                case 39: {
                    return this.DO_NEWENV;
                }
            }
            return false;
        }

        private boolean waitWILLreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_WILL_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_WILL_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_WILL_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_WILL_REPLY_TTYPE;
                }
            }
            return false;
        }

        private boolean waitDOreply(int n) {
            switch (n) {
                case 3: {
                    return this.WAIT_DO_REPLY_SUPGA;
                }
                case 1: {
                    return this.WAIT_DO_REPLY_ECHO;
                }
                case 31: {
                    return this.WAIT_DO_REPLY_NAWS;
                }
                case 24: {
                    return this.WAIT_DO_REPLY_TTYPE;
                }
                case 34: {
                    return this.WAIT_DO_REPLY_LINEMODE;
                }
                case 39: {
                    return this.WAIT_DO_REPLY_NEWENV;
                }
            }
            return false;
        }

        private void setWait(int n, int n2, boolean bl) {
            block0 : switch (n) {
                case 253: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_DO_REPLY_SUPGA = bl;
                            break;
                        }
                        case 1: {
                            this.WAIT_DO_REPLY_ECHO = bl;
                            break;
                        }
                        case 31: {
                            this.WAIT_DO_REPLY_NAWS = bl;
                            break;
                        }
                        case 24: {
                            this.WAIT_DO_REPLY_TTYPE = bl;
                            break;
                        }
                        case 34: {
                            this.WAIT_DO_REPLY_LINEMODE = bl;
                            break;
                        }
                        case 39: {
                            this.WAIT_DO_REPLY_NEWENV = bl;
                        }
                    }
                    break;
                }
                case 251: {
                    switch (n2) {
                        case 3: {
                            this.WAIT_WILL_REPLY_SUPGA = bl;
                            break block0;
                        }
                        case 1: {
                            this.WAIT_WILL_REPLY_ECHO = bl;
                            break block0;
                        }
                        case 31: {
                            this.WAIT_WILL_REPLY_NAWS = bl;
                            break block0;
                        }
                        case 24: {
                            this.WAIT_WILL_REPLY_TTYPE = bl;
                        }
                    }
                }
            }
        }
    }
}

