/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.telnet;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.jline.builtins.Options;
import org.jline.builtins.telnet.Connection;
import org.jline.builtins.telnet.ConnectionData;
import org.jline.builtins.telnet.ConnectionEvent;
import org.jline.builtins.telnet.ConnectionListener;
import org.jline.builtins.telnet.ConnectionManager;
import org.jline.builtins.telnet.PortListener;
import org.jline.builtins.telnet.TelnetIO;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class Telnet {
    public static final String[] functions = new String[]{"telnetd"};
    private static final int defaultPort = 2019;
    private final Terminal terminal;
    private final ShellProvider provider;
    private PortListener portListener;
    private int port;
    private String ip;

    public Telnet(Terminal terminal, ShellProvider shellProvider) {
        this.terminal = terminal;
        this.provider = shellProvider;
    }

    public void telnetd(String[] stringArray) {
        String[] stringArray2 = new String[]{"telnetd - start simple telnet server", "Usage: telnetd [-i ip] [-p port] start | stop | status", "  -i --ip=INTERFACE        listen interface (default=127.0.0.1)", "  -p --port=PORT           listen port (default=2019)", "  -? --help                show help"};
        Options options = Options.compile(stringArray2).parse(stringArray, true);
        List<String> list = options.args();
        if (options.isSet("help") || list.isEmpty()) {
            options.usage(System.err);
            return;
        }
        String string = list.get(0);
        if ("start".equals(string)) {
            if (this.portListener != null) {
                throw new IllegalStateException("telnetd is already running on port " + this.port);
            }
            this.ip = options.get("ip");
            this.port = options.getNumber("port");
            this.start();
            this.status();
        } else if ("stop".equals(string)) {
            if (this.portListener == null) {
                throw new IllegalStateException("telnetd is not running.");
            }
            this.stop();
        } else if ("status".equals(string)) {
            this.status();
        } else {
            throw options.usageError("bad command: " + string);
        }
    }

    private void status() {
        if (this.portListener != null) {
            System.out.println("telnetd is running on " + this.ip + ":" + this.port);
        } else {
            System.out.println("telnetd is not running.");
        }
    }

    private void start() {
        ConnectionManager connectionManager = new ConnectionManager(1000, 300000, 300000, 60000, null, null, false){

            @Override
            protected Connection createConnection(ThreadGroup threadGroup, ConnectionData connectionData) {
                return new Connection(threadGroup, connectionData){
                    TelnetIO telnetIO;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void doRun() {
                        this.telnetIO = new TelnetIO();
                        this.telnetIO.setConnection(this);
                        this.telnetIO.initIO();
                        InputStream inputStream = new InputStream(){

                            @Override
                            public int read() {
                                return telnetIO.read();
                            }

                            @Override
                            public int read(byte[] byArray, int n, int n2) {
                                int n3 = this.read();
                                if (n3 >= 0) {
                                    byArray[n] = (byte)n3;
                                    return 1;
                                }
                                return -1;
                            }
                        };
                        PrintStream printStream = new PrintStream(new OutputStream(){

                            @Override
                            public void write(int n) {
                                telnetIO.write(n);
                            }

                            @Override
                            public void flush() {
                                telnetIO.flush();
                            }
                        });
                        final Terminal terminal = TerminalBuilder.builder().type(this.getConnectionData().getNegotiatedTerminalType().toLowerCase()).streams(inputStream, printStream).system(false).name("telnet").build();
                        terminal.setSize(new Size(this.getConnectionData().getTerminalColumns(), this.getConnectionData().getTerminalRows()));
                        terminal.setAttributes(Telnet.this.terminal.getAttributes());
                        this.addConnectionListener(new ConnectionListener(){

                            @Override
                            public void connectionTerminalGeometryChanged(ConnectionEvent connectionEvent) {
                                terminal.setSize(new Size(this.getConnectionData().getTerminalColumns(), this.getConnectionData().getTerminalRows()));
                                terminal.raise(Terminal.Signal.WINCH);
                            }
                        });
                        try {
                            Telnet.this.provider.shell(terminal, this.getConnectionData().getEnvironment());
                        }
                        finally {
                            this.close();
                        }
                    }

                    @Override
                    protected void doClose() {
                        this.telnetIO.closeOutput();
                        this.telnetIO.closeInput();
                    }
                };
            }
        };
        this.portListener = new PortListener("gogo", this.port, 10);
        this.portListener.setConnectionManager(connectionManager);
        this.portListener.start();
    }

    private void stop() {
        this.portListener.stop();
        this.portListener = null;
    }

    public static interface ShellProvider {
        public void shell(Terminal var1, Map<String, String> var2);
    }
}

