/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.telnet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.telnet.Connection;
import org.jline.builtins.telnet.ConnectionData;
import org.jline.builtins.telnet.ConnectionEvent;
import org.jline.builtins.telnet.ConnectionFilter;

public abstract class ConnectionManager
implements Runnable {
    private static Logger LOG = Logger.getLogger(ConnectionManager.class.getName());
    private final List<Connection> openConnections;
    private Thread thread;
    private ThreadGroup threadGroup = new ThreadGroup(this.toString() + "Connections");
    private Stack<Connection> closedConnections = new Stack();
    private ConnectionFilter connectionFilter;
    private int maxConnections;
    private int warningTimeout;
    private int disconnectTimeout;
    private int housekeepingInterval;
    private String loginShell;
    private boolean lineMode = false;
    private boolean stopping = false;

    public ConnectionManager() {
        this.openConnections = Collections.synchronizedList(new ArrayList(100));
    }

    public ConnectionManager(int n, int n2, int n3, int n4, ConnectionFilter connectionFilter, String string, boolean bl) {
        this();
        this.connectionFilter = connectionFilter;
        this.loginShell = string;
        this.lineMode = bl;
        this.maxConnections = n;
        this.warningTimeout = n2;
        this.disconnectTimeout = n3;
        this.housekeepingInterval = n4;
    }

    public ConnectionFilter getConnectionFilter() {
        return this.connectionFilter;
    }

    public void setConnectionFilter(ConnectionFilter connectionFilter) {
        this.connectionFilter = connectionFilter;
    }

    public int openConnectionCount() {
        return this.openConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(int n) {
        List<Connection> list = this.openConnections;
        synchronized (list) {
            return this.openConnections.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection[] getConnectionsByAdddress(InetAddress inetAddress) {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        Connection[] connectionArray = this.openConnections;
        synchronized (this.openConnections) {
            for (Connection connection : this.openConnections) {
                if (!connection.getConnectionData().getInetAddress().equals(inetAddress)) continue;
                arrayList.add(connection);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            connectionArray = new Connection[arrayList.size()];
            return arrayList.toArray(connectionArray);
        }
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LOG.log(Level.FINE, "stop()::" + this.toString());
        this.stopping = true;
        try {
            if (this.thread != null) {
                this.thread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.SEVERE, "stop()", interruptedException);
        }
        List<Connection> list = this.openConnections;
        synchronized (list) {
            for (Connection connection : this.openConnections) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "stop()", exception);
                }
            }
            this.openConnections.clear();
        }
        LOG.log(Level.FINE, "stop():: Stopped " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeConnection(Socket socket) {
        LOG.log(Level.FINE, "makeConnection()::" + socket.toString());
        if (this.connectionFilter == null || this.connectionFilter.isAllowed(socket.getInetAddress())) {
            ConnectionData connectionData = new ConnectionData(socket, this);
            connectionData.setLoginShell(this.loginShell);
            connectionData.setLineMode(this.lineMode);
            if (this.openConnections.size() < this.maxConnections) {
                Connection connection = this.createConnection(this.threadGroup, connectionData);
                Object[] objectArray = new Object[]{this.openConnections.size() + 1};
                LOG.info(MessageFormat.format("connection #{0,number,integer} made.", objectArray));
                List<Connection> list = this.openConnections;
                synchronized (list) {
                    this.openConnections.add(connection);
                }
                connection.start();
            }
        } else {
            LOG.info("makeConnection():: Active Filter blocked incoming connection.");
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected abstract Connection createConnection(ThreadGroup var1, ConnectionData var2);

    @Override
    public void run() {
        try {
            do {
                this.cleanupClosed();
                this.checkOpenConnections();
                Thread.sleep(this.housekeepingInterval);
            } while (!this.stopping);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "run()", exception);
        }
        LOG.log(Level.FINE, "run():: Ran out " + this.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupClosed() {
        if (this.stopping) {
            return;
        }
        while (!this.closedConnections.isEmpty()) {
            Connection connection = this.closedConnections.pop();
            LOG.info("cleanupClosed():: Removing closed connection " + connection.toString());
            List<Connection> list = this.openConnections;
            synchronized (list) {
                this.openConnections.remove(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenConnections() {
        if (this.stopping) {
            return;
        }
        List<Connection> list = this.openConnections;
        synchronized (list) {
            for (Connection connection : this.openConnections) {
                ConnectionData connectionData = connection.getConnectionData();
                if (!connection.isActive()) {
                    this.registerClosedConnection(connection);
                    continue;
                }
                long l = System.currentTimeMillis() - connectionData.getLastActivity();
                if (l <= (long)this.warningTimeout) continue;
                if (l > (long)(this.disconnectTimeout + this.warningTimeout)) {
                    LOG.log(Level.FINE, "checkOpenConnections():" + connection.toString() + " exceeded total timeout.");
                    connection.processConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.Type.CONNECTION_TIMEDOUT));
                    continue;
                }
                if (connectionData.isWarned()) continue;
                LOG.log(Level.FINE, "checkOpenConnections():" + connection.toString() + " exceeded warning timeout.");
                connectionData.setWarned(true);
                connection.processConnectionEvent(new ConnectionEvent(connection, ConnectionEvent.Type.CONNECTION_IDLE));
            }
        }
    }

    public void registerClosedConnection(Connection connection) {
        if (this.stopping) {
            return;
        }
        if (!this.closedConnections.contains(connection)) {
            LOG.log(Level.FINE, "registerClosedConnection()::" + connection.toString());
            this.closedConnections.push(connection);
        }
    }

    public int getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public void setDisconnectTimeout(int n) {
        this.disconnectTimeout = n;
    }

    public int getHousekeepingInterval() {
        return this.housekeepingInterval;
    }

    public void setHousekeepingInterval(int n) {
        this.housekeepingInterval = n;
    }

    public boolean isLineMode() {
        return this.lineMode;
    }

    public void setLineMode(boolean bl) {
        this.lineMode = bl;
    }

    public String getLoginShell() {
        return this.loginShell;
    }

    public void setLoginShell(String string) {
        this.loginShell = string;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getWarningTimeout() {
        return this.warningTimeout;
    }

    public void setWarningTimeout(int n) {
        this.warningTimeout = n;
    }
}

