/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.telnet;

import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jline.builtins.telnet.ConnectionManager;

public class ConnectionData {
    private ConnectionManager connectionManager;
    private Socket socket;
    private InetAddress address;
    private Map<String, String> environment;
    private String hostName;
    private String hostAddress;
    private int port;
    private Locale locale;
    private long lastActivity;
    private boolean warned;
    private String negotiatedTerminalType;
    private int[] terminalGeometry;
    private boolean terminalGeometryChanged = true;
    private String loginShell;
    private boolean lineMode = false;

    public ConnectionData(Socket socket, ConnectionManager connectionManager) {
        this.socket = socket;
        this.connectionManager = connectionManager;
        this.address = socket.getInetAddress();
        this.setHostName();
        this.setHostAddress();
        this.setLocale();
        this.port = socket.getPort();
        this.terminalGeometry = new int[2];
        this.terminalGeometry[0] = 80;
        this.terminalGeometry[1] = 25;
        this.negotiatedTerminalType = "default";
        this.environment = new HashMap<String, String>(20);
        this.activity();
    }

    public ConnectionManager getManager() {
        return this.connectionManager;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    public void activity() {
        this.warned = false;
        this.lastActivity = System.currentTimeMillis();
    }

    public boolean isWarned() {
        return this.warned;
    }

    public void setWarned(boolean bl) {
        this.warned = bl;
        if (!bl) {
            this.lastActivity = System.currentTimeMillis();
        }
    }

    public void setTerminalGeometry(int n, int n2) {
        this.terminalGeometry[0] = n;
        this.terminalGeometry[1] = n2;
        this.terminalGeometryChanged = true;
    }

    public int[] getTerminalGeometry() {
        if (this.terminalGeometryChanged) {
            this.terminalGeometryChanged = false;
        }
        return this.terminalGeometry;
    }

    public int getTerminalColumns() {
        return this.terminalGeometry[0];
    }

    public int getTerminalRows() {
        return this.terminalGeometry[1];
    }

    public boolean isTerminalGeometryChanged() {
        return this.terminalGeometryChanged;
    }

    public String getNegotiatedTerminalType() {
        return this.negotiatedTerminalType;
    }

    public void setNegotiatedTerminalType(String string) {
        this.negotiatedTerminalType = string;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public String getLoginShell() {
        return this.loginShell;
    }

    public void setLoginShell(String string) {
        this.loginShell = string;
    }

    public boolean isLineMode() {
        return this.lineMode;
    }

    public void setLineMode(boolean bl) {
        this.lineMode = bl;
    }

    private void setHostName() {
        this.hostName = this.address.getHostName();
    }

    private void setHostAddress() {
        this.hostAddress = this.address.getHostAddress();
    }

    private void setLocale() {
        String string = this.getHostName();
        try {
            string = string.substring(string.lastIndexOf(".") + 1);
            this.locale = string.equals("at") ? new Locale("de", "AT") : (string.equals("de") ? new Locale("de", "DE") : (string.equals("mx") ? new Locale("es", "MX") : (string.equals("es") ? new Locale("es", "ES") : (string.equals("it") ? Locale.ITALY : (string.equals("fr") ? Locale.FRANCE : (string.equals("uk") ? new Locale("en", "GB") : (string.equals("arpa") ? Locale.US : (string.equals("com") ? Locale.US : (string.equals("edu") ? Locale.US : (string.equals("gov") ? Locale.US : (string.equals("org") ? Locale.US : (string.equals("mil") ? Locale.US : Locale.ENGLISH))))))))))));
        }
        catch (Exception exception) {
            this.locale = Locale.ENGLISH;
        }
    }
}

