/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.telnet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.builtins.telnet.ConnectionData;
import org.jline.builtins.telnet.ConnectionEvent;
import org.jline.builtins.telnet.ConnectionListener;

public abstract class Connection
extends Thread {
    private static final Logger LOG = Logger.getLogger(Connection.class.getName());
    private static int number;
    private boolean dead;
    private List<ConnectionListener> listeners;
    private ConnectionData connectionData;

    public Connection(ThreadGroup threadGroup, ConnectionData connectionData) {
        super(threadGroup, "Connection" + ++number);
        this.connectionData = connectionData;
        this.listeners = new CopyOnWriteArrayList<ConnectionListener>();
        this.dead = false;
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "run()", exception);
        }
        finally {
            if (!this.dead) {
                this.close();
            }
        }
        LOG.log(Level.FINE, "run():: Returning from " + this.toString());
    }

    protected abstract void doRun();

    protected abstract void doClose();

    public ConnectionData getConnectionData() {
        return this.connectionData;
    }

    public synchronized void close() {
        if (this.dead) {
            return;
        }
        try {
            this.dead = true;
            this.doClose();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "close()", exception);
        }
        try {
            this.connectionData.getSocket().close();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "close()", exception);
        }
        try {
            this.connectionData.getManager().registerClosedConnection(this);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "close()", exception);
        }
        try {
            this.interrupt();
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "close()", exception);
        }
        LOG.log(Level.FINE, "Closed " + this.toString() + " and inactive.");
    }

    public boolean isActive() {
        return !this.dead;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.listeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.listeners.remove(connectionListener);
    }

    public void processConnectionEvent(ConnectionEvent connectionEvent) {
        for (ConnectionListener connectionListener : this.listeners) {
            switch (connectionEvent.getType()) {
                case CONNECTION_IDLE: {
                    connectionListener.connectionIdle(connectionEvent);
                    break;
                }
                case CONNECTION_TIMEDOUT: {
                    connectionListener.connectionTimedOut(connectionEvent);
                    break;
                }
                case CONNECTION_LOGOUTREQUEST: {
                    connectionListener.connectionLogoutRequest(connectionEvent);
                    break;
                }
                case CONNECTION_BREAK: {
                    connectionListener.connectionSentBreak(connectionEvent);
                    break;
                }
                case CONNECTION_TERMINAL_GEOMETRY_CHANGED: {
                    connectionListener.connectionTerminalGeometryChanged(connectionEvent);
                }
            }
        }
    }
}

