/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;
import org.jline.builtins.Options;
import org.jline.builtins.ssh.ShellCommand;
import org.jline.builtins.ssh.ShellFactoryImpl;
import org.jline.reader.LineReader;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;

public class Ssh {
    public static final String[] functions = new String[]{"ssh", "sshd"};
    private static final int defaultPort = 2022;
    private final Consumer<ShellParams> shell;
    private final Consumer<ExecuteParams> execute;
    private final Supplier<SshServer> serverBuilder;
    private final Supplier<SshClient> clientBuilder;
    private SshServer server;
    private int port;
    private String ip;

    public Ssh(Consumer<ShellParams> consumer, Consumer<ExecuteParams> consumer2, Supplier<SshServer> supplier, Supplier<SshClient> supplier2) {
        this.shell = consumer;
        this.execute = consumer2;
        this.serverBuilder = supplier;
        this.clientBuilder = supplier2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ssh(Terminal terminal, LineReader lineReader, String string, InputStream inputStream, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        block35: {
            String[] stringArray2 = new String[]{"ssh - connect to a server using ssh", "Usage: ssh [user@]hostname [command]", "  -? --help                show help"};
            Options options = Options.compile(stringArray2).parse(stringArray, true);
            List<String> list = options.args();
            if (options.isSet("help") || list.isEmpty()) {
                options.usage(printStream2);
                return;
            }
            String string2 = string;
            String string3 = list.remove(0);
            int n = this.port;
            String string4 = null;
            int n2 = string3.indexOf(64);
            if (n2 >= 0) {
                string2 = string3.substring(0, n2);
                string3 = string3.substring(n2 + 1);
            }
            if ((n2 = string3.indexOf(58)) >= 0) {
                n = Integer.parseInt(string3.substring(n2 + 1));
                string3 = string3.substring(0, n2);
            }
            if (!list.isEmpty()) {
                string4 = String.join((CharSequence)" ", list);
            }
            try (SshClient sshClient = this.clientBuilder.get();){
                JLineUserInteraction jLineUserInteraction = new JLineUserInteraction(terminal, lineReader, printStream2);
                sshClient.setFilePasswordProvider((FilePasswordProvider)jLineUserInteraction);
                sshClient.setUserInteraction((UserInteraction)jLineUserInteraction);
                sshClient.start();
                try (ClientSession clientSession = this.connectWithRetries(terminal.writer(), sshClient, string2, string3, n, 3);){
                    ChannelShell channelShell;
                    clientSession.auth().verify();
                    if (string4 != null) {
                        channelShell = clientSession.createChannel("exec", string4 + "\n");
                        channelShell.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                        channelShell.setOut((OutputStream)new NoCloseOutputStream((OutputStream)printStream));
                        channelShell.setErr((OutputStream)new NoCloseOutputStream((OutputStream)printStream2));
                        channelShell.open().verify();
                        channelShell.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        break block35;
                    }
                    channelShell = clientSession.createShellChannel();
                    Attributes attributes = terminal.enterRawMode();
                    try {
                        HashMap<PtyMode, Integer> hashMap = new HashMap<PtyMode, Integer>();
                        hashMap.put(PtyMode.VINTR, attributes.getControlChar(Attributes.ControlChar.VINTR));
                        hashMap.put(PtyMode.VQUIT, attributes.getControlChar(Attributes.ControlChar.VQUIT));
                        hashMap.put(PtyMode.VERASE, attributes.getControlChar(Attributes.ControlChar.VERASE));
                        hashMap.put(PtyMode.VKILL, attributes.getControlChar(Attributes.ControlChar.VKILL));
                        hashMap.put(PtyMode.VEOF, attributes.getControlChar(Attributes.ControlChar.VEOF));
                        hashMap.put(PtyMode.VEOL, attributes.getControlChar(Attributes.ControlChar.VEOL));
                        hashMap.put(PtyMode.VEOL2, attributes.getControlChar(Attributes.ControlChar.VEOL2));
                        hashMap.put(PtyMode.VSTART, attributes.getControlChar(Attributes.ControlChar.VSTART));
                        hashMap.put(PtyMode.VSTOP, attributes.getControlChar(Attributes.ControlChar.VSTOP));
                        hashMap.put(PtyMode.VSUSP, attributes.getControlChar(Attributes.ControlChar.VSUSP));
                        hashMap.put(PtyMode.VDSUSP, attributes.getControlChar(Attributes.ControlChar.VDSUSP));
                        hashMap.put(PtyMode.VREPRINT, attributes.getControlChar(Attributes.ControlChar.VREPRINT));
                        hashMap.put(PtyMode.VWERASE, attributes.getControlChar(Attributes.ControlChar.VWERASE));
                        hashMap.put(PtyMode.VLNEXT, attributes.getControlChar(Attributes.ControlChar.VLNEXT));
                        hashMap.put(PtyMode.VSTATUS, attributes.getControlChar(Attributes.ControlChar.VSTATUS));
                        hashMap.put(PtyMode.VDISCARD, attributes.getControlChar(Attributes.ControlChar.VDISCARD));
                        hashMap.put(PtyMode.IGNPAR, Ssh.getFlag(attributes, Attributes.InputFlag.IGNPAR));
                        hashMap.put(PtyMode.PARMRK, Ssh.getFlag(attributes, Attributes.InputFlag.PARMRK));
                        hashMap.put(PtyMode.INPCK, Ssh.getFlag(attributes, Attributes.InputFlag.INPCK));
                        hashMap.put(PtyMode.ISTRIP, Ssh.getFlag(attributes, Attributes.InputFlag.ISTRIP));
                        hashMap.put(PtyMode.INLCR, Ssh.getFlag(attributes, Attributes.InputFlag.INLCR));
                        hashMap.put(PtyMode.IGNCR, Ssh.getFlag(attributes, Attributes.InputFlag.IGNCR));
                        hashMap.put(PtyMode.ICRNL, Ssh.getFlag(attributes, Attributes.InputFlag.ICRNL));
                        hashMap.put(PtyMode.IXON, Ssh.getFlag(attributes, Attributes.InputFlag.IXON));
                        hashMap.put(PtyMode.IXANY, Ssh.getFlag(attributes, Attributes.InputFlag.IXANY));
                        hashMap.put(PtyMode.IXOFF, Ssh.getFlag(attributes, Attributes.InputFlag.IXOFF));
                        hashMap.put(PtyMode.ISIG, Ssh.getFlag(attributes, Attributes.LocalFlag.ISIG));
                        hashMap.put(PtyMode.ICANON, Ssh.getFlag(attributes, Attributes.LocalFlag.ICANON));
                        hashMap.put(PtyMode.ECHO, Ssh.getFlag(attributes, Attributes.LocalFlag.ECHO));
                        hashMap.put(PtyMode.ECHOE, Ssh.getFlag(attributes, Attributes.LocalFlag.ECHOE));
                        hashMap.put(PtyMode.ECHOK, Ssh.getFlag(attributes, Attributes.LocalFlag.ECHOK));
                        hashMap.put(PtyMode.ECHONL, Ssh.getFlag(attributes, Attributes.LocalFlag.ECHONL));
                        hashMap.put(PtyMode.NOFLSH, Ssh.getFlag(attributes, Attributes.LocalFlag.NOFLSH));
                        hashMap.put(PtyMode.TOSTOP, Ssh.getFlag(attributes, Attributes.LocalFlag.TOSTOP));
                        hashMap.put(PtyMode.IEXTEN, Ssh.getFlag(attributes, Attributes.LocalFlag.IEXTEN));
                        hashMap.put(PtyMode.OPOST, Ssh.getFlag(attributes, Attributes.OutputFlag.OPOST));
                        hashMap.put(PtyMode.ONLCR, Ssh.getFlag(attributes, Attributes.OutputFlag.ONLCR));
                        hashMap.put(PtyMode.OCRNL, Ssh.getFlag(attributes, Attributes.OutputFlag.OCRNL));
                        hashMap.put(PtyMode.ONOCR, Ssh.getFlag(attributes, Attributes.OutputFlag.ONOCR));
                        hashMap.put(PtyMode.ONLRET, Ssh.getFlag(attributes, Attributes.OutputFlag.ONLRET));
                        channelShell.setPtyModes(hashMap);
                        channelShell.setPtyColumns(terminal.getWidth());
                        channelShell.setPtyLines(terminal.getHeight());
                        channelShell.setAgentForwarding(true);
                        channelShell.setEnv("TERM", terminal.getType());
                        channelShell.setIn((InputStream)new NoCloseInputStream(inputStream));
                        channelShell.setOut((OutputStream)new NoCloseOutputStream((OutputStream)printStream));
                        channelShell.setErr((OutputStream)new NoCloseOutputStream((OutputStream)printStream2));
                        channelShell.open().verify();
                        Terminal.SignalHandler signalHandler = terminal.handle(Terminal.Signal.WINCH, signal -> {
                            try {
                                Size size = terminal.getSize();
                                channelShell.sendWindowChange(size.getColumns(), size.getRows());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler signalHandler2 = terminal.handle(Terminal.Signal.QUIT, signal -> {
                            try {
                                channelShell.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VQUIT));
                                channelShell.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler signalHandler3 = terminal.handle(Terminal.Signal.INT, signal -> {
                            try {
                                channelShell.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VINTR));
                                channelShell.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        Terminal.SignalHandler signalHandler4 = terminal.handle(Terminal.Signal.TSTP, signal -> {
                            try {
                                channelShell.getInvertedIn().write(attributes.getControlChar(Attributes.ControlChar.VDSUSP));
                                channelShell.getInvertedIn().flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        });
                        try {
                            channelShell.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                        }
                        finally {
                            terminal.handle(Terminal.Signal.WINCH, signalHandler);
                            terminal.handle(Terminal.Signal.INT, signalHandler3);
                            terminal.handle(Terminal.Signal.TSTP, signalHandler4);
                            terminal.handle(Terminal.Signal.QUIT, signalHandler2);
                        }
                    }
                    finally {
                        terminal.setAttributes(attributes);
                    }
                }
            }
        }
    }

    private static int getFlag(Attributes attributes, Attributes.InputFlag inputFlag) {
        return attributes.getInputFlag(inputFlag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.OutputFlag outputFlag) {
        return attributes.getOutputFlag(outputFlag) ? 1 : 0;
    }

    private static int getFlag(Attributes attributes, Attributes.LocalFlag localFlag) {
        return attributes.getLocalFlag(localFlag) ? 1 : 0;
    }

    private ClientSession connectWithRetries(PrintWriter printWriter, SshClient sshClient, String string, String string2, int n, int n2) {
        ClientSession clientSession = null;
        int n3 = 0;
        do {
            ConnectFuture connectFuture = sshClient.connect(string, string2, n);
            connectFuture.await();
            try {
                clientSession = connectFuture.getSession();
            }
            catch (Exception exception) {
                if (n3++ < n2) {
                    Thread.sleep(2000L);
                    printWriter.println("retrying (attempt " + n3 + ") ...");
                    continue;
                }
                throw exception;
            }
        } while (clientSession == null);
        return clientSession;
    }

    public void sshd(PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"sshd - start an ssh server", "Usage: sshd [-i ip] [-p port] start | stop | status", "  -i --ip=INTERFACE        listen interface (default=127.0.0.1)", "  -p --port=PORT           listen port (default=2022)", "  -? --help                show help"};
        Options options = Options.compile(stringArray2).parse(stringArray, true);
        List<String> list = options.args();
        if (options.isSet("help") || list.isEmpty()) {
            options.usage(printStream2);
            return;
        }
        String string = list.get(0);
        if ("start".equals(string)) {
            if (this.server != null) {
                throw new IllegalStateException("sshd is already running on port " + this.port);
            }
            this.ip = options.get("ip");
            this.port = options.getNumber("port");
            this.start();
            this.status(printStream);
        } else if ("stop".equals(string)) {
            if (this.server == null) {
                throw new IllegalStateException("sshd is not running.");
            }
            this.stop();
        } else if ("status".equals(string)) {
            this.status(printStream);
        } else {
            throw options.usageError("bad command: " + string);
        }
    }

    private void status(PrintStream printStream) {
        if (this.server != null) {
            printStream.println("sshd is running on " + this.ip + ":" + this.port);
        } else {
            printStream.println("sshd is not running.");
        }
    }

    private void start() {
        this.server = this.serverBuilder.get();
        this.server.setPort(this.port);
        this.server.setHost(this.ip);
        this.server.setShellFactory((Factory)new ShellFactoryImpl(this.shell));
        this.server.setCommandFactory((CommandFactory)new ScpCommandFactory.Builder().withDelegate(string -> new ShellCommand(this.execute, string)).build());
        this.server.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory.Builder().build()));
        this.server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        this.server.start();
    }

    private void stop() {
        try {
            this.server.stop();
        }
        finally {
            this.server = null;
        }
    }

    private static class JLineUserInteraction
    implements UserInteraction,
    FilePasswordProvider {
        private final Terminal terminal;
        private final LineReader reader;
        private final PrintStream stderr;

        public JLineUserInteraction(Terminal terminal, LineReader lineReader, PrintStream printStream) {
            this.terminal = terminal;
            this.reader = lineReader;
            this.stderr = printStream;
        }

        public String getPassword(String string) {
            return this.readLine("Enter password for " + string + ":", false);
        }

        public void welcome(ClientSession clientSession, String string, String string2) {
            this.terminal.writer().println(string);
        }

        public String[] interactive(ClientSession clientSession, String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            String[] stringArray2 = new String[stringArray.length];
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = this.readLine(stringArray[i], blArray[i]);
                }
            }
            catch (Exception exception) {
                this.stderr.append(exception.getClass().getSimpleName()).append(" while read prompts: ").println(exception.getMessage());
            }
            return stringArray2;
        }

        public boolean isInteractionAllowed(ClientSession clientSession) {
            return true;
        }

        public void serverVersionInfo(ClientSession clientSession, List<String> list) {
            for (String string : list) {
                this.terminal.writer().append('\t').println(string);
            }
        }

        public String getUpdatedPassword(ClientSession clientSession, String string, String string2) {
            try {
                return this.readLine(string, false);
            }
            catch (Exception exception) {
                this.stderr.append(exception.getClass().getSimpleName()).append(" while reading password: ").println(exception.getMessage());
                return null;
            }
        }

        private String readLine(String string, boolean bl) {
            return this.reader.readLine(string + " ", bl ? null : Character.valueOf('\u0000'));
        }
    }

    public static class ExecuteParams {
        private final String command;
        private final Map<String, String> env;
        private final InputStream in;
        private final OutputStream out;
        private final OutputStream err;

        public ExecuteParams(String string, Map<String, String> map, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
            this.command = string;
            this.env = map;
            this.in = inputStream;
            this.out = outputStream;
            this.err = outputStream2;
        }

        public String getCommand() {
            return this.command;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public InputStream getIn() {
            return this.in;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public OutputStream getErr() {
            return this.err;
        }
    }

    public static class ShellParams {
        private final Map<String, String> env;
        private final Terminal terminal;
        private final Runnable closer;

        public ShellParams(Map<String, String> map, Terminal terminal, Runnable runnable) {
            this.env = map;
            this.terminal = terminal;
            this.closer = runnable;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public Terminal getTerminal() {
            return this.terminal;
        }

        public Runnable getCloser() {
            return this.closer;
        }
    }
}

