/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.session.ServerSession;
import org.jline.builtins.ssh.Ssh;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ShellFactoryImpl
implements Factory<Command> {
    private final Consumer<Ssh.ShellParams> shell;

    public ShellFactoryImpl(Consumer<Ssh.ShellParams> consumer) {
        this.shell = consumer;
    }

    private static void flush(OutputStream ... outputStreamArray) {
        for (OutputStream outputStream : outputStreamArray) {
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void close(Closeable ... closeableArray) {
        for (Closeable closeable : closeableArray) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Command create() {
        return new ShellImpl();
    }

    public class ShellImpl
    implements Command,
    SessionAware {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private ServerSession session;
        private boolean closed;

        public void setInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        public void setOutputStream(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void setErrorStream(OutputStream outputStream) {
            this.err = outputStream;
        }

        public void setExitCallback(ExitCallback exitCallback) {
            this.callback = exitCallback;
        }

        public void setSession(ServerSession serverSession) {
            this.session = serverSession;
        }

        public void start(Environment environment) {
            try {
                new Thread(() -> {
                    try {
                        this.run(environment);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }).start();
            }
            catch (Exception exception) {
                throw new IOException("Unable to start shell", exception);
            }
        }

        public void run(Environment environment) {
            try {
                Terminal terminal = TerminalBuilder.builder().name("JLine SSH").type((String)environment.getEnv().get("TERM")).system(false).streams(this.in, this.out).build();
                terminal.setSize(new Size(Integer.parseInt((String)environment.getEnv().get("COLUMNS")), Integer.parseInt((String)environment.getEnv().get("LINES"))));
                Attributes attributes = terminal.getAttributes();
                for (Map.Entry entry : environment.getPtyModes().entrySet()) {
                    switch ((PtyMode)entry.getKey()) {
                        case VINTR: {
                            attributes.setControlChar(Attributes.ControlChar.VINTR, (Integer)entry.getValue());
                            break;
                        }
                        case VQUIT: {
                            attributes.setControlChar(Attributes.ControlChar.VQUIT, (Integer)entry.getValue());
                            break;
                        }
                        case VERASE: {
                            attributes.setControlChar(Attributes.ControlChar.VERASE, (Integer)entry.getValue());
                            break;
                        }
                        case VKILL: {
                            attributes.setControlChar(Attributes.ControlChar.VKILL, (Integer)entry.getValue());
                            break;
                        }
                        case VEOF: {
                            attributes.setControlChar(Attributes.ControlChar.VEOF, (Integer)entry.getValue());
                            break;
                        }
                        case VEOL: {
                            attributes.setControlChar(Attributes.ControlChar.VEOL, (Integer)entry.getValue());
                            break;
                        }
                        case VEOL2: {
                            attributes.setControlChar(Attributes.ControlChar.VEOL2, (Integer)entry.getValue());
                            break;
                        }
                        case VSTART: {
                            attributes.setControlChar(Attributes.ControlChar.VSTART, (Integer)entry.getValue());
                            break;
                        }
                        case VSTOP: {
                            attributes.setControlChar(Attributes.ControlChar.VSTOP, (Integer)entry.getValue());
                            break;
                        }
                        case VSUSP: {
                            attributes.setControlChar(Attributes.ControlChar.VSUSP, (Integer)entry.getValue());
                            break;
                        }
                        case VDSUSP: {
                            attributes.setControlChar(Attributes.ControlChar.VDSUSP, (Integer)entry.getValue());
                            break;
                        }
                        case VREPRINT: {
                            attributes.setControlChar(Attributes.ControlChar.VREPRINT, (Integer)entry.getValue());
                            break;
                        }
                        case VWERASE: {
                            attributes.setControlChar(Attributes.ControlChar.VWERASE, (Integer)entry.getValue());
                            break;
                        }
                        case VLNEXT: {
                            attributes.setControlChar(Attributes.ControlChar.VLNEXT, (Integer)entry.getValue());
                            break;
                        }
                        case VSTATUS: {
                            attributes.setControlChar(Attributes.ControlChar.VSTATUS, (Integer)entry.getValue());
                            break;
                        }
                        case VDISCARD: {
                            attributes.setControlChar(Attributes.ControlChar.VDISCARD, (Integer)entry.getValue());
                            break;
                        }
                        case ECHO: {
                            attributes.setLocalFlag(Attributes.LocalFlag.ECHO, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case ICANON: {
                            attributes.setLocalFlag(Attributes.LocalFlag.ICANON, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case ISIG: {
                            attributes.setLocalFlag(Attributes.LocalFlag.ISIG, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case ICRNL: {
                            attributes.setInputFlag(Attributes.InputFlag.ICRNL, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case INLCR: {
                            attributes.setInputFlag(Attributes.InputFlag.INLCR, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case IGNCR: {
                            attributes.setInputFlag(Attributes.InputFlag.IGNCR, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case OCRNL: {
                            attributes.setOutputFlag(Attributes.OutputFlag.OCRNL, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case ONLCR: {
                            attributes.setOutputFlag(Attributes.OutputFlag.ONLCR, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case ONLRET: {
                            attributes.setOutputFlag(Attributes.OutputFlag.ONLRET, (Integer)entry.getValue() != 0);
                            break;
                        }
                        case OPOST: {
                            attributes.setOutputFlag(Attributes.OutputFlag.OPOST, (Integer)entry.getValue() != 0);
                        }
                    }
                }
                terminal.setAttributes(attributes);
                environment.addSignalListener(signal -> {
                    terminal.setSize(new Size(Integer.parseInt((String)environment.getEnv().get("COLUMNS")), Integer.parseInt((String)environment.getEnv().get("LINES"))));
                    terminal.raise(Terminal.Signal.WINCH);
                }, new Signal[]{Signal.WINCH});
                ShellFactoryImpl.this.shell.accept(new Ssh.ShellParams(environment.getEnv(), terminal, this::destroy));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public void destroy() {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(0);
            }
        }
    }
}

