/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.session.ServerSession;
import org.jline.builtins.ssh.ShellFactoryImpl;
import org.jline.builtins.ssh.Ssh;

public class ShellCommand
implements Command,
SessionAware {
    private static final Logger LOGGER = Logger.getLogger(ShellCommand.class.getName());
    private final Consumer<Ssh.ExecuteParams> execute;
    private final String command;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private ServerSession session;
    private Environment env;

    public ShellCommand(Consumer<Ssh.ExecuteParams> consumer, String string) {
        this.execute = consumer;
        this.command = string;
    }

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void setErrorStream(OutputStream outputStream) {
        this.err = outputStream;
    }

    public void setExitCallback(ExitCallback exitCallback) {
        this.callback = exitCallback;
    }

    public void setSession(ServerSession serverSession) {
        this.session = serverSession;
    }

    public void start(Environment environment) {
        this.env = environment;
        new Thread(this::run).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        int n = 0;
        try {
            this.execute.accept(new Ssh.ExecuteParams(this.command, this.env.getEnv(), this.in, this.out, this.err));
        }
        catch (RuntimeException runtimeException) {
            try {
                n = 1;
                LOGGER.log(Level.SEVERE, "Unable to start shell", runtimeException);
                try {
                    Throwable throwable = runtimeException.getCause() != null ? runtimeException.getCause() : runtimeException;
                    this.err.write(throwable.toString().getBytes());
                    this.err.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(n);
                throw throwable;
            }
            ShellFactoryImpl.close(this.in, this.out, this.err);
            this.callback.onExit(n);
        }
        ShellFactoryImpl.close(this.in, this.out, this.err);
        this.callback.onExit(n);
    }

    public void destroy() {
    }
}

