/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.text.DateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.builtins.Options;
import org.jline.builtins.ScreenTerminal;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.DefaultParser;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.LineDisciplineTerminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.Colors;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;

public class Tmux {
    public static final String OPT_PREFIX = "prefix";
    public static final String CMD_COMMANDS = "commands";
    public static final String CMD_SEND_PREFIX = "send-prefix";
    public static final String CMD_SPLIT_WINDOW = "split-window";
    public static final String CMD_SPLITW = "splitw";
    public static final String CMD_SELECT_PANE = "select-pane";
    public static final String CMD_SELECTP = "selectp";
    public static final String CMD_RESIZE_PANE = "resize-pane";
    public static final String CMD_RESIZEP = "resizep";
    public static final String CMD_DISPLAY_PANES = "display-panes";
    public static final String CMD_DISPLAYP = "displayp";
    public static final String CMD_CLOCK_MODE = "clock-mode";
    public static final String CMD_SET_OPTION = "set-option";
    public static final String CMD_SET = "set";
    public static final String CMD_LIST_KEYS = "list-keys";
    public static final String CMD_LSK = "lsk";
    public static final String CMD_SEND_KEYS = "send-keys";
    public static final String CMD_SEND = "send";
    public static final String CMD_BIND_KEY = "bind-key";
    public static final String CMD_BIND = "bind";
    public static final String CMD_UNBIND_KEY = "unbind-key";
    public static final String CMD_UNBIND = "unbind";
    private static final int[][][] WINDOW_CLOCK_TABLE = new int[][][]{new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {0, 0, 0, 0, 1}, {1, 1, 1, 1, 1}}, new int[][]{{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}}, new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}, {1, 0, 0, 0, 0}, {1, 0, 0, 0, 0}}, new int[][]{{1, 0, 0, 0, 1}, {1, 1, 0, 1, 1}, {1, 0, 1, 0, 1}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, 1}}};
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private final AtomicBoolean resized = new AtomicBoolean(true);
    private final Terminal terminal;
    private final Display display;
    private final PrintStream err;
    private final String term;
    private final Consumer<Terminal> runner;
    private List<VirtualConsole> panes = new ArrayList<VirtualConsole>();
    private VirtualConsole active;
    private int lastActive;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final Size size = new Size();
    private final AtomicInteger paneId = new AtomicInteger();
    private Layout layout;
    private boolean identify;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> clockFuture;
    private final Map<String, String> serverOptions = new HashMap<String, String>();
    private KeyMap<Object> keyMap;
    int ACTIVE_COLOR = 3908;
    int INACTIVE_COLOR = 1103;
    int CLOCK_COLOR = 1103;

    public Tmux(Terminal terminal, PrintStream printStream, Consumer<Terminal> consumer) {
        this.terminal = terminal;
        this.err = printStream;
        this.runner = consumer;
        this.display = new Display(terminal, true);
        Integer n = terminal.getNumericCapability(InfoCmp.Capability.max_colors);
        this.term = n != null && n >= 256 ? "screen-256color" : "screen";
        this.serverOptions.put(OPT_PREFIX, "`");
        this.keyMap = this.createKeyMap(this.serverOptions.get(OPT_PREFIX));
    }

    protected KeyMap<Object> createKeyMap(String string) {
        KeyMap<Object> keyMap = this.createEmptyKeyMap(string);
        keyMap.bind((Object)CMD_SEND_PREFIX, (CharSequence)(string + string));
        keyMap.bind((Object)"split-window -v", (CharSequence)(string + "\""));
        keyMap.bind((Object)"split-window -h", (CharSequence)(string + "%"));
        keyMap.bind((Object)"select-pane -U", (CharSequence)(string + KeyMap.key(this.terminal, InfoCmp.Capability.key_up)));
        keyMap.bind((Object)"select-pane -D", (CharSequence)(string + KeyMap.key(this.terminal, InfoCmp.Capability.key_down)));
        keyMap.bind((Object)"select-pane -L", (CharSequence)(string + KeyMap.key(this.terminal, InfoCmp.Capability.key_left)));
        keyMap.bind((Object)"select-pane -R", (CharSequence)(string + KeyMap.key(this.terminal, InfoCmp.Capability.key_right)));
        keyMap.bind((Object)"resize-pane -U 5", (CharSequence)(string + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_up)));
        keyMap.bind((Object)"resize-pane -D 5", (CharSequence)(string + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_down)));
        keyMap.bind((Object)"resize-pane -L 5", (CharSequence)(string + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_left)));
        keyMap.bind((Object)"resize-pane -R 5", (CharSequence)(string + KeyMap.esc() + KeyMap.key(this.terminal, InfoCmp.Capability.key_right)));
        keyMap.bind((Object)"resize-pane -U", string + KeyMap.translate("^[[1;5A"), string + KeyMap.alt(KeyMap.translate("^[[A")));
        keyMap.bind((Object)"resize-pane -D", string + KeyMap.translate("^[[1;5B"), string + KeyMap.alt(KeyMap.translate("^[[B")));
        keyMap.bind((Object)"resize-pane -L", string + KeyMap.translate("^[[1;5C"), string + KeyMap.alt(KeyMap.translate("^[[C")));
        keyMap.bind((Object)"resize-pane -R", string + KeyMap.translate("^[[1;5D"), string + KeyMap.alt(KeyMap.translate("^[[D")));
        keyMap.bind((Object)CMD_DISPLAY_PANES, (CharSequence)(string + "q"));
        keyMap.bind((Object)CMD_CLOCK_MODE, (CharSequence)(string + "t"));
        return keyMap;
    }

    protected KeyMap<Object> createEmptyKeyMap(String string) {
        KeyMap<Object> keyMap = new KeyMap<Object>();
        keyMap.setUnicode((Object)Binding.SelfInsert);
        keyMap.setNomatch((Object)Binding.SelfInsert);
        for (int i = 0; i < 255; ++i) {
            keyMap.bind((Object)Binding.Discard, (CharSequence)(string + (char)i));
        }
        keyMap.bind((Object)Binding.Mouse, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        return keyMap;
    }

    public void run() {
        Terminal.SignalHandler signalHandler = this.terminal.handle(Terminal.Signal.WINCH, this::resize);
        Terminal.SignalHandler signalHandler2 = this.terminal.handle(Terminal.Signal.INT, this::interrupt);
        Terminal.SignalHandler signalHandler3 = this.terminal.handle(Terminal.Signal.TSTP, this::suspend);
        Attributes attributes = this.terminal.enterRawMode();
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.terminal.trackMouse(Terminal.MouseTracking.Any);
        this.terminal.flush();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        try {
            this.size.copy(this.terminal.getSize());
            this.layout = new Layout();
            this.layout.sx = this.size.getColumns();
            this.layout.sy = this.size.getRows();
            this.layout.type = Layout.Type.WindowPane;
            this.active = new VirtualConsole(this.paneId.incrementAndGet(), this.term, 0, 0, this.size.getColumns(), this.size.getRows() - 1, this::setDirty, this::close, this.layout);
            this.active.active = this.lastActive++;
            this.active.getConsole().setAttributes(this.terminal.getAttributes());
            this.panes.add(this.active);
            this.runner.accept(this.active.getConsole());
            new Thread(this::inputLoop, "Mux input loop").start();
            this.redrawLoop();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        finally {
            this.executor.shutdown();
            this.terminal.trackMouse(Terminal.MouseTracking.Off);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes);
            this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
            this.terminal.handle(Terminal.Signal.INT, signalHandler2);
            this.terminal.handle(Terminal.Signal.TSTP, signalHandler3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redrawLoop() {
        while (this.running.get()) {
            try {
                AtomicBoolean atomicBoolean = this.dirty;
                synchronized (atomicBoolean) {
                    while (this.running.get() && !this.dirty.compareAndSet(true, false)) {
                        this.dirty.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.handleResize();
            this.redraw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDirty() {
        AtomicBoolean atomicBoolean = this.dirty;
        synchronized (atomicBoolean) {
            this.dirty.set(true);
            this.dirty.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inputLoop() {
        try {
            BindingReader bindingReader = new BindingReader(this.terminal.reader());
            boolean bl = true;
            while (this.running.get()) {
                Object object;
                Object object2 = bl ? bindingReader.readBinding(this.keyMap) : (bindingReader.peekCharacter(100L) >= 0 ? bindingReader.readBinding(this.keyMap, null, false) : null);
                if (object2 == Binding.SelfInsert) {
                    if (this.active.clock) {
                        this.active.clock = false;
                        if (this.clockFuture != null && this.panes.stream().noneMatch(virtualConsole -> ((VirtualConsole)virtualConsole).clock)) {
                            this.clockFuture.cancel(false);
                            this.clockFuture = null;
                        }
                        this.setDirty();
                        continue;
                    }
                    this.active.getMasterInputOutput().write(bindingReader.getLastBinding().getBytes());
                    bl = false;
                    continue;
                }
                if (bl) {
                    bl = false;
                } else {
                    this.active.getMasterInputOutput().flush();
                    bl = true;
                }
                if (object2 == Binding.Mouse) {
                    object = this.terminal.readMouseEvent();
                    continue;
                }
                if (!(object2 instanceof String) && !(object2 instanceof String[])) continue;
                object = new ByteArrayOutputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    PrintStream printStream = new PrintStream((OutputStream)object);
                    Throwable throwable = null;
                    try {
                        PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
                        Throwable throwable2 = null;
                        try {
                            if (object2 instanceof String) {
                                this.execute(printStream, printStream2, (String)object2);
                                continue;
                            }
                            this.execute(printStream, printStream2, Arrays.asList((String[])object2));
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (printStream2 == null) continue;
                            if (throwable2 != null) {
                                try {
                                    printStream2.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            printStream2.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (printStream == null) continue;
                        if (throwable != null) {
                            try {
                                printStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        printStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException iOException) {
            if (this.running.get()) {
                Log.info("Error in tmux input loop", iOException);
            }
        }
        finally {
            this.running.set(false);
            this.setDirty();
        }
    }

    private synchronized void close(VirtualConsole virtualConsole2) {
        int n = this.panes.indexOf(virtualConsole2);
        if (n >= 0) {
            this.panes.remove(n);
            if (this.panes.isEmpty()) {
                this.running.set(false);
                this.setDirty();
            } else {
                virtualConsole2.layout.remove();
                if (this.active == virtualConsole2) {
                    this.active = this.panes.stream().sorted(Comparator.comparingInt(virtualConsole -> ((VirtualConsole)virtualConsole).active).reversed()).findFirst().get();
                }
                this.layout = this.active.layout;
                while (this.layout.parent != null) {
                    this.layout = this.layout.parent;
                }
                this.layout.fixOffsets();
                this.layout.fixPanes(this.size.getColumns(), this.size.getRows());
                this.resize(Terminal.Signal.WINCH);
            }
        }
    }

    private void resize(Terminal.Signal signal) {
        this.resized.set(true);
        this.setDirty();
    }

    private void interrupt(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void suspend(Terminal.Signal signal) {
        this.active.getConsole().raise(signal);
    }

    private void handleResize() {
        if (this.resized.compareAndSet(true, false)) {
            this.size.copy(this.terminal.getSize());
        }
        this.layout.resize(this.size.getColumns(), this.size.getRows() - 1);
        this.panes.forEach(virtualConsole -> {
            if (virtualConsole.width() != ((VirtualConsole)virtualConsole).layout.sx || virtualConsole.height() != ((VirtualConsole)virtualConsole).layout.sy || virtualConsole.left() != ((VirtualConsole)virtualConsole).layout.xoff || virtualConsole.top() != ((VirtualConsole)virtualConsole).layout.yoff) {
                virtualConsole.resize(((VirtualConsole)virtualConsole).layout.xoff, ((VirtualConsole)virtualConsole).layout.yoff, ((VirtualConsole)virtualConsole).layout.sx, ((VirtualConsole)virtualConsole).layout.sy);
                this.display.clear();
            }
        });
    }

    public void execute(PrintStream printStream, PrintStream printStream2, String string) {
        ParsedLine parsedLine = new DefaultParser().parse(string.trim(), 0);
        this.execute(printStream, printStream2, parsedLine.words());
    }

    public synchronized void execute(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String string = list.get(0);
        List<String> list2 = list.subList(1, list.size());
        switch (string) {
            case "send-prefix": {
                this.sendPrefix(printStream, printStream2, list2);
                break;
            }
            case "split-window": 
            case "splitw": {
                this.splitWindow(printStream, printStream2, list2);
                break;
            }
            case "select-pane": 
            case "selectp": {
                this.selectPane(printStream, printStream2, list2);
                break;
            }
            case "resize-pane": 
            case "resizep": {
                this.resizePane(printStream, printStream2, list2);
                break;
            }
            case "display-panes": 
            case "displayp": {
                this.displayPanes(printStream, printStream2, list2);
                break;
            }
            case "clock-mode": {
                this.clockMode(printStream, printStream2, list2);
                break;
            }
            case "bind-key": 
            case "bind": {
                this.bindKey(printStream, printStream2, list2);
                break;
            }
            case "unbind-key": 
            case "unbind": {
                this.unbindKey(printStream, printStream2, list2);
                break;
            }
            case "list-keys": 
            case "lsk": {
                this.listKeys(printStream, printStream2, list2);
                break;
            }
            case "send-keys": 
            case "send": {
                this.sendKeys(printStream, printStream2, list2);
                break;
            }
            case "set-option": 
            case "set": {
                this.setOption(printStream, printStream2, list2);
            }
        }
    }

    protected void setOption(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String string;
        String[] stringArray = new String[]{"set-option - ", "Usage: set-option [-agosquw] option [value]", "  -? --help                    Show help", "  -u --unset                   Unset the option"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        int n = options.args().size();
        if (n < 1 || n > 2) {
            options.usage(printStream2);
            return;
        }
        String string2 = options.args().get(0);
        String string3 = string = n > 1 ? options.args().get(1) : null;
        if (!string2.startsWith("@")) {
            switch (string2) {
                case "prefix": {
                    if (string == null) {
                        throw new IllegalArgumentException("Missing argument");
                    }
                    String string4 = KeyMap.translate(string);
                    String string5 = this.serverOptions.put(OPT_PREFIX, string4);
                    KeyMap<Object> keyMap = this.createEmptyKeyMap(string4);
                    for (Map.Entry<String, Object> entry : this.keyMap.getBoundKeys().entrySet()) {
                        if (!(entry.getValue() instanceof String)) continue;
                        if (entry.getKey().equals(string5 + string5)) {
                            keyMap.bind(entry.getValue(), (CharSequence)(string4 + string4));
                            continue;
                        }
                        if (entry.getKey().startsWith(string5)) {
                            keyMap.bind(entry.getValue(), (CharSequence)(string4 + entry.getKey().substring(string5.length())));
                            continue;
                        }
                        keyMap.bind(entry.getValue(), (CharSequence)entry.getKey());
                    }
                    this.keyMap = keyMap;
                }
            }
        }
    }

    protected void bindKey(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"bind-key - ", "Usage: bind-key key command [arguments]", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).setOptionsFirst(true).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        List<String> list2 = options.args();
        if (list2.size() < 2) {
            options.usage(printStream2);
            return;
        }
        String string = this.serverOptions.get(OPT_PREFIX);
        String string2 = string + KeyMap.translate(list2.remove(0));
        this.keyMap.unbind((CharSequence)string2.substring(0, 2));
        this.keyMap.bind((Object)list2.toArray(new String[list2.size()]), (CharSequence)string2);
    }

    protected void unbindKey(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"unbind-key - ", "Usage: unbind-key key", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).setOptionsFirst(true).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        List<String> list2 = options.args();
        if (list2.size() != 1) {
            options.usage(printStream2);
            return;
        }
        String string = this.serverOptions.get(OPT_PREFIX);
        String string2 = string + KeyMap.translate(list2.remove(0));
        this.keyMap.unbind((CharSequence)string2);
        this.keyMap.bind((Object)Binding.Discard, (CharSequence)string2);
    }

    protected void listKeys(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"list-keys - ", "Usage: list-keys ", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        String string = this.serverOptions.get(OPT_PREFIX);
        this.keyMap.getBoundKeys().entrySet().stream().filter(entry -> entry.getValue() instanceof String).map(entry -> {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bind-key -T ");
            if (string2.startsWith(string)) {
                stringBuilder.append("prefix ");
                string2 = string2.substring(string.length());
            } else {
                stringBuilder.append("root   ");
            }
            stringBuilder.append(KeyMap.display(string2));
            while (stringBuilder.length() < 32) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string3);
            return stringBuilder.toString();
        }).sorted().forEach(printStream::println);
    }

    protected void sendKeys(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"send-keys - ", "Usage: send-keys [-lXRM] [-N repeat-count] [-t target-pane] key...", "  -? --help                    Show help", "  -l --literal                Send key literally", "  -N --number=repeat-count     Specifies a repeat count"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        int n = options.getNumber("number");
        for (int i = 0; i < n; ++i) {
            for (String string : options.args()) {
                String string2 = options.isSet("literal") ? string : KeyMap.translate(string);
                this.active.getMasterInputOutput().write(string2.getBytes());
            }
        }
    }

    protected void clockMode(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"clock-mode - ", "Usage: clock-mode", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        this.active.clock = true;
        if (this.clockFuture == null) {
            long l = Instant.now().until(Instant.now().truncatedTo(ChronoUnit.MINUTES).plusSeconds(60L), ChronoUnit.MILLIS);
            long l2 = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.SECONDS);
            this.clockFuture = this.executor.scheduleWithFixedDelay(this::setDirty, l, l2, TimeUnit.MILLISECONDS);
        }
        this.setDirty();
    }

    protected void displayPanes(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"display-panes - ", "Usage: display-panes", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        this.identify = true;
        this.setDirty();
        this.executor.schedule(() -> {
            this.identify = false;
            this.setDirty();
        }, 1L, TimeUnit.SECONDS);
    }

    protected void resizePane(PrintStream printStream, PrintStream printStream2, List<String> list) {
        int n;
        int n2;
        String[] stringArray = new String[]{"resize-pane - ", "Usage: resize-pane [-UDLR] [-x width] [-y height] [-t target-pane] [adjustment]", "  -? --help                    Show help", "  -U                           Resize pane upward", "  -D                           Select pane downward", "  -L                           Select pane to the left", "  -R                           Select pane to the right", "  -x --width=width             Set the width of the pane", "  -y --height=height           Set the height of the pane"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        if (options.args().size() == 0) {
            n2 = 1;
        } else if (options.args().size() == 1) {
            n2 = Integer.parseInt(options.args().get(0));
        } else {
            options.usage(printStream2);
            return;
        }
        if (options.isSet("width")) {
            n = options.getNumber("width");
            this.active.layout().resizeTo(Layout.Type.LeftRight, n);
        }
        if (options.isSet("height")) {
            n = options.getNumber("height");
            this.active.layout().resizeTo(Layout.Type.TopBottom, n);
        }
        if (options.isSet("L")) {
            this.active.layout().resize(Layout.Type.LeftRight, -n2, true);
        } else if (options.isSet("R")) {
            this.active.layout().resize(Layout.Type.LeftRight, n2, true);
        } else if (options.isSet("U")) {
            this.active.layout().resize(Layout.Type.TopBottom, -n2, true);
        } else if (options.isSet("D")) {
            this.active.layout().resize(Layout.Type.TopBottom, n2, true);
        }
        this.setDirty();
    }

    protected void selectPane(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"select-pane - ", "Usage: select-pane [-UDLR] [-t target-pane]", "  -? --help                    Show help", "  -U                           Select pane up", "  -D                           Select pane down", "  -L                           Select pane left", "  -R                           Select pane right"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        VirtualConsole virtualConsole2 = this.active;
        if (options.isSet("L")) {
            this.active = this.panes.stream().filter(virtualConsole -> virtualConsole.bottom() > this.active.top() && virtualConsole.top() < this.active.bottom()).filter(virtualConsole -> virtualConsole != this.active).sorted(Comparator.comparingInt(virtualConsole -> virtualConsole.left() > this.active.left() ? virtualConsole.left() : virtualConsole.left() + this.size.getColumns()).reversed().thenComparingInt(virtualConsole -> -((VirtualConsole)virtualConsole).active)).findFirst().orElse(this.active);
        } else if (options.isSet("R")) {
            this.active = this.panes.stream().filter(virtualConsole -> virtualConsole.bottom() > this.active.top() && virtualConsole.top() < this.active.bottom()).filter(virtualConsole -> virtualConsole != this.active).sorted(Comparator.comparingInt(virtualConsole -> virtualConsole.left() > this.active.left() ? virtualConsole.left() : virtualConsole.left() + this.size.getColumns()).thenComparingInt(virtualConsole -> -((VirtualConsole)virtualConsole).active)).findFirst().orElse(this.active);
        } else if (options.isSet("U")) {
            this.active = this.panes.stream().filter(virtualConsole -> virtualConsole.right() > this.active.left() && virtualConsole.left() < this.active.right()).filter(virtualConsole -> virtualConsole != this.active).sorted(Comparator.comparingInt(virtualConsole -> virtualConsole.top() > this.active.top() ? virtualConsole.top() : virtualConsole.top() + this.size.getRows()).reversed().thenComparingInt(virtualConsole -> -((VirtualConsole)virtualConsole).active)).findFirst().orElse(this.active);
        } else if (options.isSet("D")) {
            this.active = this.panes.stream().filter(virtualConsole -> virtualConsole.right() > this.active.left() && virtualConsole.left() < this.active.right()).filter(virtualConsole -> virtualConsole != this.active).sorted(Comparator.comparingInt(virtualConsole -> virtualConsole.top() > this.active.top() ? virtualConsole.top() : virtualConsole.top() + this.size.getRows()).thenComparingInt(virtualConsole -> -((VirtualConsole)virtualConsole).active)).findFirst().orElse(this.active);
        }
        if (virtualConsole2 != this.active) {
            this.setDirty();
            this.active.active = this.lastActive++;
        }
    }

    protected void sendPrefix(PrintStream printStream, PrintStream printStream2, List<String> list) {
        String[] stringArray = new String[]{"send-prefix - ", "Usage: send-prefix [-2] [-t target-pane]", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        this.active.getMasterInputOutput().write(this.serverOptions.get(OPT_PREFIX).getBytes());
    }

    protected void splitWindow(PrintStream printStream, PrintStream printStream2, List<String> list) {
        Layout layout;
        Layout.Type type;
        String[] stringArray = new String[]{"split-window - ", "Usage: split-window [-bdfhvP] [-c start-directory] [-F format] [-p percentage|-l size] [-t target-pane] [command]", "  -? --help                    Show help", "  -h --horizontal              Horizontal split", "  -v --vertical                Vertical split", "  -l --size=size               Size", "  -p --perc=percentage         Percentage", "  -b --before                  Insert the new pane before the active one", "  -f                           Split the full window instead of the active pane", "  -d                           Do not make the new pane the active one"};
        Options options = Options.compile(stringArray).parse(list);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        Layout.Type type2 = type = options.isSet("horizontal") ? Layout.Type.LeftRight : Layout.Type.TopBottom;
        if (this.layout.type == Layout.Type.WindowPane) {
            layout = new Layout();
            layout.sx = this.layout.sx;
            layout.sy = this.layout.sy;
            layout.type = type;
            layout.cells.add(this.layout);
            this.layout.parent = layout;
            this.layout = layout;
        }
        layout = this.active.layout();
        if (options.isSet("f")) {
            while (layout.parent != this.layout) {
                layout = layout.parent;
            }
        }
        int n = -1;
        if (options.isSet("size")) {
            n = options.getNumber("size");
        } else if (options.isSet("perc")) {
            int n2 = options.getNumber("perc");
            n = type == Layout.Type.TopBottom ? layout.sy * n2 / 100 : layout.sx * n2 / 100;
        }
        Layout layout2 = layout.split(type, n, options.isSet("before"));
        if (layout2 == null) {
            printStream2.println("create pane failed: pane too small");
            return;
        }
        VirtualConsole virtualConsole = new VirtualConsole(this.paneId.incrementAndGet(), this.term, layout2.xoff, layout2.yoff, layout2.sx, layout2.sy, this::setDirty, this::close, layout2);
        this.panes.add(virtualConsole);
        virtualConsole.getConsole().setAttributes(this.terminal.getAttributes());
        if (!options.isSet("d")) {
            this.active = virtualConsole;
            this.active.active = this.lastActive++;
        }
        this.runner.accept(virtualConsole.getConsole());
        this.setDirty();
    }

    protected void layoutResize() {
    }

    protected synchronized void redraw() {
        long[] lArray = new long[this.size.getRows() * this.size.getColumns()];
        Arrays.fill(lArray, 32L);
        int[] nArray = new int[2];
        for (VirtualConsole virtualConsole : this.panes) {
            String string;
            if (virtualConsole.clock) {
                string = DateFormat.getTimeInstance(3).format(new Date());
                this.print(lArray, virtualConsole, string, this.CLOCK_COLOR);
            } else {
                virtualConsole.dump(lArray, virtualConsole.top(), virtualConsole.left(), this.size.getRows(), this.size.getColumns(), (int[])(virtualConsole == this.active ? nArray : null));
            }
            if (this.identify) {
                string = Integer.toString(virtualConsole.id);
                this.print(lArray, virtualConsole, string, virtualConsole == this.active ? this.ACTIVE_COLOR : this.INACTIVE_COLOR);
            }
            this.drawBorder(lArray, this.size, virtualConsole, 0L);
        }
        this.drawBorder(lArray, this.size, this.active, 0x1008000000000000L);
        Arrays.fill(lArray, (this.size.getRows() - 1) * this.size.getColumns(), this.size.getRows() * this.size.getColumns(), 0x2000008000000020L);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < this.size.getRows(); ++i) {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder(this.size.getColumns());
            for (int j = 0; j < this.size.getColumns(); ++j) {
                int n3;
                boolean bl7;
                long l = lArray[i * this.size.getColumns() + j];
                int n4 = (int)(l & 0xFFFFFFFFL);
                int n5 = (int)(l >> 32);
                int n6 = n5 & 0xFFF;
                int n7 = (n5 & 0xFFF000) >> 12;
                boolean bl8 = (n5 & 0x1000000) != 0;
                boolean bl9 = (n5 & 0x2000000) != 0;
                boolean bl10 = (n5 & 0x4000000) != 0;
                boolean bl11 = (n5 & 0x8000000) != 0;
                boolean bl12 = (n5 & 0x10000000) != 0;
                boolean bl13 = bl7 = (n5 & 0x20000000) != 0;
                if (bl7 && bl6 && n6 != n || bl6 != bl7) {
                    if (!bl7) {
                        attributedStringBuilder.style(attributedStringBuilder.style().backgroundDefault());
                    } else {
                        n3 = n6;
                        n3 = Colors.roundRgbColor((n3 & 0xF00) >> 4, n3 & 0xF0, (n3 & 0xF) << 4, 256);
                        attributedStringBuilder.style(attributedStringBuilder.style().background(n3));
                    }
                    n = n6;
                    bl6 = bl7;
                }
                if (bl12 && bl5 && n7 != n2 || bl5 != bl12) {
                    if (!bl12) {
                        attributedStringBuilder.style(attributedStringBuilder.style().foregroundDefault());
                    } else {
                        n3 = n7;
                        n3 = Colors.roundRgbColor((n3 & 0xF00) >> 4, n3 & 0xF0, (n3 & 0xF) << 4, 256);
                        attributedStringBuilder.style(attributedStringBuilder.style().foreground(n3));
                    }
                    n2 = n7;
                    bl5 = bl12;
                }
                if (bl10 != bl4) {
                    attributedStringBuilder.style(bl10 ? attributedStringBuilder.style().conceal() : attributedStringBuilder.style().concealOff());
                    bl4 = bl10;
                }
                if (bl9 != bl) {
                    attributedStringBuilder.style(bl9 ? attributedStringBuilder.style().inverse() : attributedStringBuilder.style().inverseOff());
                    bl = bl9;
                }
                if (bl8 != bl2) {
                    attributedStringBuilder.style(bl8 ? attributedStringBuilder.style().underline() : attributedStringBuilder.style().underlineOff());
                    bl2 = bl8;
                }
                if (bl11 != bl3) {
                    attributedStringBuilder.style(bl11 ? attributedStringBuilder.style().bold() : attributedStringBuilder.style().boldOff());
                    bl3 = bl11;
                }
                attributedStringBuilder.append((char)n4);
            }
            arrayList.add(attributedStringBuilder.toAttributedString());
        }
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(arrayList, this.size.cursorPos(nArray[1], nArray[0]));
    }

    private void print(long[] lArray, VirtualConsole virtualConsole, String string, int n) {
        if (virtualConsole.height() > 5) {
            long l = (long)n << 32 | 0x2000000000000000L;
            int n2 = (virtualConsole.height() - 5) / 2;
            int n3 = (virtualConsole.width() - string.length() * 6) / 2;
            for (int i = 0; i < string.length(); ++i) {
                int n4;
                char c = string.charAt(i);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n4 = c - 48;
                        break;
                    }
                    case ':': {
                        n4 = 10;
                        break;
                    }
                    case 'A': {
                        n4 = 11;
                        break;
                    }
                    case 'P': {
                        n4 = 12;
                        break;
                    }
                    case 'M': {
                        n4 = 13;
                        break;
                    }
                    default: {
                        n4 = -1;
                    }
                }
                if (n4 < 0) continue;
                int[][] nArray = WINDOW_CLOCK_TABLE[n4];
                for (int j = 0; j < nArray.length; ++j) {
                    for (int k = 0; k < nArray[j].length; ++k) {
                        if (nArray[j][k] == 0) continue;
                        int n5 = (virtualConsole.top + n2 + j) * this.size.getColumns() + virtualConsole.left() + n3 + k + 6 * i;
                        lArray[n5] = l | 0x20L;
                    }
                }
            }
        } else {
            long l = (long)n << 44 | 0x1000000000000000L;
            int n6 = (virtualConsole.height() + 1) / 2;
            int n7 = (virtualConsole.width() - string.length()) / 2;
            int n8 = (virtualConsole.top + n6) * this.size.getColumns() + virtualConsole.left() + n7;
            for (int i = 0; i < string.length(); ++i) {
                lArray[n8 + i] = l | (long)string.charAt(i);
            }
        }
    }

    private void drawBorder(long[] lArray, Size size, VirtualConsole virtualConsole, long l) {
        int n;
        int n2;
        int n3;
        for (n3 = virtualConsole.left(); n3 < virtualConsole.right(); ++n3) {
            n2 = virtualConsole.top() - 1;
            n = virtualConsole.bottom();
            this.drawBorderChar(lArray, size, n3, n2, l, 9472);
            this.drawBorderChar(lArray, size, n3, n, l, 9472);
        }
        for (n3 = virtualConsole.top(); n3 < virtualConsole.bottom(); ++n3) {
            n2 = virtualConsole.left() - 1;
            n = virtualConsole.right();
            this.drawBorderChar(lArray, size, n2, n3, l, 9474);
            this.drawBorderChar(lArray, size, n, n3, l, 9474);
        }
        this.drawBorderChar(lArray, size, virtualConsole.left() - 1, virtualConsole.top() - 1, l, 9484);
        this.drawBorderChar(lArray, size, virtualConsole.right(), virtualConsole.top() - 1, l, 9488);
        this.drawBorderChar(lArray, size, virtualConsole.left() - 1, virtualConsole.bottom(), l, 9492);
        this.drawBorderChar(lArray, size, virtualConsole.right(), virtualConsole.bottom(), l, 9496);
    }

    private void drawBorderChar(long[] lArray, Size size, int n, int n2, long l, int n3) {
        if (n >= 0 && n < size.getColumns() && n2 >= 0 && n2 < size.getRows() - 1) {
            int n4 = (int)(lArray[n2 * size.getColumns() + n] & 0xFFFFFFFFL);
            n3 = this.addBorder(n3, n4);
            lArray[n2 * size.getColumns() + n] = l | (long)n3;
        }
    }

    private int addBorder(int n, int n2) {
        if (n2 == 32) {
            return n;
        }
        if (n2 == 9532) {
            return 9532;
        }
        switch (n) {
            case 9474: {
                return this.addBorder(9591, this.addBorder(9589, n2));
            }
            case 9472: {
                return this.addBorder(9588, this.addBorder(9590, n2));
            }
            case 9484: {
                return this.addBorder(9590, this.addBorder(9591, n2));
            }
            case 9488: {
                return this.addBorder(9588, this.addBorder(9591, n2));
            }
            case 9492: {
                return this.addBorder(9590, this.addBorder(9589, n2));
            }
            case 9496: {
                return this.addBorder(9588, this.addBorder(9589, n2));
            }
            case 9500: {
                return this.addBorder(9590, this.addBorder(9474, n2));
            }
            case 9508: {
                return this.addBorder(9588, this.addBorder(9474, n2));
            }
            case 9516: {
                return this.addBorder(9591, this.addBorder(9472, n2));
            }
            case 9524: {
                return this.addBorder(9589, this.addBorder(9472, n2));
            }
            case 9588: {
                switch (n2) {
                    case 9474: {
                        return 9508;
                    }
                    case 9472: {
                        return 9472;
                    }
                    case 9484: {
                        return 9516;
                    }
                    case 9488: {
                        return 9488;
                    }
                    case 9492: {
                        return 9524;
                    }
                    case 9496: {
                        return 9496;
                    }
                    case 9500: {
                        return 9532;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9589: {
                switch (n2) {
                    case 9474: {
                        return 9474;
                    }
                    case 9472: {
                        return 9524;
                    }
                    case 9484: {
                        return 9500;
                    }
                    case 9488: {
                        return 9508;
                    }
                    case 9492: {
                        return 9492;
                    }
                    case 9496: {
                        return 9496;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9532;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9590: {
                switch (n2) {
                    case 9474: {
                        return 9500;
                    }
                    case 9472: {
                        return 9472;
                    }
                    case 9484: {
                        return 9484;
                    }
                    case 9488: {
                        return 9516;
                    }
                    case 9492: {
                        return 9492;
                    }
                    case 9496: {
                        return 9524;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9532;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9524;
                    }
                }
                throw new IllegalArgumentException();
            }
            case 9591: {
                switch (n2) {
                    case 9474: {
                        return 9474;
                    }
                    case 9472: {
                        return 9516;
                    }
                    case 9484: {
                        return 9484;
                    }
                    case 9488: {
                        return 9488;
                    }
                    case 9492: {
                        return 9500;
                    }
                    case 9496: {
                        return 9508;
                    }
                    case 9500: {
                        return 9500;
                    }
                    case 9508: {
                        return 9508;
                    }
                    case 9516: {
                        return 9516;
                    }
                    case 9524: {
                        return 9532;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }

    private static int findMatch(String string, char c, char c2) {
        int n;
        if (string.charAt(0) != c) {
            throw new IllegalArgumentException();
        }
        int n2 = 0;
        for (n = 0; n < string.length(); ++n) {
            char c3 = string.charAt(n);
            if (c3 == c) {
                ++n2;
                continue;
            }
            if (c3 != c2 || --n2 != 0) continue;
            return n;
        }
        if (n2 > 0) {
            throw new IllegalArgumentException("No matching '" + c2 + "'");
        }
        return n;
    }

    private static class VirtualConsole
    implements Closeable {
        private final ScreenTerminal terminal;
        private final Consumer<VirtualConsole> closer;
        private final int id;
        private int left;
        private int top;
        private final Layout layout;
        private int active;
        private boolean clock;
        private final OutputStream masterOutput;
        private final OutputStream masterInputOutput;
        private final LineDisciplineTerminal console;

        public VirtualConsole(int n, String string, int n2, int n3, int n4, int n5, final Runnable runnable, final Consumer<VirtualConsole> consumer, Layout layout) {
            String string2 = String.format("tmux%02d", n);
            this.id = n;
            this.left = n2;
            this.top = n3;
            this.closer = consumer;
            this.terminal = new ScreenTerminal(n4, n5){

                @Override
                protected void setDirty() {
                    super.setDirty();
                    runnable.run();
                }
            };
            this.masterOutput = new MasterOutputStream();
            this.masterInputOutput = new OutputStream(){

                @Override
                public void write(int n) {
                    console.processInputByte(n);
                }
            };
            this.console = new LineDisciplineTerminal(string2, string, this.masterOutput, null){

                @Override
                public void close() {
                    super.close();
                    consumer.accept(this);
                }
            };
            this.console.setSize(new Size(n4, n5));
            this.layout = layout;
        }

        Layout layout() {
            return this.layout;
        }

        public int left() {
            return this.left;
        }

        public int top() {
            return this.top;
        }

        public int right() {
            return this.left() + this.width();
        }

        public int bottom() {
            return this.top() + this.height();
        }

        public int width() {
            return this.console.getWidth();
        }

        public int height() {
            return this.console.getHeight();
        }

        public LineDisciplineTerminal getConsole() {
            return this.console;
        }

        public OutputStream getMasterInputOutput() {
            return this.masterInputOutput;
        }

        public void resize(int n, int n2, int n3, int n4) {
            this.left = n;
            this.top = n2;
            this.console.setSize(new Size(n3, n4));
            this.terminal.setSize(n3, n4);
            this.console.raise(Terminal.Signal.WINCH);
        }

        public void dump(long[] lArray, int n, int n2, int n3, int n4, int[] nArray) {
            this.terminal.dump(lArray, n, n2, n3, n4, nArray);
        }

        @Override
        public void close() {
            this.console.close();
        }

        private class MasterOutputStream
        extends OutputStream {
            private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private final CharsetDecoder decoder = Charset.defaultCharset().newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);

            private MasterOutputStream() {
            }

            @Override
            public synchronized void write(int n) {
                this.buffer.write(n);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                this.buffer.write(byArray, n, n2);
            }

            @Override
            public synchronized void flush() {
                int n = this.buffer.size();
                if (n > 0) {
                    ByteBuffer byteBuffer;
                    CharBuffer charBuffer;
                    while (true) {
                        charBuffer = CharBuffer.allocate(n);
                        byteBuffer = ByteBuffer.wrap(this.buffer.toByteArray());
                        CoderResult coderResult = this.decoder.decode(byteBuffer, charBuffer, false);
                        if (!coderResult.isOverflow()) break;
                        n *= 2;
                    }
                    this.buffer.reset();
                    this.buffer.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
                    if (charBuffer.position() > 0) {
                        charBuffer.flip();
                        VirtualConsole.this.terminal.write(charBuffer);
                        VirtualConsole.this.masterInputOutput.write(VirtualConsole.this.terminal.read().getBytes());
                    }
                }
            }

            @Override
            public void close() {
                this.flush();
            }
        }
    }

    static class Layout {
        static final Pattern PATTERN = Pattern.compile("([0-9]+)x([0-9]+),([0-9]+),([0-9]+)([^0-9]\\S*)?");
        private static final int PANE_MINIMUM = 3;
        Type type;
        Layout parent;
        int sx;
        int sy;
        int xoff;
        int yoff;
        List<Layout> cells = new ArrayList<Layout>();

        Layout() {
        }

        public static Layout parse(String string) {
            if (string.length() < 6) {
                throw new IllegalArgumentException("Bad syntax");
            }
            String string2 = string.substring(0, 4);
            if (string.charAt(4) != ',') {
                throw new IllegalArgumentException("Bad syntax");
            }
            string = string.substring(5);
            if (Integer.parseInt(string2, 16) != Layout.checksum(string)) {
                throw new IllegalArgumentException("Bad checksum");
            }
            return Layout.parseCell(null, string);
        }

        public String dump() {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("0000,");
            this.doDump(stringBuilder);
            int n = Layout.checksum(stringBuilder, 5);
            stringBuilder.setCharAt(0, Layout.toHexChar(n >> 12 & 0xF));
            stringBuilder.setCharAt(1, Layout.toHexChar(n >> 8 & 0xF));
            stringBuilder.setCharAt(2, Layout.toHexChar(n >> 4 & 0xF));
            stringBuilder.setCharAt(3, Layout.toHexChar(n & 0xF));
            return stringBuilder.toString();
        }

        private static char toHexChar(int n) {
            return n < 10 ? (char)(n + 48) : (char)(n - 10 + 97);
        }

        private void doDump(StringBuilder stringBuilder) {
            stringBuilder.append(this.sx).append('x').append(this.sy).append(',').append(this.xoff).append(',').append(this.yoff);
            switch (this.type) {
                case WindowPane: {
                    stringBuilder.append(',').append('0');
                    break;
                }
                case TopBottom: 
                case LeftRight: {
                    stringBuilder.append(this.type == Type.TopBottom ? (char)'[' : '{');
                    boolean bl = true;
                    for (Layout layout : this.cells) {
                        if (bl) {
                            bl = false;
                        } else {
                            stringBuilder.append(',');
                        }
                        layout.doDump(stringBuilder);
                    }
                    stringBuilder.append(this.type == Type.TopBottom ? (char)']' : '}');
                }
            }
        }

        public void resize(Type type, int n, boolean bl) {
            Layout layout = this;
            Layout layout2 = layout.parent;
            while (layout2 != null && layout2.type != type) {
                layout = layout2;
                layout2 = layout.parent;
            }
            if (layout2 == null) {
                return;
            }
            if (layout.nextSibling() == null) {
                layout = layout.prevSibling();
            }
            int n2 = n;
            while (n2 != 0) {
                int n3;
                if (n > 0) {
                    n3 = layout.resizePaneGrow(type, n2, bl);
                    n2 -= n3;
                } else {
                    n3 = layout.resizePaneShrink(type, n2);
                    n2 += n3;
                }
                if (n3 != 0) continue;
            }
            this.fixOffsets();
            this.fixPanes();
        }

        int resizePaneGrow(Type type, int n, boolean bl) {
            Layout layout;
            int n2 = 0;
            Layout layout2 = this;
            for (layout = this.nextSibling(); layout != null && (n2 = layout.resizeCheck(type)) <= 0; layout = layout.nextSibling()) {
            }
            if (bl && layout == null) {
                for (layout = this.prevSibling(); layout != null && (n2 = layout.resizeCheck(type)) <= 0; layout = layout.prevSibling()) {
                }
            }
            if (layout == null) {
                return 0;
            }
            if (n2 > n) {
                n2 = n;
            }
            layout2.resizeAdjust(type, n2);
            layout.resizeAdjust(type, -n2);
            return n2;
        }

        int resizePaneShrink(Type type, int n) {
            int n2 = 0;
            Layout layout = this;
            while ((n2 = layout.resizeCheck(type)) <= 0 && (layout = layout.prevSibling()) != null) {
            }
            if (layout == null) {
                return 0;
            }
            Layout layout2 = this.nextSibling();
            if (layout2 == null) {
                return 0;
            }
            if (n2 > -n) {
                n2 = -n;
            }
            layout2.resizeAdjust(type, n2);
            layout.resizeAdjust(type, -n2);
            return n2;
        }

        Layout prevSibling() {
            int n = this.parent.cells.indexOf(this);
            if (n > 0) {
                return this.parent.cells.get(n - 1);
            }
            return null;
        }

        Layout nextSibling() {
            int n = this.parent.cells.indexOf(this);
            if (n < this.parent.cells.size() - 1) {
                return this.parent.cells.get(n + 1);
            }
            return null;
        }

        public void resizeTo(Type type, int n) {
            Layout layout = this;
            Layout layout2 = layout.parent;
            while (layout2 != null && layout2.type != type) {
                layout = layout2;
                layout2 = layout.parent;
            }
            if (layout2 == null) {
                return;
            }
            int n2 = type == Type.LeftRight ? layout.sx : layout.sy;
            int n3 = layout.nextSibling() == null ? n2 - n : n - n2;
            layout.resize(type, n3, true);
        }

        public void resize(int n, int n2) {
            int n3 = n - this.sx;
            int n4 = this.resizeCheck(Type.LeftRight);
            if (n3 < 0 && n3 < -n4) {
                n3 = -n4;
            }
            if (n4 == 0) {
                n3 = n <= this.sx ? 0 : n - this.sx;
            }
            if (n3 != 0) {
                this.resizeAdjust(Type.LeftRight, n3);
            }
            int n5 = n2 - this.sy;
            int n6 = this.resizeCheck(Type.TopBottom);
            if (n5 < 0 && n5 < -n6) {
                n5 = -n6;
            }
            if (n6 == 0) {
                n5 = n2 <= this.sy ? 0 : n2 - this.sy;
            }
            if (n5 != 0) {
                this.resizeAdjust(Type.TopBottom, n5);
            }
            this.fixOffsets();
            this.fixPanes(n, n2);
        }

        public void remove() {
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            int n = this.parent.cells.indexOf(this);
            Layout layout = this.parent.cells.get(n == 0 ? 1 : n - 1);
            layout.resizeAdjust(this.parent.type, this.parent.type == Type.LeftRight ? this.sx + 1 : this.sy + 1);
            this.parent.cells.remove(this);
            if (layout.parent.cells.size() == 1) {
                if (layout.parent.parent == null) {
                    layout.parent = null;
                } else {
                    layout.parent.parent.cells.set(layout.parent.parent.cells.indexOf(layout.parent), layout);
                    layout.parent = layout.parent.parent;
                }
            }
        }

        private int resizeCheck(Type type) {
            if (this.type == Type.WindowPane) {
                int n;
                int n2 = 3;
                if (type == Type.LeftRight) {
                    n = this.sx;
                } else {
                    n = this.sy;
                    ++n2;
                }
                n = n > n2 ? (n -= n2) : 0;
                return n;
            }
            if (this.type == type) {
                return this.cells.stream().mapToInt(layout -> layout.resizeCheck(type)).sum();
            }
            return this.cells.stream().mapToInt(layout -> layout.resizeCheck(type)).min().orElse(Integer.MAX_VALUE);
        }

        private void resizeAdjust(Type type, int n) {
            if (type == Type.LeftRight) {
                this.sx += n;
            } else {
                this.sy += n;
            }
            if (this.type == Type.WindowPane) {
                return;
            }
            if (this.type != type) {
                for (Layout layout : this.cells) {
                    layout.resizeAdjust(type, n);
                }
                return;
            }
            block1: while (n != 0) {
                for (Layout layout : this.cells) {
                    if (n == 0) continue block1;
                    if (n > 0) {
                        layout.resizeAdjust(type, 1);
                        --n;
                        continue;
                    }
                    if (layout.resizeCheck(type) <= 0) continue;
                    layout.resizeAdjust(type, -1);
                    ++n;
                }
            }
        }

        public void fixOffsets() {
            block3: {
                block2: {
                    if (this.type != Type.LeftRight) break block2;
                    int n = this.xoff;
                    for (Layout layout : this.cells) {
                        layout.xoff = n;
                        layout.yoff = this.yoff;
                        layout.fixOffsets();
                        n += layout.sx + 1;
                    }
                    break block3;
                }
                if (this.type != Type.TopBottom) break block3;
                int n = this.yoff;
                for (Layout layout : this.cells) {
                    layout.xoff = this.xoff;
                    layout.yoff = n;
                    layout.fixOffsets();
                    n += layout.sy + 1;
                }
            }
        }

        public void fixPanes() {
        }

        public void fixPanes(int n, int n2) {
        }

        public int countCells() {
            switch (this.type) {
                case TopBottom: 
                case LeftRight: {
                    return this.cells.stream().mapToInt(Layout::countCells).sum();
                }
            }
            return 1;
        }

        public Layout split(Type type, int n, boolean bl) {
            Layout layout;
            Layout layout2;
            Layout layout3;
            int n2;
            int n3;
            if (type == Type.WindowPane) {
                throw new IllegalStateException();
            }
            if ((type == Type.LeftRight ? this.sx : this.sy) < 7) {
                return null;
            }
            if (this.parent == null) {
                throw new IllegalStateException();
            }
            int n4 = n3 = type == Type.LeftRight ? this.sx : this.sy;
            int n5 = n < 0 ? (n3 + 1) / 2 - 1 : (n2 = bl ? n3 - n - 1 : n);
            if (n2 < 3) {
                n2 = 3;
            } else if (n2 > n3 - 2) {
                n2 = n3 - 2;
            }
            int n6 = n3 - 1 - n2;
            if (this.parent.type != type) {
                layout3 = new Layout();
                layout3.type = type;
                layout3.parent = this.parent;
                layout3.sx = this.sx;
                layout3.sy = this.sy;
                layout3.xoff = this.xoff;
                layout3.yoff = this.yoff;
                this.parent.cells.set(this.parent.cells.indexOf(this), layout3);
                layout3.cells.add(this);
                this.parent = layout3;
            }
            layout3 = new Layout();
            layout3.type = Type.WindowPane;
            layout3.parent = this.parent;
            this.parent.cells.add(this.parent.cells.indexOf(this) + (bl ? 0 : 1), layout3);
            int n7 = this.sx;
            int n8 = this.sy;
            int n9 = this.xoff;
            int n10 = this.yoff;
            if (bl) {
                layout2 = layout3;
                layout = this;
            } else {
                layout2 = this;
                layout = layout3;
            }
            if (type == Type.LeftRight) {
                layout2.setSize(n6, n8, n9, n10);
                layout.setSize(n2, n8, n9 + n6 + 1, n10);
            } else {
                layout2.setSize(n7, n6, n9, n10);
                layout.setSize(n7, n2, n9, n10 + n6 + 1);
            }
            return layout3;
        }

        private void setSize(int n, int n2, int n3, int n4) {
            this.sx = n;
            this.sy = n2;
            this.xoff = n3;
            this.yoff = n4;
        }

        private static int checksum(CharSequence charSequence) {
            return Layout.checksum(charSequence, 0);
        }

        private static int checksum(CharSequence charSequence, int n) {
            int n2 = 0;
            for (int i = n; i < charSequence.length(); ++i) {
                n2 = (n2 >> 1) + ((n2 & 1) << 15);
                n2 += charSequence.charAt(i);
            }
            return n2;
        }

        private static Layout parseCell(Layout layout, String string) {
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.matches()) {
                int n;
                Layout layout2 = new Layout();
                layout2.type = Type.WindowPane;
                layout2.parent = layout;
                layout2.sx = Integer.parseInt(matcher.group(1));
                layout2.sy = Integer.parseInt(matcher.group(2));
                layout2.xoff = Integer.parseInt(matcher.group(3));
                layout2.yoff = Integer.parseInt(matcher.group(4));
                if (layout != null) {
                    layout.cells.add(layout2);
                }
                if ((string = matcher.group(5)) == null || string.isEmpty()) {
                    return layout2;
                }
                if (string.charAt(0) == ',') {
                    for (n = 1; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
                    }
                    if (n == string.length()) {
                        return layout2;
                    }
                    if (string.charAt(n) == ',') {
                        string = string.substring(n);
                    }
                }
                switch (string.charAt(0)) {
                    case '{': {
                        layout2.type = Type.LeftRight;
                        n = Tmux.findMatch(string, '{', '}');
                        Layout.parseCell(layout2, string.substring(1, n));
                        string = string.substring(n + 1);
                        if (!string.isEmpty() && string.charAt(0) == ',') {
                            Layout.parseCell(layout, string.substring(1));
                        }
                        return layout2;
                    }
                    case '[': {
                        layout2.type = Type.TopBottom;
                        n = Tmux.findMatch(string, '[', ']');
                        Layout.parseCell(layout2, string.substring(1, n));
                        string = string.substring(n + 1);
                        if (!string.isEmpty() && string.charAt(0) == ',') {
                            Layout.parseCell(layout, string.substring(1));
                        }
                        return layout2;
                    }
                    case ',': {
                        Layout.parseCell(layout, string.substring(1));
                        return layout2;
                    }
                }
                throw new IllegalArgumentException("Unexpected '" + string.charAt(0) + "'");
            }
            throw new IllegalArgumentException("Bad syntax");
        }

        static enum Type {
            LeftRight,
            TopBottom,
            WindowPane;

        }
    }

    static enum Binding {
        Discard,
        SelfInsert,
        Mouse;

    }
}

