/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.builtins.Options;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public class TTop {
    public static final String STAT_UPTIME = "uptime";
    public static final String STAT_TID = "tid";
    public static final String STAT_NAME = "name";
    public static final String STAT_STATE = "state";
    public static final String STAT_BLOCKED_TIME = "blocked_time";
    public static final String STAT_BLOCKED_COUNT = "blocked_count";
    public static final String STAT_WAITED_TIME = "waited_time";
    public static final String STAT_WAITED_COUNT = "waited_count";
    public static final String STAT_LOCK_NAME = "lock_name";
    public static final String STAT_LOCK_OWNER_ID = "lock_owner_id";
    public static final String STAT_LOCK_OWNER_NAME = "lock_owner_name";
    public static final String STAT_USER_TIME = "user_time";
    public static final String STAT_USER_TIME_PERC = "user_time_perc";
    public static final String STAT_CPU_TIME = "cpu_time";
    public static final String STAT_CPU_TIME_PERC = "cpu_time_perc";
    public List<String> sort;
    public long delay;
    public List<String> stats;
    public int nthreads;
    private final Map<String, Column> columns = new LinkedHashMap<String, Column>();
    private final Terminal terminal;
    private final Display display;
    private final BindingReader bindingReader;
    private final KeyMap<Operation> keys;
    private final Size size = new Size();
    private Comparator<Map<String, Comparable<?>>> comparator;
    private Map<Long, Map<String, Object>> previous = new HashMap<Long, Map<String, Object>>();
    private Map<Long, Map<String, Long>> changes = new HashMap<Long, Map<String, Long>>();
    private Map<String, Integer> widths = new HashMap<String, Integer>();

    public static void ttop(Terminal terminal, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"ttop -  display and update sorted information about threads", "Usage: ttop [OPTIONS]", "  -? --help                    Show help", "  -o --order=ORDER             Comma separated list of sorting keys", "  -t --stats=STATS             Comma separated list of stats to display", "  -s --seconds=SECONDS         Delay between updates in seconds", "  -m --millis=MILLIS           Delay between updates in milliseconds", "  -n --nthreads=NTHREADS       Only display up to NTHREADS threads"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        TTop tTop = new TTop(terminal);
        tTop.sort = options.isSet("order") ? Arrays.asList(options.get("order").split(",")) : null;
        tTop.delay = options.isSet("seconds") ? (long)(options.getNumber("seconds") * 1000) : tTop.delay;
        tTop.delay = options.isSet("millis") ? (long)options.getNumber("millis") : tTop.delay;
        tTop.stats = options.isSet("stats") ? Arrays.asList(options.get("stats").split(",")) : null;
        tTop.nthreads = options.isSet("nthreads") ? options.getNumber("nthreads") : tTop.nthreads;
        tTop.run();
    }

    public TTop(Terminal terminal) {
        this.terminal = terminal;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00%", decimalFormatSymbols);
        this.register(STAT_TID, Align.Right, "TID", object -> String.format("%3d", (Long)object));
        this.register(STAT_NAME, Align.Left, "NAME", TTop.padcut(40));
        this.register(STAT_STATE, Align.Left, "STATE", object -> object.toString().toLowerCase());
        this.register(STAT_BLOCKED_TIME, Align.Right, "T-BLOCKED", object -> TTop.millis((Long)object));
        this.register(STAT_BLOCKED_COUNT, Align.Right, "#-BLOCKED", Object::toString);
        this.register(STAT_WAITED_TIME, Align.Right, "T-WAITED", object -> TTop.millis((Long)object));
        this.register(STAT_WAITED_COUNT, Align.Right, "#-WAITED", Object::toString);
        this.register(STAT_LOCK_NAME, Align.Left, "LOCK-NAME", Object::toString);
        this.register(STAT_LOCK_OWNER_ID, Align.Right, "LOCK-OWNER-ID", object -> (Long)object >= 0L ? object.toString() : "");
        this.register(STAT_LOCK_OWNER_NAME, Align.Left, "LOCK-OWNER-NAME", object -> object != null ? object.toString() : "");
        this.register(STAT_USER_TIME, Align.Right, "T-USR", object -> TTop.nanos((Long)object));
        this.register(STAT_CPU_TIME, Align.Right, "T-CPU", object -> TTop.nanos((Long)object));
        this.register(STAT_USER_TIME_PERC, Align.Right, "%-USR", decimalFormat::format);
        this.register(STAT_CPU_TIME_PERC, Align.Right, "%-CPU", decimalFormat::format);
        this.keys = new KeyMap();
        this.bindKeys(this.keys);
    }

    public KeyMap<Operation> getKeys() {
        return this.keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.comparator = this.buildComparator(this.sort);
        long l = this.delay = this.delay > 0L ? Math.max(this.delay, 100L) : 1000L;
        if (this.stats == null || this.stats.isEmpty()) {
            this.stats = Arrays.asList(STAT_TID, STAT_NAME, STAT_STATE, STAT_CPU_TIME, STAT_LOCK_OWNER_ID);
        }
        Boolean bl = null;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (this.stats.contains(STAT_BLOCKED_TIME) || this.stats.contains(STAT_BLOCKED_COUNT) || this.stats.contains(STAT_WAITED_TIME) || this.stats.contains(STAT_WAITED_COUNT)) {
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                bl = threadMXBean.isThreadContentionMonitoringEnabled();
                if (!bl.booleanValue()) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
            } else {
                this.stats.removeAll(Arrays.asList(STAT_BLOCKED_TIME, STAT_BLOCKED_COUNT, STAT_WAITED_TIME, STAT_WAITED_COUNT));
            }
        }
        Boolean bl2 = null;
        if (this.stats.contains(STAT_USER_TIME) || this.stats.contains(STAT_CPU_TIME)) {
            if (threadMXBean.isThreadCpuTimeSupported()) {
                bl2 = threadMXBean.isThreadCpuTimeEnabled();
                if (!bl2.booleanValue()) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                }
            } else {
                this.stats.removeAll(Arrays.asList(STAT_USER_TIME, STAT_CPU_TIME));
            }
        }
        this.size.copy(this.terminal.getSize());
        Terminal.SignalHandler signalHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
        Attributes attributes = this.terminal.enterRawMode();
        try {
            Operation operation;
            this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.terminal.writer().flush();
            long l2 = System.currentTimeMillis();
            do {
                this.display();
                this.checkInterrupted();
                operation = null;
                long l3 = ((System.currentTimeMillis() - l2) / this.delay + 1L) * this.delay + l2 - System.currentTimeMillis();
                int n = this.bindingReader.peekCharacter(l3);
                if (n == -1) {
                    operation = Operation.EXIT;
                } else if (n != -2) {
                    operation = this.bindingReader.readBinding(this.keys, null, false);
                }
                if (operation == null) continue;
                switch (operation) {
                    case INCREASE_DELAY: {
                        this.delay *= 2L;
                        l2 = System.currentTimeMillis();
                        break;
                    }
                    case DECREASE_DELAY: {
                        this.delay = Math.max(this.delay / 2L, 16L);
                        l2 = System.currentTimeMillis();
                        break;
                    }
                    case CLEAR: {
                        this.display.clear();
                        break;
                    }
                    case REVERSE: {
                        this.comparator = this.comparator.reversed();
                    }
                }
            } while (operation != Operation.EXIT);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.terminal.setAttributes(attributes);
            if (signalHandler != null) {
                this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
            }
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            this.terminal.writer().flush();
            if (bl != null) {
                threadMXBean.setThreadContentionMonitoringEnabled(bl);
            }
            if (bl2 != null) {
                threadMXBean.setThreadCpuTimeEnabled(bl2);
            }
        }
    }

    private void handle(Terminal.Signal signal) {
        int n = this.size.getColumns();
        this.size.copy(this.terminal.getSize());
        try {
            if (this.size.getColumns() < n) {
                this.display.clear();
            }
            this.display();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<Map<String, Comparable<?>>> infos() {
        long l2 = ManagementFactory.getRuntimeMXBean().getUptime();
        Long l3 = this.previous.computeIfAbsent(-1L, l -> new HashMap()).put(STAT_UPTIME, l2);
        long l4 = l3 != null ? l2 - l3 : 0L;
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(false, false);
        ArrayList arrayList = new ArrayList();
        for (ThreadInfo threadInfo : threadInfoArray) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(STAT_TID, threadInfo.getThreadId());
            hashMap.put(STAT_NAME, threadInfo.getThreadName());
            hashMap.put(STAT_STATE, (Object)threadInfo.getThreadState());
            if (threadMXBean.isThreadContentionMonitoringEnabled()) {
                hashMap.put(STAT_BLOCKED_TIME, threadInfo.getBlockedTime());
                hashMap.put(STAT_BLOCKED_COUNT, threadInfo.getBlockedCount());
                hashMap.put(STAT_WAITED_TIME, threadInfo.getWaitedTime());
                hashMap.put(STAT_WAITED_COUNT, threadInfo.getWaitedCount());
            }
            hashMap.put(STAT_LOCK_NAME, threadInfo.getLockName());
            hashMap.put(STAT_LOCK_OWNER_ID, threadInfo.getLockOwnerId());
            hashMap.put(STAT_LOCK_OWNER_NAME, threadInfo.getLockOwnerName());
            if (threadMXBean.isThreadCpuTimeSupported() && threadMXBean.isThreadCpuTimeEnabled()) {
                long l5 = threadInfo.getThreadId();
                long l6 = threadMXBean.getThreadCpuTime(l5);
                long l7 = this.previous.computeIfAbsent(l5, l -> new HashMap()).getOrDefault(STAT_CPU_TIME, l6);
                hashMap.put(STAT_CPU_TIME, l6);
                hashMap.put(STAT_CPU_TIME_PERC, l4 != 0L ? (double)(l6 - l7) / ((double)l4 * 1000000.0) : 0.0);
                l6 = threadMXBean.getThreadUserTime(l5);
                l7 = this.previous.computeIfAbsent(l5, l -> new HashMap()).getOrDefault(STAT_USER_TIME, l6);
                hashMap.put(STAT_USER_TIME, l6);
                hashMap.put(STAT_USER_TIME_PERC, l4 != 0L ? (double)(l6 - l7) / ((double)l4 * 1000000.0) : 0.0);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    private void align(AttributedStringBuilder attributedStringBuilder, String string, int n, Align align) {
        if (align == Align.Left) {
            attributedStringBuilder.append(string);
            for (int i = 0; i < n - string.length(); ++i) {
                attributedStringBuilder.append(' ');
            }
        } else {
            for (int i = 0; i < n - string.length(); ++i) {
                attributedStringBuilder.append(' ');
            }
            attributedStringBuilder.append(string);
        }
    }

    private void display() {
        ArrayList<String> arrayList;
        long l2 = System.currentTimeMillis();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        ArrayList<AttributedString> arrayList2 = new ArrayList<AttributedString>();
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder(this.size.getColumns());
        attributedStringBuilder.style(attributedStringBuilder.style().bold());
        attributedStringBuilder.append("ttop");
        attributedStringBuilder.style(attributedStringBuilder.style().boldOff());
        attributedStringBuilder.append(" - ");
        attributedStringBuilder.append(String.format("%8tT", new Date()));
        attributedStringBuilder.append(".");
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        String string = "OS: " + operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + ", " + operatingSystemMXBean.getArch() + ", " + operatingSystemMXBean.getAvailableProcessors() + " cpus.";
        if (attributedStringBuilder.length() + 1 + string.length() < this.size.getColumns()) {
            attributedStringBuilder.append(" ");
        } else {
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        attributedStringBuilder.append(string);
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        String string2 = "Classes: " + classLoadingMXBean.getLoadedClassCount() + " loaded, " + classLoadingMXBean.getUnloadedClassCount() + " unloaded, " + classLoadingMXBean.getTotalLoadedClassCount() + " loaded total.";
        if (attributedStringBuilder.length() + 1 + string2.length() < this.size.getColumns()) {
            attributedStringBuilder.append(" ");
        } else {
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        attributedStringBuilder.append(string2);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        String string3 = "Threads: " + threadMXBean.getThreadCount() + ", peak: " + threadMXBean.getPeakThreadCount() + ", started: " + threadMXBean.getTotalStartedThreadCount() + ".";
        if (attributedStringBuilder.length() + 1 + string3.length() < this.size.getColumns()) {
            attributedStringBuilder.append(" ");
        } else {
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        attributedStringBuilder.append(string3);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        String string4 = "Memory: heap: " + TTop.memory(memoryMXBean.getHeapMemoryUsage().getUsed(), memoryMXBean.getHeapMemoryUsage().getMax()) + ", non heap: " + TTop.memory(memoryMXBean.getNonHeapMemoryUsage().getUsed(), memoryMXBean.getNonHeapMemoryUsage().getMax()) + ".";
        if (attributedStringBuilder.length() + 1 + string4.length() < this.size.getColumns()) {
            attributedStringBuilder.append(" ");
        } else {
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        attributedStringBuilder.append(string4);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GC: ");
        boolean bl = true;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            long l3 = garbageCollectorMXBean.getCollectionCount();
            long l4 = garbageCollectorMXBean.getCollectionTime();
            stringBuilder.append(garbageCollectorMXBean.getName()).append(": ").append(Long.toString(l3)).append(" col. / ").append(String.format("%d", l4 / 1000L)).append(".").append(String.format("%03d", l4 % 1000L)).append(" s");
        }
        stringBuilder.append(".");
        if (attributedStringBuilder.length() + 1 + stringBuilder.length() < this.size.getColumns()) {
            attributedStringBuilder.append(" ");
        } else {
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        attributedStringBuilder.append(stringBuilder);
        arrayList2.add(attributedStringBuilder.toAttributedString());
        attributedStringBuilder.setLength(0);
        arrayList2.add(attributedStringBuilder.toAttributedString());
        List<Map<String, Comparable<?>>> list = this.infos();
        Collections.sort(list, this.comparator);
        int n = Math.min(this.size.getRows() - arrayList2.size() - 2, this.nthreads > 0 ? this.nthreads : list.size());
        List list2 = list.subList(0, n).stream().map(map -> this.stats.stream().collect(Collectors.toMap(Function.identity(), string -> this.columns.get((Object)string).format.apply(map.get(string))))).collect(Collectors.toList());
        for (String string5 : this.stats) {
            int n2 = list2.stream().mapToInt(map -> ((String)map.get(string5)).length()).max().orElse(0);
            this.widths.put(string5, Math.max(this.columns.get((Object)string5).header.length(), Math.max(n2, this.widths.getOrDefault(string5, 0))));
        }
        if (this.widths.values().stream().mapToInt(Integer::intValue).sum() + this.stats.size() - 1 < this.size.getColumns()) {
            arrayList = this.stats;
        } else {
            arrayList = new ArrayList<String>();
            int n3 = 0;
            for (String object : this.stats) {
                int n2 = n3;
                if (n2 > 0) {
                    ++n2;
                }
                if ((n2 += this.widths.get(object).intValue()) >= this.size.getColumns()) break;
                n3 = n2;
                arrayList.add(object);
            }
        }
        for (String string6 : arrayList) {
            if (attributedStringBuilder.length() > 0) {
                attributedStringBuilder.append(" ");
            }
            Column column = this.columns.get(string6);
            this.align(attributedStringBuilder, column.header, this.widths.get(string6), column.align);
        }
        arrayList2.add(attributedStringBuilder.toAttributedString());
        attributedStringBuilder.setLength(0);
        for (int i = 0; i < n; ++i) {
            Map map2 = (Map)list.get(i);
            long l3 = (Long)map2.get(STAT_TID);
            for (String string5 : arrayList) {
                long l4;
                if (attributedStringBuilder.length() > 0) {
                    attributedStringBuilder.append(" ");
                }
                Object v = map2.get(string5);
                Object v2 = this.previous.computeIfAbsent(l3, l -> new HashMap()).put(string5, v);
                if (v2 != null && !v2.equals(v)) {
                    this.changes.computeIfAbsent(l3, l -> new HashMap()).put(string5, l2);
                    l4 = l2;
                } else {
                    l4 = this.changes.computeIfAbsent(l3, l -> new HashMap()).getOrDefault(string5, 0L);
                }
                long l5 = this.delay * 24L;
                if (l2 - l4 < l5) {
                    int n3 = (int)((l2 - l4) / (l5 / 24L));
                    attributedStringBuilder.style(attributedStringBuilder.style().foreground(255 - n3).background(9));
                }
                this.align(attributedStringBuilder, (String)((Map)list2.get(i)).get(string5), this.widths.get(string5), this.columns.get((Object)string5).align);
                attributedStringBuilder.style(attributedStringBuilder.style().backgroundOff().foregroundOff());
            }
            arrayList2.add(attributedStringBuilder.toAttributedString());
            attributedStringBuilder.setLength(0);
        }
        this.display.update(arrayList2, 0);
    }

    private Comparator<Map<String, Comparable<?>>> buildComparator(List<String> list) {
        if (list == null || list.isEmpty()) {
            list = Collections.singletonList(STAT_TID);
        }
        Comparator<Map> comparator = null;
        for (String string : list) {
            boolean bl;
            String string2;
            if (string.startsWith("+")) {
                string2 = string.substring(1);
                bl = true;
            } else if (string.startsWith("-")) {
                string2 = string.substring(1);
                bl = false;
            } else {
                string2 = string;
                bl = true;
            }
            if (!this.columns.containsKey(string2)) {
                throw new IllegalArgumentException("Unsupported sort key: " + string2);
            }
            Comparator<Map> comparator2 = Comparator.comparing(map -> (Comparable)map.get(string2));
            if (bl) {
                comparator2 = comparator2.reversed();
            }
            if (comparator != null) {
                comparator = comparator.thenComparing(comparator2);
                continue;
            }
            comparator = comparator2;
        }
        return comparator;
    }

    private void register(String string, Align align, String string2, Function<Object, String> function) {
        this.columns.put(string, new Column(string, align, string2, function));
    }

    private static String nanos(long l) {
        return TTop.millis(l / 1000000L);
    }

    private static String millis(long l) {
        long l2 = l / 1000L;
        l %= 1000L;
        long l3 = l2 / 60L;
        l2 %= 60L;
        long l4 = l3 / 60L;
        l3 %= 60L;
        if (l4 > 0L) {
            return String.format("%d:%02d:%02d.%03d", l4, l3, l2, l);
        }
        if (l3 > 0L) {
            return String.format("%d:%02d.%03d", l3, l2, l);
        }
        return String.format("%d.%03d", l2, l);
    }

    private static Function<Object, String> padcut(int n) {
        return object -> TTop.padcut(object.toString(), n);
    }

    private static String padcut(String string, int n) {
        if (string.length() <= n) {
            StringBuilder stringBuilder = new StringBuilder(n);
            stringBuilder.append(string);
            while (stringBuilder.length() < n) {
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string, 0, n - 3);
        stringBuilder.append("...");
        return stringBuilder.toString();
    }

    private static String memory(long l, long l2) {
        if (l2 > 0L) {
            String string = TTop.humanReadableByteCount(l2, false);
            String string2 = TTop.humanReadableByteCount(l, false);
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2 + 3);
            for (int i = string2.length(); i < string.length(); ++i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2).append(" / ").append(string);
            return stringBuilder.toString();
        }
        return TTop.humanReadableByteCount(l, false);
    }

    private static String humanReadableByteCount(long l, boolean bl) {
        int n;
        int n2 = n = bl ? 1000 : 1024;
        if (l < 1024L) {
            return l + " B";
        }
        int n3 = (int)(Math.log(l) / Math.log(1024.0));
        String string = (bl ? "kMGTPE" : "KMGTPE").charAt(n3 - 1) + (bl ? "" : "i");
        return String.format("%.1f %sB", (double)l / Math.pow(n, n3), string);
    }

    private void checkInterrupted() {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private void bindKeys(KeyMap<Operation> keyMap) {
        keyMap.bind(Operation.HELP, "h", "?");
        keyMap.bind(Operation.EXIT, "q", ":q", "Q", ":Q", "ZZ");
        keyMap.bind(Operation.INCREASE_DELAY, (CharSequence)"+");
        keyMap.bind(Operation.DECREASE_DELAY, (CharSequence)"-");
        keyMap.bind(Operation.CLEAR, (CharSequence)KeyMap.ctrl('L'));
        keyMap.bind(Operation.REVERSE, (CharSequence)"r");
    }

    private static class Column {
        final String name;
        final Align align;
        final String header;
        final Function<Object, String> format;

        Column(String string, Align align, String string2, Function<Object, String> function) {
            this.name = string;
            this.align = align;
            this.header = string2;
            this.format = function;
        }
    }

    public static enum Operation {
        INCREASE_DELAY,
        DECREASE_DELAY,
        HELP,
        EXIT,
        CLEAR,
        REVERSE;

    }

    public static enum Align {
        Left,
        Right;

    }
}

