/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public interface Source {
    public String getName();

    public InputStream read() throws IOException;

    public static class StdInSource
    extends InputStreamSource {
        public StdInSource() {
            this(System.in);
        }

        public StdInSource(InputStream inputStream) {
            super(inputStream, false, null);
        }
    }

    public static class InputStreamSource
    implements Source {
        final InputStream in;
        final String name;

        public InputStreamSource(InputStream inputStream, boolean bl, String string) {
            Objects.requireNonNull(inputStream);
            this.in = bl ? inputStream : new FilterInputStream(inputStream){

                @Override
                public void close() {
                }
            };
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() {
            return this.in;
        }
    }

    public static class PathSource
    implements Source {
        final Path path;
        final String name;

        public PathSource(File file, String string) {
            this(Objects.requireNonNull(file).toPath(), string);
        }

        public PathSource(Path path, String string) {
            this.path = Objects.requireNonNull(path);
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
    }

    public static class URLSource
    implements Source {
        final URL url;
        final String name;

        public URLSource(URL uRL, String string) {
            this.url = Objects.requireNonNull(uRL);
            this.name = string;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream read() {
            return this.url.openStream();
        }
    }
}

