/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.utils.Colors;
import org.jline.utils.WCWidth;

public class ScreenTerminal {
    private int width;
    private int height;
    private long attr;
    private boolean eol;
    private int cx;
    private int cy;
    private long[][] screen;
    private long[][] screen2;
    private State vt100_parse_state = State.None;
    private int vt100_parse_len;
    private int vt100_lastchar;
    private int vt100_parse_func;
    private String vt100_parse_param;
    private boolean vt100_mode_autowrap;
    private boolean vt100_mode_insert;
    private boolean vt100_charset_is_single_shift;
    private boolean vt100_charset_is_graphical;
    private boolean vt100_mode_lfnewline;
    private boolean vt100_mode_origin;
    private boolean vt100_mode_inverse;
    private boolean vt100_mode_cursorkey;
    private boolean vt100_mode_cursor;
    private boolean vt100_mode_alt_screen;
    private boolean vt100_mode_backspace;
    private boolean vt100_mode_column_switch;
    private boolean vt100_keyfilter_escape;
    private int[] vt100_charset_graph = new int[]{9674, 8230, 8226, 63, 182, 63, 176, 177, 63, 63, 43, 43, 43, 43, 43, 175, 8212, 8212, 8212, 95, 43, 43, 43, 43, 124, 8804, 8805, 182, 8800, 163, 183, 127};
    private int vt100_charset_g_sel;
    private int[] vt100_charset_g = new int[]{0, 0};
    private Map<String, Object> vt100_saved;
    private Map<String, Object> vt100_saved2;
    private int vt100_alternate_saved_cx;
    private int vt100_alternate_saved_cy;
    private int vt100_saved_cx;
    private int vt100_saved_cy;
    private String vt100_out;
    private int scroll_area_y0;
    private int scroll_area_y1;
    private List<Integer> tab_stops;
    private final List<long[]> history = new ArrayList<long[]>();
    private AtomicBoolean dirty = new AtomicBoolean(true);

    public ScreenTerminal() {
        this(80, 24);
    }

    public ScreenTerminal(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.reset_hard();
    }

    private void reset_hard() {
        this.attr = 0L;
        this.vt100_keyfilter_escape = false;
        this.vt100_lastchar = 0;
        this.vt100_parse_len = 0;
        this.vt100_parse_state = State.None;
        this.vt100_parse_func = 0;
        this.vt100_parse_param = "";
        this.vt100_out = "";
        this.reset_screen();
        this.reset_soft();
    }

    private void reset_soft() {
        this.attr = 0L;
        this.scroll_area_y0 = 0;
        this.scroll_area_y1 = this.height;
        this.vt100_charset_is_single_shift = false;
        this.vt100_charset_is_graphical = false;
        this.vt100_charset_g_sel = 0;
        this.vt100_charset_g = new int[]{0, 0};
        this.vt100_mode_insert = false;
        this.vt100_mode_lfnewline = false;
        this.vt100_mode_cursorkey = false;
        this.vt100_mode_column_switch = false;
        this.vt100_mode_inverse = false;
        this.vt100_mode_origin = false;
        this.vt100_mode_autowrap = true;
        this.vt100_mode_cursor = true;
        this.vt100_mode_alt_screen = false;
        this.vt100_mode_backspace = false;
        this.esc_DECSC();
        this.vt100_saved2 = this.vt100_saved;
        this.esc_DECSC();
    }

    private void reset_screen() {
        int n;
        this.screen = (long[][])Array.newInstance(Long.TYPE, this.height, this.width);
        this.screen2 = (long[][])Array.newInstance(Long.TYPE, this.height, this.width);
        for (n = 0; n < this.height; ++n) {
            Arrays.fill(this.screen[n], this.attr | 0x20L);
            Arrays.fill(this.screen2[n], this.attr | 0x20L);
        }
        this.scroll_area_y0 = 0;
        this.scroll_area_y1 = this.height;
        this.cx = 0;
        this.cy = 0;
        this.tab_stops = new ArrayList<Integer>();
        for (n = 7; n < this.width; n += 8) {
            this.tab_stops.add(n);
        }
    }

    private int utf8_charwidth(int n) {
        return WCWidth.wcwidth(n);
    }

    private long[] peek(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.width * (n3 - 1) + n4;
        int n7 = this.width * n + n2;
        int n8 = n6 - n7;
        if (n8 < 0) {
            throw new IllegalArgumentException(n7 + " > " + n6);
        }
        long[] lArray = new long[n8];
        for (int i = n7; i < n6; i += n5) {
            int n9 = i / this.width;
            int n10 = i % this.width;
            n5 = Math.min(this.width - n10, n6 - i);
            System.arraycopy(this.screen[n9], n10, lArray, i - n7, n5);
        }
        return lArray;
    }

    private void poke(int n, int n2, long[] lArray) {
        int n3;
        int n4 = lArray.length;
        for (int i = 0; i < n4; i += n3) {
            n3 = Math.min(this.width - n2, n4 - i);
            System.arraycopy(lArray, 0, this.screen[n++], n2, n3);
            n2 = 0;
        }
        this.setDirty();
    }

    private void fill(int n, int n2, int n3, int n4, long l) {
        if (n == n3 - 1) {
            if (n2 < n4 - 1) {
                Arrays.fill(this.screen[n], n2, n4, l);
                this.setDirty();
            }
        } else if (n < n3 - 1) {
            Arrays.fill(this.screen[n], n2, this.width, l);
            for (int i = n; i < n3 - 1; ++i) {
                Arrays.fill(this.screen[i], l);
            }
            Arrays.fill(this.screen[n3 - 1], 0, n4, l);
            this.setDirty();
        }
    }

    private void clear(int n, int n2, int n3, int n4) {
        this.fill(n, n2, n3, n4, this.attr | 0x20L);
    }

    private void scroll_area_up(int n, int n2) {
        this.scroll_area_up(n, n2, 1);
    }

    private void scroll_area_up(int n, int n2, int n3) {
        n3 = Math.min(n2 - n, n3);
        if (n == 0 && n2 == this.height) {
            int n4;
            for (n4 = 0; n4 < n3; ++n4) {
                this.history.add(this.screen[n4]);
            }
            System.arraycopy(this.screen, n3, this.screen, 0, this.height - n3);
            for (n4 = 1; n4 <= n3; ++n4) {
                this.screen[n2 - n4] = new long[this.width];
                Arrays.fill(this.screen[n2 - 1], this.attr | 0x20L);
            }
        } else {
            this.poke(n, 0, this.peek(n + n3, 0, n2, this.width));
            this.clear(n2 - n3, 0, n2, this.width);
        }
    }

    private void scroll_area_down(int n, int n2) {
        this.scroll_area_down(n, n2, 1);
    }

    private void scroll_area_down(int n, int n2, int n3) {
        n3 = Math.min(n2 - n, n3);
        this.poke(n + n3, 0, this.peek(n, 0, n2 - n3, this.width));
        this.clear(n, 0, n + n3, this.width);
    }

    private void scroll_area_set(int n, int n2) {
        n = Math.max(0, Math.min(this.height - 1, n));
        if ((n2 = Math.max(1, Math.min(this.height, n2))) > n) {
            this.scroll_area_y0 = n;
            this.scroll_area_y1 = n2;
        }
    }

    private void scroll_line_right(int n, int n2) {
        this.scroll_line_right(n, n2, 1);
    }

    private void scroll_line_right(int n, int n2, int n3) {
        if (n2 < this.width) {
            n3 = Math.min(this.width - this.cx, n3);
            this.poke(n, n2 + n3, this.peek(n, n2, n + 1, this.width - n3));
            this.clear(n, n2, n + 1, n2 + n3);
        }
    }

    private void scroll_line_left(int n, int n2) {
        this.scroll_line_left(n, n2, 1);
    }

    private void scroll_line_left(int n, int n2, int n3) {
        if (n2 < this.width) {
            n3 = Math.min(this.width - this.cx, n3);
            this.poke(n, n2, this.peek(n, n2 + n3, n + 1, this.width));
            this.clear(n, this.width - n3, n + 1, this.width);
        }
    }

    private int[] cursor_line_width(int n) {
        int n2 = this.utf8_charwidth(n);
        int n3 = 0;
        for (int i = 0; i < Math.min(this.cx, this.width); ++i) {
            int n4 = (int)(this.peek(this.cy, i, this.cy + 1, i + 1)[0] & 0xFFFFFFFFL);
            n2 += this.utf8_charwidth(n4);
            ++n3;
        }
        return new int[]{n2, n3};
    }

    private void cursor_up() {
        this.cursor_up(1);
    }

    private void cursor_up(int n) {
        this.cy = Math.max(this.scroll_area_y0, this.cy - n);
        this.setDirty();
    }

    private void cursor_down() {
        this.cursor_down(1);
    }

    private void cursor_down(int n) {
        this.cy = Math.min(this.scroll_area_y1 - 1, this.cy + n);
        this.setDirty();
    }

    private void cursor_left() {
        this.cursor_left(1);
    }

    private void cursor_left(int n) {
        this.eol = false;
        this.cx = Math.max(0, this.cx - n);
        this.setDirty();
    }

    private void cursor_right() {
        this.cursor_right(1);
    }

    private void cursor_right(int n) {
        this.eol = this.cx + n >= this.width;
        this.cx = Math.min(this.width - 1, this.cx + n);
        this.setDirty();
    }

    private void cursor_set_x(int n) {
        this.eol = false;
        this.cx = Math.max(0, n);
        this.setDirty();
    }

    private void cursor_set_y(int n) {
        this.cy = Math.max(0, Math.min(this.height - 1, n));
        this.setDirty();
    }

    private void cursor_set(int n, int n2) {
        this.cursor_set_x(n2);
        this.cursor_set_y(n);
    }

    private void ctrl_BS() {
        int n = (this.cx - 1) / this.width;
        this.cursor_set(Math.max(this.scroll_area_y0, this.cy + n), (this.cx - 1) % this.width);
    }

    private void ctrl_HT() {
        this.ctrl_HT(1);
    }

    private void ctrl_HT(int n) {
        if (n > 0 && this.cx >= this.width) {
            return;
        }
        if (n <= 0 && this.cx == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < this.tab_stops.size(); ++i) {
            if (this.cx < this.tab_stops.get(i)) continue;
            n2 = i;
        }
        if ((n2 += n) < this.tab_stops.size() && n2 >= 0) {
            this.cursor_set_x(this.tab_stops.get(n2));
        } else {
            this.cursor_set_x(this.width - 1);
        }
    }

    private void ctrl_LF() {
        if (this.vt100_mode_lfnewline) {
            this.ctrl_CR();
        }
        if (this.cy == this.scroll_area_y1 - 1) {
            this.scroll_area_up(this.scroll_area_y0, this.scroll_area_y1);
        } else {
            this.cursor_down();
        }
    }

    private void ctrl_CR() {
        this.cursor_set_x(0);
    }

    private boolean dumb_write(int n) {
        if (n < 32) {
            if (n == 8) {
                this.ctrl_BS();
            } else if (n == 9) {
                this.ctrl_HT();
            } else if (n >= 10 && n <= 12) {
                this.ctrl_LF();
            } else if (n == 13) {
                this.ctrl_CR();
            }
            return true;
        }
        return false;
    }

    private void dumb_echo(int n) {
        if (this.eol) {
            if (this.vt100_mode_autowrap) {
                this.ctrl_CR();
                this.ctrl_LF();
            } else {
                this.cx = this.cursor_line_width(n)[1] - 1;
            }
        }
        if (this.vt100_mode_insert) {
            this.scroll_line_right(this.cy, this.cx);
        }
        if (this.vt100_charset_is_single_shift) {
            this.vt100_charset_is_single_shift = false;
        } else if (this.vt100_charset_is_graphical && (n & 0xFFE0) == 96) {
            n = this.vt100_charset_graph[n - 96];
        }
        this.poke(this.cy, this.cx, new long[]{this.attr | (long)n});
        this.cursor_right();
    }

    private void vt100_charset_update() {
        this.vt100_charset_is_graphical = this.vt100_charset_g[this.vt100_charset_g_sel] == 2;
    }

    private void vt100_charset_set(int n) {
        this.vt100_charset_g_sel = n;
        this.vt100_charset_update();
    }

    private void vt100_charset_select(int n, int n2) {
        this.vt100_charset_g[n] = n2;
        this.vt100_charset_update();
    }

    private void vt100_setmode(String string, boolean bl) {
        String[] stringArray;
        String[] stringArray2 = stringArray = this.vt100_parse_params(string, new String[0]);
        int n = stringArray2.length;
        block26: for (int i = 0; i < n; ++i) {
            String string2;
            switch (string2 = stringArray2[i]) {
                case "4": {
                    this.vt100_mode_insert = bl;
                    continue block26;
                }
                case "20": {
                    this.vt100_mode_lfnewline = bl;
                    continue block26;
                }
                case "?1": {
                    this.vt100_mode_cursorkey = bl;
                    continue block26;
                }
                case "?3": {
                    if (!this.vt100_mode_column_switch) continue block26;
                    this.width = bl ? 132 : 80;
                    this.reset_screen();
                    continue block26;
                }
                case "?5": {
                    this.vt100_mode_inverse = bl;
                    continue block26;
                }
                case "?6": {
                    this.vt100_mode_origin = bl;
                    if (bl) {
                        this.cursor_set(this.scroll_area_y0, 0);
                        continue block26;
                    }
                    this.cursor_set(0, 0);
                    continue block26;
                }
                case "?7": {
                    this.vt100_mode_autowrap = bl;
                    continue block26;
                }
                case "?25": {
                    this.vt100_mode_cursor = bl;
                    continue block26;
                }
                case "?40": {
                    this.vt100_mode_column_switch = bl;
                    continue block26;
                }
                case "?1049": {
                    if (bl && !this.vt100_mode_alt_screen || !bl && this.vt100_mode_alt_screen) {
                        long[][] lArray = this.screen;
                        this.screen = this.screen2;
                        this.screen2 = lArray;
                        Map<String, Object> map = this.vt100_saved;
                        this.vt100_saved = this.vt100_saved2;
                        this.vt100_saved2 = map;
                        int n2 = this.vt100_alternate_saved_cx;
                        this.vt100_alternate_saved_cx = this.cx;
                        this.cx = Math.min(n2, this.width - 1);
                        n2 = this.vt100_alternate_saved_cy;
                        this.vt100_alternate_saved_cy = this.cy;
                        this.cy = Math.min(n2, this.height - 1);
                    }
                    this.vt100_mode_alt_screen = bl;
                    continue block26;
                }
                case "?67": {
                    this.vt100_mode_backspace = bl;
                }
            }
        }
    }

    private void ctrl_SO() {
        this.vt100_charset_set(1);
    }

    private void ctrl_SI() {
        this.vt100_charset_set(0);
    }

    private void esc_CSI() {
        this.vt100_parse_reset(State.Csi);
    }

    private void esc_DECALN() {
        this.fill(0, 0, this.height, this.width, 16711749L);
    }

    private void esc_G0_0() {
        this.vt100_charset_select(0, 0);
    }

    private void esc_G0_1() {
        this.vt100_charset_select(0, 1);
    }

    private void esc_G0_2() {
        this.vt100_charset_select(0, 2);
    }

    private void esc_G0_3() {
        this.vt100_charset_select(0, 3);
    }

    private void esc_G0_4() {
        this.vt100_charset_select(0, 4);
    }

    private void esc_G1_0() {
        this.vt100_charset_select(1, 0);
    }

    private void esc_G1_1() {
        this.vt100_charset_select(1, 1);
    }

    private void esc_G1_2() {
        this.vt100_charset_select(1, 2);
    }

    private void esc_G1_3() {
        this.vt100_charset_select(1, 3);
    }

    private void esc_G1_4() {
        this.vt100_charset_select(1, 4);
    }

    private void esc_DECSC() {
        this.vt100_saved = new HashMap<String, Object>();
        this.vt100_saved.put("cx", this.cx);
        this.vt100_saved.put("cy", this.cy);
        this.vt100_saved.put("attr", this.attr);
        this.vt100_saved.put("vt100_charset_g_sel", this.vt100_charset_g_sel);
        this.vt100_saved.put("vt100_charset_g", this.vt100_charset_g);
        this.vt100_saved.put("vt100_mode_autowrap", this.vt100_mode_autowrap);
        this.vt100_saved.put("vt100_mode_origin", this.vt100_mode_origin);
    }

    private void esc_DECRC() {
        this.cx = (Integer)this.vt100_saved.get("cx");
        this.cy = (Integer)this.vt100_saved.get("cy");
        this.attr = (Long)this.vt100_saved.get("attr");
        this.vt100_charset_g_sel = (Integer)this.vt100_saved.get("vt100_charset_g_sel");
        this.vt100_charset_g = (int[])this.vt100_saved.get("vt100_charset_g");
        this.vt100_charset_update();
        this.vt100_mode_autowrap = (Boolean)this.vt100_saved.get("vt100_mode_autowrap");
        this.vt100_mode_origin = (Boolean)this.vt100_saved.get("vt100_mode_origin");
    }

    private void esc_IND() {
        this.ctrl_LF();
    }

    private void esc_NEL() {
        this.ctrl_CR();
        this.ctrl_LF();
    }

    private void esc_HTS() {
        this.csi_CTC("0");
    }

    private void esc_RI() {
        if (this.cy == this.scroll_area_y0) {
            this.scroll_area_down(this.scroll_area_y0, this.scroll_area_y1);
        } else {
            this.cursor_up();
        }
    }

    private void esc_SS2() {
        this.vt100_charset_is_single_shift = true;
    }

    private void esc_SS3() {
        this.vt100_charset_is_single_shift = true;
    }

    private void esc_DCS() {
        this.vt100_parse_reset(State.Str);
    }

    private void esc_SOS() {
        this.vt100_parse_reset(State.Str);
    }

    private void esc_DECID() {
        this.csi_DA("0");
    }

    private void esc_ST() {
    }

    private void esc_OSC() {
        this.vt100_parse_reset(State.Str);
    }

    private void esc_PM() {
        this.vt100_parse_reset(State.Str);
    }

    private void esc_APC() {
        this.vt100_parse_reset(State.Str);
    }

    private void esc_RIS() {
        this.reset_hard();
    }

    private void csi_ICH(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.scroll_line_right(this.cy, this.cx, nArray[0]);
    }

    private void csi_CUU(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_up(Math.max(1, nArray[0]));
    }

    private void csi_CUD(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_down(Math.max(1, nArray[0]));
    }

    private void csi_CUF(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_right(Math.max(1, nArray[0]));
    }

    private void csi_CUB(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_left(Math.max(1, nArray[0]));
    }

    private void csi_CNL(String string) {
        this.csi_CUD(string);
        this.ctrl_CR();
    }

    private void csi_CPL(String string) {
        this.csi_CUU(string);
        this.ctrl_CR();
    }

    private void csi_CHA(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_set_x(nArray[0] - 1);
    }

    private void csi_CUP(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1, 1});
        if (this.vt100_mode_origin) {
            this.cursor_set(this.scroll_area_y0 + nArray[0] - 1, nArray[1] - 1);
        } else {
            this.cursor_set(nArray[0] - 1, nArray[1] - 1);
        }
    }

    private void csi_CHT(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.ctrl_HT(Math.max(1, nArray[0]));
    }

    private void csi_ED(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[]{"0"});
        if ("0".equals(stringArray[0])) {
            this.clear(this.cy, this.cx, this.height, this.width);
        } else if ("1".equals(stringArray[0])) {
            this.clear(0, 0, this.cy + 1, this.cx + 1);
        } else if ("2".equals(stringArray[0])) {
            this.clear(0, 0, this.height, this.width);
        }
    }

    private void csi_EL(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[]{"0"});
        if ("0".equals(stringArray[0])) {
            this.clear(this.cy, this.cx, this.cy + 1, this.width);
        } else if ("1".equals(stringArray[0])) {
            this.clear(this.cy, 0, this.cy + 1, this.cx + 1);
        } else if ("2".equals(stringArray[0])) {
            this.clear(this.cy, 0, this.cy + 1, this.width);
        }
    }

    private void csi_IL(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        if (this.cy >= this.scroll_area_y0 && this.cy < this.scroll_area_y1) {
            this.scroll_area_down(this.cy, this.scroll_area_y1, Math.max(1, nArray[0]));
        }
    }

    private void csi_DL(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        if (this.cy >= this.scroll_area_y0 && this.cy < this.scroll_area_y1) {
            this.scroll_area_up(this.cy, this.scroll_area_y1, Math.max(1, nArray[0]));
        }
    }

    private void csi_DCH(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.scroll_line_left(this.cy, this.cx, Math.max(1, nArray[0]));
    }

    private void csi_SU(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.scroll_area_up(this.scroll_area_y0, this.scroll_area_y1, Math.max(1, nArray[0]));
    }

    private void csi_SD(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.scroll_area_down(this.scroll_area_y0, this.scroll_area_y1, Math.max(1, nArray[0]));
    }

    private void csi_CTC(String string) {
        String[] stringArray;
        for (String string2 : stringArray = this.vt100_parse_params(string, new String[]{"0"})) {
            if ("0".equals(string2)) {
                if (this.tab_stops.indexOf(this.cx) >= 0) continue;
                this.tab_stops.add(this.cx);
                Collections.sort(this.tab_stops);
                continue;
            }
            if ("2".equals(string2)) {
                this.tab_stops.remove((Object)this.cx);
                continue;
            }
            if (!"5".equals(string2)) continue;
            this.tab_stops = new ArrayList<Integer>();
        }
    }

    private void csi_ECH(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        int n = Math.min(this.width - this.cx, Math.max(1, nArray[0]));
        this.clear(this.cy, this.cx, this.cy + 1, this.cx + n);
    }

    private void csi_CBT(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.ctrl_HT(1 - Math.max(1, nArray[0]));
    }

    private void csi_HPA(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_set_x(nArray[0] - 1);
    }

    private void csi_HPR(String string) {
        this.csi_CUF(string);
    }

    private void csi_REP(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        if (this.vt100_lastchar < 32) {
            return;
        }
        int n = Math.min(2000, Math.max(1, nArray[0]));
        while (n-- > 0) {
            this.dumb_echo(this.vt100_lastchar);
        }
        this.vt100_lastchar = 0;
    }

    private void csi_DA(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[]{"0"});
        if ("0".equals(stringArray[0])) {
            this.vt100_out = "\u001b[?1;2c";
        } else if (">0".equals(stringArray[0]) || ">".equals(stringArray[0])) {
            this.vt100_out = "\u001b[>0;184;0c";
        }
    }

    private void csi_VPA(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1});
        this.cursor_set_y(nArray[0] - 1);
    }

    private void csi_VPR(String string) {
        this.csi_CUD(string);
    }

    private void csi_HVP(String string) {
        this.csi_CUP(string);
    }

    private void csi_TBC(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[]{"0"});
        if ("0".equals(stringArray[0])) {
            this.csi_CTC("2");
        } else if ("3".equals(stringArray[0])) {
            this.csi_CTC("5");
        }
    }

    private void csi_SM(String string) {
        this.vt100_setmode(string, true);
    }

    private void csi_RM(String string) {
        this.vt100_setmode(string, false);
    }

    private void csi_SGR(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{0});
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n == 0) {
                this.attr = 0L;
                continue;
            }
            if (n == 1) {
                this.attr |= 0x800000000000000L;
                continue;
            }
            if (n == 4) {
                this.attr |= 0x100000000000000L;
                continue;
            }
            if (n == 7) {
                this.attr |= 0x200000000000000L;
                continue;
            }
            if (n == 8) {
                this.attr |= 0x400000000000000L;
                continue;
            }
            if (n == 21) {
                this.attr &= 0xF7FFFFFF00000000L;
                continue;
            }
            if (n == 24) {
                this.attr &= 0xFEFFFFFF00000000L;
                continue;
            }
            if (n == 27) {
                this.attr &= 0xFDFFFFFF00000000L;
                continue;
            }
            if (n == 28) {
                this.attr &= 0xFBFFFFFF00000000L;
                continue;
            }
            if (n >= 30 && n <= 37) {
                this.attr = this.attr & 0xEF000FFF00000000L | 0x1000000000000000L | this.col24(n - 30) << 44;
                continue;
            }
            if (n == 38) {
                int n2 = n = ++i < nArray.length ? nArray[i] : 0;
                if (n != 5) continue;
                n = ++i < nArray.length ? nArray[i] : 0;
                this.attr = this.attr & 0xEF000FFF00000000L | 0x1000000000000000L | this.col24(n) << 44;
                continue;
            }
            if (n == 39) {
                this.attr &= 0xEF000FFF00000000L;
                continue;
            }
            if (n >= 40 && n <= 47) {
                this.attr = this.attr & 0xDFFFF00000000000L | 0x2000000000000000L | this.col24(n - 40) << 32;
                continue;
            }
            if (n == 48) {
                int n3 = n = ++i < nArray.length ? nArray[i] : 0;
                if (n != 5) continue;
                n = ++i < nArray.length ? nArray[i] : 0;
                this.attr = this.attr & 0xDFFFF00000000000L | 0x2000000000000000L | this.col24(n) << 32;
                continue;
            }
            if (n == 49) {
                this.attr &= 0xDF000FFF00000000L;
                continue;
            }
            if (n >= 90 && n <= 97) {
                this.attr = this.attr & 0xEF000FFF00000000L | 0x1000000000000000L | this.col24(n - 90 + 8) << 44;
                continue;
            }
            if (n < 100 || n > 107) continue;
            this.attr = this.attr & 0xDFFFF00000000000L | 0x2000000000000000L | this.col24(n - 100 + 8) << 32;
        }
    }

    private long col24(int n) {
        int n2 = Colors.rgbColor(n);
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 >> 0 & 0xFF;
        return n3 >> 4 << 8 | n4 >> 4 << 4 | n5 >> 4 << 0;
    }

    private void csi_DSR(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[]{"0"});
        if ("5".equals(stringArray[0])) {
            this.vt100_out = "\u001b[0n";
        } else if ("6".equals(stringArray[0])) {
            this.vt100_out = "\u001b[" + (this.cy + 1) + ";" + (this.cx + 1) + "R";
        } else if ("7".equals(stringArray[0])) {
            this.vt100_out = "gogo-term";
        } else if ("8".equals(stringArray[0])) {
            this.vt100_out = "1.0-SNAPSHOT";
        } else if ("?6".equals(stringArray[0])) {
            this.vt100_out = "\u001b[" + (this.cy + 1) + ";" + (this.cx + 1) + ";0R";
        } else if ("?15".equals(stringArray[0])) {
            this.vt100_out = "\u001b[?13n";
        } else if ("?25".equals(stringArray[0])) {
            this.vt100_out = "\u001b[?20n";
        } else if ("?26".equals(stringArray[0])) {
            this.vt100_out = "\u001b[?27;1n";
        } else if ("?53".equals(stringArray[0])) {
            this.vt100_out = "\u001b[?53n";
        }
    }

    private void csi_DECSTBM(String string) {
        int[] nArray = this.vt100_parse_params(string, new int[]{1, this.height});
        this.scroll_area_set(nArray[0] - 1, nArray[1]);
        if (this.vt100_mode_origin) {
            this.cursor_set(this.scroll_area_y0, 0);
        } else {
            this.cursor_set(0, 0);
        }
    }

    private void csi_SCP(String string) {
        this.vt100_saved_cx = this.cx;
        this.vt100_saved_cy = this.cy;
    }

    private void csi_RCP(String string) {
        this.cx = this.vt100_saved_cx;
        this.cy = this.vt100_saved_cy;
    }

    private void csi_DECREQTPARM(String string) {
        String[] stringArray = this.vt100_parse_params(string, new String[0]);
        if ("0".equals(stringArray[0])) {
            this.vt100_out = "\u001b[2;1;1;112;112;1;0x";
        } else if ("1".equals(stringArray[0])) {
            this.vt100_out = "\u001b[3;1;1;112;112;1;0x";
        }
    }

    private void csi_DECSTR(String string) {
        this.reset_soft();
    }

    private String[] vt100_parse_params(String string, String[] stringArray) {
        String string2 = "";
        if (string.length() > 0 && string.charAt(0) >= '<' && string.charAt(0) <= '?') {
            string2 = "" + string.charAt(0);
            string = string.substring(1);
        }
        String[] stringArray2 = string.split(";");
        int n = Math.max(stringArray2.length, stringArray.length);
        String[] stringArray3 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string3 = null;
            if (i < stringArray2.length && stringArray2[i].length() > 0) {
                string3 = string2 + stringArray2[i];
            }
            if (string3 == null && i < stringArray.length) {
                string3 = stringArray[i];
            }
            if (string3 == null) {
                string3 = "";
            }
            stringArray3[i] = string3;
        }
        return stringArray3;
    }

    private int[] vt100_parse_params(String string, int[] nArray) {
        String string2 = "";
        String string3 = string = string == null ? "" : string;
        if (string.length() > 0 && string.charAt(0) >= '<' && string.charAt(0) <= '?') {
            string2 = string.substring(0, 1);
            string = string.substring(1);
        }
        String[] stringArray = string.split(";");
        int n = Math.max(stringArray.length, nArray.length);
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            Integer n2 = null;
            if (i < stringArray.length) {
                String string4 = string2 + stringArray[i];
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n2 == null && i < nArray.length) {
                n2 = nArray[i];
            }
            if (n2 == null) {
                n2 = 0;
            }
            nArray2[i] = n2;
        }
        return nArray2;
    }

    private void vt100_parse_reset() {
        this.vt100_parse_reset(State.None);
    }

    private void vt100_parse_reset(State state) {
        this.vt100_parse_state = state;
        this.vt100_parse_len = 0;
        this.vt100_parse_func = 0;
        this.vt100_parse_param = "";
    }

    private void vt100_parse_process() {
        if (this.vt100_parse_state == State.Esc) {
            switch (this.vt100_parse_func) {
                case 54: {
                    break;
                }
                case 55: {
                    this.esc_DECSC();
                    break;
                }
                case 56: {
                    this.esc_DECRC();
                    break;
                }
                case 66: {
                    break;
                }
                case 67: {
                    break;
                }
                case 68: {
                    this.esc_IND();
                    break;
                }
                case 69: {
                    this.esc_NEL();
                    break;
                }
                case 70: {
                    this.esc_NEL();
                    break;
                }
                case 72: {
                    this.esc_HTS();
                    break;
                }
                case 73: {
                    break;
                }
                case 74: {
                    break;
                }
                case 75: {
                    break;
                }
                case 76: {
                    break;
                }
                case 77: {
                    this.esc_RI();
                    break;
                }
                case 78: {
                    this.esc_SS2();
                    break;
                }
                case 79: {
                    this.esc_SS3();
                    break;
                }
                case 80: {
                    this.esc_DCS();
                    break;
                }
                case 81: {
                    break;
                }
                case 82: {
                    break;
                }
                case 83: {
                    break;
                }
                case 84: {
                    break;
                }
                case 85: {
                    break;
                }
                case 86: {
                    break;
                }
                case 87: {
                    break;
                }
                case 88: {
                    this.esc_SOS();
                    break;
                }
                case 90: {
                    break;
                }
                case 91: {
                    this.esc_CSI();
                    break;
                }
                case 92: {
                    this.esc_ST();
                    break;
                }
                case 93: {
                    this.esc_OSC();
                    break;
                }
                case 94: {
                    this.esc_PM();
                    break;
                }
                case 95: {
                    this.esc_APC();
                    break;
                }
                case 96: {
                    break;
                }
                case 97: {
                    break;
                }
                case 98: {
                    break;
                }
                case 99: {
                    this.esc_RIS();
                    break;
                }
                case 100: {
                    break;
                }
                case 108: {
                    break;
                }
                case 110: {
                    break;
                }
                case 111: {
                    break;
                }
                case 124: {
                    break;
                }
                case 125: {
                    break;
                }
                case 126: {
                    break;
                }
                case 9016: {
                    this.esc_DECALN();
                    break;
                }
                case 10305: {
                    this.esc_G0_0();
                    break;
                }
                case 10306: {
                    this.esc_G0_1();
                    break;
                }
                case 10288: {
                    this.esc_G0_2();
                    break;
                }
                case 10289: {
                    this.esc_G0_3();
                    break;
                }
                case 10290: {
                    this.esc_G0_4();
                    break;
                }
                case 10544: {
                    this.esc_G1_2();
                    break;
                }
                case 10545: {
                    this.esc_G1_3();
                    break;
                }
                case 10546: {
                    this.esc_G1_4();
                    break;
                }
                case 10561: {
                    this.esc_G1_0();
                    break;
                }
                case 10562: {
                    this.esc_G1_1();
                }
            }
            if (this.vt100_parse_state == State.Esc) {
                this.vt100_parse_reset();
            }
        } else {
            switch (this.vt100_parse_func) {
                case 64: {
                    this.csi_ICH(this.vt100_parse_param);
                    break;
                }
                case 65: {
                    this.csi_CUU(this.vt100_parse_param);
                    break;
                }
                case 66: {
                    this.csi_CUD(this.vt100_parse_param);
                    break;
                }
                case 67: {
                    this.csi_CUF(this.vt100_parse_param);
                    break;
                }
                case 68: {
                    this.csi_CUB(this.vt100_parse_param);
                    break;
                }
                case 69: {
                    this.csi_CNL(this.vt100_parse_param);
                    break;
                }
                case 70: {
                    this.csi_CPL(this.vt100_parse_param);
                    break;
                }
                case 71: {
                    this.csi_CHA(this.vt100_parse_param);
                    break;
                }
                case 72: {
                    this.csi_CUP(this.vt100_parse_param);
                    break;
                }
                case 73: {
                    this.csi_CHT(this.vt100_parse_param);
                    break;
                }
                case 74: {
                    this.csi_ED(this.vt100_parse_param);
                    break;
                }
                case 75: {
                    this.csi_EL(this.vt100_parse_param);
                    break;
                }
                case 76: {
                    this.csi_IL(this.vt100_parse_param);
                    break;
                }
                case 77: {
                    this.csi_DL(this.vt100_parse_param);
                    break;
                }
                case 78: {
                    break;
                }
                case 79: {
                    break;
                }
                case 80: {
                    this.csi_DCH(this.vt100_parse_param);
                    break;
                }
                case 81: {
                    break;
                }
                case 82: {
                    break;
                }
                case 83: {
                    this.csi_SU(this.vt100_parse_param);
                    break;
                }
                case 84: {
                    this.csi_SD(this.vt100_parse_param);
                    break;
                }
                case 85: {
                    break;
                }
                case 86: {
                    break;
                }
                case 87: {
                    this.csi_CTC(this.vt100_parse_param);
                    break;
                }
                case 88: {
                    this.csi_ECH(this.vt100_parse_param);
                    break;
                }
                case 89: {
                    break;
                }
                case 90: {
                    this.csi_CBT(this.vt100_parse_param);
                    break;
                }
                case 91: {
                    break;
                }
                case 92: {
                    break;
                }
                case 93: {
                    break;
                }
                case 94: {
                    break;
                }
                case 96: {
                    this.csi_HPA(this.vt100_parse_param);
                    break;
                }
                case 97: {
                    this.csi_HPR(this.vt100_parse_param);
                    break;
                }
                case 98: {
                    this.csi_REP(this.vt100_parse_param);
                    break;
                }
                case 99: {
                    this.csi_DA(this.vt100_parse_param);
                    break;
                }
                case 100: {
                    this.csi_VPA(this.vt100_parse_param);
                    break;
                }
                case 101: {
                    this.csi_VPR(this.vt100_parse_param);
                    break;
                }
                case 102: {
                    this.csi_HVP(this.vt100_parse_param);
                    break;
                }
                case 103: {
                    this.csi_TBC(this.vt100_parse_param);
                    break;
                }
                case 104: {
                    this.csi_SM(this.vt100_parse_param);
                    break;
                }
                case 105: {
                    break;
                }
                case 106: {
                    break;
                }
                case 107: {
                    break;
                }
                case 108: {
                    this.csi_RM(this.vt100_parse_param);
                    break;
                }
                case 109: {
                    this.csi_SGR(this.vt100_parse_param);
                    break;
                }
                case 110: {
                    this.csi_DSR(this.vt100_parse_param);
                    break;
                }
                case 111: {
                    break;
                }
                case 114: {
                    this.csi_DECSTBM(this.vt100_parse_param);
                    break;
                }
                case 115: {
                    this.csi_SCP(this.vt100_parse_param);
                    break;
                }
                case 117: {
                    this.csi_RCP(this.vt100_parse_param);
                    break;
                }
                case 120: {
                    this.csi_DECREQTPARM(this.vt100_parse_param);
                    break;
                }
                case 8256: {
                    break;
                }
                case 8257: {
                    break;
                }
                case 8258: {
                    break;
                }
                case 8259: {
                    break;
                }
                case 8260: {
                    break;
                }
                case 8261: {
                    break;
                }
                case 8262: {
                    break;
                }
                case 8263: {
                    break;
                }
                case 8264: {
                    break;
                }
                case 8265: {
                    break;
                }
                case 8266: {
                    break;
                }
                case 8267: {
                    break;
                }
                case 8268: {
                    break;
                }
                case 8269: {
                    break;
                }
                case 8270: {
                    break;
                }
                case 8271: {
                    break;
                }
                case 8272: {
                    break;
                }
                case 8273: {
                    break;
                }
                case 8274: {
                    break;
                }
                case 8275: {
                    break;
                }
                case 8276: {
                    break;
                }
                case 8277: {
                    break;
                }
                case 8278: {
                    break;
                }
                case 8279: {
                    break;
                }
                case 8280: {
                    break;
                }
                case 8281: {
                    break;
                }
                case 8282: {
                    break;
                }
                case 8283: {
                    break;
                }
                case 8284: {
                    break;
                }
                case 8285: {
                    break;
                }
                case 8286: {
                    break;
                }
                case 8287: {
                    break;
                }
                case 8288: {
                    break;
                }
                case 8289: {
                    break;
                }
                case 8290: {
                    break;
                }
                case 8291: {
                    break;
                }
                case 8292: {
                    break;
                }
                case 8293: {
                    break;
                }
                case 8294: {
                    break;
                }
                case 8295: {
                    break;
                }
                case 8296: {
                    break;
                }
                case 8297: {
                    break;
                }
                case 8298: {
                    break;
                }
                case 8299: {
                    break;
                }
                case 8560: {
                    this.csi_DECSTR(this.vt100_parse_param);
                    break;
                }
                case 9330: {
                    break;
                }
            }
            if (this.vt100_parse_state == State.Csi) {
                this.vt100_parse_reset();
            }
        }
    }

    private boolean vt100_write(int n) {
        if (n < 32) {
            if (n == 27) {
                this.vt100_parse_reset(State.Esc);
                return true;
            }
            if (n == 14) {
                this.ctrl_SO();
            } else if (n == 15) {
                this.ctrl_SI();
            }
        } else if ((n & 0xFFE0) == 128) {
            this.vt100_parse_reset(State.Esc);
            this.vt100_parse_func = (char)(n - 64);
            this.vt100_parse_process();
            return true;
        }
        if (this.vt100_parse_state != State.None) {
            if (this.vt100_parse_state == State.Str) {
                if (n >= 32) {
                    return true;
                }
                this.vt100_parse_reset();
            } else if (n < 32) {
                if (n == 24 || n == 26) {
                    this.vt100_parse_reset();
                    return true;
                }
            } else {
                ++this.vt100_parse_len;
                if (this.vt100_parse_len > 32) {
                    this.vt100_parse_reset();
                } else {
                    int n2 = n & 0xF0;
                    if (n2 == 32) {
                        this.vt100_parse_func <<= 8;
                        this.vt100_parse_func += (char)n;
                    } else if (n2 == 48 && this.vt100_parse_state == State.Csi) {
                        this.vt100_parse_param = this.vt100_parse_param + new String(new char[]{(char)n});
                    } else {
                        this.vt100_parse_func <<= 8;
                        this.vt100_parse_func += (char)n;
                        this.vt100_parse_process();
                    }
                    return true;
                }
            }
        }
        this.vt100_lastchar = n;
        return false;
    }

    public boolean isDirty() {
        return this.dirty.compareAndSet(true, false);
    }

    public synchronized void waitDirty() {
        while (!this.dirty.compareAndSet(true, false)) {
            this.wait();
        }
    }

    protected synchronized void setDirty() {
        this.dirty.set(true);
        this.notifyAll();
    }

    public synchronized boolean setSize(int n, int n2) {
        int n3;
        int n4;
        if (n < 2 || n > 256 || n2 < 2 || n2 > 256) {
            return false;
        }
        for (n4 = 0; n4 < this.height; ++n4) {
            if (this.screen[n4].length < n) {
                this.screen[n4] = Arrays.copyOf(this.screen[n4], n);
            }
            if (this.screen2[n4].length >= n) continue;
            this.screen2[n4] = Arrays.copyOf(this.screen2[n4], n);
        }
        if (this.cx >= n) {
            this.cx = n - 1;
        }
        if (n2 < this.height) {
            n4 = this.height - n2;
            n3 = this.height - 1 - this.cy;
            if (n3 > 0) {
                if (n3 > n4) {
                    n3 = n4;
                }
                this.screen = (long[][])Arrays.copyOfRange(this.screen, 0, this.height - n3);
            }
            n4 -= n3;
            for (int i = 0; i < n4; ++i) {
                this.history.add(this.screen[i]);
            }
            this.screen = (long[][])Arrays.copyOfRange(this.screen, n4, this.screen.length);
            this.cy -= n4;
        } else if (n2 > this.height) {
            int n5;
            n4 = n2 - this.height;
            n3 = this.history.size();
            if (n3 > n4) {
                n3 = n4;
            }
            long[][] lArrayArray = new long[n2][];
            if (n3 > 0) {
                for (n5 = 0; n5 < n3; ++n5) {
                    lArrayArray[n5] = this.history.remove(this.history.size() - n3 + n5);
                }
                this.cy += n3;
            }
            System.arraycopy(this.screen, 0, lArrayArray, n3, this.screen.length);
            for (n5 = n3 + this.screen.length; n5 < lArrayArray.length; ++n5) {
                lArrayArray[n5] = new long[n];
                Arrays.fill(lArrayArray[n5], this.attr | 0x20L);
            }
            this.screen = lArrayArray;
        }
        this.screen2 = (long[][])Array.newInstance(Long.TYPE, n2, n);
        for (n4 = 0; n4 < n2; ++n4) {
            Arrays.fill(this.screen2[n4], this.attr | 0x20L);
        }
        this.scroll_area_y0 = Math.min(n2, this.scroll_area_y0);
        this.scroll_area_y1 = this.scroll_area_y1 == this.height ? n2 : Math.min(n2, this.scroll_area_y1);
        this.cx = Math.min(n - 1, this.cx);
        this.cy = Math.min(n2 - 1, this.cy);
        this.width = n;
        this.height = n2;
        this.setDirty();
        return true;
    }

    public synchronized String read() {
        String string = this.vt100_out;
        this.vt100_out = "";
        return string;
    }

    public synchronized String pipe(String string) {
        String string2 = "";
        for (char c : string.toCharArray()) {
            if (this.vt100_keyfilter_escape) {
                this.vt100_keyfilter_escape = false;
                if (this.vt100_mode_cursorkey) {
                    switch (c) {
                        case '~': {
                            string2 = string2 + "~";
                            break;
                        }
                        case 'A': {
                            string2 = string2 + "\u001bOA";
                            break;
                        }
                        case 'B': {
                            string2 = string2 + "\u001bOB";
                            break;
                        }
                        case 'C': {
                            string2 = string2 + "\u001bOC";
                            break;
                        }
                        case 'D': {
                            string2 = string2 + "\u001bOD";
                            break;
                        }
                        case 'F': {
                            string2 = string2 + "\u001bOF";
                            break;
                        }
                        case 'H': {
                            string2 = string2 + "\u001bOH";
                            break;
                        }
                        case '1': {
                            string2 = string2 + "\u001b[5~";
                            break;
                        }
                        case '2': {
                            string2 = string2 + "\u001b[6~";
                            break;
                        }
                        case '3': {
                            string2 = string2 + "\u001b[2~";
                            break;
                        }
                        case '4': {
                            string2 = string2 + "\u001b[3~";
                            break;
                        }
                        case 'a': {
                            string2 = string2 + "\u001bOP";
                            break;
                        }
                        case 'b': {
                            string2 = string2 + "\u001bOQ";
                            break;
                        }
                        case 'c': {
                            string2 = string2 + "\u001bOR";
                            break;
                        }
                        case 'd': {
                            string2 = string2 + "\u001bOS";
                            break;
                        }
                        case 'e': {
                            string2 = string2 + "\u001b[15~";
                            break;
                        }
                        case 'f': {
                            string2 = string2 + "\u001b[17~";
                            break;
                        }
                        case 'g': {
                            string2 = string2 + "\u001b[18~";
                            break;
                        }
                        case 'h': {
                            string2 = string2 + "\u001b[19~";
                            break;
                        }
                        case 'i': {
                            string2 = string2 + "\u001b[20~";
                            break;
                        }
                        case 'j': {
                            string2 = string2 + "\u001b[21~";
                            break;
                        }
                        case 'k': {
                            string2 = string2 + "\u001b[23~";
                            break;
                        }
                        case 'l': {
                            string2 = string2 + "\u001b[24~";
                        }
                    }
                    continue;
                }
                switch (c) {
                    case '~': {
                        string2 = string2 + "~";
                        break;
                    }
                    case 'A': {
                        string2 = string2 + "\u001b[A";
                        break;
                    }
                    case 'B': {
                        string2 = string2 + "\u001b[B";
                        break;
                    }
                    case 'C': {
                        string2 = string2 + "\u001b[C";
                        break;
                    }
                    case 'D': {
                        string2 = string2 + "\u001b[D";
                        break;
                    }
                    case 'F': {
                        string2 = string2 + "\u001b[F";
                        break;
                    }
                    case 'H': {
                        string2 = string2 + "\u001b[H";
                        break;
                    }
                    case '1': {
                        string2 = string2 + "\u001b[5~";
                        break;
                    }
                    case '2': {
                        string2 = string2 + "\u001b[6~";
                        break;
                    }
                    case '3': {
                        string2 = string2 + "\u001b[2~";
                        break;
                    }
                    case '4': {
                        string2 = string2 + "\u001b[3~";
                        break;
                    }
                    case 'a': {
                        string2 = string2 + "\u001bOP";
                        break;
                    }
                    case 'b': {
                        string2 = string2 + "\u001bOQ";
                        break;
                    }
                    case 'c': {
                        string2 = string2 + "\u001bOR";
                        break;
                    }
                    case 'd': {
                        string2 = string2 + "\u001bOS";
                        break;
                    }
                    case 'e': {
                        string2 = string2 + "\u001b[15~";
                        break;
                    }
                    case 'f': {
                        string2 = string2 + "\u001b[17~";
                        break;
                    }
                    case 'g': {
                        string2 = string2 + "\u001b[18~";
                        break;
                    }
                    case 'h': {
                        string2 = string2 + "\u001b[19~";
                        break;
                    }
                    case 'i': {
                        string2 = string2 + "\u001b[20~";
                        break;
                    }
                    case 'j': {
                        string2 = string2 + "\u001b[21~";
                        break;
                    }
                    case 'k': {
                        string2 = string2 + "\u001b[23~";
                        break;
                    }
                    case 'l': {
                        string2 = string2 + "\u001b[24~";
                    }
                }
                continue;
            }
            if (c == '~') {
                this.vt100_keyfilter_escape = true;
                continue;
            }
            if (c == '\u007f') {
                if (this.vt100_mode_backspace) {
                    string2 = string2 + '\b';
                    continue;
                }
                string2 = string2 + '\u007f';
                continue;
            }
            string2 = string2 + c;
            if (!this.vt100_mode_lfnewline || c != '\r') continue;
            string2 = string2 + '\n';
        }
        return string2;
    }

    public synchronized boolean write(CharSequence charSequence) {
        charSequence.codePoints().forEachOrdered(n -> {
            if (!this.vt100_write(n) && !this.dumb_write(n) && n <= 65535) {
                this.dumb_echo(n);
            }
        });
        return true;
    }

    public synchronized void dump(long[] lArray, int n, int n2, int n3, int n4, int[] nArray) {
        int n5 = Math.min(this.cx, this.width - 1);
        int n6 = this.cy;
        for (int i = 0; i < Math.min(this.height, n3 - n); ++i) {
            System.arraycopy(this.screen[i], 0, lArray, (i + n) * n4 + n2, this.width);
        }
        if (nArray != null) {
            nArray[0] = n5 + n2;
            nArray[1] = n6 + n;
        }
    }

    public synchronized String dump(long l, boolean bl) {
        if (!this.dirty.get() && l > 0L) {
            this.wait(l);
        }
        if (this.dirty.compareAndSet(true, false) || bl) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = -1;
            int n2 = Math.min(this.cx, this.width - 1);
            int n3 = this.cy;
            stringBuilder.append("<div><pre class='term'>");
            for (int i = 0; i < this.height; ++i) {
                int n4 = 0;
                block6: for (int j = 0; j < this.width; ++j) {
                    long l2 = this.screen[i][j];
                    int n5 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
                    int n6 = (int)(l2 >> 32);
                    if (n3 == i && n2 == j && this.vt100_mode_cursor) {
                        n6 = n6 & 0xFFF0 | 0xC;
                    }
                    if (n6 != n) {
                        if (n != -1) {
                            stringBuilder.append("</span>");
                        }
                        int n7 = n6 & 0xFF;
                        int n8 = (n6 & 0xFF00) >> 8;
                        boolean bl2 = (n6 & 0x20000) != 0;
                        boolean bl3 = this.vt100_mode_inverse;
                        if (bl2 && !bl3 || bl3 && !bl2) {
                            int n9 = n8;
                            n8 = n7;
                            n7 = n9;
                        }
                        if ((n6 & 0x40000) != 0) {
                            n8 = 12;
                        }
                        String string = (n6 & 0x10000) != 0 ? " ul" : "";
                        String string2 = (n6 & 0x80000) != 0 ? " b" : "";
                        stringBuilder.append("<span class='f").append(n8).append(" b").append(n7).append(string).append(string2).append("'>");
                        n = n6;
                    }
                    switch (n5) {
                        case 38: {
                            stringBuilder.append("&amp;");
                            continue block6;
                        }
                        case 60: {
                            stringBuilder.append("&lt;");
                            continue block6;
                        }
                        case 62: {
                            stringBuilder.append("&gt;");
                            continue block6;
                        }
                        default: {
                            if ((n4 += this.utf8_charwidth(n5)) > this.width) continue block6;
                            stringBuilder.append((char)n5);
                        }
                    }
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append("</span></pre></div>");
            return stringBuilder.toString();
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                stringBuilder.appendCodePoint((int)(this.screen[i][j] & 0xFFFFFFFFL));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static enum State {
        None,
        Esc,
        Str,
        Csi;

    }
}

