/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Options {
    public static final String NL = System.getProperty("line.separator", "\n");
    private static final String regex = "(?x)\\s*(?:-([^-]))?(?:,?\\s*-(\\w))?(?:,?\\s*--(\\w[\\w-]*)(=\\w+)?)?(?:,?\\s*--(\\w[\\w-]*))?.*?(?:\\(default=(.*)\\))?\\s*";
    private static final int GROUP_SHORT_OPT_1 = 1;
    private static final int GROUP_SHORT_OPT_2 = 2;
    private static final int GROUP_LONG_OPT_1 = 3;
    private static final int GROUP_ARG_1 = 4;
    private static final int GROUP_LONG_OPT_2 = 5;
    private static final int GROUP_DEFAULT = 6;
    private final Pattern parser = Pattern.compile("(?x)\\s*(?:-([^-]))?(?:,?\\s*-(\\w))?(?:,?\\s*--(\\w[\\w-]*)(=\\w+)?)?(?:,?\\s*--(\\w[\\w-]*))?.*?(?:\\(default=(.*)\\))?\\s*");
    private final Pattern uname = Pattern.compile("^Usage:\\s+(\\w+)");
    private final Map<String, Boolean> unmodifiableOptSet;
    private final Map<String, Object> unmodifiableOptArg;
    private final Map<String, Boolean> optSet = new HashMap<String, Boolean>();
    private final Map<String, Object> optArg = new HashMap<String, Object>();
    private final Map<String, String> optName = new HashMap<String, String>();
    private final Map<String, String> optAlias = new HashMap<String, String>();
    private final List<Object> xargs = new ArrayList<Object>();
    private List<String> args = null;
    private static final String UNKNOWN = "unknown";
    private String usageName = "unknown";
    private int usageIndex = 0;
    private final String[] spec;
    private final String[] gspec;
    private final String defOpts;
    private final String[] defArgs;
    private String error = null;
    private boolean optionsFirst = false;
    private boolean stopOnBadOption = false;

    public static Options compile(String[] stringArray) {
        return new Options(stringArray, null, null, System::getenv);
    }

    public static Options compile(String[] stringArray, Function<String, String> function) {
        return new Options(stringArray, null, null, function);
    }

    public static Options compile(String string) {
        return Options.compile(string.split("\\n"), System::getenv);
    }

    public static Options compile(String string, Function<String, String> function) {
        return Options.compile(string.split("\\n"), function);
    }

    public static Options compile(String[] stringArray, Options options) {
        return new Options(stringArray, null, options, System::getenv);
    }

    public static Options compile(String[] stringArray, String[] stringArray2) {
        return new Options(stringArray, stringArray2, null, System::getenv);
    }

    public Options setStopOnBadOption(boolean bl) {
        this.stopOnBadOption = bl;
        return this;
    }

    public Options setOptionsFirst(boolean bl) {
        this.optionsFirst = bl;
        return this;
    }

    public boolean isSet(String string) {
        if (!this.optSet.containsKey(string)) {
            throw new IllegalArgumentException("option not defined in spec: " + string);
        }
        return this.optSet.get(string);
    }

    public Object getObject(String string) {
        if (!this.optArg.containsKey(string)) {
            throw new IllegalArgumentException("option not defined with argument: " + string);
        }
        List<Object> list = this.getObjectList(string);
        return list.isEmpty() ? "" : list.get(list.size() - 1);
    }

    public List<Object> getObjectList(String string) {
        ArrayList<Object> arrayList;
        Object object = this.optArg.get(string);
        if (object == null) {
            throw new IllegalArgumentException("option not defined with argument: " + string);
        }
        if (object instanceof String) {
            arrayList = new ArrayList<Object>();
            if (!"".equals(object)) {
                arrayList.add(object);
            }
        } else {
            arrayList = (ArrayList<Object>)object;
        }
        return arrayList;
    }

    public List<String> getList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.getObjectList(string)) {
            try {
                arrayList.add((String)object);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("option not String: " + string);
            }
        }
        return arrayList;
    }

    private void addArg(String string, Object object) {
        ArrayList<Object> arrayList;
        Object object2 = this.optArg.get(string);
        if (object2 instanceof String) {
            arrayList = new ArrayList<Object>();
            this.optArg.put(string, arrayList);
        } else {
            arrayList = (ArrayList<Object>)object2;
        }
        arrayList.add(object);
    }

    public String get(String string) {
        try {
            return (String)this.getObject(string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("option not String: " + string);
        }
    }

    public int getNumber(String string) {
        String string2 = this.get(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("option '" + string + "' not Number: " + string2);
        }
    }

    public List<Object> argObjects() {
        return this.xargs;
    }

    public List<String> args() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
            for (Object object : this.xargs) {
                this.args.add(object == null ? "null" : object.toString());
            }
        }
        return this.args;
    }

    public void usage(PrintStream printStream) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (this.error != null) {
            stringBuilder.append(this.error);
            stringBuilder.append(NL);
            n = this.usageIndex;
        }
        for (int i = n; i < this.spec.length; ++i) {
            stringBuilder.append(this.spec[i]);
            stringBuilder.append(NL);
        }
        String string = stringBuilder.toString();
        printStream.print(string);
    }

    public IllegalArgumentException usageError(String string) {
        this.error = this.usageName + ": " + string;
        return new IllegalArgumentException(this.error);
    }

    private Options(String[] stringArray, String[] stringArray2, Options options, Function<String, String> function) {
        Cloneable cloneable;
        this.gspec = stringArray2;
        if (stringArray2 == null && options == null) {
            this.spec = stringArray;
        } else {
            cloneable = new ArrayList<String>();
            ((ArrayList)cloneable).addAll(Arrays.asList(stringArray));
            ((ArrayList)cloneable).addAll(Arrays.asList(stringArray2 != null ? stringArray2 : options.gspec));
            this.spec = ((ArrayList)cloneable).toArray(new String[((ArrayList)cloneable).size()]);
        }
        cloneable = new HashMap();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.parseSpec((Map<String, Boolean>)((Object)cloneable), hashMap);
        if (options != null) {
            for (Map.Entry<String, Boolean> entry : options.optSet.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                cloneable.put(entry.getKey(), true);
            }
            for (Map.Entry<String, Object> entry : options.optArg.entrySet()) {
                if (entry.getValue().equals("")) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
            options.reset();
        }
        this.unmodifiableOptSet = Collections.unmodifiableMap(cloneable);
        this.unmodifiableOptArg = Collections.unmodifiableMap(hashMap);
        this.defOpts = function != null ? function.apply(this.usageName.toUpperCase() + "_OPTS") : null;
        this.defArgs = this.defOpts != null ? this.defOpts.split("\\s+") : new String[]{};
    }

    private void parseSpec(Map<String, Boolean> map, Map<String, Object> map2) {
        int n = 0;
        for (String string : this.spec) {
            Object object;
            Matcher matcher = this.parser.matcher(string);
            if (matcher.matches()) {
                String string2;
                String string3;
                String string4;
                object = matcher.group(3);
                String string5 = string4 = object != null ? object : matcher.group(1);
                if (string4 != null) {
                    if (map.containsKey(string4)) {
                        throw new IllegalArgumentException("duplicate option in spec: --" + string4);
                    }
                    map.put(string4, false);
                }
                String string6 = string3 = matcher.group(6) != null ? matcher.group(6) : "";
                if (matcher.group(4) != null) {
                    map2.put((String)object, string3);
                }
                if ((string2 = matcher.group(5)) != null) {
                    this.optAlias.put(string2, (String)object);
                    map.put(string2, false);
                    if (matcher.group(4) != null) {
                        map2.put(string2, "");
                    }
                }
                for (int i = 0; i < 2; ++i) {
                    String string7 = matcher.group(i == 0 ? 1 : 2);
                    if (string7 == null) continue;
                    if (this.optName.containsKey(string7)) {
                        throw new IllegalArgumentException("duplicate option in spec: -" + string7);
                    }
                    this.optName.put(string7, string4);
                }
            }
            if (Objects.equals(this.usageName, UNKNOWN) && ((Matcher)(object = this.uname.matcher(string))).find()) {
                this.usageName = ((Matcher)object).group(1);
                this.usageIndex = n;
            }
            ++n;
        }
    }

    private void reset() {
        this.optSet.clear();
        this.optSet.putAll(this.unmodifiableOptSet);
        this.optArg.clear();
        this.optArg.putAll(this.unmodifiableOptArg);
        this.xargs.clear();
        this.args = null;
        this.error = null;
    }

    public Options parse(Object[] objectArray) {
        return this.parse(objectArray, false);
    }

    public Options parse(List<?> list) {
        return this.parse(list, false);
    }

    public Options parse(Object[] objectArray, boolean bl) {
        if (null == objectArray) {
            throw new IllegalArgumentException("argv is null");
        }
        return this.parse(Arrays.asList(objectArray), bl);
    }

    public Options parse(List<?> list, boolean bl) {
        Object object22;
        this.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(this.defArgs));
        for (Object object22 : list) {
            if (bl) {
                bl = false;
                this.usageName = object22.toString();
                continue;
            }
            arrayList.add((String)object22);
        }
        Object object3 = null;
        object22 = null;
        boolean bl2 = false;
        block5: for (Object object4 : arrayList) {
            String string;
            String string2;
            int n;
            String string3;
            String string4 = string3 = object4 == null ? "null" : object4.toString();
            if (bl2) {
                this.xargs.add(object4);
                continue;
            }
            if (object3 != null) {
                this.addArg((String)object3, object4);
                object3 = null;
                object22 = null;
                continue;
            }
            if (!string3.startsWith("-") || "-".equals(object4)) {
                if (this.optionsFirst) {
                    bl2 = true;
                }
                this.xargs.add(object4);
                continue;
            }
            if (string3.equals("--")) {
                bl2 = true;
                continue;
            }
            if (string3.startsWith("--")) {
                n = string3.indexOf("=");
                string2 = n == -1 ? null : string3.substring(n + 1);
                string = string3.substring(2, n == -1 ? string3.length() : n);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (this.optSet.containsKey(string)) {
                    arrayList2.add(string);
                } else {
                    for (String string5 : this.optSet.keySet()) {
                        if (!string5.startsWith(string)) continue;
                        arrayList2.add(string5);
                    }
                }
                switch (arrayList2.size()) {
                    case 1: {
                        string = (String)arrayList2.get(0);
                        this.optSet.put(string, true);
                        if (this.optArg.containsKey(string)) {
                            if (string2 != null) {
                                this.addArg(string, string2);
                                break;
                            }
                            object3 = string;
                            break;
                        }
                        if (string2 == null) continue block5;
                        throw this.usageError("option '--" + string + "' doesn't allow an argument");
                    }
                    case 0: {
                        if (this.stopOnBadOption) {
                            bl2 = true;
                            this.xargs.add(object4);
                            break;
                        }
                        throw this.usageError("invalid option '--" + string + "'");
                    }
                    default: {
                        throw this.usageError("option '--" + string + "' is ambiguous: " + arrayList2);
                    }
                }
                continue;
            }
            for (n = 1; n < string3.length(); ++n) {
                string2 = String.valueOf(string3.charAt(n));
                if (this.optName.containsKey(string2)) {
                    string = this.optName.get(string2);
                    this.optSet.put(string, true);
                    if (!this.optArg.containsKey(string)) continue;
                    int n2 = n + 1;
                    if (n2 < string3.length()) {
                        this.addArg(string, string3.substring(n2));
                        continue block5;
                    }
                    object22 = string2;
                    object3 = string;
                    continue block5;
                }
                if (this.stopOnBadOption) {
                    this.xargs.add("-" + string2);
                    bl2 = true;
                    continue;
                }
                throw this.usageError("invalid option '" + string2 + "'");
            }
        }
        if (object3 != null) {
            Iterator<Object> iterator = object22 != null ? object22 : "--" + object3;
            throw this.usageError("option '" + iterator + "' requires an argument");
        }
        for (Map.Entry entry : this.optAlias.entrySet()) {
            if (this.optSet.get(entry.getKey()).booleanValue()) {
                this.optSet.put((String)entry.getValue(), true);
                if (this.optArg.containsKey(entry.getKey())) {
                    this.optArg.put((String)entry.getValue(), this.optArg.get(entry.getKey()));
                }
            }
            this.optSet.remove(entry.getKey());
            this.optArg.remove(entry.getKey());
        }
        return this;
    }

    public String toString() {
        return "isSet" + this.optSet + "\nArg" + this.optArg + "\nargs" + this.xargs;
    }
}

