/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class NfaMatcher<T> {
    private final String regexp;
    private final BiFunction<T, String, Boolean> matcher;
    private volatile State start;

    public NfaMatcher(String string, BiFunction<T, String, Boolean> biFunction) {
        this.regexp = string;
        this.matcher = biFunction;
    }

    public void compile() {
        if (this.start == null) {
            this.start = NfaMatcher.toNfa(NfaMatcher.toPostFix(this.regexp));
        }
    }

    public boolean match(List<T> list) {
        HashSet<State> hashSet = new HashSet<State>();
        this.compile();
        this.addState(hashSet, this.start);
        for (T t : list) {
            HashSet hashSet2 = new HashSet();
            hashSet.stream().filter(state -> !Objects.equals("++MATCH++", state.c) && !Objects.equals("++SPLIT++", state.c)).filter(state -> this.matcher.apply(t, state.c)).forEach(state -> this.addState(hashSet2, state.out));
            hashSet = hashSet2;
        }
        return hashSet.stream().anyMatch(state -> Objects.equals("++MATCH++", state.c));
    }

    public Set<String> matchPartial(List<T> list) {
        HashSet<State> hashSet = new HashSet<State>();
        this.compile();
        this.addState(hashSet, this.start);
        for (T t : list) {
            HashSet hashSet2 = new HashSet();
            hashSet.stream().filter(state -> !Objects.equals("++MATCH++", state.c) && !Objects.equals("++SPLIT++", state.c)).filter(state -> this.matcher.apply(t, state.c)).forEach(state -> this.addState(hashSet2, state.out));
            hashSet = hashSet2;
        }
        return hashSet.stream().filter(state -> !Objects.equals("++MATCH++", state.c) && !Objects.equals("++SPLIT++", state.c)).map(state -> state.c).collect(Collectors.toSet());
    }

    void addState(Set<State> set, State state) {
        if (state != null && set.add(state) && Objects.equals("++SPLIT++", state.c)) {
            this.addState(set, state.out);
            this.addState(set, state.out1);
        }
    }

    static State toNfa(List<String> list) {
        Frag frag;
        ArrayDeque<Frag> arrayDeque = new ArrayDeque<Frag>();
        Iterator<String> iterator = list.iterator();
        block14: while (iterator.hasNext()) {
            State state;
            String string;
            switch (string = iterator.next()) {
                case ".": {
                    Frag frag2 = (Frag)arrayDeque.pollLast();
                    Frag frag3 = (Frag)arrayDeque.pollLast();
                    frag3.patch(frag2.start);
                    arrayDeque.offerLast(new Frag(frag3.start, frag2.out));
                    continue block14;
                }
                case "|": {
                    Frag frag2 = (Frag)arrayDeque.pollLast();
                    Frag frag3 = (Frag)arrayDeque.pollLast();
                    state = new State("++SPLIT++", frag3.start, frag2.start);
                    arrayDeque.offerLast(new Frag(state, frag3.out, frag2.out));
                    continue block14;
                }
                case "?": {
                    frag = (Frag)arrayDeque.pollLast();
                    state = new State("++SPLIT++", frag.start, null);
                    arrayDeque.offerLast(new Frag(state, frag.out, state::setOut1));
                    continue block14;
                }
                case "*": {
                    frag = (Frag)arrayDeque.pollLast();
                    state = new State("++SPLIT++", frag.start, null);
                    frag.patch(state);
                    arrayDeque.offerLast(new Frag(state, state::setOut1));
                    continue block14;
                }
                case "+": {
                    frag = (Frag)arrayDeque.pollLast();
                    state = new State("++SPLIT++", frag.start, null);
                    frag.patch(state);
                    arrayDeque.offerLast(new Frag(frag.start, state::setOut1));
                    continue block14;
                }
            }
            state = new State(string, null, null);
            arrayDeque.offerLast(new Frag(state, state::setOut));
        }
        frag = (Frag)arrayDeque.pollLast();
        if (!arrayDeque.isEmpty()) {
            throw new IllegalStateException("Wrong postfix expression, " + arrayDeque.size() + " elements remaining");
        }
        frag.patch(new State("++MATCH++", null, null));
        return frag.start;
    }

    static List<String> toPostFix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        ArrayDeque<Integer> arrayDeque2 = new ArrayDeque<Integer>();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                if (n >= 0) continue;
                n = i;
                continue;
            }
            if (n >= 0) {
                if (n2 > 1) {
                    --n2;
                    arrayList.add(".");
                }
                arrayList.add(string.substring(n, i));
                ++n2;
                n = -1;
            }
            if (Character.isWhitespace(c)) continue;
            switch (c) {
                case '(': {
                    if (n2 > 1) {
                        --n2;
                        arrayList.add(".");
                    }
                    arrayDeque2.offerLast(n3);
                    arrayDeque.offerLast(n2);
                    n3 = 0;
                    n2 = 0;
                    continue block6;
                }
                case '|': {
                    if (n2 == 0) {
                        throw new IllegalStateException("unexpected '" + c + "' at pos " + i);
                    }
                    while (--n2 > 0) {
                        arrayList.add(".");
                    }
                    ++n3;
                    continue block6;
                }
                case ')': {
                    if (arrayDeque2.isEmpty() || n2 == 0) {
                        throw new IllegalStateException("unexpected '" + c + "' at pos " + i);
                    }
                    while (--n2 > 0) {
                        arrayList.add(".");
                    }
                    while (n3 > 0) {
                        arrayList.add("|");
                        --n3;
                    }
                    n3 = (Integer)arrayDeque2.pollLast();
                    n2 = (Integer)arrayDeque.pollLast();
                    ++n2;
                    continue block6;
                }
                case '*': 
                case '+': 
                case '?': {
                    if (n2 == 0) {
                        throw new IllegalStateException("unexpected '" + c + "' at pos " + i);
                    }
                    arrayList.add(String.valueOf(c));
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("unexpected '" + c + "' at pos " + i);
                }
            }
        }
        if (n >= 0) {
            if (n2 > 1) {
                --n2;
                arrayList.add(".");
            }
            arrayList.add(string.substring(n));
            ++n2;
        }
        while (--n2 > 0) {
            arrayList.add(".");
        }
        while (n3 > 0) {
            arrayList.add("|");
            --n3;
        }
        return arrayList;
    }

    private static class Frag {
        final State start;
        final List<Consumer<State>> out = new ArrayList<Consumer<State>>();

        public Frag(State state, Collection<Consumer<State>> collection) {
            this.start = state;
            this.out.addAll(collection);
        }

        public Frag(State state, Collection<Consumer<State>> collection, Collection<Consumer<State>> collection2) {
            this.start = state;
            this.out.addAll(collection);
            this.out.addAll(collection2);
        }

        public Frag(State state, Consumer<State> consumer) {
            this.start = state;
            this.out.add(consumer);
        }

        public Frag(State state, Collection<Consumer<State>> collection, Consumer<State> consumer) {
            this.start = state;
            this.out.addAll(collection);
            this.out.add(consumer);
        }

        public void patch(State state) {
            this.out.forEach(consumer -> consumer.accept(state));
        }
    }

    static class State {
        static final String Match = "++MATCH++";
        static final String Split = "++SPLIT++";
        final String c;
        State out;
        State out1;

        public State(String string, State state, State state2) {
            this.c = string;
            this.out = state;
            this.out1 = state2;
        }

        public void setOut(State state) {
            this.out = state;
        }

        public void setOut1(State state) {
            this.out1 = state;
        }
    }
}

