/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.mozilla.universalchardet.UniversalDetector;

public class Nano {
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected final Size size;
    protected final Path root;
    protected KeyMap<Operation> keys;
    public String title = "JLine Nano 3.0.0";
    public boolean printLineNumbers = true;
    public boolean wrapping = true;
    public boolean smoothScrolling = true;
    public boolean mouseSupport = false;
    public boolean oneMoreLine = true;
    public boolean constantCursor;
    public int tabs = 4;
    public String brackets = "\"\u2019)>]}";
    public String matchBrackets = "(<[{)>]}";
    public String punct = "!.?";
    public String quoteStr = "^([ \\t]*[#:>\\|}])+";
    protected final List<Buffer> buffers = new ArrayList<Buffer>();
    protected int bufferIndex;
    protected Buffer buffer;
    protected String message;
    protected int nbBindings = 0;
    protected LinkedHashMap<String, String> shortcuts;
    protected String editMessage;
    protected final StringBuilder editBuffer = new StringBuilder();
    protected boolean searchCaseSensitive;
    protected boolean searchRegexp;
    protected boolean searchBackwards;
    protected String searchTerm;
    protected WriteMode writeMode = WriteMode.WRITE;
    protected boolean writeBackup;
    protected boolean readNewBuffer = true;

    public Nano(Terminal terminal, File file) {
        this(terminal, file.toPath());
    }

    public Nano(Terminal terminal, Path path) {
        this.terminal = terminal;
        this.root = path;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
        this.size = new Size();
        this.bindKeys();
    }

    public void open(String ... stringArray) {
        this.open(Arrays.asList(stringArray));
    }

    public void open(List<String> list) {
        for (String string : list) {
            this.buffers.add(new Buffer(string));
        }
    }

    public void run() {
        if (this.buffers.isEmpty()) {
            this.buffers.add(new Buffer(null));
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        Attributes attributes = this.terminal.getAttributes();
        Attributes attributes2 = new Attributes(attributes);
        attributes2.setLocalFlags(EnumSet.of(Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.IEXTEN), false);
        attributes2.setInputFlags(EnumSet.of(Attributes.InputFlag.IXON, Attributes.InputFlag.ICRNL, Attributes.InputFlag.INLCR), false);
        attributes2.setControlChar(Attributes.ControlChar.VMIN, 1);
        attributes2.setControlChar(Attributes.ControlChar.VTIME, 0);
        attributes2.setControlChar(Attributes.ControlChar.VINTR, 0);
        this.terminal.setAttributes(attributes2);
        Terminal.SignalHandler signalHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
        this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
        this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
        this.size.copy(this.terminal.getSize());
        this.display.clear();
        this.display.reset();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        if (this.mouseSupport) {
            this.terminal.trackMouse(Terminal.MouseTracking.Normal);
        }
        this.shortcuts = this.standardShortcuts();
        try {
            this.buffer.open();
            if (this.buffer.file != null) {
                this.setMessage("Read " + this.buffer.lines.size() + " lines");
            }
            this.display();
            while (true) {
                Operation operation = this.readOperation(this.keys);
                switch (operation) {
                    case QUIT: {
                        if (!this.quit()) break;
                        return;
                    }
                    case WRITE: {
                        this.write();
                        break;
                    }
                    case READ: {
                        this.read();
                        break;
                    }
                    case UP: {
                        this.buffer.moveUp(1);
                        break;
                    }
                    case DOWN: {
                        this.buffer.moveDown(1);
                        break;
                    }
                    case LEFT: {
                        this.buffer.moveLeft(1);
                        break;
                    }
                    case RIGHT: {
                        this.buffer.moveRight(1);
                        break;
                    }
                    case INSERT: {
                        this.buffer.insert(this.bindingReader.getLastBinding());
                        break;
                    }
                    case BACKSPACE: {
                        this.buffer.backspace(1);
                        break;
                    }
                    case DELETE: {
                        this.buffer.delete(1);
                        break;
                    }
                    case WRAP: {
                        this.wrap();
                        break;
                    }
                    case NUMBERS: {
                        this.numbers();
                        break;
                    }
                    case SMOOTH_SCROLLING: {
                        this.smoothScrolling();
                        break;
                    }
                    case MOUSE_SUPPORT: {
                        this.mouseSupport();
                        break;
                    }
                    case ONE_MORE_LINE: {
                        this.oneMoreLine();
                        break;
                    }
                    case CLEAR_SCREEN: {
                        this.clearScreen();
                        break;
                    }
                    case PREV_BUFFER: {
                        this.prevBuffer();
                        break;
                    }
                    case NEXT_BUFFER: {
                        this.nextBuffer();
                        break;
                    }
                    case CUR_POS: {
                        this.curPos();
                        break;
                    }
                    case PREV_WORD: {
                        this.buffer.prevWord();
                        break;
                    }
                    case NEXT_WORD: {
                        this.buffer.nextWord();
                        break;
                    }
                    case BEGINNING_OF_LINE: {
                        this.buffer.beginningOfLine();
                        break;
                    }
                    case END_OF_LINE: {
                        this.buffer.endOfLine();
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case PREV_PAGE: {
                        this.buffer.prevPage();
                        break;
                    }
                    case NEXT_PAGE: {
                        this.buffer.nextPage();
                        break;
                    }
                    case SCROLL_UP: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case SCROLL_DOWN: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case SEARCH: {
                        this.search();
                        break;
                    }
                    case NEXT_SEARCH: {
                        this.buffer.nextSearch();
                        break;
                    }
                    case HELP: {
                        this.help("nano-main-help.txt");
                        break;
                    }
                    case CONSTANT_CURSOR: {
                        this.constantCursor();
                        break;
                    }
                    case VERBATIM: {
                        this.buffer.insert(new String(Character.toChars(this.bindingReader.readCharacter())));
                        break;
                    }
                    case MATCHING: {
                        this.buffer.matching();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                        break;
                    }
                    default: {
                        this.setMessage("Unsupported " + operation.name().toLowerCase().replace('_', '-'));
                    }
                }
                this.display();
            }
        }
        finally {
            if (this.mouseSupport) {
                this.terminal.trackMouse(Terminal.MouseTracking.Off);
            }
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.flush();
            this.terminal.setAttributes(attributes);
            this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
        }
    }

    boolean write() {
        char c;
        KeyMap<Operation> keyMap = new KeyMap<Operation>();
        keyMap.setUnicode(Operation.INSERT);
        for (c = ' '; c < '\u0100'; c = (char)(c + '\u0001')) {
            keyMap.bind(Operation.INSERT, (CharSequence)Character.toString(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            keyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(c));
        }
        keyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        keyMap.bind(Operation.MAC_FORMAT, (CharSequence)KeyMap.alt('m'));
        keyMap.bind(Operation.DOS_FORMAT, (CharSequence)KeyMap.alt('d'));
        keyMap.bind(Operation.APPEND_MODE, (CharSequence)KeyMap.alt('a'));
        keyMap.bind(Operation.PREPEND_MODE, (CharSequence)KeyMap.alt('p'));
        keyMap.bind(Operation.BACKUP, (CharSequence)KeyMap.alt('b'));
        keyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        keyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        keyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        keyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        keyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getWriteMessage();
        this.editBuffer.setLength(0);
        this.editBuffer.append(this.buffer.file == null ? "" : this.buffer.file);
        this.shortcuts = this.writeShortcuts();
        this.display();
        while (true) {
            switch (this.readOperation(keyMap)) {
                case INSERT: {
                    this.editBuffer.append(this.bindingReader.getLastBinding());
                    break;
                }
                case BACKSPACE: {
                    if (this.editBuffer.length() <= 0) break;
                    this.editBuffer.setLength(this.editBuffer.length() - 1);
                    break;
                }
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return false;
                }
                case ACCEPT: {
                    this.editMessage = null;
                    if (this.save(this.editBuffer.toString())) {
                        this.shortcuts = this.standardShortcuts();
                        return true;
                    }
                    return false;
                }
                case HELP: {
                    this.help("nano-write-help.txt");
                    break;
                }
                case MAC_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.MAC ? WriteFormat.UNIX : WriteFormat.MAC;
                    break;
                }
                case DOS_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.DOS ? WriteFormat.UNIX : WriteFormat.DOS;
                    break;
                }
                case APPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.APPEND ? WriteMode.WRITE : WriteMode.APPEND;
                    break;
                }
                case PREPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.PREPEND ? WriteMode.WRITE : WriteMode.PREPEND;
                    break;
                }
                case BACKUP: {
                    this.writeBackup = !this.writeBackup;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                }
            }
            this.editMessage = this.getWriteMessage();
            this.display();
        }
    }

    private Operation readOperation(KeyMap<Operation> keyMap) {
        Operation operation;
        while ((operation = this.bindingReader.readBinding(keyMap)) == Operation.DO_LOWER_CASE) {
            this.bindingReader.runMacro(this.bindingReader.getLastBinding().toLowerCase());
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean save(String string) {
        Object object;
        boolean bl;
        Path path = this.buffer.file != null ? this.root.resolve(this.buffer.file) : null;
        Path path2 = this.root.resolve(string);
        boolean bl2 = bl = path != null && Files.isSameFile(path, path2);
        if (!bl && Files.exists(Paths.get(string, new String[0]), new LinkOption[0]) && (object = this.getYNC("File exists, OVERWRITE ? ")) != Operation.YES) {
            return false;
        }
        object = Files.createTempFile(path2.getParent(), "jline-", ".temp", new FileAttribute[0]);
        try {
            int n;
            Throwable throwable;
            OutputStream outputStream;
            block28: {
                block29: {
                    outputStream = Files.newOutputStream(object, new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE});
                    throwable = null;
                    if (this.writeMode == WriteMode.APPEND && Files.isReadable(path2)) {
                        Files.copy(path2, outputStream);
                    }
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.buffer.charset);
                    for (n = 0; n < this.buffer.lines.size(); n += 1) {
                        if (n > 0) {
                            switch (this.buffer.format) {
                                case UNIX: {
                                    outputStreamWriter.write("\n");
                                    break;
                                }
                                case DOS: {
                                    outputStreamWriter.write("\r\n");
                                    break;
                                }
                                case MAC: {
                                    outputStreamWriter.write("\r");
                                }
                            }
                        }
                        outputStreamWriter.write(this.buffer.lines.get(n));
                    }
                    ((Writer)outputStreamWriter).flush();
                    if (this.writeMode == WriteMode.PREPEND && Files.isReadable(path2)) {
                        Files.copy(path2, outputStream);
                    }
                    if (this.writeBackup) {
                        Files.move(path2, path2.resolveSibling(path2.getFileName().toString() + "~"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Files.move(object, path2, new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    this.buffer.file = string;
                    this.buffer.dirty = false;
                    this.setMessage("Wrote " + this.buffer.lines.size() + " lines");
                    n = 1;
                    if (outputStream == null) break block28;
                    if (throwable == null) break block29;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block28;
                }
                outputStream.close();
            }
            return n != 0;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException iOException) {
                    this.setMessage("Error writing " + string + ": " + iOException.toString());
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            Files.deleteIfExists(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation getYNC(String string) {
        String string2 = this.editMessage;
        String string3 = this.editBuffer.toString();
        LinkedHashMap<String, String> linkedHashMap = this.shortcuts;
        try {
            this.editMessage = string;
            this.editBuffer.setLength(0);
            KeyMap<Operation> keyMap = new KeyMap<Operation>();
            keyMap.bind(Operation.YES, "y", "Y");
            keyMap.bind(Operation.NO, "n", "N");
            keyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
            this.shortcuts = new LinkedHashMap();
            this.shortcuts.put(" Y", "Yes");
            this.shortcuts.put(" N", "No");
            this.shortcuts.put("^C", "Cancel");
            this.display();
            Operation operation = this.readOperation(keyMap);
            return operation;
        }
        finally {
            this.editMessage = string2;
            this.editBuffer.append(string3);
            this.shortcuts = linkedHashMap;
        }
    }

    private String getWriteMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File Name to ");
        switch (this.writeMode) {
            case WRITE: {
                stringBuilder.append("Write");
                break;
            }
            case APPEND: {
                stringBuilder.append("Append");
                break;
            }
            case PREPEND: {
                stringBuilder.append("Prepend");
            }
        }
        switch (this.buffer.format) {
            case UNIX: {
                break;
            }
            case DOS: {
                stringBuilder.append(" [DOS Format]");
                break;
            }
            case MAC: {
                stringBuilder.append(" [Mac Format]");
            }
        }
        if (this.writeBackup) {
            stringBuilder.append(" [Backup]");
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    void read() {
        char c;
        KeyMap<Operation> keyMap = new KeyMap<Operation>();
        keyMap.setUnicode(Operation.INSERT);
        for (c = ' '; c < '\u0100'; c = (char)(c + '\u0001')) {
            keyMap.bind(Operation.INSERT, (CharSequence)Character.toString(c));
        }
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            keyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(c));
        }
        keyMap.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        keyMap.bind(Operation.NEW_BUFFER, (CharSequence)KeyMap.alt('f'));
        keyMap.bind(Operation.TO_FILES, (CharSequence)KeyMap.ctrl('T'));
        keyMap.bind(Operation.EXECUTE, (CharSequence)KeyMap.ctrl('X'));
        keyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        keyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        keyMap.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        keyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getReadMessage();
        this.editBuffer.setLength(0);
        this.shortcuts = this.readShortcuts();
        this.display();
        while (true) {
            switch (this.readOperation(keyMap)) {
                case INSERT: {
                    this.editBuffer.append(this.bindingReader.getLastBinding());
                    break;
                }
                case BACKSPACE: {
                    if (this.editBuffer.length() <= 0) break;
                    this.editBuffer.setLength(this.editBuffer.length() - 1);
                    break;
                }
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case ACCEPT: {
                    Path path;
                    this.editMessage = null;
                    String string = this.editBuffer.toString();
                    boolean bl = string.isEmpty();
                    Path path2 = path = bl ? null : this.root.resolve(string);
                    if (!(this.readNewBuffer || bl || Files.exists(path, new LinkOption[0]))) {
                        this.setMessage("\"" + string + "\" not found");
                    } else if (!bl && Files.isDirectory(path, new LinkOption[0])) {
                        this.setMessage("\"" + string + "\" is a directory");
                    } else if (!bl && !Files.isRegularFile(path, new LinkOption[0])) {
                        this.setMessage("\"" + string + "\" is not a regular file");
                    } else {
                        Buffer buffer = new Buffer(bl ? null : string);
                        try {
                            buffer.open();
                            if (this.readNewBuffer) {
                                this.buffers.add(++this.bufferIndex, buffer);
                                this.buffer = buffer;
                            } else {
                                this.buffer.insert(String.join((CharSequence)"\n", buffer.lines));
                            }
                            this.setMessage(null);
                        }
                        catch (IOException iOException) {
                            this.setMessage("Error reading " + string + ": " + iOException.getMessage());
                        }
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case HELP: {
                    this.help("nano-read-help.txt");
                    break;
                }
                case NEW_BUFFER: {
                    this.readNewBuffer = !this.readNewBuffer;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                }
            }
            this.editMessage = this.getReadMessage();
            this.display();
        }
    }

    private String getReadMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("File to insert");
        if (this.readNewBuffer) {
            stringBuilder.append(" into new buffer");
        }
        stringBuilder.append(" [from ./]: ");
        return stringBuilder.toString();
    }

    private LinkedHashMap<String, String> readShortcuts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("^G", "Get Help");
        linkedHashMap.put("^T", "To Files");
        linkedHashMap.put("M-F", "New Buffer");
        linkedHashMap.put("^C", "Cancel");
        linkedHashMap.put("^X", "Execute Command");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> writeShortcuts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("^G", "Get Help");
        linkedHashMap.put("^T", "To Files");
        linkedHashMap.put("M-M", "Mac Format");
        linkedHashMap.put("M-P", "Prepend");
        linkedHashMap.put("^C", "Cancel");
        linkedHashMap.put("M-D", "DOS Format");
        linkedHashMap.put("M-A", "Append");
        linkedHashMap.put("M-B", "Backup File");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> helpShortcuts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("^L", "Refresh");
        linkedHashMap.put("^Y", "Prev Page");
        linkedHashMap.put("^P", "Prev Line");
        linkedHashMap.put("M-\\", "First Line");
        linkedHashMap.put("^X", "Exit");
        linkedHashMap.put("^V", "Next Page");
        linkedHashMap.put("^N", "Next Line");
        linkedHashMap.put("M-/", "Last Line");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> searchShortcuts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("^G", "Get Help");
        linkedHashMap.put("^Y", "First Line");
        linkedHashMap.put("^R", "Replace");
        linkedHashMap.put("^W", "Beg of Par");
        linkedHashMap.put("M-C", "Case Sens");
        linkedHashMap.put("M-R", "Regexp");
        linkedHashMap.put("^C", "Cancel");
        linkedHashMap.put("^V", "Last Line");
        linkedHashMap.put("^T", "Go To Line");
        linkedHashMap.put("^O", "End of Par");
        linkedHashMap.put("M-B", "Backwards");
        linkedHashMap.put("^P", "PrevHstory");
        return linkedHashMap;
    }

    private LinkedHashMap<String, String> standardShortcuts() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("^G", "Get Help");
        linkedHashMap.put("^O", "WriteOut");
        linkedHashMap.put("^R", "Read File");
        linkedHashMap.put("^O", "WriteOut");
        linkedHashMap.put("^Y", "Prev Page");
        linkedHashMap.put("^K", "Cut Text");
        linkedHashMap.put("^C", "Cur Pos");
        linkedHashMap.put("^X", "Exit");
        linkedHashMap.put("^J", "Justify");
        linkedHashMap.put("^W", "Where Is");
        linkedHashMap.put("^V", "Next Page");
        linkedHashMap.put("^U", "UnCut Text");
        linkedHashMap.put("^T", "To Spell");
        return linkedHashMap;
    }

    void help(String string) {
        Object object;
        Buffer buffer = this.buffer;
        Buffer buffer2 = new Buffer(null);
        try {
            object = this.getClass().getResourceAsStream(string);
            Throwable throwable = null;
            try {
                buffer2.open((InputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.setMessage("Unable to read help");
            return;
        }
        object = this.shortcuts;
        this.shortcuts = this.helpShortcuts();
        boolean bl = this.wrapping;
        boolean bl2 = this.printLineNumbers;
        boolean bl3 = this.constantCursor;
        this.wrapping = true;
        this.printLineNumbers = false;
        this.constantCursor = false;
        this.buffer = buffer2;
        try {
            this.message = null;
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.display();
            while (true) {
                switch (this.readOperation(this.keys)) {
                    case QUIT: {
                        return;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case PREV_PAGE: {
                        this.buffer.prevPage();
                        break;
                    }
                    case NEXT_PAGE: {
                        this.buffer.nextPage();
                        break;
                    }
                    case UP: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case DOWN: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case CLEAR_SCREEN: {
                        this.clearScreen();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                    }
                }
                this.display();
            }
        }
        finally {
            this.buffer = buffer;
            this.wrapping = bl;
            this.printLineNumbers = bl2;
            this.constantCursor = bl3;
            this.shortcuts = object;
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
        }
    }

    void search() {
        KeyMap<Operation> keyMap = new KeyMap<Operation>();
        keyMap.setUnicode(Operation.INSERT);
        for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            keyMap.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(c));
        }
        keyMap.bind(Operation.CASE_SENSITIVE, (CharSequence)KeyMap.alt('c'));
        keyMap.bind(Operation.BACKWARDS, (CharSequence)KeyMap.alt('b'));
        keyMap.bind(Operation.REGEXP, (CharSequence)KeyMap.alt('r'));
        keyMap.bind(Operation.ACCEPT, (CharSequence)"\r");
        keyMap.bind(Operation.CANCEL, (CharSequence)KeyMap.ctrl('C'));
        keyMap.bind(Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl('Y'));
        keyMap.bind(Operation.LAST_LINE, (CharSequence)KeyMap.ctrl('V'));
        keyMap.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
        this.editMessage = this.getSearchMessage();
        this.editBuffer.setLength(0);
        this.shortcuts = this.searchShortcuts();
        this.display();
        try {
            while (true) {
                switch (this.readOperation(keyMap)) {
                    case INSERT: {
                        this.editBuffer.append(this.bindingReader.getLastBinding());
                        break;
                    }
                    case CASE_SENSITIVE: {
                        this.searchCaseSensitive = !this.searchCaseSensitive;
                        break;
                    }
                    case BACKWARDS: {
                        this.searchBackwards = !this.searchBackwards;
                        break;
                    }
                    case REGEXP: {
                        this.searchRegexp = !this.searchRegexp;
                        break;
                    }
                    case CANCEL: {
                        return;
                    }
                    case BACKSPACE: {
                        if (this.editBuffer.length() <= 0) break;
                        this.editBuffer.setLength(this.editBuffer.length() - 1);
                        break;
                    }
                    case ACCEPT: {
                        if (this.editBuffer.length() > 0) {
                            this.searchTerm = this.editBuffer.toString();
                        }
                        if (this.searchTerm == null || this.searchTerm.isEmpty()) {
                            this.setMessage("Cancelled");
                        } else {
                            this.buffer.nextSearch();
                        }
                        return;
                    }
                    case HELP: {
                        this.help("nano-search-help.txt");
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        return;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        return;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                    }
                }
                this.editMessage = this.getSearchMessage();
                this.display();
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    private String getSearchMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Search");
        if (this.searchCaseSensitive) {
            stringBuilder.append(" [Case Sensitive]");
        }
        if (this.searchRegexp) {
            stringBuilder.append(" [Regexp]");
        }
        if (this.searchBackwards) {
            stringBuilder.append(" [Backwards]");
        }
        if (this.searchTerm != null) {
            stringBuilder.append(" [");
            stringBuilder.append(this.searchTerm);
            stringBuilder.append("]");
        }
        stringBuilder.append(": ");
        return stringBuilder.toString();
    }

    String computeCurPos() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.buffer.lines.size(); ++i) {
            int n3 = this.buffer.lines.get(i).length() + 1;
            if (i < this.buffer.line) {
                n += n3;
            } else if (i == this.buffer.line) {
                n += this.buffer.offsetInLine + this.buffer.column;
            }
            n2 += n3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("line ");
        stringBuilder.append(this.buffer.line + 1);
        stringBuilder.append("/");
        stringBuilder.append(this.buffer.lines.size());
        stringBuilder.append(" (");
        stringBuilder.append(Math.round(100.0 * (double)this.buffer.line / (double)this.buffer.lines.size()));
        stringBuilder.append("%), ");
        stringBuilder.append("col ");
        stringBuilder.append(this.buffer.offsetInLine + this.buffer.column + 1);
        stringBuilder.append("/");
        stringBuilder.append(this.buffer.lines.get(this.buffer.line).length() + 1);
        stringBuilder.append(" (");
        if (this.buffer.lines.get(this.buffer.line).length() > 0) {
            stringBuilder.append(Math.round(100.0 * (double)(this.buffer.offsetInLine + this.buffer.column) / (double)this.buffer.lines.get(this.buffer.line).length()));
        } else {
            stringBuilder.append("100");
        }
        stringBuilder.append("%), ");
        stringBuilder.append("char ");
        stringBuilder.append(n + 1);
        stringBuilder.append("/");
        stringBuilder.append(n2);
        stringBuilder.append(" (");
        stringBuilder.append(Math.round(100.0 * (double)n / (double)n2));
        stringBuilder.append("%)");
        return stringBuilder.toString();
    }

    void curPos() {
        this.setMessage(this.computeCurPos());
    }

    void prevBuffer() {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + this.buffers.size() - 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void nextBuffer() {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void setMessage(String string) {
        this.message = string;
        this.nbBindings = 25;
    }

    boolean quit() {
        if (this.buffer.dirty) {
            Operation operation = this.getYNC("Save modified buffer (ANSWERING \"No\" WILL DESTROY CHANGES) ? ");
            switch (operation) {
                case CANCEL: {
                    return false;
                }
                case NO: {
                    break;
                }
                case YES: {
                    if (this.write()) break;
                    return false;
                }
            }
        }
        this.buffers.remove(this.bufferIndex);
        if (this.bufferIndex == this.buffers.size() && this.bufferIndex > 0) {
            this.bufferIndex = this.buffers.size() - 1;
        }
        if (this.buffers.isEmpty()) {
            this.buffer = null;
            return true;
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        this.buffer.open();
        this.display.clear();
        this.setMessage("Switched to " + this.buffer.getTitle());
        return false;
    }

    void numbers() {
        this.printLineNumbers = !this.printLineNumbers;
        this.resetDisplay();
        this.setMessage("Lines numbering " + (this.printLineNumbers ? "enabled" : "disabled"));
    }

    void smoothScrolling() {
        this.smoothScrolling = !this.smoothScrolling;
        this.setMessage("Smooth scrolling " + (this.smoothScrolling ? "enabled" : "disabled"));
    }

    void mouseSupport() {
        this.mouseSupport = !this.mouseSupport;
        this.setMessage("Mouse support " + (this.mouseSupport ? "enabled" : "disabled"));
        this.terminal.trackMouse(this.mouseSupport ? Terminal.MouseTracking.Normal : Terminal.MouseTracking.Off);
    }

    void constantCursor() {
        this.constantCursor = !this.constantCursor;
        this.setMessage("Constant cursor position display " + (this.constantCursor ? "enabled" : "disabled"));
    }

    void oneMoreLine() {
        this.oneMoreLine = !this.oneMoreLine;
        this.setMessage("Use of one more line for editing " + (this.oneMoreLine ? "enabled" : "disabled"));
    }

    void wrap() {
        this.wrapping = !this.wrapping;
        this.resetDisplay();
        this.setMessage("Lines wrapping " + (this.wrapping ? "enabled" : "disabled"));
    }

    void clearScreen() {
        this.resetDisplay();
    }

    void mouseEvent() {
        MouseEvent mouseEvent = this.terminal.readMouseEvent();
        if (mouseEvent.getModifiers().isEmpty() && mouseEvent.getType() == MouseEvent.Type.Released && mouseEvent.getButton() == MouseEvent.Button.Button1) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = this.buffer.computeHeader().size();
            int n4 = this.computeFooter().size();
            if (n2 >= n3) {
                if (n2 < this.size.getRows() - n4) {
                    this.buffer.moveTo(n, n2 - n3);
                } else {
                    int n5 = (this.shortcuts.size() + 1) / 2;
                    int n6 = this.size.getColumns() / n5;
                    int n7 = n2 - (this.size.getRows() - n4) - 1;
                    int n8 = n7 * n5 + n / n6;
                    String string = null;
                    Iterator<String> iterator = this.shortcuts.keySet().iterator();
                    while (n8-- >= 0 && iterator.hasNext()) {
                        string = iterator.next();
                    }
                    if (string != null) {
                        string = string.replaceAll("M-", "\\\\E");
                        String string2 = KeyMap.translate(string);
                        this.bindingReader.runMacro(string2);
                    }
                }
            }
        } else if (mouseEvent.getType() == MouseEvent.Type.Wheel) {
            if (mouseEvent.getButton() == MouseEvent.Button.WheelDown) {
                this.buffer.moveDown(1);
            } else if (mouseEvent.getButton() == MouseEvent.Button.WheelUp) {
                this.buffer.moveUp(1);
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    void resetDisplay() {
        this.display.clear();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        for (Buffer buffer : this.buffers) {
            buffer.resetDisplay();
        }
    }

    synchronized void display() {
        int n;
        if (this.nbBindings > 0 && --this.nbBindings == 0) {
            this.message = null;
        }
        List<AttributedString> list = this.buffer.computeHeader();
        List<AttributedString> list2 = this.computeFooter();
        int n2 = this.size.getRows() - list.size() - list2.size();
        List<AttributedString> list3 = this.buffer.getDisplayedLines(n2);
        list3.addAll(0, list);
        list3.addAll(list2);
        if (this.editMessage != null) {
            n = this.editMessage.length() + this.editBuffer.length();
            n = this.size.cursorPos(this.size.getRows() - list2.size(), n);
        } else {
            n = this.size.cursorPos(list.size(), this.buffer.getDisplayedCursor());
        }
        this.display.update(list3, n);
    }

    protected List<AttributedString> computeFooter() {
        int n;
        int n2;
        int n3;
        Object object;
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        if (this.editMessage != null) {
            object = new AttributedStringBuilder();
            ((AttributedStringBuilder)object).style(AttributedStyle.INVERSE);
            ((AttributedStringBuilder)object).append(this.editMessage);
            ((AttributedStringBuilder)object).append(this.editBuffer);
            for (n3 = this.editMessage.length() + this.editBuffer.length(); n3 < this.size.getColumns(); ++n3) {
                ((AttributedStringBuilder)object).append(' ');
            }
            ((AttributedStringBuilder)object).append('\n');
            arrayList.add(((AttributedCharSequence)object).toAttributedString());
        } else if (this.message != null || this.constantCursor) {
            int n4 = this.size.getColumns();
            String string = "[ " + (this.message == null ? this.computeCurPos() : this.message) + " ]";
            n2 = string.length();
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            for (n = 0; n < (n4 - n2) / 2; ++n) {
                attributedStringBuilder.append(' ');
            }
            attributedStringBuilder.style(AttributedStyle.INVERSE);
            attributedStringBuilder.append(string);
            attributedStringBuilder.append('\n');
            arrayList.add(attributedStringBuilder.toAttributedString());
        } else {
            arrayList.add(new AttributedString("\n"));
        }
        object = this.shortcuts.entrySet().iterator();
        n3 = (this.shortcuts.size() + 1) / 2;
        n2 = (this.size.getColumns() - 1) / n3;
        int n5 = (this.size.getColumns() - 1) % n3;
        for (n = 0; n < 2; ++n) {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            for (int i = 0; i < n3; ++i) {
                Map.Entry entry = object.hasNext() ? (Map.Entry)object.next() : null;
                String string = entry != null ? (String)entry.getKey() : "";
                String string2 = entry != null ? (String)entry.getValue() : "";
                attributedStringBuilder.style(AttributedStyle.INVERSE);
                attributedStringBuilder.append(string);
                attributedStringBuilder.style(AttributedStyle.DEFAULT);
                attributedStringBuilder.append(" ");
                int n6 = n2 - string.length() - 1 + (i < n5 ? 1 : 0);
                if (string2.length() > n6) {
                    attributedStringBuilder.append(string2.substring(0, n6));
                    continue;
                }
                attributedStringBuilder.append(string2);
                if (i >= n3 - 1) continue;
                for (int j = 0; j < n6 - string2.length(); ++j) {
                    attributedStringBuilder.append(" ");
                }
            }
            attributedStringBuilder.append('\n');
            arrayList.add(attributedStringBuilder.toAttributedString());
        }
        return arrayList;
    }

    protected void handle(Terminal.Signal signal) {
        this.size.copy(this.terminal.getSize());
        this.buffer.computeAllOffsets();
        this.buffer.moveToChar(this.buffer.offsetInLine + this.buffer.column);
        this.resetDisplay();
        this.display();
    }

    protected void bindKeys() {
        char c;
        this.keys = new KeyMap();
        this.keys.setUnicode(Operation.INSERT);
        for (c = ' '; c < '\u0080'; c = (char)((char)(c + 1))) {
            this.keys.bind(Operation.INSERT, (CharSequence)Character.toString(c));
        }
        this.keys.bind(Operation.BACKSPACE, (CharSequence)KeyMap.del());
        for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
            this.keys.bind(Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt(c));
        }
        this.keys.bind(Operation.HELP, KeyMap.ctrl('G'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f1));
        this.keys.bind(Operation.QUIT, KeyMap.ctrl('X'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f2));
        this.keys.bind(Operation.WRITE, KeyMap.ctrl('O'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f3));
        this.keys.bind(Operation.JUSTIFY_PARAGRAPH, KeyMap.ctrl('J'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f4));
        this.keys.bind(Operation.READ, KeyMap.ctrl('R'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f5));
        this.keys.bind(Operation.SEARCH, KeyMap.ctrl('W'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f6));
        this.keys.bind(Operation.PREV_PAGE, KeyMap.ctrl('Y'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f7));
        this.keys.bind(Operation.NEXT_PAGE, KeyMap.ctrl('V'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f8));
        this.keys.bind(Operation.CUT, KeyMap.ctrl('K'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f9));
        this.keys.bind(Operation.UNCUT, KeyMap.ctrl('U'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f10));
        this.keys.bind(Operation.CUR_POS, KeyMap.ctrl('C'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f11));
        this.keys.bind(Operation.TO_SPELL, KeyMap.ctrl('T'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f11));
        this.keys.bind(Operation.GOTO, KeyMap.ctrl('_'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f13), KeyMap.alt('g'));
        this.keys.bind(Operation.REPLACE, KeyMap.ctrl('\\'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f14), KeyMap.alt('r'));
        this.keys.bind(Operation.MARK, KeyMap.ctrl('^'), KeyMap.key(this.terminal, InfoCmp.Capability.key_f15), KeyMap.alt('a'));
        this.keys.bind(Operation.NEXT_SEARCH, KeyMap.key(this.terminal, InfoCmp.Capability.key_f16), KeyMap.alt('w'));
        this.keys.bind(Operation.COPY, (CharSequence)KeyMap.alt('^'));
        this.keys.bind(Operation.INDENT, (CharSequence)KeyMap.alt('}'));
        this.keys.bind(Operation.UNINDENT, (CharSequence)KeyMap.alt('{'));
        this.keys.bind(Operation.RIGHT, (CharSequence)KeyMap.ctrl('F'));
        this.keys.bind(Operation.LEFT, (CharSequence)KeyMap.ctrl('B'));
        this.keys.bind(Operation.NEXT_WORD, (CharSequence)KeyMap.ctrl(' '));
        this.keys.bind(Operation.PREV_WORD, (CharSequence)KeyMap.alt(' '));
        this.keys.bind(Operation.UP, (CharSequence)KeyMap.ctrl('P'));
        this.keys.bind(Operation.DOWN, (CharSequence)KeyMap.ctrl('N'));
        this.keys.bind(Operation.BEGINNING_OF_LINE, (CharSequence)KeyMap.ctrl('A'));
        this.keys.bind(Operation.END_OF_LINE, (CharSequence)KeyMap.ctrl('E'));
        this.keys.bind(Operation.BEGINNING_OF_PARAGRAPH, KeyMap.alt('('), KeyMap.alt('9'));
        this.keys.bind(Operation.END_OF_PARAGRAPH, KeyMap.alt(')'), KeyMap.alt('0'));
        this.keys.bind(Operation.FIRST_LINE, KeyMap.alt('\\'), KeyMap.alt('|'));
        this.keys.bind(Operation.LAST_LINE, KeyMap.alt('/'), KeyMap.alt('?'));
        this.keys.bind(Operation.MATCHING, (CharSequence)KeyMap.alt(']'));
        this.keys.bind(Operation.SCROLL_UP, KeyMap.alt('-'), KeyMap.alt('_'));
        this.keys.bind(Operation.SCROLL_DOWN, KeyMap.alt('+'), KeyMap.alt('='));
        this.keys.bind(Operation.PREV_BUFFER, (CharSequence)KeyMap.alt('<'));
        this.keys.bind(Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt('>'));
        this.keys.bind(Operation.PREV_BUFFER, (CharSequence)KeyMap.alt(','));
        this.keys.bind(Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt('.'));
        this.keys.bind(Operation.VERBATIM, (CharSequence)KeyMap.alt('v'));
        this.keys.bind(Operation.INSERT, KeyMap.ctrl('I'), KeyMap.ctrl('M'));
        this.keys.bind(Operation.DELETE, (CharSequence)KeyMap.ctrl('D'));
        this.keys.bind(Operation.BACKSPACE, (CharSequence)KeyMap.ctrl('H'));
        this.keys.bind(Operation.CUT_TO_END, (CharSequence)KeyMap.alt('t'));
        this.keys.bind(Operation.JUSTIFY_FILE, (CharSequence)KeyMap.alt('j'));
        this.keys.bind(Operation.COUNT, (CharSequence)KeyMap.alt('d'));
        this.keys.bind(Operation.CLEAR_SCREEN, (CharSequence)KeyMap.ctrl('L'));
        this.keys.bind(Operation.HELP, (CharSequence)KeyMap.alt('x'));
        this.keys.bind(Operation.CONSTANT_CURSOR, (CharSequence)KeyMap.alt('c'));
        this.keys.bind(Operation.ONE_MORE_LINE, (CharSequence)KeyMap.alt('o'));
        this.keys.bind(Operation.SMOOTH_SCROLLING, (CharSequence)KeyMap.alt('s'));
        this.keys.bind(Operation.MOUSE_SUPPORT, (CharSequence)KeyMap.alt('m'));
        this.keys.bind(Operation.WHITESPACE, (CharSequence)KeyMap.alt('p'));
        this.keys.bind(Operation.HIGHLIGHT, (CharSequence)KeyMap.alt('y'));
        this.keys.bind(Operation.SMART_HOME_KEY, (CharSequence)KeyMap.alt('h'));
        this.keys.bind(Operation.AUTO_INDENT, (CharSequence)KeyMap.alt('i'));
        this.keys.bind(Operation.CUT_TO_END_TOGGLE, (CharSequence)KeyMap.alt('k'));
        this.keys.bind(Operation.TABS_TO_SPACE, (CharSequence)KeyMap.alt('q'));
        this.keys.bind(Operation.BACKUP, (CharSequence)KeyMap.alt('b'));
        this.keys.bind(Operation.NUMBERS, (CharSequence)KeyMap.alt('n'));
        this.keys.bind(Operation.UP, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        this.keys.bind(Operation.DOWN, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        this.keys.bind(Operation.RIGHT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        this.keys.bind(Operation.LEFT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        this.keys.bind(Operation.MOUSE_EVENT, (CharSequence)KeyMap.key(this.terminal, InfoCmp.Capability.key_mouse));
    }

    protected static enum Operation {
        DO_LOWER_CASE,
        QUIT,
        WRITE,
        READ,
        GOTO,
        FIND,
        WRAP,
        NUMBERS,
        SMOOTH_SCROLLING,
        MOUSE_SUPPORT,
        ONE_MORE_LINE,
        CLEAR_SCREEN,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        INSERT,
        BACKSPACE,
        NEXT_BUFFER,
        PREV_BUFFER,
        HELP,
        NEXT_PAGE,
        PREV_PAGE,
        SCROLL_UP,
        SCROLL_DOWN,
        NEXT_WORD,
        PREV_WORD,
        BEGINNING_OF_LINE,
        END_OF_LINE,
        FIRST_LINE,
        LAST_LINE,
        CUR_POS,
        CASE_SENSITIVE,
        BACKWARDS,
        REGEXP,
        ACCEPT,
        CANCEL,
        SEARCH,
        MAC_FORMAT,
        DOS_FORMAT,
        APPEND_MODE,
        PREPEND_MODE,
        BACKUP,
        TO_FILES,
        YES,
        NO,
        NEW_BUFFER,
        EXECUTE,
        NEXT_SEARCH,
        MATCHING,
        VERBATIM,
        DELETE,
        JUSTIFY_PARAGRAPH,
        TO_SPELL,
        CUT,
        REPLACE,
        MARK,
        COPY,
        INDENT,
        UNINDENT,
        BEGINNING_OF_PARAGRAPH,
        END_OF_PARAGRAPH,
        CUT_TO_END,
        JUSTIFY_FILE,
        COUNT,
        CONSTANT_CURSOR,
        WHITESPACE,
        HIGHLIGHT,
        SMART_HOME_KEY,
        AUTO_INDENT,
        CUT_TO_END_TOGGLE,
        TABS_TO_SPACE,
        UNCUT,
        MOUSE_EVENT;

    }

    protected class Buffer {
        String file;
        Charset charset;
        WriteFormat format = WriteFormat.UNIX;
        List<String> lines;
        int firstLineToDisplay;
        int firstColumnToDisplay;
        int offsetInLineToDisplay;
        int line;
        List<LinkedList<Integer>> offsets = new ArrayList<LinkedList<Integer>>();
        int offsetInLine;
        int column;
        int wantedColumn;
        boolean dirty;

        protected Buffer(String string) {
            this.file = string;
        }

        void open() {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            if (this.file == null) {
                return;
            }
            Path path = Nano.this.root.resolve(this.file);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Nano.this.setMessage("\"" + this.file + "\" is a directory");
                return;
            }
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                this.read(inputStream);
            }
            catch (IOException iOException) {
                Nano.this.setMessage("Error reading " + this.file + ": " + iOException.getMessage());
            }
        }

        void open(InputStream inputStream) {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            this.read(inputStream);
        }

        void read(InputStream inputStream) {
            Object object;
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            try {
                object = new UniversalDetector(null);
                object.handleData(byArray2, 0, byArray2.length);
                object.dataEnd();
                if (object.getDetectedCharset() != null) {
                    this.charset = Charset.forName(object.getDetectedCharset());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(byArray2), this.charset));
            Throwable throwable = null;
            try {
                String string;
                this.lines.clear();
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    this.lines.add(string);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
            if (this.lines.isEmpty()) {
                this.lines.add("");
            }
            this.computeAllOffsets();
            this.moveToChar(0);
        }

        void insert(String string) {
            String string2 = this.lines.get(this.line);
            int n = this.offsetInLine + this.column;
            string = string.replaceAll("\r\n", "\n");
            string = string.replaceAll("\r", "\n");
            String string3 = n == string2.length() ? string2 + string : string2.substring(0, n) + string + string2.substring(n);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            int n3 = string3.indexOf(10, n2);
            while (n3 >= 0) {
                arrayList.add(string3.substring(n2, n3));
                n2 = n3 + 1;
                n3 = string3.indexOf(10, n2);
            }
            arrayList.add(string3.substring(n2));
            this.lines.set(this.line, (String)arrayList.get(0));
            this.offsets.set(this.line, this.computeOffsets((String)arrayList.get(0)));
            for (int i = 1; i < arrayList.size(); ++i) {
                ++this.line;
                this.lines.add(this.line, (String)arrayList.get(i));
                this.offsets.add(this.line, this.computeOffsets((String)arrayList.get(i)));
            }
            this.moveToChar(((String)arrayList.get(arrayList.size() - 1)).length() - (string2.length() - n));
            this.dirty = true;
        }

        void computeAllOffsets() {
            this.offsets.clear();
            for (String string : this.lines) {
                this.offsets.add(this.computeOffsets(string));
            }
        }

        LinkedList<Integer> computeOffsets(String string) {
            int n = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            linkedList.add(0);
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (this.isBreakable(string.charAt(i))) {
                    bl = true;
                } else if (bl) {
                    n3 = i;
                    bl = false;
                }
                if (i != n2 + n - 1) continue;
                if (n3 == n2) {
                    n3 = i;
                }
                linkedList.add(n3);
                n2 = n3;
            }
            return linkedList;
        }

        boolean isBreakable(char c) {
            return c == ' ';
        }

        void moveToChar(int n) {
            this.offsetInLine = this.prevLineOffset(this.line, n + 1).get();
            this.column = n - this.offsetInLine;
        }

        void delete(int n) {
            while (--n >= 0 && this.moveRight(1) && this.backspace(1)) {
            }
        }

        boolean backspace(int n) {
            while (n > 0) {
                String string = this.lines.get(this.line);
                int n2 = this.offsetInLine + this.column;
                if (n2 == 0) {
                    if (this.line == 0) {
                        this.bof();
                        return false;
                    }
                    String string2 = this.lines.get(--this.line);
                    this.lines.set(this.line, string2 + string);
                    this.offsets.set(this.line, this.computeOffsets(string2 + string));
                    this.moveToChar(this.length(string2, Nano.this.tabs));
                    this.lines.remove(this.line + 1);
                    this.offsets.remove(this.line + 1);
                    --n;
                    this.dirty = true;
                    continue;
                }
                int n3 = Math.min(n2, n);
                string = string.substring(0, n2 - n3) + string.substring(n2);
                this.lines.set(this.line, string);
                this.offsets.set(this.line, this.computeOffsets(string));
                this.moveToChar(this.offsetInLine + this.column - n3);
                n -= n3;
                this.dirty = true;
            }
            return true;
        }

        boolean moveLeft(int n) {
            boolean bl = true;
            while (--n >= 0) {
                if (this.offsetInLine + this.column > 0) {
                    this.moveToChar(this.offsetInLine + this.column - 1);
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.moveToChar(this.length(this.getLine(this.line), Nano.this.tabs));
                    continue;
                }
                this.bof();
                bl = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return bl;
        }

        boolean moveRight(int n) {
            boolean bl = true;
            while (--n >= 0) {
                int n2 = this.length(this.getLine(this.line), Nano.this.tabs);
                if (this.offsetInLine + this.column + 1 <= n2) {
                    this.moveToChar(this.offsetInLine + this.column + 1);
                    continue;
                }
                if (this.getLine(this.line + 1) != null) {
                    ++this.line;
                    this.offsetInLine = 0;
                    this.column = 0;
                    continue;
                }
                this.eof();
                bl = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return bl;
        }

        void moveDown(int n) {
            this.cursorDown(n);
            this.ensureCursorVisible();
        }

        void moveUp(int n) {
            this.cursorUp(n);
            this.ensureCursorVisible();
        }

        private Optional<Integer> prevLineOffset(int n, int n2) {
            if (n >= this.offsets.size()) {
                return Optional.empty();
            }
            Iterator<Integer> iterator = this.offsets.get(n).descendingIterator();
            while (iterator.hasNext()) {
                int n3 = iterator.next();
                if (n3 >= n2) continue;
                return Optional.of(n3);
            }
            return Optional.empty();
        }

        private Optional<Integer> nextLineOffset(int n, int n3) {
            if (n >= this.offsets.size()) {
                return Optional.empty();
            }
            return this.offsets.get(n).stream().filter(n2 -> n2 > n3).findFirst();
        }

        void moveDisplayDown(int n) {
            int n2 = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            while (--n >= 0) {
                int n3 = this.firstLineToDisplay;
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    n3 += n2 - 1;
                } else {
                    int n4 = this.offsetInLineToDisplay;
                    for (int i = 0; i < n2 - 1; ++i) {
                        Optional<Integer> optional = this.nextLineOffset(n3, n4);
                        if (optional.isPresent()) {
                            n4 = optional.get();
                            continue;
                        }
                        n4 = 0;
                        ++n3;
                    }
                }
                if (this.getLine(n3) == null) {
                    this.eof();
                    return;
                }
                Optional<Integer> optional = this.nextLineOffset(this.firstLineToDisplay, this.offsetInLineToDisplay);
                if (optional.isPresent()) {
                    this.offsetInLineToDisplay = optional.get();
                    continue;
                }
                this.offsetInLineToDisplay = 0;
                ++this.firstLineToDisplay;
            }
        }

        void moveDisplayUp(int n) {
            int n2 = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            while (--n >= 0) {
                if (this.offsetInLineToDisplay > 0) {
                    this.offsetInLineToDisplay = Math.max(0, this.offsetInLineToDisplay - (n2 - 1));
                    continue;
                }
                if (this.firstLineToDisplay > 0) {
                    --this.firstLineToDisplay;
                    this.offsetInLineToDisplay = this.prevLineOffset(this.firstLineToDisplay, Integer.MAX_VALUE).get();
                    continue;
                }
                this.bof();
                return;
            }
        }

        private void cursorDown(int n) {
            while (--n >= 0) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    if (this.getLine(this.line + 1) != null) {
                        ++this.line;
                        this.offsetInLine = 0;
                        this.column = Math.min(this.getLine(this.line).length(), this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                String string = this.getLine(this.line);
                Optional<Integer> optional = this.nextLineOffset(this.line, this.offsetInLine);
                if (optional.isPresent()) {
                    this.offsetInLine = optional.get();
                } else {
                    if (this.getLine(this.line + 1) == null) {
                        this.eof();
                        break;
                    }
                    ++this.line;
                    this.offsetInLine = 0;
                    string = this.getLine(this.line);
                }
                String string2 = string;
                int n2 = this.nextLineOffset(this.line, this.offsetInLine).orElseGet(string2::length);
                this.column = Math.min(this.wantedColumn, n2 - this.offsetInLine);
            }
        }

        private void cursorUp(int n) {
            while (--n >= 0) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    if (this.line > 0) {
                        --this.line;
                        this.column = Math.min(this.length(this.getLine(this.line), Nano.this.tabs) - this.offsetInLine, this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                Optional<Integer> optional = this.prevLineOffset(this.line, this.offsetInLine);
                if (optional.isPresent()) {
                    this.offsetInLine = optional.get();
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.offsetInLine = this.prevLineOffset(this.line, Integer.MAX_VALUE).get();
                    int n2 = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.getLine(this.line).length());
                    this.column = Math.min(this.wantedColumn, n2 - this.offsetInLine);
                    continue;
                }
                this.bof();
                break;
            }
        }

        void ensureCursorVisible() {
            List<AttributedString> list = this.computeHeader();
            int n = Nano.this.size.getColumns();
            int n2 = Nano.this.size.getRows() - list.size() - Nano.this.computeFooter().size();
            while (this.line < this.firstLineToDisplay || this.line == this.firstLineToDisplay && this.offsetInLine < this.offsetInLineToDisplay) {
                this.moveDisplayUp(Nano.this.smoothScrolling ? 1 : n2 / 2);
            }
            while (true) {
                int n3 = list.size() * Nano.this.size.getColumns() + (Nano.this.printLineNumbers ? 8 : 0);
                int n4 = this.firstLineToDisplay;
                int n5 = this.offsetInLineToDisplay;
                while (n4 < this.line || n5 < this.offsetInLine) {
                    if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                        n3 += n;
                        ++n4;
                        continue;
                    }
                    n3 += n;
                    Optional<Integer> optional = this.nextLineOffset(n4, n5);
                    if (optional.isPresent()) {
                        n5 = optional.get();
                        continue;
                    }
                    ++n4;
                    n5 = 0;
                }
                if (n4 != this.line) {
                    throw new IllegalStateException();
                }
                if ((n3 += this.column) < (n2 + list.size()) * n) break;
                this.moveDisplayDown(Nano.this.smoothScrolling ? 1 : n2 / 2);
            }
        }

        void eof() {
        }

        void bof() {
        }

        void resetDisplay() {
            int n = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            this.column = this.offsetInLine + this.column;
            this.offsetInLine = this.column / n * (n - 1);
            this.column -= this.offsetInLine;
        }

        String getLine(int n) {
            return n < this.lines.size() ? this.lines.get(n) : null;
        }

        String getTitle() {
            return this.file != null ? "File: " + this.file : "New Buffer";
        }

        List<AttributedString> computeHeader() {
            int n;
            CharSequence charSequence;
            int n2;
            String string = Nano.this.getTitle();
            String string2 = null;
            String string3 = this.dirty ? "Modified" : "        ";
            int n3 = Nano.this.size.getColumns();
            int n4 = 2 + string.length() + 1;
            int n5 = n3 - 2 - 8;
            if (this.file == null) {
                string2 = "New Buffer";
            } else {
                n2 = n5 - n4;
                charSequence = this.file;
                if ("File: ".length() + ((String)charSequence).length() > n2) {
                    n = ((String)charSequence).lastIndexOf(47);
                    if (n > 0) {
                        String string4 = ((String)charSequence).substring(n);
                        String string5 = ((String)charSequence).substring(0, n);
                        while (string5.startsWith(".")) {
                            string5 = string5.substring(1);
                        }
                        int n6 = n2 - string4.length() - "File: ...".length();
                        int n7 = Math.max(0, Math.min(string5.length(), string5.length() - n6));
                        string2 = "File: ..." + string5.substring(n7, string5.length()) + string4;
                    }
                    if (string2 == null || string2.length() > n2) {
                        string = null;
                        n2 = n5 - 2;
                        int n8 = n2 - "File: ...".length();
                        int n9 = Math.max(0, Math.min(((String)charSequence).length(), ((String)charSequence).length() - n8));
                        string2 = "File: ..." + ((String)charSequence).substring(n9, ((String)charSequence).length());
                        if (string2.length() > n2) {
                            string2 = string2.substring(0, n2);
                        }
                    }
                } else {
                    string2 = "File: " + (String)charSequence;
                }
            }
            n2 = 0;
            charSequence = new AttributedStringBuilder();
            ((AttributedStringBuilder)charSequence).style(AttributedStyle.INVERSE);
            ((AttributedStringBuilder)charSequence).append("  ");
            n2 += 2;
            if (string != null) {
                ((AttributedStringBuilder)charSequence).append(string);
                n2 += string.length();
                ((AttributedStringBuilder)charSequence).append(" ");
                ++n2;
                for (n = 1; n < (Nano.this.size.getColumns() - string2.length()) / 2 - string.length() - 1 - 2; ++n) {
                    ((AttributedStringBuilder)charSequence).append(" ");
                    ++n2;
                }
            }
            ((AttributedStringBuilder)charSequence).append(string2);
            n2 += string2.length();
            while (n2 < n3 - 8 - 2) {
                ((AttributedStringBuilder)charSequence).append(" ");
                ++n2;
            }
            ((AttributedStringBuilder)charSequence).append(string3);
            ((AttributedStringBuilder)charSequence).append("  \n");
            if (Nano.this.oneMoreLine) {
                return Collections.singletonList(((AttributedCharSequence)charSequence).toAttributedString());
            }
            return Arrays.asList(((AttributedCharSequence)charSequence).toAttributedString(), new AttributedString("\n"));
        }

        List<AttributedString> getDisplayedLines(int n) {
            AttributedStyle attributedStyle = AttributedStyle.DEFAULT.foreground(8);
            AttributedString attributedString = new AttributedString("\u2026", attributedStyle);
            AttributedString attributedString2 = new AttributedString("\u21a9", attributedStyle);
            ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
            int n2 = Nano.this.size.getColumns();
            int n3 = n2 - (Nano.this.printLineNumbers ? 8 : 0);
            int n4 = this.firstLineToDisplay;
            int n5 = this.offsetInLineToDisplay;
            int n6 = -1;
            for (int i = 0; i < n; ++i) {
                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder().tabs(Nano.this.tabs);
                if (Nano.this.printLineNumbers && n4 < this.lines.size()) {
                    attributedStringBuilder.style(attributedStyle);
                    if (n4 != n6) {
                        attributedStringBuilder.append(String.format("%7d ", n4 + 1));
                    } else {
                        attributedStringBuilder.append("      \u2027 ");
                    }
                    attributedStringBuilder.style(AttributedStyle.DEFAULT);
                    n6 = n4;
                }
                if (n4 < this.lines.size()) {
                    Optional<Integer> optional;
                    if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                        optional = new AttributedString(this.getLine(n4));
                        if (((AttributedCharSequence)((Object)(optional = ((AttributedCharSequence)((Object)optional)).columnSubSequence(this.firstColumnToDisplay, Integer.MAX_VALUE)))).columnLength() >= n3) {
                            attributedStringBuilder.append(((AttributedCharSequence)((Object)optional)).columnSubSequence(0, n3 - attributedString.columnLength()));
                            attributedStringBuilder.append(attributedString);
                        } else {
                            attributedStringBuilder.append((AttributedString)((Object)optional));
                        }
                        ++n4;
                    } else {
                        AttributedString attributedString3;
                        optional = this.nextLineOffset(n4, n5);
                        if (optional.isPresent()) {
                            attributedString3 = new AttributedString(this.getLine(n4));
                            attributedStringBuilder.append(attributedString3.columnSubSequence(n5, (Integer)optional.get()));
                            attributedStringBuilder.append(attributedString2);
                            n5 = (Integer)optional.get();
                        } else {
                            attributedString3 = new AttributedString(this.getLine(n4));
                            attributedStringBuilder.append(attributedString3.columnSubSequence(n5, Integer.MAX_VALUE));
                            ++n4;
                            n5 = 0;
                        }
                    }
                }
                attributedStringBuilder.append('\n');
                arrayList.add(attributedStringBuilder.toAttributedString());
            }
            return arrayList;
        }

        public void moveTo(int n, int n2) {
            if (Nano.this.printLineNumbers) {
                n = Math.max(n - 8, 0);
            }
            this.line = this.firstLineToDisplay;
            this.offsetInLine = this.offsetInLineToDisplay;
            this.wantedColumn = n;
            this.cursorDown(n2);
        }

        public int getDisplayedCursor() {
            int n = Nano.this.size.getColumns() + 1;
            int n2 = Nano.this.printLineNumbers ? 8 : 0;
            int n3 = this.firstLineToDisplay;
            int n4 = this.offsetInLineToDisplay;
            while (n3 < this.line || n4 < this.offsetInLine) {
                if (this.firstColumnToDisplay > 0 || !Nano.this.wrapping) {
                    n2 += n;
                    ++n3;
                    continue;
                }
                n2 += n;
                Optional<Integer> optional = this.nextLineOffset(n3, n4);
                if (optional.isPresent()) {
                    n4 = optional.get();
                    continue;
                }
                ++n3;
                n4 = 0;
            }
            if (n3 != this.line) {
                throw new IllegalStateException();
            }
            return n2 += this.column;
        }

        char getCurrentChar() {
            String string = this.lines.get(this.line);
            if (this.column + this.offsetInLine < string.length()) {
                return string.charAt(this.column + this.offsetInLine);
            }
            if (this.line < this.lines.size() - 1) {
                return '\n';
            }
            return '\u0000';
        }

        public void prevWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            this.moveRight(1);
        }

        public void nextWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
        }

        public void beginningOfLine() {
            this.offsetInLine = 0;
            this.column = 0;
            this.wantedColumn = 0;
        }

        public void endOfLine() {
            this.column = this.length(this.lines.get(this.line), Nano.this.tabs);
            int n = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            this.offsetInLine = this.column / n * (n - 1);
            this.column -= this.offsetInLine;
            this.wantedColumn = this.column;
        }

        public void prevPage() {
            int n = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollUp(n - 2);
        }

        public void nextPage() {
            int n = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollDown(n - 2);
        }

        public void scrollUp(int n) {
            this.cursorUp(n);
            this.moveDisplayUp(n);
        }

        public void scrollDown(int n) {
            this.cursorDown(n);
            this.moveDisplayDown(n);
        }

        public void firstLine() {
            this.line = 0;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        public void lastLine() {
            this.line = this.lines.size() - 1;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        void nextSearch() {
            if (Nano.this.searchTerm == null) {
                Nano.this.setMessage("No current search pattern");
                return;
            }
            Nano.this.setMessage(null);
            int n = this.line;
            int n2 = Nano.this.searchBackwards ? -1 : 1;
            int n3 = -1;
            int n4 = -1;
            List<Integer> list = this.doSearch(this.lines.get(this.line));
            if (Nano.this.searchBackwards) {
                Collections.reverse(list);
            }
            for (int n5 : list) {
                if (!(Nano.this.searchBackwards ? n5 < this.offsetInLine + this.column : n5 > this.offsetInLine + this.column)) continue;
                n3 = n5;
                n4 = this.line;
                break;
            }
            if (n3 < 0) {
                while ((n = (n + n2 + this.lines.size()) % this.lines.size()) != this.line) {
                    List<Integer> list2 = this.doSearch(this.lines.get(n));
                    if (list2.isEmpty()) continue;
                    n3 = Nano.this.searchBackwards ? ((Integer)list2.get(list2.size() - 1)).intValue() : ((Integer)list2.get(0)).intValue();
                    n4 = n;
                    break;
                }
            }
            if (n3 < 0 && !list.isEmpty()) {
                n3 = list.get(0);
                n4 = this.line;
            }
            if (n3 >= 0) {
                if (n4 == this.line && n3 == this.offsetInLine + this.column) {
                    Nano.this.setMessage("This is the only occurence");
                    return;
                }
                if (Nano.this.searchBackwards && (n4 > this.line || n4 == this.line && n3 > this.offsetInLine + this.column) || !Nano.this.searchBackwards && (n4 < this.line || n4 == this.line && n3 < this.offsetInLine + this.column)) {
                    Nano.this.setMessage("Search Wrapped");
                }
                int n6 = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
                this.line = n4;
                this.column = n3;
                this.offsetInLine = this.column / n6 * (n6 - 1);
                this.ensureCursorVisible();
            } else {
                Nano.this.setMessage("\"" + Nano.this.searchTerm + "\" not found");
            }
        }

        private List<Integer> doSearch(String string) {
            Pattern pattern = Pattern.compile(Nano.this.searchTerm, (Nano.this.searchCaseSensitive ? 0 : 66) | (Nano.this.searchRegexp ? 0 : 16));
            Matcher matcher = pattern.matcher(string);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (matcher.find()) {
                arrayList.add(matcher.start());
            }
            return arrayList;
        }

        public void matching() {
            char c = this.getCurrentChar();
            int n = Nano.this.matchBrackets.indexOf(c);
            if (n >= 0) {
                int n2 = n >= Nano.this.matchBrackets.length() / 2 ? -1 : 1;
                char c2 = Nano.this.matchBrackets.charAt((n + Nano.this.matchBrackets.length() / 2) % Nano.this.matchBrackets.length());
                int n3 = 1;
                int n4 = this.line;
                int n5 = this.offsetInLine + this.column;
                while (true) {
                    if (n5 + n2 >= 0 && n5 + n2 < this.getLine(n4).length()) {
                        n5 += n2;
                    } else if (n4 + n2 >= 0 && n4 + n2 < this.lines.size()) {
                        n5 = n2 > 0 ? 0 : this.lines.get(n4 += n2).length() - 1;
                        if (n5 < 0 || n5 >= this.lines.get(n4).length()) {
                            continue;
                        }
                    } else {
                        Nano.this.setMessage("No matching bracket");
                        return;
                    }
                    char c3 = this.lines.get(n4).charAt(n5);
                    if (c3 == c) {
                        ++n3;
                        continue;
                    }
                    if (c3 == c2 && --n3 == 0) break;
                }
                this.line = n4;
                this.moveToChar(n5);
                this.ensureCursorVisible();
                return;
            }
            Nano.this.setMessage("Not a bracket");
        }

        private int length(String string, int n) {
            return new AttributedStringBuilder().tabs(n).append(string).columnLength();
        }
    }

    protected static enum WriteFormat {
        UNIX,
        DOS,
        MAC;

    }

    protected static enum WriteMode {
        WRITE,
        APPEND,
        PREPEND;

    }
}

