/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.jline.builtins.Source;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;

public class Less {
    private static final int ESCAPE = 27;
    public boolean quitAtSecondEof;
    public boolean quitAtFirstEof;
    public boolean quitIfOneScreen;
    public boolean printLineNumbers;
    public boolean quiet;
    public boolean veryQuiet;
    public boolean chopLongLines;
    public boolean ignoreCaseCond;
    public boolean ignoreCaseAlways;
    public boolean noKeypad;
    public boolean noInit;
    public int tabs = 4;
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected List<Source> sources;
    protected int sourceIdx;
    protected BufferedReader reader;
    protected KeyMap<Operation> keys;
    protected int firstLineInMemory = 0;
    protected List<AttributedString> lines = new ArrayList<AttributedString>();
    protected int firstLineToDisplay = 0;
    protected int firstColumnToDisplay = 0;
    protected int offsetInLine = 0;
    protected String message;
    protected final StringBuilder buffer = new StringBuilder();
    protected final Map<String, Operation> options = new TreeMap<String, Operation>();
    protected int window;
    protected int halfWindow;
    protected int nbEof;
    protected String pattern;
    protected final Size size = new Size();

    public Less(Terminal terminal) {
        this.terminal = terminal;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
    }

    public void handle(Terminal.Signal signal) {
        this.size.copy(this.terminal.getSize());
        try {
            this.display.clear();
            this.display(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void run(Source ... sourceArray) {
        this.run(Arrays.asList(sourceArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(List<Source> list) {
        block76: {
            if (list == null || list.isEmpty()) {
                throw new IllegalArgumentException("No sources");
            }
            this.sources = list;
            this.sourceIdx = 0;
            this.openSource();
            try {
                block75: {
                    this.size.copy(this.terminal.getSize());
                    if (this.quitIfOneScreen && list.size() == 1 && this.display(true)) {
                        return;
                    }
                    Terminal.SignalHandler signalHandler = this.terminal.handle(Terminal.Signal.WINCH, this::handle);
                    Attributes attributes = this.terminal.enterRawMode();
                    try {
                        Operation operation;
                        this.window = this.size.getRows() - 1;
                        this.halfWindow = this.window / 2;
                        this.keys = new KeyMap();
                        this.bindKeys(this.keys);
                        if (!this.noInit) {
                            this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
                        }
                        if (!this.noKeypad) {
                            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
                        }
                        this.terminal.writer().flush();
                        this.display(false);
                        Less.checkInterrupted();
                        this.options.put("-e", Operation.OPT_QUIT_AT_SECOND_EOF);
                        this.options.put("--quit-at-eof", Operation.OPT_QUIT_AT_SECOND_EOF);
                        this.options.put("-E", Operation.OPT_QUIT_AT_FIRST_EOF);
                        this.options.put("-QUIT-AT-EOF", Operation.OPT_QUIT_AT_FIRST_EOF);
                        this.options.put("-N", Operation.OPT_PRINT_LINES);
                        this.options.put("--LINE-NUMBERS", Operation.OPT_PRINT_LINES);
                        this.options.put("-q", Operation.OPT_QUIET);
                        this.options.put("--quiet", Operation.OPT_QUIET);
                        this.options.put("--silent", Operation.OPT_QUIET);
                        this.options.put("-Q", Operation.OPT_VERY_QUIET);
                        this.options.put("--QUIET", Operation.OPT_VERY_QUIET);
                        this.options.put("--SILENT", Operation.OPT_VERY_QUIET);
                        this.options.put("-S", Operation.OPT_CHOP_LONG_LINES);
                        this.options.put("--chop-long-lines", Operation.OPT_CHOP_LONG_LINES);
                        this.options.put("-i", Operation.OPT_IGNORE_CASE_COND);
                        this.options.put("--ignore-case", Operation.OPT_IGNORE_CASE_COND);
                        this.options.put("-I", Operation.OPT_IGNORE_CASE_ALWAYS);
                        this.options.put("--IGNORE-CASE", Operation.OPT_IGNORE_CASE_ALWAYS);
                        do {
                            Less.checkInterrupted();
                            operation = null;
                            if (this.buffer.length() > 0 && this.buffer.charAt(0) == '-') {
                                int n = this.terminal.reader().read();
                                this.message = null;
                                if (this.buffer.length() == 1) {
                                    this.buffer.append((char)n);
                                    if (n != 45 && (operation = this.options.get(this.buffer.toString())) == null) {
                                        this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                        this.buffer.setLength(0);
                                    }
                                } else if (n == 13) {
                                    operation = this.options.get(this.buffer.toString());
                                    if (operation == null) {
                                        this.message = "There is no " + this.printable(this.buffer.toString()) + " option";
                                        this.buffer.setLength(0);
                                    }
                                } else {
                                    this.buffer.append((char)n);
                                    HashMap<String, Operation> hashMap = new HashMap<String, Operation>();
                                    for (Map.Entry<String, Operation> entry : this.options.entrySet()) {
                                        if (!entry.getKey().startsWith(this.buffer.toString())) continue;
                                        hashMap.put(entry.getKey(), entry.getValue());
                                    }
                                    switch (hashMap.size()) {
                                        case 0: {
                                            this.buffer.setLength(0);
                                            break;
                                        }
                                        case 1: {
                                            this.buffer.setLength(0);
                                            this.buffer.append((String)hashMap.keySet().iterator().next());
                                        }
                                    }
                                }
                            } else if (this.buffer.length() > 0 && (this.buffer.charAt(0) == '/' || this.buffer.charAt(0) == '?')) {
                                int n = this.terminal.reader().read();
                                this.message = null;
                                if (n == 13) {
                                    this.pattern = this.buffer.toString().substring(1);
                                    if (this.buffer.charAt(0) == '/') {
                                        this.moveToNextMatch();
                                    } else {
                                        this.moveToPreviousMatch();
                                    }
                                    this.buffer.setLength(0);
                                } else {
                                    this.buffer.append((char)n);
                                }
                            } else {
                                Operation operation2 = this.bindingReader.readBinding(this.keys, null, false);
                                if (operation2 == Operation.CHAR) {
                                    char c = this.bindingReader.getLastBinding().charAt(0);
                                    if (c == '-' || c == '/' || c == '?') {
                                        this.buffer.setLength(0);
                                    }
                                    this.buffer.append(c);
                                } else {
                                    operation = operation2;
                                }
                            }
                            if (operation != null) {
                                this.message = null;
                                switch (operation) {
                                    case FORWARD_ONE_LINE: {
                                        this.moveForward(this.getStrictPositiveNumberInBuffer(1));
                                        break;
                                    }
                                    case BACKWARD_ONE_LINE: {
                                        this.moveBackward(this.getStrictPositiveNumberInBuffer(1));
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_OR_LINES: {
                                        this.moveForward(this.getStrictPositiveNumberInBuffer(this.window));
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_AND_SET: {
                                        this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                        this.moveForward(this.window);
                                        break;
                                    }
                                    case FORWARD_ONE_WINDOW_NO_STOP: {
                                        this.moveForward(this.window);
                                        break;
                                    }
                                    case FORWARD_HALF_WINDOW_AND_SET: {
                                        this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                        this.moveForward(this.halfWindow);
                                        break;
                                    }
                                    case BACKWARD_ONE_WINDOW_AND_SET: {
                                        this.window = this.getStrictPositiveNumberInBuffer(this.window);
                                        this.moveBackward(this.window);
                                        break;
                                    }
                                    case BACKWARD_ONE_WINDOW_OR_LINES: {
                                        this.moveBackward(this.getStrictPositiveNumberInBuffer(this.window));
                                        break;
                                    }
                                    case BACKWARD_HALF_WINDOW_AND_SET: {
                                        this.halfWindow = this.getStrictPositiveNumberInBuffer(this.halfWindow);
                                        this.moveBackward(this.halfWindow);
                                        break;
                                    }
                                    case GO_TO_FIRST_LINE_OR_N: {
                                        this.firstLineToDisplay = this.firstLineInMemory;
                                        this.offsetInLine = 0;
                                        break;
                                    }
                                    case GO_TO_LAST_LINE_OR_N: {
                                        this.moveForward(Integer.MAX_VALUE);
                                        break;
                                    }
                                    case LEFT_ONE_HALF_SCREEN: {
                                        this.firstColumnToDisplay = Math.max(0, this.firstColumnToDisplay - this.size.getColumns() / 2);
                                        break;
                                    }
                                    case RIGHT_ONE_HALF_SCREEN: {
                                        this.firstColumnToDisplay += this.size.getColumns() / 2;
                                        break;
                                    }
                                    case REPEAT_SEARCH_BACKWARD: 
                                    case REPEAT_SEARCH_BACKWARD_SPAN_FILES: {
                                        this.moveToPreviousMatch();
                                        break;
                                    }
                                    case REPEAT_SEARCH_FORWARD: 
                                    case REPEAT_SEARCH_FORWARD_SPAN_FILES: {
                                        this.moveToNextMatch();
                                        break;
                                    }
                                    case UNDO_SEARCH: {
                                        this.pattern = null;
                                        break;
                                    }
                                    case OPT_PRINT_LINES: {
                                        this.buffer.setLength(0);
                                        this.printLineNumbers = !this.printLineNumbers;
                                        this.message = this.printLineNumbers ? "Constantly display line numbers" : "Don't use line numbers";
                                        break;
                                    }
                                    case OPT_QUIET: {
                                        this.buffer.setLength(0);
                                        this.quiet = !this.quiet;
                                        this.veryQuiet = false;
                                        this.message = this.quiet ? "Ring the bell for errors but not at eof/bof" : "Ring the bell for errors AND at eof/bof";
                                        break;
                                    }
                                    case OPT_VERY_QUIET: {
                                        this.buffer.setLength(0);
                                        this.veryQuiet = !this.veryQuiet;
                                        this.quiet = false;
                                        this.message = this.veryQuiet ? "Never ring the bell" : "Ring the bell for errors AND at eof/bof";
                                        break;
                                    }
                                    case OPT_CHOP_LONG_LINES: {
                                        this.buffer.setLength(0);
                                        this.offsetInLine = 0;
                                        this.chopLongLines = !this.chopLongLines;
                                        this.message = this.chopLongLines ? "Chop long lines" : "Fold long lines";
                                        break;
                                    }
                                    case OPT_IGNORE_CASE_COND: {
                                        this.ignoreCaseCond = !this.ignoreCaseCond;
                                        this.ignoreCaseAlways = false;
                                        this.message = this.ignoreCaseCond ? "Ignore case in searches" : "Case is significant in searches";
                                        break;
                                    }
                                    case OPT_IGNORE_CASE_ALWAYS: {
                                        this.ignoreCaseAlways = !this.ignoreCaseAlways;
                                        this.ignoreCaseCond = false;
                                        this.message = this.ignoreCaseAlways ? "Ignore case in searches and in patterns" : "Case is significant in searches";
                                        break;
                                    }
                                    case NEXT_FILE: {
                                        if (this.sourceIdx < list.size() - 1) {
                                            ++this.sourceIdx;
                                            this.openSource();
                                            break;
                                        }
                                        this.message = "No next file";
                                        break;
                                    }
                                    case PREV_FILE: {
                                        if (this.sourceIdx > 0) {
                                            --this.sourceIdx;
                                            this.openSource();
                                            break;
                                        }
                                        this.message = "No previous file";
                                    }
                                }
                                this.buffer.setLength(0);
                            }
                            if (this.quitAtFirstEof && this.nbEof > 0 || this.quitAtSecondEof && this.nbEof > 1) {
                                if (this.sourceIdx < list.size() - 1) {
                                    ++this.sourceIdx;
                                    this.openSource();
                                } else {
                                    operation = Operation.EXIT;
                                }
                            }
                            this.display(false);
                        } while (operation != Operation.EXIT);
                        this.terminal.setAttributes(attributes);
                        if (signalHandler == null) break block75;
                        this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
                    }
                    catch (InterruptedException interruptedException) {
                        this.terminal.setAttributes(attributes);
                        if (signalHandler != null) {
                            this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
                        }
                        if (!this.noInit) {
                            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                        }
                        if (!this.noKeypad) {
                            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                        }
                        this.terminal.writer().flush();
                        break block76;
                        catch (Throwable throwable) {
                            this.terminal.setAttributes(attributes);
                            if (signalHandler != null) {
                                this.terminal.handle(Terminal.Signal.WINCH, signalHandler);
                            }
                            if (!this.noInit) {
                                this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                            }
                            if (!this.noKeypad) {
                                this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                            }
                            this.terminal.writer().flush();
                            throw throwable;
                        }
                    }
                }
                if (!this.noInit) {
                    this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
                }
                if (!this.noKeypad) {
                    this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
                }
                this.terminal.writer().flush();
            }
            finally {
                this.reader.close();
            }
        }
    }

    protected void openSource() {
        if (this.reader != null) {
            this.reader.close();
        }
        Source source = this.sources.get(this.sourceIdx);
        InputStream inputStream = source.read();
        this.message = this.sources.size() == 1 ? source.getName() : source.getName() + " (file " + (this.sourceIdx + 1) + " of " + this.sources.size() + ")";
        this.reader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(inputStream)));
        this.firstLineInMemory = 0;
        this.lines = new ArrayList<AttributedString>();
        this.firstLineToDisplay = 0;
        this.firstColumnToDisplay = 0;
        this.offsetInLine = 0;
    }

    private void moveToNextMatch() {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            AttributedString attributedString;
            int n = this.firstLineToDisplay + 1;
            while ((attributedString = this.getLine(n)) != null) {
                if (pattern.matcher(attributedString).find()) {
                    this.firstLineToDisplay = n;
                    this.offsetInLine = 0;
                    return;
                }
                ++n;
            }
        }
        this.message = "Pattern not found";
    }

    private void moveToPreviousMatch() {
        Pattern pattern = this.getPattern();
        if (pattern != null) {
            AttributedString attributedString;
            for (int i = this.firstLineToDisplay - 1; i >= this.firstLineInMemory && (attributedString = this.getLine(i)) != null; --i) {
                if (!pattern.matcher(attributedString).find()) continue;
                this.firstLineToDisplay = i;
                this.offsetInLine = 0;
                return;
            }
        }
        this.message = "Pattern not found";
    }

    private String printable(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u001b') {
                stringBuilder.append("ESC");
                continue;
            }
            if (c < ' ') {
                stringBuilder.append('^').append((char)(c + 64));
                continue;
            }
            if (c < '\u0080') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('\\').append(String.format("%03o", c));
        }
        return stringBuilder.toString();
    }

    void moveForward(int n) {
        int n2 = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        int n3 = this.size.getRows();
        while (--n >= 0) {
            int n4 = this.firstLineToDisplay;
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                n4 += n3 - 1;
            } else {
                AttributedString attributedString;
                int n5 = this.offsetInLine;
                for (int i = 0; i < n3 - 1 && (attributedString = this.getLine(n4)) != null; ++i) {
                    if (attributedString.columnLength() > n5 + n2) {
                        n5 += n2;
                        continue;
                    }
                    n5 = 0;
                    ++n4;
                }
            }
            if (this.getLine(n4) == null) {
                this.eof();
                return;
            }
            AttributedString attributedString = this.getLine(this.firstLineToDisplay);
            if (attributedString.columnLength() > n2 + this.offsetInLine) {
                this.offsetInLine += n2;
                continue;
            }
            this.offsetInLine = 0;
            ++this.firstLineToDisplay;
        }
    }

    void moveBackward(int n) {
        int n2 = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        while (--n >= 0) {
            if (this.offsetInLine > 0) {
                this.offsetInLine = Math.max(0, this.offsetInLine - n2);
                continue;
            }
            if (this.firstLineInMemory < this.firstLineToDisplay) {
                --this.firstLineToDisplay;
                AttributedString attributedString = this.getLine(this.firstLineToDisplay);
                int n3 = attributedString.columnLength();
                this.offsetInLine = n3 - n3 % n2;
                continue;
            }
            this.bof();
            return;
        }
    }

    private void eof() {
        ++this.nbEof;
        this.message = this.sourceIdx < this.sources.size() - 1 ? "(END) - Next: " + this.sources.get(this.sourceIdx + 1).getName() : "(END)";
        if (!(this.quiet || this.veryQuiet || this.quitAtFirstEof || this.quitAtSecondEof)) {
            this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
            this.terminal.writer().flush();
        }
    }

    private void bof() {
        if (!this.quiet && !this.veryQuiet) {
            this.terminal.puts(InfoCmp.Capability.bell, new Object[0]);
            this.terminal.writer().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getStrictPositiveNumberInBuffer(int n) {
        try {
            int n2 = Integer.parseInt(this.buffer.toString());
            int n3 = n2 > 0 ? n2 : n;
            return n3;
        }
        catch (NumberFormatException numberFormatException) {
            int n4 = n;
            return n4;
        }
        finally {
            this.buffer.setLength(0);
        }
    }

    boolean display(boolean bl) {
        ArrayList<AttributedString> arrayList = new ArrayList<AttributedString>();
        int n = this.size.getColumns() - (this.printLineNumbers ? 8 : 0);
        int n2 = this.size.getRows();
        int n3 = this.firstLineToDisplay;
        AttributedString attributedString2 = null;
        Pattern pattern = this.getPattern();
        boolean bl2 = false;
        for (int i = 0; i < n2 - 1; ++i) {
            AttributedString attributedString3;
            if (attributedString2 == null) {
                if ((attributedString2 = this.getLine(n3++)) == null) {
                    if (bl) {
                        bl2 = true;
                        break;
                    }
                    attributedString2 = new AttributedString("");
                }
                if (pattern != null) {
                    attributedString2 = attributedString2.styleMatches(pattern, AttributedStyle.DEFAULT.inverse());
                }
            }
            if (this.firstColumnToDisplay > 0 || this.chopLongLines) {
                int n4 = this.firstColumnToDisplay;
                if (i == 0 && this.offsetInLine > 0) {
                    n4 = Math.max(this.offsetInLine, n4);
                }
                attributedString3 = attributedString2.columnSubSequence(n4, n4 + n);
                attributedString2 = null;
            } else {
                if (i == 0 && this.offsetInLine > 0) {
                    attributedString2 = attributedString2.columnSubSequence(this.offsetInLine, Integer.MAX_VALUE);
                }
                attributedString3 = attributedString2.columnSubSequence(0, n);
                if ((attributedString2 = attributedString2.columnSubSequence(n, Integer.MAX_VALUE)).length() == 0) {
                    attributedString2 = null;
                }
            }
            if (this.printLineNumbers) {
                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
                attributedStringBuilder.append(String.format("%7d ", n3));
                attributedStringBuilder.append(attributedString3);
                arrayList.add(attributedStringBuilder.toAttributedString());
                continue;
            }
            arrayList.add(attributedString3);
        }
        if (bl) {
            if (bl2) {
                arrayList.forEach(attributedString -> this.terminal.writer().println(attributedString.toAnsi(this.terminal)));
            }
            return bl2;
        }
        AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
        if (this.buffer.length() > 0) {
            attributedStringBuilder.append(" ").append(this.buffer);
        } else if (this.bindingReader.getCurrentBuffer().length() > 0 && this.terminal.reader().peek(1L) == -2) {
            attributedStringBuilder.append(" ").append(this.printable(this.bindingReader.getCurrentBuffer()));
        } else if (this.message != null) {
            attributedStringBuilder.style(AttributedStyle.INVERSE);
            attributedStringBuilder.append(this.message);
            attributedStringBuilder.style(AttributedStyle.INVERSE.inverseOff());
        } else {
            attributedStringBuilder.append(":");
        }
        arrayList.add(attributedStringBuilder.toAttributedString());
        this.display.resize(this.size.getRows(), this.size.getColumns());
        this.display.update(arrayList, -1);
        return false;
    }

    private Pattern getPattern() {
        Pattern pattern = null;
        if (this.pattern != null) {
            boolean bl = this.ignoreCaseAlways || this.ignoreCaseCond && this.pattern.toLowerCase().equals(this.pattern);
            pattern = Pattern.compile("(" + this.pattern + ")", bl ? 66 : 0);
        }
        return pattern;
    }

    AttributedString getLine(int n) {
        String string;
        while (n >= this.lines.size() && (string = this.reader.readLine()) != null) {
            this.lines.add(AttributedString.fromAnsi(string, this.tabs));
        }
        if (n < this.lines.size()) {
            return this.lines.get(n);
        }
        return null;
    }

    public static void checkInterrupted() {
        Thread.yield();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    private void bindKeys(KeyMap<Operation> keyMap) {
        keyMap.bind(Operation.HELP, "h", "H");
        keyMap.bind(Operation.EXIT, "q", ":q", "Q", ":Q", "ZZ");
        keyMap.bind(Operation.FORWARD_ONE_LINE, "e", KeyMap.ctrl('E'), "j", KeyMap.ctrl('N'), "\r", KeyMap.key(this.terminal, InfoCmp.Capability.key_down));
        keyMap.bind(Operation.BACKWARD_ONE_LINE, "y", KeyMap.ctrl('Y'), "k", KeyMap.ctrl('K'), KeyMap.ctrl('P'), KeyMap.key(this.terminal, InfoCmp.Capability.key_up));
        keyMap.bind(Operation.FORWARD_ONE_WINDOW_OR_LINES, "f", KeyMap.ctrl('F'), KeyMap.ctrl('V'), " ");
        keyMap.bind(Operation.BACKWARD_ONE_WINDOW_OR_LINES, "b", KeyMap.ctrl('B'), KeyMap.alt('v'));
        keyMap.bind(Operation.FORWARD_ONE_WINDOW_AND_SET, (CharSequence)"z");
        keyMap.bind(Operation.BACKWARD_ONE_WINDOW_AND_SET, (CharSequence)"w");
        keyMap.bind(Operation.FORWARD_ONE_WINDOW_NO_STOP, (CharSequence)KeyMap.alt(' '));
        keyMap.bind(Operation.FORWARD_HALF_WINDOW_AND_SET, "d", KeyMap.ctrl('D'));
        keyMap.bind(Operation.BACKWARD_HALF_WINDOW_AND_SET, "u", KeyMap.ctrl('U'));
        keyMap.bind(Operation.RIGHT_ONE_HALF_SCREEN, KeyMap.alt(')'), KeyMap.key(this.terminal, InfoCmp.Capability.key_right));
        keyMap.bind(Operation.LEFT_ONE_HALF_SCREEN, KeyMap.alt('('), KeyMap.key(this.terminal, InfoCmp.Capability.key_left));
        keyMap.bind(Operation.FORWARD_FOREVER, (CharSequence)"F");
        keyMap.bind(Operation.REPEAT_SEARCH_FORWARD, "n", "N");
        keyMap.bind(Operation.REPEAT_SEARCH_FORWARD_SPAN_FILES, KeyMap.alt('n'), KeyMap.alt('N'));
        keyMap.bind(Operation.UNDO_SEARCH, (CharSequence)KeyMap.alt('u'));
        keyMap.bind(Operation.GO_TO_FIRST_LINE_OR_N, "g", "<", KeyMap.alt('<'));
        keyMap.bind(Operation.GO_TO_LAST_LINE_OR_N, "G", ">", KeyMap.alt('>'));
        keyMap.bind(Operation.NEXT_FILE, (CharSequence)":n");
        keyMap.bind(Operation.PREV_FILE, (CharSequence)":p");
        "-/0123456789?".chars().forEach(n -> keyMap.bind(Operation.CHAR, (CharSequence)Character.toString((char)n)));
    }

    static class InterruptibleInputStream
    extends FilterInputStream {
        InterruptibleInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            return super.read(byArray, n, n2);
        }
    }

    protected static enum Operation {
        HELP,
        EXIT,
        FORWARD_ONE_LINE,
        BACKWARD_ONE_LINE,
        FORWARD_ONE_WINDOW_OR_LINES,
        BACKWARD_ONE_WINDOW_OR_LINES,
        FORWARD_ONE_WINDOW_AND_SET,
        BACKWARD_ONE_WINDOW_AND_SET,
        FORWARD_ONE_WINDOW_NO_STOP,
        FORWARD_HALF_WINDOW_AND_SET,
        BACKWARD_HALF_WINDOW_AND_SET,
        LEFT_ONE_HALF_SCREEN,
        RIGHT_ONE_HALF_SCREEN,
        FORWARD_FOREVER,
        REPAINT,
        REPAINT_AND_DISCARD,
        REPEAT_SEARCH_FORWARD,
        REPEAT_SEARCH_BACKWARD,
        REPEAT_SEARCH_FORWARD_SPAN_FILES,
        REPEAT_SEARCH_BACKWARD_SPAN_FILES,
        UNDO_SEARCH,
        GO_TO_FIRST_LINE_OR_N,
        GO_TO_LAST_LINE_OR_N,
        GO_TO_PERCENT_OR_N,
        GO_TO_NEXT_TAG,
        GO_TO_PREVIOUS_TAG,
        FIND_CLOSE_BRACKET,
        FIND_OPEN_BRACKET,
        OPT_PRINT_LINES,
        OPT_CHOP_LONG_LINES,
        OPT_QUIT_AT_FIRST_EOF,
        OPT_QUIT_AT_SECOND_EOF,
        OPT_QUIET,
        OPT_VERY_QUIET,
        OPT_IGNORE_CASE_COND,
        OPT_IGNORE_CASE_ALWAYS,
        NEXT_FILE,
        PREV_FILE,
        CHAR;

    }
}

