/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.jline.reader.Binding;
import org.jline.reader.LineReader;
import org.jline.reader.Macro;
import org.jline.reader.Reference;
import org.jline.utils.Log;

public final class InputRC {
    private final LineReader reader;

    public static void configure(LineReader lineReader, URL uRL) {
        try (InputStream inputStream = uRL.openStream();){
            InputRC.configure(lineReader, inputStream);
        }
    }

    public static void configure(LineReader lineReader, InputStream inputStream) {
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
            InputRC.configure(lineReader, inputStreamReader);
        }
    }

    public static void configure(LineReader lineReader, Reader reader) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        lineReader.getVariables().putIfAbsent("editing-mode", "emacs");
        lineReader.setKeyMap("main");
        if ("vi".equals(lineReader.getVariable("editing-mode"))) {
            lineReader.getKeyMaps().put("main", lineReader.getKeyMaps().get("viins"));
        } else if ("emacs".equals(lineReader.getVariable("editing-mode"))) {
            lineReader.getKeyMaps().put("main", lineReader.getKeyMaps().get("emacs"));
        }
        new InputRC(lineReader).parse(bufferedReader);
        if ("vi".equals(lineReader.getVariable("editing-mode"))) {
            lineReader.getKeyMaps().put("main", lineReader.getKeyMaps().get("viins"));
        } else if ("emacs".equals(lineReader.getVariable("editing-mode"))) {
            lineReader.getKeyMaps().put("main", lineReader.getKeyMaps().get("emacs"));
        }
    }

    private InputRC(LineReader lineReader) {
        this.reader = lineReader;
    }

    private void parse(BufferedReader bufferedReader) {
        String string;
        boolean bl = true;
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        while ((string = bufferedReader.readLine()) != null) {
            try {
                char c;
                String string2;
                String string3;
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                int n = 0;
                if (string.charAt(n) == '$') {
                    ++n;
                    while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                        ++n;
                    }
                    int n2 = n;
                    while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                        ++n;
                    }
                    string3 = string.substring(n2, n);
                    while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                        ++n;
                    }
                    n2 = n;
                    while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                        ++n;
                    }
                    String string4 = string.substring(n2, n);
                    if ("if".equalsIgnoreCase(string3)) {
                        arrayList.add(bl);
                        if (!bl || string4.startsWith("term=")) continue;
                        if (string4.startsWith("mode=")) {
                            string2 = (String)this.reader.getVariable("editing-mode");
                            bl = string4.substring("mode=".length()).equalsIgnoreCase(string2);
                            continue;
                        }
                        bl = string4.equalsIgnoreCase(this.reader.getAppName());
                        continue;
                    }
                    if ("else".equalsIgnoreCase(string3)) {
                        if (arrayList.isEmpty()) {
                            throw new IllegalArgumentException("$else found without matching $if");
                        }
                        boolean bl2 = true;
                        Iterator iterator = arrayList.iterator();
                        while (iterator.hasNext()) {
                            c = ((Boolean)iterator.next()).booleanValue();
                            if (c != '\u0000') continue;
                            bl2 = false;
                            break;
                        }
                        if (!bl2) continue;
                        bl = !bl;
                        continue;
                    }
                    if ("endif".equalsIgnoreCase(string3)) {
                        if (arrayList.isEmpty()) {
                            throw new IllegalArgumentException("endif found without matching $if");
                        }
                        bl = (Boolean)arrayList.remove(arrayList.size() - 1);
                        continue;
                    }
                    if (!"include".equalsIgnoreCase(string3)) continue;
                }
                if (!bl) continue;
                if (string.charAt(n++) == '\"') {
                    boolean bl3 = false;
                    while (true) {
                        if (n >= string.length()) {
                            throw new IllegalArgumentException("Missing closing quote on line '" + string + "'");
                        }
                        if (bl3) {
                            bl3 = false;
                        } else if (string.charAt(n) == '\\') {
                            bl3 = true;
                        } else if (string.charAt(n) == '\"') break;
                        ++n;
                    }
                }
                while (n < string.length() && string.charAt(n) != ':' && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                    ++n;
                }
                string3 = string.substring(0, n);
                boolean bl4 = n + 1 < string.length() && string.charAt(n) == ':' && string.charAt(n + 1) == '=';
                ++n;
                if (bl4) {
                    ++n;
                }
                if (string3.equalsIgnoreCase("set")) {
                    while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                        ++n;
                    }
                    int n3 = n;
                    while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                        ++n;
                    }
                    String string5 = string.substring(n3, n);
                    while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                        ++n;
                    }
                    n3 = n;
                    while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                        ++n;
                    }
                    string2 = string.substring(n3, n);
                    InputRC.setVar(this.reader, string5, string2);
                    continue;
                }
                while (n < string.length() && (string.charAt(n) == ' ' || string.charAt(n) == '\t')) {
                    ++n;
                }
                int n4 = n;
                if (n < string.length() && (string.charAt(n) == '\'' || string.charAt(n) == '\"')) {
                    char c2 = string.charAt(n++);
                    boolean bl5 = false;
                    while (n < string.length()) {
                        if (bl5) {
                            bl5 = false;
                        } else if (string.charAt(n) == '\\') {
                            bl5 = true;
                        } else if (string.charAt(n) == c2) break;
                        ++n;
                    }
                }
                while (n < string.length() && string.charAt(n) != ' ' && string.charAt(n) != '\t') {
                    ++n;
                }
                string2 = string.substring(Math.min(n4, string.length()), Math.min(n, string.length()));
                if (string3.charAt(0) == '\"') {
                    string3 = InputRC.translateQuoted(string3);
                } else {
                    String string6 = string3.lastIndexOf(45) > 0 ? string3.substring(string3.lastIndexOf(45) + 1) : string3;
                    c = InputRC.getKeyFromName(string6);
                    string6 = string3.toLowerCase();
                    string3 = "";
                    if (string6.contains("meta-") || string6.contains("m-")) {
                        string3 = string3 + "\u001b";
                    }
                    if (string6.contains("control-") || string6.contains("c-") || string6.contains("ctrl-")) {
                        c = (char)(Character.toUpperCase(c) & 0x1F);
                    }
                    string3 = string3 + c;
                }
                if (string2.length() > 0 && (string2.charAt(0) == '\'' || string2.charAt(0) == '\"')) {
                    this.reader.getKeys().bind((Binding)new Macro(InputRC.translateQuoted(string2)), (CharSequence)string3);
                    continue;
                }
                this.reader.getKeys().bind((Binding)new Reference(string2), (CharSequence)string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.warn("Unable to parse user configuration: ", illegalArgumentException);
            }
        }
    }

    private static String translateQuoted(String string) {
        String string2 = string.substring(1, string.length() - 1);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string2.length(); ++i) {
            int n = string2.charAt(i);
            if (n == 92) {
                boolean bl;
                boolean bl2 = string2.regionMatches(i, "\\C-", 0, 3) || string2.regionMatches(i, "\\M-\\C-", 0, 6);
                if ((i += ((bl = string2.regionMatches(i, "\\M-", 0, 3) || string2.regionMatches(i, "\\C-\\M-", 0, 6)) ? 3 : 0) + (bl2 ? 3 : 0) + (!bl && !bl2 ? 1 : 0)) >= string2.length()) break;
                n = string2.charAt(i);
                if (bl) {
                    stringBuilder.append("\u001b");
                }
                if (bl2) {
                    char c = (char)(n = (char)(n == 63 ? 127 : (char)(Character.toUpperCase((char)n) & 0x1F)));
                }
                if (!bl && !bl2) {
                    switch (n) {
                        case 97: {
                            n = 7;
                            break;
                        }
                        case 98: {
                            n = 8;
                            break;
                        }
                        case 100: {
                            n = 127;
                            break;
                        }
                        case 101: {
                            n = 27;
                            break;
                        }
                        case 102: {
                            n = 12;
                            break;
                        }
                        case 110: {
                            n = 10;
                            break;
                        }
                        case 114: {
                            n = 13;
                            break;
                        }
                        case 116: {
                            n = 9;
                            break;
                        }
                        case 118: {
                            n = 11;
                            break;
                        }
                        case 92: {
                            n = 92;
                            break;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            int n2;
                            int n3;
                            n = 0;
                            for (n3 = 0; n3 < 3 && i < string2.length() && (n2 = Character.digit(string2.charAt(i), 8)) >= 0; ++n3, ++i) {
                                n = (char)(n * 8 + n2);
                            }
                            n = (char)(n & 0xFF);
                            break;
                        }
                        case 120: {
                            int n2;
                            int n3;
                            ++i;
                            n = 0;
                            for (n3 = 0; n3 < 2 && i < string2.length() && (n2 = Character.digit(string2.charAt(i), 16)) >= 0; ++n3, ++i) {
                                n = (char)(n * 16 + n2);
                            }
                            n = (char)(n & 0xFF);
                            break;
                        }
                        case 117: {
                            int n2;
                            int n3;
                            ++i;
                            n = 0;
                            for (n3 = 0; n3 < 4 && i < string2.length() && (n2 = Character.digit(string2.charAt(i), 16)) >= 0; ++n3, ++i) {
                                n = (char)(n * 16 + n2);
                            }
                            break;
                        }
                    }
                }
                stringBuilder.append((char)n);
                continue;
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static char getKeyFromName(String string) {
        if ("DEL".equalsIgnoreCase(string) || "Rubout".equalsIgnoreCase(string)) {
            return '\u007f';
        }
        if ("ESC".equalsIgnoreCase(string) || "Escape".equalsIgnoreCase(string)) {
            return '\u001b';
        }
        if ("LFD".equalsIgnoreCase(string) || "NewLine".equalsIgnoreCase(string)) {
            return '\n';
        }
        if ("RET".equalsIgnoreCase(string) || "Return".equalsIgnoreCase(string)) {
            return '\r';
        }
        if ("SPC".equalsIgnoreCase(string) || "Space".equalsIgnoreCase(string)) {
            return ' ';
        }
        if ("Tab".equalsIgnoreCase(string)) {
            return '\t';
        }
        return string.charAt(0);
    }

    private static void setVar(LineReader lineReader, String string, String string2) {
        if ("keymap".equalsIgnoreCase(string)) {
            lineReader.setKeyMap(string2);
            return;
        }
        for (LineReader.Option option : LineReader.Option.values()) {
            if (!option.name().toLowerCase(Locale.ENGLISH).replace('_', '-').equals(string2)) continue;
            if ("on".equalsIgnoreCase(string2)) {
                lineReader.setOpt(option);
            } else if ("off".equalsIgnoreCase(string2)) {
                lineReader.unsetOpt(option);
            }
            return;
        }
        lineReader.setVariable(string, string2);
    }
}

