/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.jline.builtins.NfaMatcher;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Completers {

    public static class RegexCompleter
    implements org.jline.reader.Completer {
        private final NfaMatcher<String> matcher;
        private final Function<String, org.jline.reader.Completer> completers;
        private final ThreadLocal<LineReader> reader = new ThreadLocal();

        public RegexCompleter(String string, Function<String, org.jline.reader.Completer> function) {
            this.matcher = new NfaMatcher<String>(string, this::doMatch);
            this.completers = function;
        }

        @Override
        public synchronized void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            List<String> list2 = parsedLine.words().subList(0, parsedLine.wordIndex());
            this.reader.set(lineReader);
            Set<String> set = this.matcher.matchPartial(list2);
            for (String string : set) {
                this.completers.apply(string).complete(lineReader, new ArgumentLine(parsedLine.word(), parsedLine.wordCursor()), list);
            }
            this.reader.set(null);
        }

        private boolean doMatch(String string, String string2) {
            ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
            this.completers.apply(string2).complete(this.reader.get(), new ArgumentLine(string, string.length()), arrayList);
            return arrayList.stream().anyMatch(candidate -> candidate.value().equals(string));
        }

        public static class ArgumentLine
        implements ParsedLine {
            private final String word;
            private final int cursor;

            public ArgumentLine(String string, int n) {
                this.word = string;
                this.cursor = n;
            }

            @Override
            public String word() {
                return this.word;
            }

            @Override
            public int wordCursor() {
                return this.cursor;
            }

            @Override
            public int wordIndex() {
                return 0;
            }

            @Override
            public List<String> words() {
                return Collections.singletonList(this.word);
            }

            @Override
            public String line() {
                return this.word;
            }

            @Override
            public int cursor() {
                return this.cursor;
            }
        }
    }

    public static class TreeCompleter
    implements org.jline.reader.Completer {
        final Map<String, org.jline.reader.Completer> completers = new HashMap<String, org.jline.reader.Completer>();
        final RegexCompleter completer;

        public TreeCompleter(Node ... nodeArray) {
            this(Arrays.asList(nodeArray));
        }

        public TreeCompleter(List<Node> list) {
            StringBuilder stringBuilder = new StringBuilder();
            this.addRoots(stringBuilder, list);
            this.completer = new RegexCompleter(stringBuilder.toString(), this.completers::get);
        }

        public static Node node(Object ... objectArray) {
            org.jline.reader.Completer completer = null;
            ArrayList<Candidate> arrayList = new ArrayList<Candidate>();
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (Object object : objectArray) {
                if (object instanceof String) {
                    arrayList.add(new Candidate((String)object));
                    continue;
                }
                if (object instanceof Candidate) {
                    arrayList.add((Candidate)object);
                    continue;
                }
                if (object instanceof Node) {
                    arrayList2.add((Node)object);
                    continue;
                }
                if (object instanceof org.jline.reader.Completer) {
                    completer = (org.jline.reader.Completer)object;
                    continue;
                }
                throw new IllegalArgumentException();
            }
            if (completer != null) {
                if (!arrayList.isEmpty()) {
                    throw new IllegalArgumentException();
                }
                return new Node(completer, arrayList2);
            }
            if (!arrayList.isEmpty()) {
                return new Node((lineReader, parsedLine, list2) -> list2.addAll(arrayList), arrayList2);
            }
            throw new IllegalArgumentException();
        }

        void addRoots(StringBuilder stringBuilder, List<Node> list) {
            if (!list.isEmpty()) {
                stringBuilder.append(" ( ");
                boolean bl = true;
                for (Node node : list) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(" | ");
                    }
                    String string = "c" + this.completers.size();
                    this.completers.put(string, node.completer);
                    stringBuilder.append(string);
                    this.addRoots(stringBuilder, node.nodes);
                }
                stringBuilder.append(" ) ");
            }
        }

        @Override
        public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            this.completer.complete(lineReader, parsedLine, list);
        }

        public static class Node {
            final org.jline.reader.Completer completer;
            final List<Node> nodes;

            public Node(org.jline.reader.Completer completer, List<Node> list) {
                this.completer = completer;
                this.nodes = list;
            }
        }
    }

    public static class FileNameCompleter
    implements org.jline.reader.Completer {
        @Override
        public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            Path path2;
            String string;
            String string2;
            assert (parsedLine != null);
            assert (list != null);
            String string3 = parsedLine.word().substring(0, parsedLine.wordCursor());
            int n = string3.lastIndexOf(string2 = this.getUserDir().getFileSystem().getSeparator());
            if (n >= 0) {
                string = string3.substring(0, n + 1);
                path2 = string.startsWith("~") ? (string.startsWith("~" + string2) ? this.getUserHome().resolve(string.substring(2)) : this.getUserHome().getParent().resolve(string.substring(1))) : this.getUserDir().resolve(string);
            } else {
                string = "";
                path2 = this.getUserDir();
            }
            try {
                Files.newDirectoryStream(path2, this::accept).forEach(path -> {
                    String string3 = string + path.getFileName().toString();
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        list.add(new Candidate(string3 + (lineReader.isSet(LineReader.Option.AUTO_PARAM_SLASH) ? string2 : ""), this.getDisplay(lineReader.getTerminal(), (Path)path), null, null, lineReader.isSet(LineReader.Option.AUTO_REMOVE_SLASH) ? string2 : null, null, false));
                    } else {
                        list.add(new Candidate(string3, this.getDisplay(lineReader.getTerminal(), (Path)path), null, null, null, null, true));
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected boolean accept(Path path) {
            try {
                return !Files.isHidden(path);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        protected Path getUserDir() {
            return Paths.get(System.getProperty("user.dir"), new String[0]);
        }

        protected Path getUserHome() {
            return Paths.get(System.getProperty("user.home"), new String[0]);
        }

        protected String getDisplay(Terminal terminal, Path path) {
            String string = path.getFileName().toString();
            if (Files.isDirectory(path, new LinkOption[0])) {
                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
                attributedStringBuilder.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)string);
                attributedStringBuilder.append("/");
                string = attributedStringBuilder.toAnsi(terminal);
            } else if (Files.isSymbolicLink(path)) {
                AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
                attributedStringBuilder.styled(AttributedStyle.BOLD.foreground(1), (CharSequence)string);
                attributedStringBuilder.append("@");
                string = attributedStringBuilder.toAnsi(terminal);
            }
            return string;
        }
    }

    public static class FilesCompleter
    extends FileNameCompleter {
        private final Path currentDir;

        public FilesCompleter(File file) {
            this(file.toPath());
        }

        public FilesCompleter(Path path) {
            this.currentDir = path;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir;
        }
    }

    public static class DirectoriesCompleter
    extends FileNameCompleter {
        private final Path currentDir;

        public DirectoriesCompleter(File file) {
            this(file.toPath());
        }

        public DirectoriesCompleter(Path path) {
            this.currentDir = path;
        }

        @Override
        protected Path getUserDir() {
            return this.currentDir;
        }

        @Override
        protected boolean accept(Path path) {
            return Files.isDirectory(path, new LinkOption[0]) && super.accept(path);
        }
    }

    public static class Completer
    implements org.jline.reader.Completer {
        private final CompletionEnvironment environment;

        public Completer(CompletionEnvironment completionEnvironment) {
            this.environment = completionEnvironment;
        }

        @Override
        public void complete(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            if (parsedLine.wordIndex() == 0) {
                this.completeCommand(list);
            } else {
                this.tryCompleteArguments(lineReader, parsedLine, list);
            }
        }

        protected void tryCompleteArguments(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list) {
            List<CompletionData> list2;
            String string = parsedLine.words().get(0);
            String string2 = this.environment.resolveCommand(string);
            Map<String, List<CompletionData>> map = this.environment.getCompletions();
            if (map != null && (list2 = map.get(string2)) != null) {
                this.completeCommandArguments(lineReader, parsedLine, list, list2);
            }
        }

        protected void completeCommandArguments(LineReader lineReader, ParsedLine parsedLine, List<Candidate> list, List<CompletionData> list2) {
            for (CompletionData completionData : list2) {
                Object object;
                boolean bl = parsedLine.word().startsWith("-");
                String string = parsedLine.wordIndex() >= 2 && parsedLine.words().get(parsedLine.wordIndex() - 1).startsWith("-") ? parsedLine.words().get(parsedLine.wordIndex() - 1) : null;
                String string2 = UUID.randomUUID().toString();
                boolean bl2 = true;
                if (completionData.condition != null) {
                    object = Boolean.FALSE;
                    try {
                        object = this.environment.evaluate(lineReader, parsedLine, completionData.condition);
                    }
                    catch (Throwable throwable) {
                        throwable.getCause();
                    }
                    bl2 = this.isTrue(object);
                }
                if (bl2 && bl && completionData.options != null) {
                    for (String string3 : completionData.options) {
                        list.add(new Candidate(string3, string3, "options", completionData.description, null, string2, true));
                    }
                    continue;
                }
                if (!bl && string != null && completionData.argument != null && completionData.options != null && completionData.options.contains(string)) {
                    object = null;
                    try {
                        object = this.environment.evaluate(lineReader, parsedLine, completionData.argument);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (object instanceof Candidate) {
                        list.add((Candidate)object);
                        continue;
                    }
                    if (object instanceof String) {
                        list.add(new Candidate((String)object, (String)object, null, null, null, null, true));
                        continue;
                    }
                    if (object instanceof Collection) {
                        for (Object e : (Collection)object) {
                            if (e instanceof Candidate) {
                                list.add((Candidate)e);
                                continue;
                            }
                            if (!(e instanceof String)) continue;
                            list.add(new Candidate((String)e, (String)e, null, null, null, null, true));
                        }
                        continue;
                    }
                    if (object == null || !object.getClass().isArray()) continue;
                    int n = Array.getLength(object);
                    for (int i = 0; i < n; ++i) {
                        Object object2 = Array.get(object, i);
                        if (object2 instanceof Candidate) {
                            list.add((Candidate)object2);
                            continue;
                        }
                        if (!(object2 instanceof String)) continue;
                        list.add(new Candidate((String)object2, (String)object2, null, null, null, null, true));
                    }
                    continue;
                }
                if (bl || completionData.argument == null) continue;
                object = null;
                try {
                    object = this.environment.evaluate(lineReader, parsedLine, completionData.argument);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (object instanceof Candidate) {
                    list.add((Candidate)object);
                    continue;
                }
                if (object instanceof String) {
                    list.add(new Candidate((String)object, (String)object, null, completionData.description, null, null, true));
                    continue;
                }
                if (!(object instanceof Collection)) continue;
                for (Object e : (Collection)object) {
                    if (e instanceof Candidate) {
                        list.add((Candidate)e);
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    list.add(new Candidate((String)e, (String)e, null, completionData.description, null, null, true));
                }
            }
        }

        protected void completeCommand(List<Candidate> list) {
            Set<String> set = this.environment.getCommands();
            for (String string : set) {
                Object object;
                String string2 = this.environment.commandName(string);
                boolean bl = string.equals(this.environment.resolveCommand(string2));
                if (string2.startsWith("_")) continue;
                String string3 = null;
                Map<String, List<CompletionData>> map = this.environment.getCompletions();
                if (map != null && (object = map.get(string)) != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        CompletionData completionData = (CompletionData)iterator.next();
                        if (completionData.description == null || completionData.options != null || completionData.argument != null || completionData.condition != null) continue;
                        string3 = completionData.description;
                    }
                }
                object = UUID.randomUUID().toString();
                if (string3 != null) {
                    list.add(new Candidate(string, string, null, string3, null, (String)object, true));
                    if (!bl) continue;
                    list.add(new Candidate(string2, string2, null, string3, null, (String)object, true));
                    continue;
                }
                list.add(new Candidate(string, string, null, null, null, (String)object, true));
                if (!bl) continue;
                list.add(new Candidate(string2, string2, null, null, null, (String)object, true));
            }
        }

        private boolean isTrue(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (object instanceof Number && 0 == ((Number)object).intValue()) {
                return false;
            }
            return !"".equals(object) && !"0".equals(object);
        }
    }

    public static class CompletionData {
        public final List<String> options;
        public final String description;
        public final String argument;
        public final String condition;

        public CompletionData(List<String> list, String string, String string2, String string3) {
            this.options = list;
            this.description = string;
            this.argument = string2;
            this.condition = string3;
        }
    }

    public static interface CompletionEnvironment {
        public Map<String, List<CompletionData>> getCompletions();

        public Set<String> getCommands();

        public String resolveCommand(String var1);

        public String commandName(String var1);

        public Object evaluate(LineReader var1, ParsedLine var2, String var3) throws Exception;
    }
}

