/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jline.builtins.Completers;
import org.jline.builtins.Less;
import org.jline.builtins.Nano;
import org.jline.builtins.Options;
import org.jline.builtins.Source;
import org.jline.builtins.Tmux;
import org.jline.keymap.KeyMap;
import org.jline.reader.Binding;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.Macro;
import org.jline.reader.Reference;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

public class Commands {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tmux(Terminal terminal, PrintStream printStream, PrintStream printStream2, Supplier<Object> supplier, Consumer<Object> consumer, Consumer<Terminal> consumer2, String[] stringArray) {
        String[] stringArray2 = new String[]{"tmux -  terminal multiplexer", "Usage: tmux [command]", "  -? --help                    Show help"};
        if (stringArray.length == 1 && ("--help".equals(stringArray[0]) || "-?".equals(stringArray[0]))) {
            for (String string : stringArray2) {
                printStream2.println(string);
            }
            return;
        }
        if (stringArray.length == 0) {
            Object object = supplier.get();
            if (object != null) {
                printStream2.println("tmux: can't run tmux inside itself");
            } else {
                Tmux tmux = new Tmux(terminal, printStream2, consumer2);
                consumer.accept(tmux);
                try {
                    tmux.run();
                }
                finally {
                    consumer.accept(null);
                }
            }
        } else {
            Object object = supplier.get();
            if (object != null) {
                ((Tmux)object).execute(printStream, printStream2, Arrays.asList(stringArray));
            } else {
                printStream2.println("tmux: no instance running");
            }
        }
    }

    public static void nano(Terminal terminal, PrintStream printStream, PrintStream printStream2, Path path, String[] stringArray) {
        String[] stringArray2 = new String[]{"nano -  edit files", "Usage: nano [FILES]", "  -? --help                    Show help"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        Nano nano = new Nano(terminal, path);
        nano.open(options.args());
        nano.run();
    }

    public static void less(Terminal terminal, InputStream inputStream, PrintStream printStream, PrintStream printStream2, Path path, String[] stringArray) {
        String[] stringArray2 = new String[]{"less -  file pager", "Usage: less [OPTIONS] [FILES]", "  -? --help                    Show help", "  -e --quit-at-eof             Exit on second EOF", "  -E --QUIT-AT-EOF             Exit on EOF", "  -q --quiet --silent          Silent mode", "  -Q --QUIET --SILENT          Completely  silent", "  -S --chop-long-lines         Do not fold long lines", "  -i --ignore-case             Search ignores lowercase case", "  -I --IGNORE-CASE             Search ignores all case", "  -x --tabs                    Set tab stops", "  -N --LINE-NUMBERS            Display line number for each line"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        Less less = new Less(terminal);
        less.quitAtFirstEof = options.isSet("QUIT-AT-EOF");
        less.quitAtSecondEof = options.isSet("quit-at-eof");
        less.quiet = options.isSet("quiet");
        less.veryQuiet = options.isSet("QUIET");
        less.chopLongLines = options.isSet("chop-long-lines");
        less.ignoreCaseAlways = options.isSet("IGNORE-CASE");
        less.ignoreCaseCond = options.isSet("ignore-case");
        if (options.isSet("tabs")) {
            less.tabs = options.getNumber("tabs");
        }
        less.printLineNumbers = options.isSet("LINE-NUMBERS");
        ArrayList<Source> arrayList = new ArrayList<Source>();
        if (options.args().isEmpty()) {
            options.args().add("-");
        }
        for (String string : options.args()) {
            if ("-".equals(string)) {
                arrayList.add(new Source.StdInSource(inputStream));
                continue;
            }
            arrayList.add(new Source.URLSource(path.resolve(string).toUri().toURL(), string));
        }
        less.run(arrayList);
    }

    public static void history(LineReader lineReader, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"history -  list history of commands", "Usage: history [OPTIONS]", "  -? --help                       Displays command help", "     --clear                      Clear history", "     --save                       Save history", "  -d                              Print timestamps for each event"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        if (!options.args().isEmpty()) {
            printStream2.println("usage: history [OPTIONS]");
            return;
        }
        History history = lineReader.getHistory();
        if (options.isSet("clear")) {
            history.purge();
        }
        if (options.isSet("save")) {
            history.save();
        }
        if (options.isSet("clear") || options.isSet("save")) {
            return;
        }
        for (History.Entry entry : history) {
            AttributedStringBuilder attributedStringBuilder = new AttributedStringBuilder();
            attributedStringBuilder.append("  ");
            attributedStringBuilder.styled(AttributedStyle::bold, (CharSequence)String.format("%3d", entry.index() + 1));
            if (options.isSet("d")) {
                attributedStringBuilder.append("  ");
                LocalTime localTime = LocalTime.from(entry.time().atZone(ZoneId.systemDefault())).truncatedTo(ChronoUnit.SECONDS);
                DateTimeFormatter.ISO_LOCAL_TIME.formatTo(localTime, attributedStringBuilder);
            }
            attributedStringBuilder.append("  ");
            attributedStringBuilder.append(entry.line());
            printStream.println(attributedStringBuilder.toAnsi(lineReader.getTerminal()));
        }
    }

    public static void complete(LineReader lineReader, PrintStream printStream, PrintStream printStream2, Map<String, List<Completers.CompletionData>> map, String[] stringArray) {
        String string22;
        String[] stringArray2 = new String[]{"complete -  edit command specific tab-completions", "Usage: complete", "  -? --help                       Displays command help", "  -c --command=COMMAND            Command to add completion to", "  -d --description=DESCRIPTION    Description of this completions", "  -e --erase                      Erase the completions", "  -s --short-option=SHORT_OPTION  Posix-style option to complete", "  -l --long-option=LONG_OPTION    GNU-style option to complete", "  -a --argument=ARGUMENTS         A list of possible arguments", "  -n --condition=CONDITION        The completion should only be used if the", "                                  specified command has a zero exit status"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        String string3 = options.get("command");
        if (options.isSet("erase")) {
            map.remove(string3);
            return;
        }
        List list = map.computeIfAbsent(string3, string -> new ArrayList());
        ArrayList<String> arrayList = null;
        if (options.isSet("short-option")) {
            for (String string22 : options.getList("short-option")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add("-" + string22);
            }
        }
        if (options.isSet("long-option")) {
            for (String string22 : options.getList("long-option")) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add("--" + string22);
            }
        }
        Iterator<String> iterator = options.isSet("description") ? options.get("description") : null;
        string22 = options.isSet("argument") ? options.get("argument") : null;
        String string4 = options.isSet("condition") ? options.get("condition") : null;
        list.add(new Completers.CompletionData((List<String>)arrayList, (String)((Object)iterator), string22, string4));
    }

    public static void widget(LineReader lineReader, PrintStream printStream, PrintStream printStream2, Function<String, Widget> function, String[] stringArray) {
        String[] stringArray2 = new String[]{"widget -  manipulate widgets", "Usage: widget [options] -N new-widget [function-name]", "       widget [options] -D widget ...", "       widget [options] -A old-widget new-widget", "       widget [options] -U string ...", "       widget [options] -l", "  -? --help                       Displays command help", "  -A                              Create alias to widget", "  -N                              Create new widget", "  -D                              Delete widgets", "  -U                              Push characters to the stack", "  -l                              List user-defined widgets", "  -a                              With -l, list all widgets"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        int n = (options.isSet("N") ? 1 : 0) + (options.isSet("D") ? 1 : 0) + (options.isSet("U") ? 1 : 0) + (options.isSet("l") ? 1 : 0) + (options.isSet("A") ? 1 : 0);
        if (n > 1) {
            printStream2.println("widget: incompatible operation selection options");
            return;
        }
        if (options.isSet("l")) {
            TreeSet<String> treeSet = new TreeSet<String>(lineReader.getWidgets().keySet());
            if (!options.isSet("a")) {
                treeSet.removeAll(lineReader.getBuiltinWidgets().keySet());
            }
            treeSet.forEach(printStream::println);
        } else if (options.isSet("N")) {
            if (options.args().size() < 1) {
                printStream2.println("widget: not enough arguments for -N");
                return;
            }
            if (options.args().size() > 2) {
                printStream2.println("widget: too many arguments for -N");
                return;
            }
            String string = options.args().get(0);
            String string2 = options.args().size() == 2 ? options.args().get(1) : string;
            lineReader.getWidgets().put(string, function.apply(string2));
        } else if (options.isSet("D")) {
            for (String string : options.args()) {
                lineReader.getWidgets().remove(string);
            }
        } else if (options.isSet("A")) {
            if (options.args().size() < 2) {
                printStream2.println("widget: not enough arguments for -A");
                return;
            }
            if (options.args().size() > 2) {
                printStream2.println("widget: too many arguments for -A");
                return;
            }
            Widget widget = lineReader.getWidgets().get(options.args().get(0));
            if (widget == null) {
                printStream2.println("widget: no such widget `" + options.args().get(0) + "'");
                return;
            }
            lineReader.getWidgets().put(options.args().get(1), widget);
        } else if (options.isSet("U")) {
            for (String string : options.args()) {
                lineReader.runMacro(KeyMap.translate(string));
            }
        } else if (options.args().size() == 1) {
            lineReader.callWidget(options.args().get(0));
        }
    }

    public static void keymap(LineReader lineReader, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"keymap -  manipulate keymaps", "Usage: keymap [options] -l [-L] [keymap ...]", "       keymap [options] -d", "       keymap [options] -D keymap ...", "       keymap [options] -A old-keymap new-keymap", "       keymap [options] -N new-keymap [old-keymap]", "       keymap [options] -m", "       keymap [options] -r in-string ...", "       keymap [options] -s in-string out-string ...", "       keymap [options] in-string command ...", "       keymap [options] [in-string]", "  -? --help                       Displays command help", "  -A                              Create alias to keymap", "  -D                              Delete named keymaps", "  -L                              Output in form of keymap commands", "  -M (default=main)               Specify keymap to select", "  -N                              Create new keymap", "  -R                              Interpret in-strings as ranges", "  -a                              Select vicmd keymap", "  -d                              Delete existing keymaps and reset to default state", "  -e                              Select emacs keymap and bind it to main", "  -l                              List existing keymap names", "  -p                              List bindings which have given key sequence as a a prefix", "  -r                              Unbind specified in-strings", "  -s                              Bind each in-string to each out-string", "  -v                              Select viins keymap and bind it to main"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        Map<String, KeyMap<Binding>> map = lineReader.getKeyMaps();
        int n = (options.isSet("N") ? 1 : 0) + (options.isSet("d") ? 1 : 0) + (options.isSet("D") ? 1 : 0) + (options.isSet("l") ? 1 : 0) + (options.isSet("r") ? 1 : 0) + (options.isSet("s") ? 1 : 0) + (options.isSet("A") ? 1 : 0);
        if (n > 1) {
            printStream2.println("keymap: incompatible operation selection options");
            return;
        }
        if (options.isSet("l")) {
            boolean bl = options.isSet("L");
            if (options.args().size() > 0) {
                for (String string : options.args()) {
                    KeyMap<Binding> keyMap = map.get(string);
                    if (keyMap == null) {
                        printStream2.println("keymap: no such keymap: `" + string + "'");
                        continue;
                    }
                    printStream.println(string);
                }
            } else {
                map.keySet().forEach(printStream::println);
            }
        } else if (options.isSet("N")) {
            if (options.isSet("e") || options.isSet("v") || options.isSet("a") || options.isSet("M")) {
                printStream2.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (options.args().size() < 1) {
                printStream2.println("keymap: not enough arguments for -N");
                return;
            }
            if (options.args().size() > 2) {
                printStream2.println("keymap: too many arguments for -N");
                return;
            }
            KeyMap<Binding> keyMap = null;
            if (options.args().size() == 2 && (keyMap = map.get(options.args().get(1))) == null) {
                printStream2.println("keymap: no such keymap `" + options.args().get(1) + "'");
                return;
            }
            KeyMap<Binding> keyMap2 = new KeyMap<Binding>();
            if (keyMap != null) {
                for (Map.Entry<String, Binding> entry : keyMap.getBoundKeys().entrySet()) {
                    keyMap2.bind(entry.getValue(), (CharSequence)entry.getKey());
                }
            }
            map.put(options.args().get(0), keyMap2);
        } else if (options.isSet("A")) {
            if (options.isSet("e") || options.isSet("v") || options.isSet("a") || options.isSet("M")) {
                printStream2.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (options.args().size() < 2) {
                printStream2.println("keymap: not enough arguments for -A");
                return;
            }
            if (options.args().size() > 2) {
                printStream2.println("keymap: too many arguments for -A");
                return;
            }
            KeyMap<Binding> keyMap = map.get(options.args().get(0));
            if (keyMap == null) {
                printStream2.println("keymap: no such keymap `" + options.args().get(0) + "'");
                return;
            }
            map.put(options.args().get(1), keyMap);
        } else if (options.isSet("d")) {
            if (options.isSet("e") || options.isSet("v") || options.isSet("a") || options.isSet("M")) {
                printStream2.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (options.args().size() > 0) {
                printStream2.println("keymap: too many arguments for -d");
                return;
            }
            map.clear();
            map.putAll(lineReader.defaultKeyMaps());
        } else if (options.isSet("D")) {
            if (options.isSet("e") || options.isSet("v") || options.isSet("a") || options.isSet("M")) {
                printStream2.println("keymap: keymap can not be selected with -N");
                return;
            }
            if (options.args().size() < 1) {
                printStream2.println("keymap: not enough arguments for -A");
                return;
            }
            for (String string : options.args()) {
                if (map.remove(string) != null) continue;
                printStream2.println("keymap: no such keymap `" + string + "'");
                return;
            }
        } else if (options.isSet("r")) {
            String string = "main";
            int n2 = (options.isSet("a") ? 1 : 0) + (options.isSet("e") ? 1 : 0) + (options.isSet("v") ? 1 : 0) + (options.isSet("M") ? 1 : 0);
            if (n2 > 1) {
                printStream2.println("keymap: incompatible keymap selection options");
                return;
            }
            if (options.isSet("a")) {
                string = "vicmd";
            } else if (options.isSet("e")) {
                string = "emacs";
            } else if (options.isSet("v")) {
                string = "viins";
            } else if (options.isSet("M")) {
                if (options.args().isEmpty()) {
                    printStream2.println("keymap: argument expected: -M");
                    return;
                }
                string = options.args().remove(0);
            }
            KeyMap<Binding> keyMap = map.get(string);
            if (keyMap == null) {
                printStream2.println("keymap: no such keymap `" + string + "'");
                return;
            }
            boolean bl = options.isSet("R");
            boolean bl2 = options.isSet("p");
            HashSet<String> hashSet = new HashSet<String>();
            Map<String, Binding> map2 = keyMap.getBoundKeys();
            for (String string2 : options.args()) {
                Collection<String> collection;
                if (bl) {
                    collection = KeyMap.range(options.args().get(0));
                    if (collection == null) {
                        printStream2.println("keymap: malformed key range `" + options.args().get(0) + "'");
                        return;
                    }
                    hashSet.addAll(collection);
                    continue;
                }
                collection = KeyMap.translate(string2);
                for (String string3 : map2.keySet()) {
                    if ((!bl2 || !string3.startsWith((String)((Object)collection)) || string3.length() <= ((String)((Object)collection)).length()) && (bl2 || !string3.equals(collection))) continue;
                    hashSet.add(string3);
                }
            }
            for (String string2 : hashSet) {
                keyMap.unbind((CharSequence)string2);
            }
            if (options.isSet("e") || options.isSet("v")) {
                map.put("main", keyMap);
            }
        } else if (options.isSet("s") || options.args().size() > 1) {
            String string = "main";
            int n3 = (options.isSet("a") ? 1 : 0) + (options.isSet("e") ? 1 : 0) + (options.isSet("v") ? 1 : 0) + (options.isSet("M") ? 1 : 0);
            if (n3 > 1) {
                printStream2.println("keymap: incompatible keymap selection options");
                return;
            }
            if (options.isSet("a")) {
                string = "vicmd";
            } else if (options.isSet("e")) {
                string = "emacs";
            } else if (options.isSet("v")) {
                string = "viins";
            } else if (options.isSet("M")) {
                if (options.args().isEmpty()) {
                    printStream2.println("keymap: argument expected: -M");
                    return;
                }
                string = options.args().remove(0);
            }
            KeyMap<Binding> keyMap = map.get(string);
            if (keyMap == null) {
                printStream2.println("keymap: no such keymap `" + string + "'");
                return;
            }
            boolean bl = options.isSet("R");
            if (options.args().size() % 2 == 1) {
                printStream2.println("keymap: even number of arguments required");
                return;
            }
            for (int i = 0; i < options.args().size(); i += 2) {
                Collection<String> collection;
                Binding binding;
                Binding binding2 = binding = options.isSet("s") ? new Macro(KeyMap.translate(options.args().get(i + 1))) : new Reference(options.args().get(i + 1));
                if (bl) {
                    collection = KeyMap.range(options.args().get(i));
                    if (collection == null) {
                        printStream2.println("keymap: malformed key range `" + options.args().get(i) + "'");
                        return;
                    }
                    keyMap.bind(binding, (Iterable<CharSequence>)collection);
                    continue;
                }
                collection = KeyMap.translate(options.args().get(i));
                keyMap.bind(binding, (CharSequence)((Object)collection));
            }
            if (options.isSet("e") || options.isSet("v")) {
                map.put("main", keyMap);
            }
        } else {
            String string = "main";
            int n4 = (options.isSet("a") ? 1 : 0) + (options.isSet("e") ? 1 : 0) + (options.isSet("v") ? 1 : 0) + (options.isSet("M") ? 1 : 0);
            if (n4 > 1) {
                printStream2.println("keymap: incompatible keymap selection options");
                return;
            }
            if (options.isSet("a")) {
                string = "vicmd";
            } else if (options.isSet("e")) {
                string = "emacs";
            } else if (options.isSet("v")) {
                string = "viins";
            } else if (options.isSet("M")) {
                if (options.args().isEmpty()) {
                    printStream2.println("keymap: argument expected: -M");
                    return;
                }
                string = options.args().remove(0);
            }
            KeyMap<Binding> keyMap = map.get(string);
            if (keyMap == null) {
                printStream2.println("keymap: no such keymap `" + string + "'");
                return;
            }
            boolean bl = options.isSet("p");
            boolean bl3 = options.isSet("L");
            if (bl && options.args().isEmpty()) {
                printStream2.println("keymap: option -p requires a prefix string");
                return;
            }
            if (options.args().size() > 0 || !options.isSet("e") && !options.isSet("v")) {
                Map<String, Binding> map3 = keyMap.getBoundKeys();
                String string4 = options.args().size() > 0 ? KeyMap.translate(options.args().get(0)) : null;
                Map.Entry<String, Binding> entry = null;
                String string5 = null;
                Iterator<Map.Entry<String, Binding>> iterator = map3.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Binding> entry2 = iterator.next();
                    String string6 = entry2.getKey();
                    if (string4 != null && (!bl || !string6.startsWith(string4) || string6.equals(string4)) && (bl || !string6.equals(string4))) continue;
                    if (entry != null || !iterator.hasNext()) {
                        String string7 = (string5.length() > 1 ? string5.substring(0, string5.length() - 1) : "") + (char)(string5.charAt(string5.length() - 1) + '\u0001');
                        if (string6.equals(string7) && entry2.getValue().equals(entry.getValue())) {
                            string5 = string6;
                            continue;
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        if (bl3) {
                            stringBuilder.append("keymap -M ");
                            stringBuilder.append(string);
                            stringBuilder.append(" ");
                        }
                        if (entry.getKey().equals(string5)) {
                            stringBuilder.append(KeyMap.display(string5));
                            stringBuilder.append(" ");
                            Commands.displayValue(stringBuilder, entry.getValue());
                            printStream.println(stringBuilder.toString());
                        } else {
                            if (bl3) {
                                stringBuilder.append("-R ");
                            }
                            stringBuilder.append(KeyMap.display(entry.getKey()));
                            stringBuilder.append("-");
                            stringBuilder.append(KeyMap.display(string5));
                            stringBuilder.append(" ");
                            Commands.displayValue(stringBuilder, entry.getValue());
                            printStream.println(stringBuilder.toString());
                        }
                        entry = entry2;
                        string5 = string6;
                        continue;
                    }
                    entry = entry2;
                    string5 = string6;
                }
            }
            if (options.isSet("e") || options.isSet("v")) {
                map.put("main", keyMap);
            }
        }
    }

    public static void setopt(LineReader lineReader, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"setopt -  set options", "Usage: setopt [-m] option ...", "       setopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        if (options.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (lineReader.isSet(option) == option.isDef()) continue;
                printStream.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean bl = options.isSet("m");
            Commands.doSetOpts(lineReader, printStream, printStream2, options.args(), bl, true);
        }
    }

    public static void unsetopt(LineReader lineReader, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        String[] stringArray2 = new String[]{"unsetopt -  unset options", "Usage: unsetopt [-m] option ...", "       unsetopt", "  -? --help                       Displays command help", "  -m                              Use pattern matching"};
        Options options = Options.compile(stringArray2).parse(stringArray);
        if (options.isSet("help")) {
            options.usage(printStream2);
            return;
        }
        if (options.args().isEmpty()) {
            for (LineReader.Option option : LineReader.Option.values()) {
                if (lineReader.isSet(option) != option.isDef()) continue;
                printStream.println((option.isDef() ? "no-" : "") + option.toString().toLowerCase().replace('_', '-'));
            }
        } else {
            boolean bl = options.isSet("m");
            Commands.doSetOpts(lineReader, printStream, printStream2, options.args(), bl, false);
        }
    }

    private static void doSetOpts(LineReader lineReader, PrintStream printStream, PrintStream printStream2, List<String> list, boolean bl, boolean bl2) {
        for (String string : list) {
            String string2 = string.toLowerCase().replaceAll("[-_]", "");
            if (bl) {
                string2 = string2.replaceAll("\\*", "[a-z]*");
                string2 = string2.replaceAll("\\?", "[a-z]");
            }
            boolean bl3 = false;
            for (LineReader.Option option : LineReader.Option.values()) {
                String string3 = option.name().toLowerCase().replaceAll("[-_]", "");
                if (bl ? string3.matches(string2) : string3.equals(string2)) {
                    if (bl2) {
                        lineReader.setOpt(option);
                    } else {
                        lineReader.unsetOpt(option);
                    }
                    bl3 = true;
                    if (bl) continue;
                    break;
                }
                if (!(bl ? ("no" + string3).matches(string2) : ("no" + string3).equals(string2))) continue;
                if (bl2) {
                    lineReader.unsetOpt(option);
                } else {
                    lineReader.setOpt(option);
                }
                if (bl) break;
                bl3 = true;
                break;
            }
            if (bl3) continue;
            printStream2.println("No matching option: " + string);
        }
    }

    private static void displayValue(StringBuilder stringBuilder, Object object) {
        if (object == null) {
            stringBuilder.append("undefined-key");
        } else if (object instanceof Macro) {
            stringBuilder.append(KeyMap.display(((Macro)object).getSequence()));
        } else if (object instanceof Reference) {
            stringBuilder.append(((Reference)object).name());
        } else {
            stringBuilder.append(object.toString());
        }
    }
}

