/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementScanner6;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.atteo.classindex.IndexAnnotated;
import org.atteo.classindex.IndexSubclasses;

public class ClassIndexProcessor
extends AbstractProcessor {
    private Map<String, Set<String>> subclassMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> annotatedMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> packageMap = new HashMap<String, Set<String>>();
    private boolean annotationDriven = true;
    private Set<String> indexedAnnotations = new HashSet<String>();
    private Set<String> indexedSuperclasses = new HashSet<String>();
    private Set<String> indexedPackages = new HashSet<String>();
    private Set<TypeElement> javadocAlreadyStored = new HashSet<TypeElement>();
    private Types types;
    private Filer filer;
    private Elements elementUtils;
    private Messager messager;

    public ClassIndexProcessor() {
    }

    protected ClassIndexProcessor(Class<?> ... classArray) {
        if (classArray.length == 0) {
            return;
        }
        this.annotationDriven = false;
        for (Class<?> clazz : classArray) {
            this.indexedAnnotations.add(clazz.getCanonicalName());
        }
    }

    protected final void indexAnnotations(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.indexedAnnotations.add(clazz.getCanonicalName());
        }
        this.annotationDriven = false;
    }

    protected final void indexSubclasses(Class<?> ... classArray) {
        for (Class<?> clazz : classArray) {
            this.indexedSuperclasses.add(clazz.getCanonicalName());
        }
        this.annotationDriven = false;
    }

    protected final void indexPackages(String ... stringArray) {
        Collections.addAll(this.indexedPackages, stringArray);
        this.annotationDriven = false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.types = processingEnvironment.getTypeUtils();
        this.filer = processingEnvironment.getFiler();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.messager = processingEnvironment.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        try {
            for (Element object : roundEnvironment.getRootElements()) {
                if (!(object instanceof TypeElement)) continue;
                final PackageElement packageElement = this.getPackage(object);
                object.accept(new ElementScanner6<Void, Void>(){

                    @Override
                    public Void visitType(TypeElement typeElement, Void void_) {
                        try {
                            for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                                ClassIndexProcessor.this.storeRepeatableAnnotation(annotationMirror, typeElement);
                                TypeElement typeElement2 = (TypeElement)annotationMirror.getAnnotationType().asElement();
                                ClassIndexProcessor.this.storeAnnotation(typeElement2, typeElement);
                            }
                            ClassIndexProcessor.this.indexSupertypes(typeElement, typeElement);
                            if (packageElement != null) {
                                ClassIndexProcessor.this.storeClassFromPackage(packageElement, typeElement);
                            }
                        }
                        catch (IOException iOException) {
                            ClassIndexProcessor.this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] " + iOException.getMessage());
                        }
                        return (Void)super.visitType(typeElement, void_);
                    }
                }, null);
            }
            if (!roundEnvironment.processingOver()) {
                return false;
            }
            this.writeIndexFiles("META-INF/services/", this.subclassMap);
            this.writeIndexFiles("META-INF/annotations/", this.annotatedMap);
            for (Map.Entry entry : this.packageMap.entrySet()) {
                this.writeSimpleNameIndexFile((Set)entry.getValue(), ((String)entry.getKey()).replace(".", "/") + "/" + "jaxb.index");
            }
        }
        catch (IOException iOException) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Can't write index file: " + iOException.getMessage());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Internal error: " + throwable.getMessage());
        }
        return false;
    }

    private void storeRepeatableAnnotation(AnnotationMirror annotationMirror, TypeElement typeElement) {
        for (AnnotationValue annotationValue : annotationMirror.getElementValues().values()) {
            if (!(annotationValue.getValue() instanceof List)) continue;
            for (Object e : (List)annotationValue.getValue()) {
                AnnotationMirror annotationMirror2;
                TypeElement typeElement2;
                Repeatable repeatable;
                if (!(e instanceof AnnotationMirror) || (repeatable = (typeElement2 = (TypeElement)(annotationMirror2 = (AnnotationMirror)e).getAnnotationType().asElement()).getAnnotation(Repeatable.class)) == null) continue;
                this.storeAnnotation(typeElement2, typeElement);
            }
        }
    }

    private void writeIndexFiles(String string, Map<String, Set<String>> map) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            this.writeSimpleNameIndexFile(entry.getValue(), string + entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject readOldIndexFile(Set<String> set, String string) {
        block15: {
            try (Reader reader = null;){
                FileObject fileObject = this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", string);
                reader = fileObject.openReader(true);
                ClassIndexProcessor.readOldIndexFile(set, reader);
                FileObject fileObject2 = fileObject;
                return fileObject2;
            }
        }
        return null;
    }

    private static void readOldIndexFile(Set<String> set, Reader reader) {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string = bufferedReader.readLine();
            while (string != null) {
                set.add(string);
                string = bufferedReader.readLine();
            }
        }
    }

    private void writeIndexFile(Set<String> set, String string, FileObject fileObject) {
        FileObject fileObject2 = fileObject;
        if (fileObject2 == null) {
            fileObject2 = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", string, new Element[0]);
        }
        try (Writer writer = fileObject2.openWriter();){
            for (String string2 : set) {
                writer.write(string2);
                writer.write("\n");
            }
        }
    }

    private void writeSimpleNameIndexFile(Set<String> set, String string) {
        FileObject fileObject = this.readOldIndexFile(set, string);
        if (fileObject != null) {
            try {
                this.writeIndexFile(set, string, fileObject);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.writeIndexFile(set, string, null);
    }

    private void writeFile(String string, String string2) {
        FileObject fileObject = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", string2, new Element[0]);
        try (Writer writer = fileObject.openWriter();){
            writer.write(string);
        }
    }

    private void indexSupertypes(TypeElement typeElement, TypeElement typeElement2) {
        for (TypeMirror typeMirror : this.types.directSupertypes(typeElement2.asType())) {
            if (typeMirror.getKind() != TypeKind.DECLARED) continue;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement3 = (TypeElement)declaredType.asElement();
            this.storeSubclass(typeElement3, typeElement);
            for (AnnotationMirror annotationMirror : typeElement3.getAnnotationMirrors()) {
                TypeElement typeElement4 = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (!this.hasAnnotation(typeElement4, Inherited.class)) continue;
                this.storeAnnotation(typeElement4, typeElement);
            }
            this.indexSupertypes(typeElement, typeElement3);
        }
    }

    private boolean hasAnnotation(TypeElement typeElement, Class<? extends Annotation> clazz) {
        block3: {
            try {
                for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().toString().equals(clazz.getName())) continue;
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getClass().getName().equals("com.sun.tools.javac.code.Symbol$CompletionFailure")) break block3;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "[ClassIndexProcessor] Can't check annotation: " + runtimeException.getMessage());
            }
        }
        return false;
    }

    private void storeAnnotation(TypeElement typeElement, TypeElement typeElement2) {
        IndexAnnotated indexAnnotated;
        if (this.indexedAnnotations.contains(typeElement.getQualifiedName().toString())) {
            this.putElement(this.annotatedMap, typeElement.getQualifiedName().toString(), typeElement2);
        } else if (this.annotationDriven && (indexAnnotated = typeElement.getAnnotation(IndexAnnotated.class)) != null) {
            this.putElement(this.annotatedMap, typeElement.getQualifiedName().toString(), typeElement2);
            if (indexAnnotated.storeJavadoc()) {
                this.storeJavadoc(typeElement2);
            }
        }
    }

    private void storeSubclass(TypeElement typeElement, TypeElement typeElement2) {
        IndexSubclasses indexSubclasses;
        if (this.indexedSuperclasses.contains(typeElement.getQualifiedName().toString())) {
            this.putElement(this.subclassMap, typeElement.getQualifiedName().toString(), typeElement2);
        } else if (this.annotationDriven && (indexSubclasses = typeElement.getAnnotation(IndexSubclasses.class)) != null) {
            this.putElement(this.subclassMap, typeElement.getQualifiedName().toString(), typeElement2);
            if (indexSubclasses.storeJavadoc()) {
                this.storeJavadoc(typeElement2);
            }
        }
        if (this.indexedSuperclasses.contains(typeElement.getQualifiedName().toString()) || this.annotationDriven && typeElement.getAnnotation(IndexSubclasses.class) != null) {
            this.putElement(this.subclassMap, typeElement.getQualifiedName().toString(), typeElement2);
        }
    }

    private void storeClassFromPackage(PackageElement packageElement, TypeElement typeElement) {
        String string;
        IndexSubclasses indexSubclasses;
        if (this.indexedPackages.contains(packageElement.getQualifiedName().toString())) {
            this.putElement(this.packageMap, packageElement.getQualifiedName().toString(), typeElement);
        } else if (this.annotationDriven && (indexSubclasses = packageElement.getAnnotation(IndexSubclasses.class)) != null && (string = this.getShortName(typeElement)) != null) {
            this.putElement(this.packageMap, packageElement.getQualifiedName().toString(), string);
            if (indexSubclasses.storeJavadoc()) {
                this.storeJavadoc(typeElement);
            }
        }
    }

    private <K> void putElement(Map<K, Set<String>> map, K k, TypeElement typeElement) {
        String string = this.getFullName(typeElement);
        if (string != null) {
            this.putElement(map, k, string);
        }
    }

    private <K> void putElement(Map<K, Set<String>> map, K k, String string) {
        Set<String> set = map.get(k);
        if (set == null) {
            set = new TreeSet<String>();
            map.put(k, set);
        }
        set.add(string);
    }

    private String getFullName(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return typeElement.getQualifiedName().toString();
            }
            case MEMBER: {
                String string;
                Element element = typeElement.getEnclosingElement();
                if (element instanceof TypeElement && (string = this.getFullName((TypeElement)element)) != null) {
                    return string + '$' + typeElement.getSimpleName().toString();
                }
                return null;
            }
        }
        return null;
    }

    private String getShortName(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return typeElement.getSimpleName().toString();
            }
            case MEMBER: {
                String string;
                Element element = typeElement.getEnclosingElement();
                if (element instanceof TypeElement && (string = this.getShortName((TypeElement)element)) != null) {
                    return string + '$' + typeElement.getSimpleName().toString();
                }
                return null;
            }
        }
        return null;
    }

    private PackageElement getPackage(Element element) {
        for (Element element2 = element; element2 != null; element2 = element2.getEnclosingElement()) {
            if (!(element2 instanceof PackageElement)) continue;
            return (PackageElement)element2;
        }
        return null;
    }

    private void storeJavadoc(TypeElement typeElement) {
        if (this.javadocAlreadyStored.contains(typeElement)) {
            return;
        }
        this.javadocAlreadyStored.add(typeElement);
        String string = this.elementUtils.getDocComment(typeElement);
        if (string == null) {
            return;
        }
        this.writeFile(string, "META-INF/javadocs/" + typeElement.getQualifiedName().toString());
    }
}

