/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class ClassIndex {
    public static final String SUBCLASS_INDEX_PREFIX = "META-INF/services/";
    public static final String ANNOTATED_INDEX_PREFIX = "META-INF/annotations/";
    public static final String PACKAGE_INDEX_NAME = "jaxb.index";
    public static final String JAVADOC_PREFIX = "META-INF/javadocs/";

    private ClassIndex() {
    }

    public static <T> Iterable<Class<? extends T>> getSubclasses(Class<T> clazz) {
        return ClassIndex.getSubclasses(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Iterable<Class<? extends T>> getSubclasses(Class<T> clazz, ClassLoader classLoader) {
        Iterable<String> iterable = ClassIndex.getSubclassesNames(clazz, classLoader);
        HashSet hashSet = new HashSet();
        ClassIndex.findClasses(classLoader, hashSet, iterable);
        ArrayList<Class<T>> arrayList = new ArrayList<Class<T>>();
        for (Class clazz2 : hashSet) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public static <T> Iterable<String> getSubclassesNames(Class<T> clazz) {
        return ClassIndex.getSubclassesNames(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Iterable<String> getSubclassesNames(Class<T> clazz, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, SUBCLASS_INDEX_PREFIX + clazz.getCanonicalName());
    }

    public static Iterable<Class<?>> getPackageClasses(String string) {
        return ClassIndex.getPackageClasses(string, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<Class<?>> getPackageClasses(String string, ClassLoader classLoader) {
        Iterable<String> iterable = ClassIndex.readIndexFile(classLoader, string.replace(".", "/") + "/" + PACKAGE_INDEX_NAME);
        HashSet hashSet = new HashSet();
        ClassIndex.findClassesInPackage(classLoader, string, hashSet, iterable);
        ClassIndex.findClasses(classLoader, hashSet, iterable);
        return hashSet;
    }

    public static Iterable<String> getPackageClassesNames(String string) {
        return ClassIndex.getPackageClassesNames(string, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<String> getPackageClassesNames(String string, ClassLoader classLoader) {
        Iterable<String> iterable = ClassIndex.readIndexFile(classLoader, string.replace(".", "/") + "/" + PACKAGE_INDEX_NAME);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : iterable) {
            arrayList.add(string + "." + string2);
        }
        return arrayList;
    }

    public static Iterable<Class<?>> getAnnotated(Class<? extends Annotation> clazz) {
        return ClassIndex.getAnnotated(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<Class<?>> getAnnotated(Class<? extends Annotation> clazz, ClassLoader classLoader) {
        Iterable<String> iterable = ClassIndex.getAnnotatedNames(clazz, classLoader);
        HashSet hashSet = new HashSet();
        ClassIndex.findClasses(classLoader, hashSet, iterable);
        return hashSet;
    }

    public static Iterable<String> getAnnotatedNames(Class<? extends Annotation> clazz) {
        return ClassIndex.getAnnotatedNames(clazz, Thread.currentThread().getContextClassLoader());
    }

    public static Iterable<String> getAnnotatedNames(Class<? extends Annotation> clazz, ClassLoader classLoader) {
        return ClassIndex.readIndexFile(classLoader, ANNOTATED_INDEX_PREFIX + clazz.getCanonicalName());
    }

    public static String getClassSummary(Class<?> clazz) {
        return ClassIndex.getClassSummary(clazz, Thread.currentThread().getContextClassLoader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getClassSummary(Class<?> clazz, ClassLoader classLoader) {
        URL uRL = classLoader.getResource(JAVADOC_PREFIX + clazz.getCanonicalName());
        if (uRL == null) {
            return null;
        }
        try {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));){
                StringBuilder stringBuilder = new StringBuilder();
                String string = bufferedReader.readLine();
                while (string != null) {
                    int n = string.indexOf(46);
                    if (n != -1) {
                        stringBuilder.append(string.subSequence(0, n));
                        String string2 = stringBuilder.toString().trim();
                        return string2;
                    }
                    stringBuilder.append(string);
                    string = bufferedReader.readLine();
                }
                String string3 = stringBuilder.toString().trim();
                return string3;
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("ClassIndex: Cannot read Javadoc index", iOException);
        }
    }

    private static Iterable<String> readIndexFile(ClassLoader classLoader, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8"));){
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        hashSet.add(string2);
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("ClassIndex: Cannot read class index", iOException);
        }
        return hashSet;
    }

    private static void findClasses(ClassLoader classLoader, Set<Class<?>> set, Iterable<String> iterable) {
        for (String string : iterable) {
            Class<?> clazz;
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            set.add(clazz);
        }
    }

    private static void findClassesInPackage(ClassLoader classLoader, String string, Set<Class<?>> set, Iterable<String> iterable) {
        for (String string2 : iterable) {
            Class<?> clazz;
            if (string2.contains(".")) continue;
            try {
                clazz = classLoader.loadClass(string + "." + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
            set.add(clazz);
        }
    }
}

