/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.classindex;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;

public final class ClassFilter {
    private ClassFilter() {
    }

    public static UnionBuilder only() {
        return new Builder();
    }

    public static FilterBuilder any(final Predicate ... predicateArray) {
        return new CommonFilterBuilder(){

            @Override
            public boolean matches(Class<?> clazz) {
                for (Predicate predicate : predicateArray) {
                    if (!predicate.matches(clazz)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class Builder
    extends CommonFilterBuilder
    implements UnionBuilder {
        private final List<Predicate> predicates = new ArrayList<Predicate>();

        private Builder() {
        }

        @Override
        public Builder satisfying(Predicate predicate) {
            this.predicates.add(predicate);
            return this;
        }

        @Override
        public Builder topLevel() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return clazz.getEnclosingClass() == null;
                }
            });
        }

        @Override
        public UnionBuilder topLevelOrStaticNested() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return clazz.getEnclosingClass() == null || (clazz.getModifiers() & 8) != 0;
                }
            });
        }

        @Override
        public Builder enclosedIn(final Class<?> clazz) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz2) {
                    do {
                        if ((clazz2 = clazz2.getEnclosingClass()) != null) continue;
                        return false;
                    } while (!clazz.equals(clazz2));
                    return true;
                }
            });
        }

        @Override
        public UnionBuilder enclosedDirectlyIn(final Class<?> clazz) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz2) {
                    if ((clazz2 = clazz2.getEnclosingClass()) == null) {
                        return false;
                    }
                    return clazz2 == clazz;
                }
            });
        }

        @Override
        public Builder annotatedWith(final Class<? extends Annotation> clazz) {
            Retention retention = clazz.getAnnotation(Retention.class);
            if (retention == null || retention.value() != RetentionPolicy.RUNTIME) {
                throw new IllegalStateException("Cannot filter annotated with annotation without retention policy set to RUNTIME: " + clazz.getName());
            }
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz2) {
                    return clazz2.isAnnotationPresent(clazz);
                }
            });
        }

        @Override
        public UnionBuilder withModifiers(final int n) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return (clazz.getModifiers() & n) != 0;
                }
            });
        }

        @Override
        public UnionBuilder withoutModifiers(final int n) {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return (clazz.getModifiers() & n) == 0;
                }
            });
        }

        @Override
        public UnionBuilder withPublicDefaultConstructor() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    try {
                        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                        return (constructor.getModifiers() & 1) != 0;
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        return false;
                    }
                }
            });
        }

        @Override
        public UnionBuilder interfaces() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return clazz.isInterface();
                }
            });
        }

        @Override
        public UnionBuilder classes() {
            return this.satisfying(new Predicate(){

                @Override
                public boolean matches(Class<?> clazz) {
                    return !clazz.isInterface();
                }
            });
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (Predicate predicate : this.predicates) {
                if (predicate.matches(clazz)) continue;
                return false;
            }
            return true;
        }
    }

    private static abstract class CommonFilterBuilder
    implements FilterBuilder {
        private CommonFilterBuilder() {
        }

        @Override
        public <T> Iterable<Class<? extends T>> from(Iterable<Class<? extends T>> iterable) {
            ArrayList<Class<T>> arrayList = new ArrayList<Class<T>>();
            for (Class<T> clazz : iterable) {
                if (!this.matches(clazz)) continue;
                arrayList.add(clazz);
            }
            return arrayList;
        }
    }

    public static interface UnionBuilder
    extends FilterBuilder {
        public UnionBuilder satisfying(Predicate var1);

        public UnionBuilder topLevel();

        public UnionBuilder topLevelOrStaticNested();

        public UnionBuilder enclosedIn(Class<?> var1);

        public UnionBuilder enclosedDirectlyIn(Class<?> var1);

        public UnionBuilder annotatedWith(Class<? extends Annotation> var1);

        public UnionBuilder withModifiers(int var1);

        public UnionBuilder withoutModifiers(int var1);

        public UnionBuilder withPublicDefaultConstructor();

        public UnionBuilder interfaces();

        public UnionBuilder classes();
    }

    public static interface FilterBuilder
    extends Predicate {
        public <T> Iterable<Class<? extends T>> from(Iterable<Class<? extends T>> var1);
    }

    public static interface Predicate {
        public boolean matches(Class<?> var1);
    }
}

