/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar.wrapped;

import java.io.FilterInputStream;
import java.io.InputStream;
import me.tongfei.progressbar.ProgressBar;

public class ProgressBarWrappedInputStream
extends FilterInputStream {
    private ProgressBar pb;
    private long mark = 0L;

    public ProgressBarWrappedInputStream(InputStream inputStream, ProgressBar progressBar) {
        super(inputStream);
        this.pb = progressBar;
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    @Override
    public int read() {
        int n = this.in.read();
        if (n != -1) {
            this.pb.step();
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) {
        int n = this.in.read(byArray);
        this.pb.stepBy(n);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.in.read(byArray, n, n2);
        this.pb.stepBy(n3);
        return n3;
    }

    @Override
    public long skip(long l) {
        long l2 = this.in.skip(l);
        this.pb.stepBy(l2);
        return l2;
    }

    @Override
    public void mark(int n) {
        this.in.mark(n);
        this.mark = this.pb.getCurrent();
    }

    @Override
    public void reset() {
        this.in.reset();
        this.pb.stepTo(this.mark);
    }

    @Override
    public void close() {
        this.in.close();
        this.pb.close();
    }
}

