/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import me.tongfei.progressbar.ProgressBarStyle;
import me.tongfei.progressbar.ProgressState;
import me.tongfei.progressbar.Util;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

class ProgressThread
implements Runnable {
    volatile boolean killed;
    ProgressBarStyle style;
    ProgressState progress;
    long updateInterval;
    PrintStream consoleStream;
    Terminal terminal;
    int consoleWidth = 80;
    String unitName = "";
    long unitSize = 1L;
    static int consoleRightMargin = 2;
    int length;

    ProgressThread(ProgressState progressState, ProgressBarStyle progressBarStyle, long l, PrintStream printStream, String string, long l2) {
        this.progress = progressState;
        this.style = progressBarStyle;
        this.updateInterval = l;
        this.consoleStream = printStream;
        this.killed = false;
        this.unitName = string;
        this.unitSize = l2;
        try {
            this.terminal = TerminalBuilder.builder().dumb(true).build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.terminal.getWidth() >= 10) {
            this.consoleWidth = this.terminal.getWidth();
        }
    }

    double progress() {
        if (this.progress.max <= 0L) {
            return 0.0;
        }
        return (double)this.progress.current / (double)this.progress.max;
    }

    int progressIntegralPart() {
        return (int)(this.progress() * (double)this.length);
    }

    int progressFractionalPart() {
        double d = this.progress() * (double)this.length;
        double d2 = (d - Math.floor(d)) * (double)this.style.fractionSymbols.length();
        return (int)Math.floor(d2);
    }

    String eta(Duration duration) {
        if (this.progress.max <= 0L || this.progress.indefinite) {
            return "?";
        }
        if (this.progress.current == 0L) {
            return "?";
        }
        return Util.formatDuration(duration.dividedBy(this.progress.current).multipliedBy(this.progress.max - this.progress.current));
    }

    String percentage() {
        String string = this.progress.max <= 0L || this.progress.indefinite ? "? %" : String.valueOf((int)Math.floor(100.0 * (double)this.progress.current / (double)this.progress.max)) + "%";
        return Util.repeat(' ', 4 - string.length()) + string;
    }

    String ratio() {
        String string = this.progress.indefinite ? "?" : String.valueOf(this.progress.max / this.unitSize);
        String string2 = String.valueOf(this.progress.current / this.unitSize);
        return Util.repeat(' ', string.length() - string2.length()) + string2 + "/" + string + this.unitName;
    }

    void refresh() {
        this.consoleStream.print('\r');
        Instant instant = Instant.now();
        Duration duration = Duration.between(this.progress.startTime, instant);
        String string = this.progress.task + " " + this.percentage() + " " + this.style.leftBracket;
        int n = Math.max(0, this.consoleWidth - consoleRightMargin - string.length() - 10);
        String string2 = this.style.rightBracket + " " + this.ratio() + " (" + Util.formatDuration(duration) + " / " + this.eta(duration) + ") " + this.progress.extraMessage;
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        this.length = this.consoleWidth - consoleRightMargin - string.length() - string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        if (this.progress.indefinite) {
            int n2 = (int)(this.progress.current % (long)this.length);
            stringBuilder.append(Util.repeat(this.style.space, n2));
            stringBuilder.append(this.style.block);
            stringBuilder.append(Util.repeat(this.style.space, this.length - n2 - 1));
        } else {
            stringBuilder.append(Util.repeat(this.style.block, this.progressIntegralPart()));
            if (this.progress.current < this.progress.max) {
                stringBuilder.append(this.style.fractionSymbols.charAt(this.progressFractionalPart()));
                stringBuilder.append(Util.repeat(this.style.space, this.length - this.progressIntegralPart() - 1));
            }
        }
        stringBuilder.append(string2);
        String string3 = stringBuilder.toString();
        this.consoleStream.print(string3);
    }

    void kill() {
        this.killed = true;
    }

    @Override
    public void run() {
        try {
            while (!this.killed) {
                this.refresh();
                Thread.sleep(this.updateInterval);
            }
            this.refresh();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

